(*************************************************

  Procedure: Draw Pie Slice.
    As previously defined.

*************************************************)

    Procedure Draw_Pie_Slice( X1, Y1: Integer; Start_Angle, End_Angle, Radius: Word );
      Begin
        Draw_Sector( X1, Y1, Start_Angle, End_Angle, Radius, Round( Radius * Aspect_Ratio ) );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Draw Rectangle.
    As previously defined.

*************************************************)

    Procedure Draw_Rectangle( Left, Top, Right, Bottom: Integer );
      Begin
        Draw_Line( Left, Top, Left, Bottom );
        Draw_Line( Left, Bottom, Right, Bottom );
        Draw_Line( Right, Bottom, Right, Top );
        Draw_Line( Right, Top, Left, Top );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Clear Defaults.
    As previously defined.

*************************************************)

    Procedure Clear_Defaults;
      Var
        X_Index,
        Y_Index: Word;
      Begin
        Background_Color := 0;
        Drawing_Color := 1;
        Current_Pointer_X := 0;
        Current_Pointer_Y := 0;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Set Background Color.
    As previously defined.

*************************************************)

    Procedure Set_Background_Color( Color: Word );
      Begin
        Background_Color := Color;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Set Filling Color.
    As previously defined.

*************************************************)

    Procedure Set_Filling_Color( Color: Word );
      Begin
        Filling_Color := Color;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Set Color.
    As previously defined.

*************************************************)

    Procedure Set_Color( Color: Word );
      Begin
        Drawing_Color := Color;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get Aspect Ratio.
    As previously defined.

*************************************************)

    Procedure Get_Aspect_Ratio( Var X_Ratio, Y_Ratio: Word );
      Begin
        X_Ratio := X_Aspect_Ratio;
        Y_Ratio := Y_Aspect_Ratio;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get Line Relative.
    As previously defined.

*************************************************)

    Procedure Draw_Line_Relative( DX, DY: Integer );
      Begin
        Draw_Line( Current_Pointer_X, Current_Pointer_Y, ( Current_Pointer_X + DX ), ( Current_Pointer_Y + DY ) );
        Current_Pointer_X := ( Current_Pointer_X + DX );
        Current_Pointer_Y := ( Current_Pointer_Y + DY );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get Line To.
    As previously defined.

*************************************************)

    Procedure Draw_Line_To( X, Y: Integer );
      Begin
        Draw_Line( Current_Pointer_X, Current_Pointer_Y, X, Y );
        Current_Pointer_X := X;
        Current_Pointer_Y := Y;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get Relative.
    As previously defined.

*************************************************)

    Procedure Move_Relative( DX, DY: Integer );
      Begin
        Current_Pointer_X := ( Current_Pointer_X + DX );
        Current_Pointer_Y := ( Current_Pointer_Y + DY );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Move To.
    As previously defined.

*************************************************)

    Procedure Move_To( X, Y: Integer );
      Begin
        Current_Pointer_X := X;
        Current_Pointer_Y := Y;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Set Aspect Ratio.
    As previously defined.

*************************************************)

    Procedure Set_Aspect_Ratio( X_Ratio, Y_Ratio: Word );
      Begin
        X_Aspect_Ratio := X_Ratio;
        Y_Aspect_Ratio := Y_Ratio;
        Aspect_Ratio := ( X_Aspect_Ratio / Y_Aspect_Ratio );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Draw Bezier Spline.
    As previously defined.

*************************************************)

    Procedure Draw_Bezier_Spline( E1_X, E1_Y, C1_X, C1_Y, E2_X, E2_Y, C2_X, C2_Y: Integer );
      Var
        Time: Word;
        A, B, C, D,
        Real_Time,
        Real_Time2,
        Quick_Time,
        Opposite_Time,
        Opposite_Time2: Real;
        X, Y,
        OldX,
        OldY: Integer;
      Begin
        OldX := E1_X;
        OldY := E1_Y;
        Quick_Time := ( 1 / Bezier_Spline_Time_Limit );
        Real_Time := Quick_Time;
        For Time := 1 to Bezier_Spline_Time_Limit do
          Begin
            Real_Time := ( Real_Time + Quick_Time );
            Real_Time2 := ( Real_Time * Real_Time );
            Opposite_Time := ( 1 - Real_Time );
            Opposite_Time2 := ( Opposite_Time * Opposite_Time );
            A := ( Opposite_Time * Opposite_Time2 );
            B := ( 3 * Real_Time * Opposite_Time2 );
            C := ( 3 * Real_Time2 * Opposite_Time );
            D := ( Real_Time2 * Real_Time );
            X := Trunc( A * E1_X + B * C1_X + C * C2_X + D * E2_X );
            Y := Trunc( A * E1_Y + B * C1_Y + C * C2_Y + D * E2_Y );
            Draw_Line( OldX, OldY, X, Y );
            OldX := X;
            OldY := Y;
          End;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Roll Point.
    As previously defined.

*************************************************)

    Procedure Roll_Point( Var X, Y: Real; Amount: Real );
      Var
        R,
        P,
        O: Real;
      Begin
        R := Sqrt( Sqr( X ) + Sqr( Y ) );
        If ( X = 0.0 )
          then
            If ( Y < 0 )
              then
                P := ( Pi * 0.25 )
              else
                P := ( Pi * 0.75 )
          else
            P := ArcTan( Y / X );
        If ( ( Y < 0 ) or ( X < 0 ) )
          then
            Begin
              P := ( P - Pi );
              If ( X > 0 )
                then
                  P := ( P - Pi );
            End;
        O := ( P + ( 0.017453292 * Amount ) );
        X := ( R * Cos( O ) );
        Y := ( R * Sin( O ) );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Default Set Pixel.
    This is the default graphic routine to display
    the point on the screen.  This routine uses
    the default BIOS routine to set the pixel.

*************************************************)

    Procedure Default_Set_Pixel( X, Y: Integer; Color: Word );
      Var
        The_Registers: Registers;
      Begin
        The_Registers.AH := $C;
        The_Registers.AL := Color;
        The_Registers.BH := 0;
        The_Registers.CX := Word( X );
        The_Registers.DX := Word( Y );
        Intr( $10, The_Registers );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Function: Default Get Pixel.
    This is the default graphic routine to poll
    the point on the screen.  This routine uses
    the default BIOS routine to get the pixel.

*************************************************)

    Function Default_Get_Pixel( X, Y: Integer ): Word;
      Var
        The_Registers: Registers;
      Begin
        The_Registers.AH := $D;
        The_Registers.BH := 0;
        The_Registers.CX := Word( X );
        The_Registers.DX := Word( Y );
        Intr( $10, The_Registers );
        Default_Get_Pixel := The_Registers.AL;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Function: Default Fill Line.
    This is the default graphic routine to display
    a row of points on the screen.  This routine
    uses the current Set_Pixel routine to set the
    pixels.

*************************************************)

    Procedure Default_Fill_Line( X1, X2, Y: Integer; Color: Word );
      Var
        Count: Integer;
      Begin
        If ( X1 < X2 )
          then
            For Count := X1 to X2 do
              Set_Pixel( Count, Y, Color )
          else
            For Count := X2 to X1 do
              Set_Pixel( Count, Y, Color );
      End;

