{$F+} { Compiler Directive: Generate far calls: On } { Do Not Change! }
{$O+} { Compiler Directive: Generate overlay code: On }

(*****************************************************************************

  Character
    Version 2.0

    This unit hold a collection of routines for displaying vector characters
      on the screen.

    Purpose:
      This unit displays vector characters on the screen or the redirected
      graphical structure.  It's a useful way of drawing alterable vectored
      characters of any size.

    How it works:
      Each individual character is drawn on the screen as a series of lines
        and curves or filled objects.
      Each character is represented by a procedure on a list of variable
        procedures.

    Features:
      All coordinates are taken in pixels from the upper left hand corner and
        proceeding downwards and rightwards as the values increase.  The X
        values represent the pixels to the right of the left side of the
        screen, while the Y values represent the pixels to the bottom of the
        top side of the screen.

  Copyright 1991, 1993, All rights reserved.
    Paul R. Renaud

  Compiler:
    Turbo Pascal Versions 5.0 to 6.0

  System:
    MS-DOS, MDOS

*****************************************************************************)

Unit Characters;

  Interface

    Uses
      Draw,
      FillCode;

(***********************************************************

  Procedure: Set character color.

    This procedure sets the color of the characters.  The
    characters are drawn in a different color than the
    default Draw colors.

***********************************************************)

    Procedure Set_Character_Color( Color: Byte );

(***********************************************************

  Procedure: Draw character.

    This procedure draws a single character in the given
    screen box defined by X1, Y1 as the upper left hand
    corner and X2, Y2 as the lower right hand corner.

***********************************************************)

    Procedure Draw_Character( X1, Y1, X2, Y2: Integer; Character: Char );

(***********************************************************

  Procedure: Draw string.

    This procedure draws a string of characters in the given
    screen box defined by X1, Y1 as the upper left hand
    corner and X2, Y2 as the lower right hand corner.

***********************************************************)

    Procedure Draw_String( X1, Y1, X2, Y2: Integer; Sentence: String );

(***********************************************************

  Procedure: Initialize standard characters.

    This procedure redefines the character set to the
    default character set.  Additional character sets may be
    defined in other dependent units.

***********************************************************)

    Procedure Initialize_Standard_Characters;

{=============================================================================

  These procedures are intended for alternate character sets.

    The values used represent points on the individual character's matrix and
      not absolute screen values.

=============================================================================}

    Type
     { This data structure will holds the array of routines.  One routine for each defined character. }
      Procedures_Array = array[ 0 .. 255 ] of Procedure;

(***********************************************************

  Procedure:  Plot line.
    This procedure plots a line from the coordinates defined
    by X1, Y1 to the point defined by X2, Y2.

***********************************************************)

    Procedure Plot_Line( X1, Y1, X2, Y2: Byte );

(***********************************************************

  Procedure:  Plot Arc.
    This procedure plots an arc around the coordinate
    defined by X1, Y1.  RX, RY define the respective X
    radius and Y radius of the arc.  Start and Finish are
    taken as degrees.

***********************************************************)

    Procedure Plot_Arc( X1, Y1, RX, RY: Byte; Start, Finish: Word );

(***********************************************************

  Procedure:  Plot Dot.
    This procedure draws a filled circle centered at the
    coordinate defined by X1, Y1.  RX, RY define the
    respective X radius and Y radius of the arc.

***********************************************************)

    Procedure Plot_Dot( X1, Y1, RX, RY: Byte );

(***********************************************************

  Procedure:  Plot Circle.
    This procedure draws an circle centered at the
    coordinate defined by X1, Y1.  RX, RY define the
    respective X radius and Y radius of the arc.

***********************************************************)

    Procedure Plot_Circle( X1, Y1, RX, RY: Byte );

(***********************************************************

  Procedure:  Plot filled line.
    This procedure plots a line from the coordinates defined
    by X1, Y1 to the point defined by X2, Y2.  Later the
    data will be filled.

***********************************************************)

    Procedure Plot_Filled_Line( X1, Y1, X2, Y2: Byte );

(***********************************************************

  Procedure:  Plot filled Arc.
    This procedure plots an arc around the coordinate
    defined by X1, Y1.  RX, RY define the respective X
    radius and Y radius of the arc.  Start and Finish are
    taken as degrees.  Later the data will be filled.

***********************************************************)

    Procedure Plot_Filled_Arc( X1, Y1, RX, RY: Byte; Start, Finish: Word );

(***********************************************************

  Procedure:  Plot filled Ellipse.
    This procedure draws a filled ellipse centered at the
    coordinate defined by X1, Y1.  RX, RY define the
    respective X radius and Y radius of the arc.  Later the
    data will be filled.

***********************************************************)

    Procedure Plot_Filled_Ellipse( X1, Y1, RX, RY: Byte );

(***********************************************************

  Procedures.
    Defines the data structure to hold the array of variable
    routines.

***********************************************************)

    Var
      Procedures: Procedures_Array;

{----------------------------------------------------------------------------}

  Implementation

   {$F+} { Compiler Directive: Generate far Calls: On } { Do Not Change! }

    Type
     { Defines the standard system integer point type. }
      Point_Type  = Record
                      X_Coordinate,
                      Y_Coordinate: Integer;
                    End;
     { Defines the matrix to hold the points of the individual character. }
      Matrix_Type = array[ 1 .. 22, 1 .. 22 ] of Point_Type;
     { Defines the matrix to hold the radius lengths of the individual characters. }
      Radius_List = array[ 1 .. 12 ] of Word;

    Var
     { The two radius lists.  One for each screen deminsion. }
      TX,
      TY: Radius_List;
     { This variable holds the color to draw the characters in. }
      Character_Color: Byte;
     { Holds the point matrix for the drawing of the character. }
      Point_Matrix: Matrix_Type;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Plot line.
    As previously defined.

*************************************************)

    Procedure Plot_Line( X1, Y1, X2, Y2: Byte );
      Begin
        Draw_Line( Point_Matrix[ X1, Y1 ].X_Coordinate, Point_Matrix[ X1, Y1 ].Y_Coordinate,
                   Point_Matrix[ X2, Y2 ].X_Coordinate, Point_Matrix[ X2, Y2 ].Y_Coordinate );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Plot arc.
    As previously defined.

*************************************************)

    Procedure Plot_Arc( X1, Y1, RX, RY: Byte; Start, Finish: Word );
      Begin
        Draw_Elliptical_Arc( Point_Matrix[ X1, Y1 ].X_Coordinate, Point_Matrix[ X1, Y1 ].Y_Coordinate, Start, Finish,
                             TX[ RX ], TY[ RY ] );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Plot dot.
    As previously defined.

*************************************************)

    Procedure Plot_Dot( X1, Y1, RX, RY: Byte );
      Begin
        Draw_Filled_Ellipse( Point_Matrix[ X1, Y1 ].X_Coordinate, Point_Matrix[ X1, Y1 ].Y_Coordinate, TX[ RX ], TY[ RY ] );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Plot circle.
    As previously defined.

*************************************************)

    Procedure Plot_Circle( X1, Y1, RX, RY: Byte );
      Begin
        Draw_Ellipse( Point_Matrix[ X1, Y1 ].X_Coordinate, Point_Matrix[ X1, Y1 ].Y_Coordinate, TX[ RX ], TY[ RY ] );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Plot filled box.
    This procedure draws a filled box on the
    screen.  The X1, Y1 coordinates define the
    upper left and X2, Y2 define the bottom right.

*************************************************)

    Procedure Plot_Filled_Box( X1, Y1, X2, Y2: Byte );
      Begin
        Draw_Filled_Rectangle( Point_Matrix[ X1, Y1 ].X_Coordinate, Point_Matrix[ X1, Y1 ].Y_Coordinate,
                               Point_Matrix[ X2, Y2 ].X_Coordinate, Point_Matrix[ X2, Y2 ].Y_Coordinate );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Plot box.
    This procedure draws a outline of a box on the
    screen.  The X1, Y1 coordinates define the
    upper left and X2, Y2 define the bottom right.

*************************************************)

    Procedure Plot_Box( X1, Y1, X2, Y2: Byte );
      Begin
        Draw_Rectangle( Point_Matrix[ X1, Y1 ].X_Coordinate, Point_Matrix[ X1, Y1 ].Y_Coordinate,
                        Point_Matrix[ X2, Y2 ].X_Coordinate, Point_Matrix[ X2, Y2 ].Y_Coordinate );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Plot shape.
    This procedure draws a outline of a shape on
    the screen.  The coordinates are defined by
    X1, Y1 and Ect.  It only holds four points.

*************************************************)

    Procedure Plot_Shape( X1, Y1, X2, Y2, X3, Y3, X4, Y4: Byte );
      Var
        Data: array[ 1 .. 4 ] of Point_Type;
      Begin
        Data[ 1 ] := Point_Matrix[ X1, Y1 ];
        Data[ 2 ] := Point_Matrix[ X2, Y2 ];
        Data[ 3 ] := Point_Matrix[ X3, Y3 ];
        Data[ 4 ] := Point_Matrix[ X4, Y4 ];
        Draw_Filled_Polygon( 4, Data );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Plot filled line.
    As previously defined.

*************************************************)

    Procedure Plot_Filled_Line( X1, Y1, X2, Y2: Byte );
      Begin
        Filled_Line_Job( Point_Matrix[ X1, Y1 ].X_Coordinate, Point_Matrix[ X1, Y1 ].Y_Coordinate,
                       Point_Matrix[ X2, Y2 ].X_Coordinate, Point_Matrix[ X2, Y2 ].Y_Coordinate );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Plot filled arc.
    As previously defined.

*************************************************)

    Procedure Plot_Filled_Arc( X1, Y1, RX, RY: Byte; Start, Finish: Word );
      Begin
        Draw_Elliptical_Arc_Job( Point_Matrix[ X1, Y1 ].X_Coordinate, Point_Matrix[ X1, Y1 ].Y_Coordinate, Start, Finish,
                                 TX[ RX ], TY[ RY ] );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Plot filled ellipse.
    As previously defined.

*************************************************)

    Procedure Plot_Filled_Ellipse( X1, Y1, RX, RY: Byte );
      Begin
        Draw_Filled_Ellipse_Job( Point_Matrix[ X1, Y1 ].X_Coordinate, Point_Matrix[ X1, Y1 ].Y_Coordinate,
                                 TX[ RX ], TY[ RY ] );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Initialize Radius and matrix.
    This procedure takes the screen coordinates
    X and Y and fills the character matrix of
    points using standard distance approximations
    defined by X_Size and Y_Size.

*************************************************)

    Procedure Initialize_Radius_And_Matrix( Var X, Y: Integer; Var X_Size, Y_Size: Word );
      Var
        My_X,
        My_Y: Real;
        Row,
        Column: Byte;
      Begin
        TX[ 1 ] := Round( 0.05 * X_Size );
        TX[ 2 ] := Round( 0.1 * X_Size );
        TX[ 3 ] := Round( 0.15 * X_Size );
        TX[ 4 ] := Round( 0.2 * X_Size );
        TX[ 5 ] := Round( 0.25 * X_Size );
        TX[ 6 ] := Round( 0.3 * X_Size );
        TX[ 7 ] := Round( 0.35 * X_Size );
        TX[ 8 ] := Round( 0.4 * X_Size );
        TX[ 9 ] := Round( 0.45 * X_Size );
        TX[ 10 ] := Round( 0.5 * X_Size );
        TX[ 11 ] := Round( 0.55 * X_Size );
        TX[ 12 ] := Round( 0.6 * X_Size );
        TY[ 1 ] := Round( 0.05 * Y_Size );
        TY[ 2 ] := Round( 0.1 * Y_Size );
        TY[ 3 ] := Round( 0.15 * Y_Size );
        TY[ 4 ] := Round( 0.2 * Y_Size );
        TY[ 5 ] := Round( 0.25 * Y_Size );
        TY[ 6 ] := Round( 0.3 * Y_Size );
        TY[ 7 ] := Round( 0.35 * Y_Size );
        TY[ 8 ] := Round( 0.4 * Y_Size );
        TY[ 9 ] := Round( 0.45 * Y_Size );
        TY[ 10 ] := Round( 0.5 * Y_Size );
        TY[ 11 ] := Round( 0.55 * Y_Size );
        TY[ 12 ] := Round( 0.6 * Y_Size );
        For Row := 1 to 22 do
          Begin
            My_Y := ( Y + ( Y_Size * ( Row * 0.05 ) ) );
            For Column := 1 to 22 do
              Begin
                My_X := ( X + ( X_Size * ( Column * 0.05 ) ) );
                With Point_Matrix[ Row, Column ] do
                  Begin
                    X_Coordinate := Round( My_X );
                    Y_Coordinate := Round( My_Y );
                  End;
              End;
          End;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Update matrix.
    This procedure updates the values in the
    matrix for the drawing of the next character.

*************************************************)

    Procedure Update_Matrix( Var X_Size: Word );
      Var
        Row,
        Column: Byte;
      Begin
        For Row := 1 to 22 do
          For Column := 1 to 22 do
            Inc( Point_Matrix[ Row, Column ].X_Coordinate, X_Size );
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  The following procedures are used for drawing
  the characters.  One procedure cooresponds to
  one of the available characters.

*************************************************)

    Procedure Plot_0;
      Begin
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_1;
      Begin
        Plot_Circle(  10, 10, 8, 8 );
        Plot_Arc(  12, 10, 6, 2, 190, 350 );
        Plot_Dot(  8, 6, 2, 2 );
        Plot_Dot( 8, 14, 2, 2 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_2;
      Begin
        Clear_List;
        Plot_Filled_Ellipse( 10, 10, 8, 8 );
        Plot_Filled_Ellipse( 8, 6, 2, 2 );
        Plot_Filled_Ellipse( 8, 14, 2, 2 );
        Plot_Filled_Arc( 12, 10, 6, 2, 190, 350 );
        Plot_Filled_Arc( 12, 10, 6, 3, 190, 350 );
        Draw_List;
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_3;
      Begin
        Clear_List;
        Plot_Filled_Arc( 6, 6, 4, 4, 0, 180 );
        Plot_Filled_Arc( 6, 14, 4, 4, 0, 179 );
        Plot_Filled_Arc( 6, 14, 12, 12, 180, 250 );
        Plot_Filled_Arc( 6, 6, 12, 12, 290, 0 );
        Draw_List;
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_4;
      Begin
        Plot_Shape( 2, 10, 10, 2, 18, 10, 10, 18 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_5;
      Begin
        Clear_List;
        Plot_Filled_Ellipse( 6, 10, 4, 4 );
        Plot_Filled_Ellipse( 12, 6, 4, 4 );
        Plot_Filled_Ellipse( 12, 14, 4, 4 );
        Plot_Line( 10, 10, 18, 10 );
        Plot_Line( 18, 8, 18, 12 );
        Draw_List;
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_6;
      Begin
        Clear_List;
        Plot_Filled_Arc( 12, 6, 4, 4, 180, 360 );
        Plot_Filled_Arc( 12, 14, 4, 4, 180, 360 );
        Plot_Filled_Line( 12, 2, 2, 10 );
        Plot_Filled_Line( 2, 10, 12, 18 );
        Plot_Line( 12, 10, 18, 10 );
        Plot_Line( 18, 8, 18, 12 );
        Plot_Line( 12, 2, 12, 18 );
        Draw_List;
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_7;
      Begin
        Plot_Dot( 10, 10, 2, 2 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_8;
      Begin
        Clear_List;
        Plot_Filled_Line( 2, 2, 22, 2 );
        Plot_Filled_Line( 2, 22, 22, 22 );
        Plot_Filled_Ellipse( 10, 10, 3, 3 );
        Draw_List;
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_9;
      Begin
        Plot_Circle( 10, 10, 6, 6 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_10;
      Begin
        Clear_List;
        Plot_Filled_Line( 2, 2, 22, 2 );
        Plot_Filled_Line( 2, 22, 22, 22 );
        Plot_Filled_Ellipse( 10, 10, 7, 7 );
        Plot_Filled_Ellipse( 10, 10, 5, 5 );
        Draw_List;
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_11;
      Begin
        Plot_Circle( 12, 10, 6, 6 );
        Plot_Line( 8, 14, 4, 18 );
        Plot_Line( 4, 16, 4, 18 );
        Plot_Line( 6, 18, 4, 18 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_12;
      Begin
        Plot_Circle( 8, 10, 6, 6 );
        Plot_Line( 14, 10, 18, 10 );
        Plot_Line( 16, 8, 16, 12 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_13;
      Begin
        Plot_Dot( 16, 8, 4, 2 );
        Plot_Line( 16, 12, 6, 12 );
        Plot_Shape( 4, 12, 10, 16, 8, 12, 4, 12 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_14;
      Begin
        Plot_Dot( 12, 6, 2, 2 );
        Plot_Dot( 16, 12, 2, 2 );
        Plot_Line( 2, 8, 12, 8 );
        Plot_Line( 2, 8, 6, 14 );
        Plot_Line( 6, 14, 16, 14 );
        Plot_Line( 4, 8, 8, 14 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_15;
      Begin
        Plot_Circle( 10, 10, 6, 6 );
        Plot_Line( 4, 10, 2, 10 );
        Plot_Line( 16, 10, 18, 10 );
        Plot_Line( 10, 2, 10, 4 );
        Plot_Line( 10, 16, 10, 18 );
        Plot_Line( 6, 6, 4, 4 );
        Plot_Line( 6, 14, 4, 16 );
        Plot_Line( 14, 6, 16, 4 );
        Plot_Line( 14, 14, 16, 16 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_16;
      Begin
        Plot_Shape( 2, 2, 10, 18, 18, 2, 10, 4 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_17;
      Begin
        Plot_Shape( 10, 2, 2, 18, 10, 16, 18, 18 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_18;
      Begin
        Plot_Shape( 6, 8, 2, 10, 6, 12, 4, 10 );
        Plot_Shape( 14, 8, 18, 10, 14, 12, 16, 10 );
        Plot_Line( 4, 10, 16, 10 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_19;
      Begin
        Clear_List;
        Plot_Filled_Arc( 6, 6, 2, 4, 0, 179 );
        Plot_Filled_Arc( 6, 14, 2, 4, 0, 179 );
        Plot_Filled_Line( 6, 4, 14, 6 );
        Plot_Filled_Line( 14, 6, 6, 8 );
        Plot_Filled_Line( 6, 12, 14, 14 );
        Plot_Filled_Line( 14, 14, 6, 16 );
        Plot_Dot( 18, 6, 2, 2 );
        Plot_Dot( 18, 14, 2, 2 );
        Draw_List;
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_20;
      Begin
        Plot_Arc( 6, 6, 4, 4, 90, 270 );
        Plot_Line( 2, 6, 2, 18 );
        Plot_Line( 2, 6, 18, 6 );
        Plot_Line( 2, 14, 18, 14 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_21;
      Begin
        Plot_Arc( 6, 10, 8, 4, 0, 250 );
        Plot_Circle( 10, 10, 4, 4 );
        Plot_Arc( 14, 10, 8, 4, 180, 70 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_22;
      Begin
        Plot_Filled_Box( 10, 2, 18, 18 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_23;
      Begin
        Plot_Shape( 6, 8, 2, 10, 6, 12, 4, 10 );
        Plot_Shape( 12, 8, 16, 10, 12, 12, 14, 10 );
        Plot_Line( 4, 10, 14, 10 );
        Plot_Line( 20, 2, 20, 18 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_24;
      Begin
        Plot_Shape( 8, 6, 2, 10, 8, 14, 6, 10 );
        Plot_Line( 6, 10, 18, 10 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_25;
      Begin
        Plot_Shape( 12, 6, 18, 10, 12, 14, 14, 10 );
        Plot_Line( 2, 10, 14, 10 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_26;
      Begin
        Plot_Shape( 10, 14, 14, 12, 10, 18, 6, 12 );
        Plot_Line( 10, 2, 10, 14 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_27;
      Begin
        Plot_Shape( 10, 2, 6, 8, 10, 6, 14, 8 );
        Plot_Line( 10, 6, 10, 18 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_28;
      Begin
        Plot_Line( 14, 2, 14, 18 );
        Plot_Line( 8, 2, 14, 2 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_29;
      Begin
        Plot_Shape( 10, 16, 12, 14, 10, 18, 8, 14 );
        Plot_Shape( 10, 2, 8, 6, 10, 4, 12, 6 );
        Plot_Line( 10, 4, 10, 16 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_30;
      Begin
        Plot_Shape( 18, 2, 2, 10, 18, 18, 16, 10 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_31;
      Begin
        Plot_Shape( 2, 2, 4, 10, 2, 18, 18, 10 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_32;
      Begin
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_33;
      Begin
        Clear_List;
        Plot_Filled_Arc( 6, 10, 4, 4, 0, 179 );
        Plot_Filled_Line( 6, 6, 14, 10 );
        Plot_Filled_Line( 14, 10, 6, 14 );
        Plot_Dot( 18, 10, 2, 2 );
        Draw_List;
      End;


{-----------------------------------------------------------------------------}

    Procedure Plot_34;
      Begin
        Plot_Line( 2, 8, 6, 8 );
        Plot_Line( 2, 12, 6, 12 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_35;
      Begin
        Plot_Line( 8, 2, 8, 18 );
        Plot_Line( 12, 2, 12, 18 );
        Plot_Line( 2, 8, 18, 8 );
        Plot_Line( 2, 12, 18, 12 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_36;
      Begin
        Plot_Arc( 8, 10, 6, 2, 60, 270 );
        Plot_Arc( 12, 10, 6, 2, 240, 90 );
        Plot_Line( 2, 12, 18, 12 );
        Plot_Line( 2, 8, 18, 8 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_37;
       Begin
         Plot_Line( 2, 16, 18, 4 );
         Plot_Circle( 6, 6, 2, 2 );
         Plot_Circle( 14, 14, 2, 2 );
       End;

{-----------------------------------------------------------------------------}

    Procedure Plot_38;
      Begin
        Plot_Arc( 6, 10, 4, 4, 270, 180 );
        Plot_Line( 18, 18, 6, 6 );
        Plot_Line( 10, 10, 14, 2 );
        Plot_Arc( 14, 6, 4, 4, 180, 270 );
        Plot_Arc( 10, 10, 8, 8, 270, 0 );
        Plot_Line( 18, 6, 18, 10 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_39;
      Begin
        Plot_Line( 2, 10, 4, 8 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_40;
      Begin
        Plot_Arc( 12, 10, 10, 10, 90, 270 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_41;
      Begin
        Plot_Arc( 12, 10, 10, 10, 270, 90 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_42;
      Begin
        Plot_Line( 2, 6, 18, 14 );
        Plot_Line( 2, 14, 18, 6 );
        Plot_Line( 10, 4, 10, 16 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_43;
      Begin
        Plot_Line( 4, 10, 16, 10 );
        Plot_Line( 10, 4, 10, 16 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_44;
      Begin
        Plot_Dot( 18, 10, 2, 2 );
        Plot_Line( 20, 10, 22, 8 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_45;
      Begin
        Plot_Line( 10, 4, 10, 16 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_46;
      Begin
        Plot_Dot( 18, 10, 2, 2 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_47;
      Begin
        Plot_Line( 2, 18, 18, 2 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_48;
      Begin
        Plot_Circle( 10, 10, 8, 8 );
        Plot_Line( 4, 16, 16, 4 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_49;
      Begin
        Plot_Line( 2, 10, 6, 8 );
        Plot_Line( 2, 10, 18, 10 );
        Plot_Line( 18, 8, 18, 12 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_50;
      Begin
        Plot_Arc( 10, 10, 8, 8, 0, 160 );
        Plot_Line( 10, 18, 18, 2 );
        Plot_Line( 18, 2, 18, 18 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_51;
      Begin
        Plot_Arc( 6, 10, 10, 4, 270, 180 );
        Plot_Line( 10, 10, 10, 6 );
        Plot_Arc( 14, 10, 10, 4, 180, 90 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_52;
      Begin
        Plot_Line( 2, 16, 14, 2 );
        Plot_Line( 2, 16, 18, 16 );
        Plot_Line( 14, 2, 14, 18 );
        Plot_Line( 18, 14, 18, 18 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_53;
      Begin
        Plot_Line( 2, 2, 2, 18 );
        Plot_Line( 2, 2, 10, 2 );
        Plot_Line( 10, 2, 10, 10 );
        Plot_Arc( 14, 10, 8, 4, 180, 90 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_54;
      Begin
        Plot_Arc( 10, 10, 8, 8, 70, 270 );
        Plot_Line( 18, 10, 18, 14 );
        Plot_Arc( 14, 14, 4, 4, 270, 90 );
        Plot_Line( 10, 14, 10, 2 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_55;
      Begin
        Plot_Line( 4, 2, 2, 2 );
        Plot_Line( 2, 2, 2, 18 );
        Plot_Line( 2, 18, 18, 10 );
        Plot_Line( 18, 8, 18, 12 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_56;
      Begin
        Plot_Circle( 6, 10, 6, 4 );
        Plot_Circle( 14, 10, 8, 4 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_57;
      Begin
        Plot_Arc( 6, 6, 4, 4, 90, 270 );
        Plot_Line( 10, 18, 10, 6 );
        Plot_Line( 2, 6, 2, 10 );
        Plot_Arc( 10, 10, 8, 8, 270, 90 );
        Plot_Line( 18, 10, 18, 6 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_58;
      Begin
        Plot_Dot( 12, 10, 2, 2 );
        Plot_Dot( 18, 10, 2, 2 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_59;
      Begin
        Plot_Dot( 12, 10, 2, 2 );
        Plot_Dot( 18, 10, 2, 2 );
        Plot_Line( 20, 10, 22, 8 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_60;
      Begin
        Plot_Line( 2, 18, 10, 2 );
        Plot_Line( 10, 2, 18, 18 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_61;
      Begin
        Plot_Line( 8, 4, 8, 16 );
        Plot_Line( 12, 4, 12, 16 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_62;
      Begin
        Plot_Line( 2, 2, 10, 18 );
        Plot_Line( 10, 18, 18, 2 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_63;
      Begin
        Plot_Dot( 18, 10, 2, 2 );
        Plot_Arc( 6, 10, 8, 4, 0, 170 );
        Plot_Line( 6, 18, 10, 10 );
        Plot_Line( 10, 10, 14, 10 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_64;
      Begin
        Plot_Arc( 10, 10, 8, 8, 0, 290 );
        Plot_Line( 10, 18, 14, 16 );
        Plot_Line( 14, 16, 6, 16 );
        Plot_Circle( 10, 12, 4, 4 );
      End;

{-----------------------------------------------------------------------------}

    Procedure Plot_65;
      Begin
        Plot_Line( 2, 10, 18, 2 );
        Plot_Line( 2, 10, 18, 18 );
        Plot_Line( 14, 4, 14, 16 );
      End;

{-----------------------------------------------------------------------------}

  {$I Charact2.Pas }

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Draw character.
    As previously defined.

*************************************************)

    Procedure Draw_Character( X1, Y1, X2, Y2: Integer; Character: Char );
      Var
        X_Size,
        Y_Size: Word;
        Save_Draw_Color,
        Save_Fill_Color: Byte;
      Begin
        Save_Draw_Color := Drawing_Color;
        Save_Fill_Color := Filling_Color;
        Drawing_Color := Character_Color;
        Filling_Color := Character_Color;
        Y_Size := ( Y2 - Y1 );
        X_Size := ( X2 - X1 );
        Initialize_Radius_And_Matrix( X1, Y1, X_Size, Y_Size );
        Procedures[ Byte( Character ) ];
        Drawing_Color := Save_Draw_Color;
        Filling_Color := Save_Fill_Color;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Draw string.
    As previously defined.

*************************************************)

    Procedure Draw_String( X1, Y1, X2, Y2: Integer; Sentence: String );
      Var
        X_Size,
        Y_Size: Word;
        Counter,
        Save_Draw_Color,
        Save_Fill_Color: Byte;
      Begin
        Save_Draw_Color := Drawing_Color;
        Save_Fill_Color := Filling_Color;
        Drawing_Color := Character_Color;
        Filling_Color := Character_Color;
        Y_Size := ( Y2 - Y1 );
        X_Size := ( ( X2 - X1 ) div Length( Sentence ) );
        Initialize_Radius_And_Matrix( X1, Y1, X_Size, Y_Size );
        For Counter := 1 to Length( Sentence ) do
          Begin
            Procedures[ Byte( Sentence[ Counter ] ) ];
            Update_Matrix( X_Size );
          End;
        Drawing_Color := Save_Draw_Color;
        Filling_Color := Save_Fill_Color;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure: Initialize standard characters.
    As previously defined.

*************************************************)

    Procedure Initialize_Standard_Characters;
      Begin
        Procedures[ 0 ] := Plot_0;
        Procedures[ 1 ] := Plot_1;
        Procedures[ 2 ] := Plot_2;
        Procedures[ 3 ] := Plot_3;
        Procedures[ 4 ] := Plot_4;
        Procedures[ 5 ] := Plot_5;
        Procedures[ 6 ] := Plot_6;
        Procedures[ 7 ] := Plot_7;
        Procedures[ 8 ] := Plot_8;
        Procedures[ 9 ] := Plot_9;
        Procedures[ 10 ] := Plot_10;
        Procedures[ 11 ] := Plot_11;
        Procedures[ 12 ] := Plot_12;
        Procedures[ 13 ] := Plot_13;
        Procedures[ 14 ] := Plot_14;
        Procedures[ 15 ] := Plot_15;
        Procedures[ 16 ] := Plot_16;
        Procedures[ 17 ] := Plot_17;
        Procedures[ 18 ] := Plot_18;
        Procedures[ 19 ] := Plot_19;
        Procedures[ 20 ] := Plot_20;
        Procedures[ 21 ] := Plot_21;
        Procedures[ 22 ] := Plot_22;
        Procedures[ 23 ] := Plot_23;
        Procedures[ 24 ] := Plot_24;
        Procedures[ 25 ] := Plot_25;
        Procedures[ 26 ] := Plot_26;
        Procedures[ 27 ] := Plot_27;
        Procedures[ 28 ] := Plot_28;
        Procedures[ 29 ] := Plot_29;
        Procedures[ 30 ] := Plot_30;
        Procedures[ 31 ] := Plot_31;
        Procedures[ 32 ] := Plot_32;
        Procedures[ 33 ] := Plot_33;
        Procedures[ 34 ] := Plot_34;
        Procedures[ 35 ] := Plot_35;
        Procedures[ 36 ] := Plot_36;
        Procedures[ 37 ] := Plot_37;
        Procedures[ 38 ] := Plot_38;
        Procedures[ 39 ] := Plot_39;
        Procedures[ 40 ] := Plot_40;
        Procedures[ 41 ] := Plot_41;
        Procedures[ 42 ] := Plot_42;
        Procedures[ 43 ] := Plot_43;
        Procedures[ 44 ] := Plot_44;
        Procedures[ 45 ] := Plot_45;
        Procedures[ 46 ] := Plot_46;
        Procedures[ 47 ] := Plot_47;
        Procedures[ 48 ] := Plot_48;
        Procedures[ 49 ] := Plot_49;
        Procedures[ 50 ] := Plot_50;
        Procedures[ 51 ] := Plot_51;
        Procedures[ 52 ] := Plot_52;
        Procedures[ 53 ] := Plot_53;
        Procedures[ 54 ] := Plot_54;
        Procedures[ 55 ] := Plot_55;
        Procedures[ 56 ] := Plot_56;
        Procedures[ 57 ] := Plot_57;
        Procedures[ 58 ] := Plot_58;
        Procedures[ 59 ] := Plot_59;
        Procedures[ 60 ] := Plot_60;
        Procedures[ 61 ] := Plot_61;
        Procedures[ 62 ] := Plot_62;
        Procedures[ 63 ] := Plot_63;
        Procedures[ 64 ] := Plot_64;
        Procedures[ 65 ] := Plot_65;
        Procedures[ 66 ] := Plot_66;
        Procedures[ 67 ] := Plot_67;
        Procedures[ 68 ] := Plot_68;
        Procedures[ 69 ] := Plot_69;
        Procedures[ 70 ] := Plot_70;
        Procedures[ 71 ] := Plot_71;
        Procedures[ 72 ] := Plot_72;
        Procedures[ 73 ] := Plot_73;
        Procedures[ 74 ] := Plot_74;
        Procedures[ 75 ] := Plot_75;
        Procedures[ 76 ] := Plot_76;
        Procedures[ 77 ] := Plot_77;
        Procedures[ 78 ] := Plot_78;
        Procedures[ 79 ] := Plot_79;
        Procedures[ 80 ] := Plot_80;
        Procedures[ 81 ] := Plot_81;
        Procedures[ 82 ] := Plot_82;
        Procedures[ 83 ] := Plot_83;
        Procedures[ 84 ] := Plot_84;
        Procedures[ 85 ] := Plot_85;
        Procedures[ 86 ] := Plot_86;
        Procedures[ 87 ] := Plot_87;
        Procedures[ 88 ] := Plot_88;
        Procedures[ 89 ] := Plot_89;
        Procedures[ 90 ] := Plot_90;
        Procedures[ 91 ] := Plot_91;
        Procedures[ 92 ] := Plot_92;
        Procedures[ 93 ] := Plot_93;
        Procedures[ 94 ] := Plot_94;
        Procedures[ 95 ] := Plot_95;
        Procedures[ 96 ] := Plot_96;
        Procedures[ 97 ] := Plot_97;
        Procedures[ 98 ] := Plot_98;
        Procedures[ 99 ] := Plot_99;
        Procedures[ 100 ] := Plot_100;
        Procedures[ 101 ] := Plot_101;
        Procedures[ 102 ] := Plot_102;
        Procedures[ 103 ] := Plot_103;
        Procedures[ 104 ] := Plot_104;
        Procedures[ 105 ] := Plot_105;
        Procedures[ 106 ] := Plot_106;
        Procedures[ 107 ] := Plot_107;
        Procedures[ 108 ] := Plot_108;
        Procedures[ 109 ] := Plot_109;
        Procedures[ 110 ] := Plot_110;
        Procedures[ 111 ] := Plot_111;
        Procedures[ 112 ] := Plot_112;
        Procedures[ 113 ] := Plot_113;
        Procedures[ 114 ] := Plot_114;
        Procedures[ 115 ] := Plot_115;
        Procedures[ 116 ] := Plot_116;
        Procedures[ 117 ] := Plot_117;
        Procedures[ 118 ] := Plot_118;
        Procedures[ 119 ] := Plot_119;
        Procedures[ 120 ] := Plot_120;
        Procedures[ 121 ] := Plot_121;
        Procedures[ 122 ] := Plot_122;
        Procedures[ 123 ] := Plot_123;
        Procedures[ 124 ] := Plot_124;
        Procedures[ 125 ] := Plot_125;
        Procedures[ 126 ] := Plot_126;
        Procedures[ 127 ] := Plot_127;
        Procedures[ 128 ] := Plot_128;
        Procedures[ 129 ] := Plot_129;
        Procedures[ 130 ] := Plot_130;
        Procedures[ 131 ] := Plot_131;
        Procedures[ 132 ] := Plot_132;
        Procedures[ 133 ] := Plot_133;
        Procedures[ 134 ] := Plot_134;
        Procedures[ 135 ] := Plot_135;
        Procedures[ 136 ] := Plot_136;
        Procedures[ 137 ] := Plot_137;
        Procedures[ 138 ] := Plot_138;
        Procedures[ 139 ] := Plot_139;
        Procedures[ 140 ] := Plot_140;
        Procedures[ 141 ] := Plot_141;
        Procedures[ 142 ] := Plot_142;
        Procedures[ 143 ] := Plot_143;
        Procedures[ 144 ] := Plot_144;
        Procedures[ 145 ] := Plot_145;
        Procedures[ 146 ] := Plot_146;
        Procedures[ 147 ] := Plot_147;
        Procedures[ 148 ] := Plot_148;
        Procedures[ 149 ] := Plot_149;
        Procedures[ 150 ] := Plot_150;
        Procedures[ 151 ] := Plot_151;
        Procedures[ 152 ] := Plot_152;
        Procedures[ 153 ] := Plot_153;
        Procedures[ 154 ] := Plot_154;
        Procedures[ 155 ] := Plot_155;
        Procedures[ 156 ] := Plot_156;
        Procedures[ 157 ] := Plot_157;
        Procedures[ 158 ] := Plot_158;
        Procedures[ 159 ] := Plot_159;
        Procedures[ 160 ] := Plot_160;
        Procedures[ 161 ] := Plot_161;
        Procedures[ 162 ] := Plot_162;
        Procedures[ 163 ] := Plot_163;
        Procedures[ 164 ] := Plot_164;
        Procedures[ 165 ] := Plot_165;
        Procedures[ 166 ] := Plot_166;
        Procedures[ 167 ] := Plot_167;
        Procedures[ 168 ] := Plot_168;
        Procedures[ 169 ] := Plot_169;
        Procedures[ 170 ] := Plot_170;
        Procedures[ 171 ] := Plot_171;
        Procedures[ 172 ] := Plot_172;
        Procedures[ 173 ] := Plot_173;
        Procedures[ 174 ] := Plot_174;
        Procedures[ 175 ] := Plot_175;
        Procedures[ 176 ] := Plot_176;
        Procedures[ 177 ] := Plot_177;
        Procedures[ 178 ] := Plot_178;
        Procedures[ 179 ] := Plot_179;
        Procedures[ 180 ] := Plot_180;
        Procedures[ 181 ] := Plot_181;
        Procedures[ 182 ] := Plot_182;
        Procedures[ 183 ] := Plot_183;
        Procedures[ 184 ] := Plot_184;
        Procedures[ 185 ] := Plot_185;
        Procedures[ 186 ] := Plot_186;
        Procedures[ 187 ] := Plot_187;
        Procedures[ 188 ] := Plot_188;
        Procedures[ 189 ] := Plot_189;
        Procedures[ 190 ] := Plot_190;
        Procedures[ 191 ] := Plot_191;
        Procedures[ 192 ] := Plot_192;
        Procedures[ 193 ] := Plot_193;
        Procedures[ 194 ] := Plot_194;
        Procedures[ 195 ] := Plot_195;
        Procedures[ 196 ] := Plot_196;
        Procedures[ 197 ] := Plot_197;
        Procedures[ 198 ] := Plot_198;
        Procedures[ 199 ] := Plot_199;
        Procedures[ 200 ] := Plot_200;
        Procedures[ 201 ] := Plot_201;
        Procedures[ 202 ] := Plot_202;
        Procedures[ 203 ] := Plot_203;
        Procedures[ 204 ] := Plot_204;
        Procedures[ 205 ] := Plot_205;
        Procedures[ 206 ] := Plot_206;
        Procedures[ 207 ] := Plot_207;
        Procedures[ 208 ] := Plot_208;
        Procedures[ 209 ] := Plot_209;
        Procedures[ 210 ] := Plot_210;
        Procedures[ 211 ] := Plot_211;
        Procedures[ 212 ] := Plot_212;
        Procedures[ 213 ] := Plot_213;
        Procedures[ 214 ] := Plot_214;
        Procedures[ 215 ] := Plot_215;
        Procedures[ 216 ] := Plot_216;
        Procedures[ 217 ] := Plot_217;
        Procedures[ 218 ] := Plot_218;
        Procedures[ 219 ] := Plot_219;
        Procedures[ 220 ] := Plot_220;
        Procedures[ 221 ] := Plot_221;
        Procedures[ 222 ] := Plot_222;
        Procedures[ 223 ] := Plot_223;
        Procedures[ 224 ] := Plot_224;
        Procedures[ 225 ] := Plot_225;
        Procedures[ 226 ] := Plot_226;
        Procedures[ 227 ] := Plot_227;
        Procedures[ 228 ] := Plot_228;
        Procedures[ 229 ] := Plot_229;
        Procedures[ 230 ] := Plot_230;
        Procedures[ 231 ] := Plot_231;
        Procedures[ 232 ] := Plot_232;
        Procedures[ 233 ] := Plot_233;
        Procedures[ 234 ] := Plot_234;
        Procedures[ 235 ] := Plot_235;
        Procedures[ 236 ] := Plot_236;
        Procedures[ 237 ] := Plot_237;
        Procedures[ 238 ] := Plot_238;
        Procedures[ 239 ] := Plot_239;
        Procedures[ 240 ] := Plot_240;
        Procedures[ 241 ] := Plot_241;
        Procedures[ 242 ] := Plot_242;
        Procedures[ 243 ] := Plot_243;
        Procedures[ 244 ] := Plot_244;
        Procedures[ 245 ] := Plot_245;
        Procedures[ 246 ] := Plot_246;
        Procedures[ 247 ] := Plot_247;
        Procedures[ 248 ] := Plot_248;
        Procedures[ 249 ] := Plot_249;
        Procedures[ 250 ] := Plot_250;
        Procedures[ 251 ] := Plot_251;
        Procedures[ 252 ] := Plot_252;
        Procedures[ 253 ] := Plot_253;
        Procedures[ 254 ] := Plot_254;
        Procedures[ 255 ] := Plot_255;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Procedure Set character color.
    As previously defined.

*************************************************)

    Procedure Set_Character_Color( Color: Byte );
      Begin
        Character_Color := Color;
      End;

{-----------------------------------------------------------------------------}

(*************************************************

  Main initialization section.

*************************************************)

    Begin
      Character_Color := 1;
      Initialize_Standard_Characters;
    End.

