{ Created: 1993-12-01

Program to test the Post Mortem Debugger

}


{$Q+}
program TestPMD;

uses
  Objects,
{$IFDEF Windows}
  WinCrt,
{$ENDIF}
  BBError,                   { implements the logging function            }
                             { should be listed before any unit           }
                             { which uses logging                         }
  ObjMemory,                 { Handles memory allocations larger than 64K }
  PMD;                       { this unit implements the Post Mortem dumps }


type
  types = (test1, test2, test3);


procedure GenerateError(var f : text; e: types);
var
  s : string;

  procedure InSide(o : TObjMemory);
  var
    w : word;
    d : real;
  begin
    d := 3.1415;
    w := 0;
    w := w - 1;
  end;

begin
  s := 'Hello world';
  InSide(GetObjMemory(100, 0, memfAll)^);
end;


var
  f : text;
begin
{ display information about this program }
  writeln('Post Mortem Debugger tester.');
  writeln('If this program is compiled with debug info on,');
  writeln('see TESTPMD.LOG after this program halts.');

{ initialize the kit in the next three lines. You will always need these }
{ lines in your program too                                              }

{ initialize log file unit }
  InitBBError('TESTPMD.LOG', TRUE);

{ initialize memory handling unit }
  InitObjMemory;

{ initialize PMD with symbolic stack dump and data segment dump }
  InitPMD(dfStandard+dfLocals);

{ you can also initialize PMD with symbolic stack dump and data segment dump }
  {InitPMD(dfStandard+dfLocals+dfDataSeg);}

{ open a text file, nice in symbolic stack dump and dseg dump }
  Assign(f, 'TESTPMD.PAS');
  Reset(f);

{ generate the error }
  GenerateError(f, test2);

{ we don't need to clean up of course, because we will never reach this... }
end.
