{

Program to show application of MemCheck. Compile with debug info enabled
if you want the InitPMD to have any effect.

}

{$IFDEF Windows}
{$DEFINE WinCrt}
{$ENDIF}


{$X+}
program TestMem;

uses
{$IFDEF WinCrt}
  WinCrt,
{$ENDIF}
  BBError,                   { implements the logging function            }
                             { should be listed before any unit           }
                             { which uses logging                         }
  MemCheck,                  { the allocation/deallocation tracker unit   }
  ObjMemory,                 { Handles memory allocations larger than 64K }
  PMD;                       { this unit implements the Post Mortem dumps }


var
  p : pointer;
  c : char;

procedure DisposeBug;
begin
  FreeMem(p, 200);
end;

procedure OverwriteBug;
begin
  PChar(p)[100] := #0;
  FreeMem(p, 100);
end;

{$IFDEF WinCrt}
var
  SkipMemCheckExitProc: pointer;
{$ENDIF}

begin
{ in WinCrt we need to disable MemCheck's exit procedure, because
  WinCrt disposes memory after all exit procedures have been called...
  (in its callback function) }
{$IFDEF WinCrt}
  SkipMemCheckExitProc := ExitProc;
{$ENDIF}

{ call InitMemCheck always to enable memory checking }
  InitMemCheck(mfStandard);

{ WinCrt needs this... }
{$IFDEF WinCrt}
  ExitProc := SkipMemCheckExitProc;
{$ENDIF}

{ use a log file }
  InitBBError('TESTMEM.LOG', TRUE);

{ initialize memory routines }
  InitObjMemory;

{ initialize symbolic dump }
  InitPMD(dfStandard);

{ and do the 'real' stuff }
  GetMem(p, 100);
  writeln('1. Dispose other size than allocated.');
  writeln('2. Write into memory after allocated memory block.');
  writeln('3. Allocated, but not deallocated -> see ', ReportFileName, '.');
  writeln('X. Exit');
  writeln;
  write('Type 1, 2, 3 or X and press ENTER => ');
  read(c);
  case c of
    '1' : DisposeBug;
    '2' : OverwriteBug;
    '3' : MemCheckReport;
  end;
end.
