(* This file was mangled by Mangler 1.40 (c) Copyright 1993-1994 by Berend de Boer *)
{ Created : 1993-09-22

BBGui is a generic user interface which provides simple i/o services to low
level programs. BBGui is adaptable to any gui as Windows or TurboVision. As
is, it only provides a stdio/dos interface.


Last changes :
93-12-08  Made Beep public. Beep removed from BBUtil
93-12-16  Added a portable Delay routine to BBGui
          Added a portable Pause function which should give up a time slice
93-12-31  Added PrintWarning
94-03-17  Added BeepOff and BeepOn to turn beeping on and off
94-05-02  Added OpenProgressDlg and CloseProgressDlg to show a running
          percentage (use SetProgressDlg)
94-05-16  Adapted to the Windows environment
}





{$IFDEF MSDos}
{$F+,O+,D-}
{$ENDIF}

{S-,R-,Q-,I-}
unit BBGui;

interface


{* TurboVision constants *}
const
  cmYes = 12;
  cmNo = 13;


type
  SpawnModes = (P_WAIT, P_NOWAIT, P_OVERLAY);

type
  CloseProgressDlgType = procedure;
  DelayType = procedure(MS : word);
  FatalErrorType = procedure(const s : string; AHelpCtx : word);
  InfoBoxType = procedure(const s : string; AHelpCtx : word);
  OpenProgressDlgType = procedure(const ATitle : string; ATotal : longint);
  PauseType = procedure;
  PrintErrorType = procedure(const s : string; AHelpCtx : word);
  PrintWarningType = procedure(const s : string; AHelpCtx : word);
  SetProgressDlgType = procedure(Position : longint);
  SpawnType = procedure(Mode : SpawnModes; const Path, CmdLine : string);
  UserAnswerType = function(const s : string; AHelpCtx : word) : word;


procedure Beep;
procedure BeepOff;
procedure BeepOn;
procedure DefaultSpawn(Mode : SpawnModes; const Path, CmdLine : string);
procedure DosDelay(MS : word);
{$IFNDEF Windows}
function GetTickCount : longint;
{$ENDIF}
procedure NoPause;
procedure TextCloseProgressDlg;
procedure TextFatalError(const s : string; AHelpCtx : word);
procedure TextInfoBox(const s : string; AHelpCtx : word);
procedure TextOpenProgressDlg(const ATitle : string; ATotal : longint);
procedure TextPrintError(const s : string; AHelpCtx : word);
procedure TextPrintWarning(const s : string; AHelpCtx : word);
procedure TextSetProgressDlg(Position : longint);
function  TextUserAnswer(const s : string; AHelpCtx : word) : word;



const
  CloseProgressDlg : CloseProgressDlgType = TextCloseProgressDlg;
  Delay : DelayType = DosDelay;
  FatalError : FatalErrorType = TextFatalError;
  InfoBox : InfoBoxType = TextInfoBox;
  OpenProgressDlg : OpenProgressDlgType = TextOpenProgressDlg;
  Pause : PauseType = NoPause;
  PrintError : PrintErrorType = TextPrintError;
  PrintWarning : PrintWarningType = TextPrintWarning;
  SetProgressDlg : SetProgressDlgType = TextSetProgressDlg;
  Spawn : SpawnType = DefaultSpawn;
  UserAnswer : UserAnswerType = TextUserAnswer;



 IMPLEMENTATION USES {$IFDEF Windows}{$IFDEF Ver80}SYSUTILS ,WINPROCS ,WINTYPES ,{$ELSE}STRINGS ,WINAPI ,WINPROCS
,{$ENDIF}{$ELSE}DOS ,{$ENDIF}BBERROR ,BBFILE ,BBUTIL ;CONST O1l111O01III:BOOLEAN=TRUE;O1l1l1011OO1:STRING ='';
OlI10I0lI1:LONGINT=0 ;O1010Ol0l00O1:LONGINT=0 ;{$IFDEF Windows}PROCEDURE BEEP ;BEGIN IF O1l111O01III THEN MESSAGEBEEP
($FFFF );END ;{$ELSE}PROCEDURE BEEP ;ASSEMBLER;ASM {} MOV AL , O1l111O01III{} CMP AL , 0 {} JE @@nobeep {}
MOV DL , 07h {} MOV AH , 02h {} INT 21h {} @@nobeep : {} END;{$ENDIF}PROCEDURE BEEPOFF ;BEGIN O1l111O01III :=FALSE ;
END ;PROCEDURE BEEPON ;BEGIN O1l111O01III :=TRUE ;END ;PROCEDURE DEFAULTSPAWN (MODE:SPAWNMODES;CONST PATH,CMDLINE:STRING
);BEGIN {$IFDEF Windows}PRINTERROR ('Spawning of programs not supported under Windows.',0 );{$ELSE}SWAPVECTORS ;EXEC
(PATH ,CMDLINE );SWAPVECTORS ;{$ENDIF}END ;PROCEDURE DOSDELAY (MS:WORD);VAR O1011l1l0llI0:LONGINT;O1010I1I0l1O0:LONGINT;
BEGIN O1011l1l0llI0 :=GETTICKCOUNT ;O1010I1I0l1O0 :=O1011l1l0llI0 + ROUND ((MS / (1000 / 18.2 )));REPEAT PAUSE ;UNTIL
GETTICKCOUNT >= O1010I1I0l1O0 ;END ;{$IFNDEF Windows}FUNCTION GETTICKCOUNT :LONGINT ;BEGIN GETTICKCOUNT :=MEML [ SEG0040
:$6C ] ;END ;{$ENDIF}PROCEDURE NOPAUSE ;BEGIN END ;PROCEDURE TEXTCLOSEPROGRESSDLG ;BEGIN WRITELN ;O1l1l1011OO1 :='';
END ;PROCEDURE TEXTFATALERROR (CONST S:STRING ;AHELPCTX:WORD);BEGIN PRINTERROR (S ,AHELPCTX );HALT (1 );END ;
PROCEDURE TEXTINFOBOX (CONST S:STRING ;AHELPCTX:WORD);{$IFDEF Windows}VAR OIOI1l01I01:ARRAY [ 0 .. 255 ]  OF CHAR;
{$ENDIF}BEGIN {$IFDEF Windows}MESSAGEBOX (0 ,STRPCOPY (OIOI1l01I01 ,S ),'Information',MB_OK + MB_ICONINFORMATION );
{$ELSE}WRITELN (S );{$ENDIF}END ;PROCEDURE TEXTPRINTERROR (CONST S:STRING ;AHELPCTX:WORD);VAR O100llIl00IOl:WORD;
{$IFDEF Windows}OIOI1l01I01:ARRAY [ 0 .. 255 ]  OF CHAR;{$ENDIF}BEGIN ASM {} MOV O100llIl00IOl, BP {} END;BEEP ;
{$IFDEF Windows}MESSAGEBOX (0 ,STRPCOPY (OIOI1l01I01 ,S ),NIL ,MB_OK );{$ELSE}WRITELN ('Error: ',S );{$ENDIF}LOGERROR
('Error: '+ S );IF @ DUMPSTACK <> NIL THEN DUMPSTACK (NIL ,O100llIl00IOl );END ;PROCEDURE TEXTOPENPROGRESSDLG
(CONST ATITLE:STRING ;ATOTAL:LONGINT);BEGIN WRITE (ATITLE ,' 0%');O1l1l1011OO1 :=ATITLE ;OlI10I0lI1 :=ATOTAL ;
O1010Ol0l00O1 :=0 ;END ;PROCEDURE TEXTSETPROGRESSDLG (POSITION:LONGINT);BEGIN IF O1l1l1011OO1 <> ''THEN BEGIN IF POSITION
>= OlI10I0lI1 THEN WRITE (CR ,O1l1l1011OO1 ,' 100%')ELSE BEGIN IF (POSITION - O1010Ol0l00O1 )>= 0.025 * OlI10I0lI1 THEN
BEGIN WRITE (CR ,O1l1l1011OO1 ,' ',(POSITION * 100 )DIV OlI10I0lI1 ,'%');O1010Ol0l00O1 :=POSITION ;END ;END ;END ;END ;
PROCEDURE TEXTPRINTWARNING (CONST S:STRING ;AHELPCTX:WORD);{$IFDEF Windows}VAR OIOI1l01I01:ARRAY [ 0 .. 255 ]  OF CHAR;
{$ENDIF}BEGIN BEEP ;{$IFDEF Windows}MESSAGEBOX (0 ,STRPCOPY (OIOI1l01I01 ,S ),NIL ,MB_OK + MB_ICONEXCLAMATION );
{$ELSE}WRITELN ('Warning: ',S );{$ENDIF}LOGERROR ('Warning: '+ S );END ;FUNCTION TEXTUSERANSWER (CONST S:STRING ;
AHELPCTX:WORD):WORD ;VAR OOlIll10O1ll:STRING ;BEGIN WRITELN (S );REPEAT READLN (OOlIll10O1ll );UNTIL (OOlIll10O1ll <>
'')AND (UPCASE (OOlIll10O1ll [ 1 ] )IN [ 'Y','N'] );IF UPSTR (OOlIll10O1ll [ 1 ] )='Y'THEN TEXTUSERANSWER :=CMYES ELSE
TEXTUSERANSWER :=CMNO ;END ;END .
