
{ Turbo Overlays }
{ Copyright (c) 1985, 1989 by Borland International, Inc. }

{~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}
{ Program to illustrate the use of Overlays, whereby code is contained }
{ in a number of units on disk and is called into overlay section of   }
{ memory when required. Useful when memory is otherwise fully used.    }
{ Some modifications made to the original Borland program to give      }
{ screen indication of the overlay in use.                             }
{                                                                      }
{ OVRDEMO.PAS  -> .EXE      R Shaw      15.4.90                        }
{______________________________________________________________________}

{$F+,O+}
program OvrDemo;
(*
  This is a simple example of how to use the new overlay system. For
  more complete documentation, refer to the overlay chapter in the
  Turbo Pascal manual. Here's a quick checklist:

    1.  Turn "far calls" on {$F+} (to be safe, in all overlaid units and
        the main program).
    2.  Turn "Overlays allowed" on {$O+}
    3.  Use Overlay unit in main program.
    4.  Issue separate {$O} directives for each overlaid unit.
    5.  Make sure to call OvrInit and pass the name of the .OVR file.
    6.  Test OvrResult after OvrInit calls (optional).
    7.  Compile to disk (cannot run in memory).

  Here the overlay error returns for quick reference:

    const
      ovrOk          =  0;   { Success }
      ovrError       = -1;   { Overlay manager error }
      ovrNotFound    = -2;   { Overlay file not found }
      ovrNoMemory    = -3;   { Not enough memory for overlay buffer }
      ovrIOError     = -4;   { Overlay file I/O error }
      ovrNoEMSDriver = -5;   { EMS driver not installed }
      ovrNoEMSMemory = -6;   { Not enough EMS memory }
*)

uses
  Overlay, Crt, OvrDemo1, OvrDemo2;

{$O OvrDemo1}                  { overlay 'em }
{$O OvrDemo2}

begin
  TextAttr := White;
  ClrScr;
  OvrInit('OVRDEMO.OVR');          { init overlay system, reserve heap space }
  if OvrResult <> 0 then
  begin
    Writeln('Overlay error: ', OvrResult);
    Halt(1);
  end;
  repeat
    Write1;
    Writeln('A ten second delay introduced to allow messages to be read');
    Writeln('Press any key to stop on completion of the next overlay');
    Delay(10000);
    Write2;
    Writeln('Another ten second delay created from main program');
    Writeln('Press any key to stop on completion of this second overlay');
    Delay(10000);
  until KeyPressed;
end.
