(******************************************************************************
*                                    calc                                     *
* HyperAct Inc. CALC - Parser demo program.                                   *
* (c) 1992, 1994 HyperAct Inc, Written By Ron Loewy.                          *
* Version 3.0, Jul. 1994.                                                     *
******************************************************************************)
program calc;

uses
   parser
{$ifdef windows}
   ,wincrt
{$endif}
   ;

var
   exitFlag,
   validity : boolean;
   s        : string;
   result   : real;

(******************************************************************************
*                                  makeUpper                                  *
* receive a string, and convert it to upper-case                              *
******************************************************************************)
function makeUpper(s : string) : string;
var
   i : byte;
begin
   for i := 1 to length(s) do
      if (s[i] in ['a' .. 'z']) then
         s[i] := upCase(s[i]);
   makeUpper := s;
end; {makeUpper}

begin
   writeln('CALC V3.0, HyperAct Inc, Parser demo program');
   writeln;
   writeln('Enter mathematical expression, or QUIT/EXIT to DOS');
   writeln;
   exitFlag := false;
   repeat
      write('CALC> ');
      readln(s);
      s := makeUpper(s);
      if ((copy(s, 1, 4) = 'QUIT') or (copy(s, 1, 4) = 'EXIT')) then 
         exitFlag := true
      else begin
         result :=  getExpr(s, validity);
         if (not validity) then
            writeln('Error in expression, at position ', errAt)
         else
            writeln('RSLT> ', result);
      end; { not a QUIT command }
   until (exitFlag);
   writeln;
   writeln('Thank you for using CALC, HyperAct Inc.');
   writeln;
end.
