{ͻ
                                 TAQUIN V1.1                                
 ͹
                 GENERATED BY MRE (MOS RESOURCE EDITOR) v2.8                
 ͹
  Coded by Zuul as BouFFtou as Cheveau Frdric.                            
  Source Turbo Pascal v7.00 generated by MRE (MOS Resource Editor) v2.8.    
  Contact us on MOS Home's Page - http://www.multimania.com/mos             
 ͼ}

{$M 64000,0,465520}                     {*Stack And Heap*}

Program TAQUIN;                         {*Program Name*}

Uses Dos,                               {*Unit BP7 Graphique*}
     MOS_VAR,
     MOS_CRT,
     MOS_VESA,
     MOS_FIL,
     MOS_GPH,
     MOS_BAS,                           {*Manage Initialisations*}
     MOS_XMS,                           {*Manage XMS Memory*}
     MOS_ASM,                           {*Manage Assembler*}
     MOS_MSE,                           {*Manage Mouse*}
     MOS_DSK,                           {*Manage Disk*}
     MOS_TOO,                           {*Manage Graphics Tools*}
     MOS_GAD,                           {*Manage Gadgets*}
     MOS_WIN,                           {*Manage Windows*}
     MOS_WAV,                           {*Manage Sound Blaster*}
     MOS_BMP,                           {*Manage BMP*}
     MOS_MEN,                           {*Manage Menu*}
     MOS_EZR,
     MOS_TSK,
     MOS_DIR,                           {*Manage Files*}
     MOS_HAR,
     MOS_HRR,
     MOS_SYS,                           {*Manage System*}
     MOS_REQ,                           {*Manage Requesters*}
     MOS_SWAP;                          {*Manage External}

Const MaxB=10;                          {*Nombre Max de Blocks par Ligne*}
Const MaxHS=10;                         {*Maximum de Highscores*}

Type TPrefs=Record                      {*Structure Prfrences*}
   PPath          :String;              {*Path & Name for Image*}
   PName          :String[12];
   Line           :Byte;                {*Line Type*}
   Qtt_Line       :Byte;                {*Nombre de Lignes et de Colones*}
   Mix_Level      :Byte;                {*Level de Mixage (0 / 100%)*}
   Gfx_Back       :Byte;                {*Image in Screen Background*}
   Move_Anim      :Byte;                {*Animation=1*}
   Sound          :Byte;                {*Son Quand Move Block*}
   Done           :Byte;                {*Affichage des Blocks Bien Placs*}
   Panel          :Byte;                {*Control Panel or No*}
   Score          :Byte;                {*Type de Score (0/1/2)*}
   Player         :Byte;                {*Human / Computer*}
   End;

Type TMain=Record                       {*Structure Main*}
   WsX,WsY        :Integer;             {*Size X,Y de la Main Window*}
   Wxi,Wyi        :Integer;             {*Position X,Y Initiale de la Fentre*}
   Gx1,Gy1,Gx2,Gy2:Integer;             {*Coord Box de la Box de l'Image*}
   SBlock         :Integer;             {*Taille d'un Bloc*}
   SLine          :Byte;                {*Taille Des Lignes de Sparations*}
   IX,IY          :Integer;             {*Image Size*}
   Count          :Integer;             {*Nombre de Blocks Bien Placs*}
   ScorV          :Integer;             {*Score Ralis Blocks*}
   ITime          :Longint;             {*Temps Au commencement du Jeu*}
   CTime          :Longint;             {*Temps Actuel*}
   STime          :Longint;             {*Afficher le Nouveau Temps*}
   VideX,VideY    :Integer;             {*Position du Block Vide*}
   InGame         :Boolean;             {*On est en Train de Jouer*}
   Image          :TXMSBitmap;          {*Pointer sur Image en XMS*}
   View_One       :Boolean;             {*Display Image One Time Only*}
   Catch          :Boolean;             {*Catch Image After Modif*}
   End;

Type THScore=Record                     {*Tableau des Highscore*}
   T1             :Array[1..10] of String[30];
   T2             :Array[1..10] of String[10];
   T3             :Array[1..10] of String[10];
   B1             :Array[1..10] of String[30];
   B2             :Array[1..10] of String[10];
   B3             :Array[1..10] of String[10];
   End;

Type Block=Record                       {*Structure Block*}
   Xi,Yi          :Integer;             {*Position Initiale de l'Image*}
   X,Y            :Integer;             {*Position Actuelle de l'Image*}
   End;

Type Blocks       =Array[1..MaxB, 1..MaxB] of Block;{*Structure Blocks*}

Var  Pi           :TXMSBitmap;          {*Pointer sur Image du Block en XMS*}

{****************************************************************************}

Procedure DISPLAY_BLANK_BLOCK(X,Y:Integer; P:TPrefs; M:TMain; W:TWindow); Forward;

{ͻ
                            PROCEDURE LOAD_PREFS                            
 ͼ}

Function LOAD_PREFS(FName:String; Var MP:TPrefs):Boolean;
Var F             :File;
Begin
If Not File_TestExist(FName) Then    {*Fichier Prfrences Introuvable*}
   Begin
   LOAD_PREFS:=False; Exit;
   End;
Assign(F,FName);
{$I-}
Reset(F,1);                             {*Open File*}
{$I+}
If IOResult=0 Then Begin                {*No Errors ? => Ok !*}
   BlockRead(F,MP,Sizeof(MP));
   LOAD_PREFS:=True;                    {*Ok : No Errors !*}
   Close(F);
   End
   Else LOAD_PREFS:=False;              {*Cannot Open File !*}
End;

{ͻ
                            PROCEDURE SAVE_PREFS                            
 ͼ}

Function SAVE_PREFS(FName:String; MP:TPrefs):Boolean;
Var F             :File;
Begin
Assign(F,FName);
{$I-}
Rewrite(F,1);                           {*Create File*}
{$I+}
If IOResult=0 Then Begin                {*No Errors ? => Ok !*}
   BlockWrite(F,MP,Sizeof(MP));
   SAVE_PREFS:=True;                    {*Ok : No Errors !*}
   Close(F);
   End
   Else SAVE_PREFS:=False;              {*Cannot Open File !*}
End;

{ͻ
                          PROCEDURE LOAD_HSCORES                            
 ͼ}

Function LOAD_HSCORES(FName:String; Var HS:THscore):Boolean;
Var F             :File;
Begin
If Not File_TestExist(FName) Then    {*Fichier Prfrences Introuvable*}
   Begin
   LOAD_HSCORES:=False; Exit;
   End;
Assign(F,FName);
{$I-}
Reset(F,1);                             {*Open File*}
{$I+}
If IOResult=0 Then Begin                {*No Errors ? => Ok !*}
   BlockRead(F,HS,Sizeof(HS));
   LOAD_HSCORES:=True;                  {*Ok : No Errors !*}
   Close(F);
   End
   Else LOAD_HSCORES:=False;            {*Cannot Open File !*}
End;

{ͻ
                           PROCEDURE SAVE_HSCORES                           
 ͼ}

Function SAVE_HSCORES(FName:String; HS:THScore):Boolean;
Var F             :File;
Begin
Assign(F,FName);
{$I-}
Rewrite(F,1);                           {*Create File*}
{$I+}
If IOResult=0 Then Begin                {*No Errors ? => Ok !*}
   BlockWrite(F,HS,Sizeof(HS));
   SAVE_HSCORES:=True;                  {*Ok : No Errors !*}
   Close(F);
   End
   Else SAVE_HSCORES:=False;            {*Cannot Open File !*}
End;

{ͻ
                             PROCEDURE INIT_ALL                             
 ͼ}

Procedure INIT_ALL(Var M:TMain; Var P:TPrefs; Var HS:THScore);
Var A:Integer;
Begin
With M do Begin                         {*Define Main Values de Base*}
   Wxi:=145;
   Wyi:=54;
   InGame:=No;
   View_One:=Yes;
   Catch:=No;
   End;
With P do Begin                         {*Define Prefs de Base*}
   PPath:='';
   PName:='BLU_NOTE.BMP';
   PPath:='D:\MOS\IMAGES\';
   PName:='FIR_LAKE.BMP';
   Line:=2;
   Qtt_Line:=5;
   Mix_Level:=100;
   Gfx_Back:=1;
   Move_Anim:=1;
   Sound:=1;
   Done:=1;
   Panel:=1;
   Score:=2;
   Player:=1;
   End;

For A:=1 to MaxHS do
   Begin
   With HS do Begin                        {*Clear Highscores...*}
      T1[A]:='Nobody'; T2[A]:='0'; T3[A]:='0';
      B1[A]:='Nobody'; B2[A]:='0'; B3[A]:='0';
      End;
   End;

LOAD_PREFS('TAQUIN.CFG',P);             {*Load Prefs if Exist*}
LOAD_HSCORES('TAQUIN.THS',HS);          {*Load Highscores*}
If P.Gfx_Back=1 Then Gfx_Screen:=P.PPath+P.PName;
End;

{ͻ
                             PROCEDURE DONE_ALL                             
 ͼ}

Procedure DONE_ALL(P:TPrefs; M:TMain; B:Blocks; HS:THScore);
Begin
XMS_FreeBitmap(M.Image);                {*Libre la Mmoire XMS Alloue*}
SAVE_HSCORES('TAQUIN.THS',HS);          {*Save Highscores Time*}
End;

{ͻ
                        CALCULE SIZE WINDOW ET AUTRE                        
 ͼ}

Procedure CALCULE_DATAS(P:TPrefs; Var M:TMain);
Var FName:String;
    Sx,Sy,SizeT:Word;
    Col,Dif,DelY:Longint;
Begin

{================ CALCUL DE LA TAILLE DE LA FENETRE PRINCIPALE ==============}

Sx:=0; Sy:=0;                           {*De Base...*}
M.IX:=LaF*38; M.IY:=HaF*16+1;

M.IX:=180; M.IY:=180;                   {*Au cas ou Pas de BMP...*}
Sx:=180; Sy:=180;
FName:=P.PPath+P.PName;                 {*Compute FileName*}
If File_TestExist(FName) Then
   If Test_BMP(FName) Then              {*Is it a BMP ?*}
      Begin
      Get_BMPInfo(FName,Sx,Sy,Col);    {*Get Image Size*}
{gotoxy(1,2);writeln('Sx = ',Sx,' Sy = ',SY, ' ');
      Sx:=220; Sy:=220;}
      If Sy>VESA_GetMaxY-HaF1*2-HaF*6 Then Sy:=VESA_GetMaxY-HaF1*2-HaF*6;
      If Sx>Sy Then Sx:=Sy;
      If Sy>Sx Then Sy:=Sx;             {*Resize Image to Carr*}
      M.IX:=Sx; M.IY:=Sy;

      M.SBlock:=M.IX Div P.Qtt_Line;    {*Prcalcul de la Taille d'un Bloc*}
      Dif:=M.IX-M.SBlock*P.Qtt_Line;    {*Sucre les MODULOS X et Y*}
      M.IX:=M.IX-Dif; M.IY:=M.IX;
      Sx:=M.IX; Sy:=M.IY;               {*Restocke les Paramtres*}

      If Sx>VESA_GetMaxX-50 Then Sx:=VESA_GetMaxX-50;{*Image Trop Grande !*}
      If Sy>VESA_GetMaxY-HaF1 Then Sy:=VESA_GetMaxY-HaF1;
      End;

If P.Panel=0 Then Sx:=Sx+LaF*8;         {*Inc X*}
Sy:=Sy+HaF1+HaF*6;                      {*Inc Y*}
{gotoxy(1,3);writeln('Sx = ',Sx,' Sy = ',SY, ' ');}

If P.Panel=1 Then Sx:=Sx+LaF*32;        {*Panel dans Fentre en Plus*}

If (P.Panel=1) And (Sy<HaF1+HaF*27+6) Then Sy:=HaF1+HaF*27+6;{*Size Y Minimum*}
If (P.Panel=0) And (Sy<HaF1+HaF*5+6+M.IY) Then Sy:=HaF1+HaF*5+6+M.IY;{*Size Y Minimum*}

If (P.Panel=1) And (Sx<LaF*70) Then SX:=LaF*70;  {*Size X Minimum Avec Panel*}
If (P.Panel=0) And (Sx<LaF*50) Then SX:=LaF*50;  {*Size X Minimum Sans Panel*}

If (P.Panel=0) And (P.Score=0) And (P.Done=0) Then DelY:=HaF*2
                                              Else DelY:=0;
Sy:=Sy-DelY;                            {*Si pas de Score => Dcale + Haut !*}

M.WsX:=Sx;
M.WsY:=Sy;                              {*Save Size X,Y de la Main Window*}
{gotoxy(1,3);writeln('WSx = ',M.WsX, ' ');
gotoxy(1,4);writeln('WSy = ',M.WsY, ' ');
wait;}

{============== CALCUL DES COORDONNEES DE LA BOITE DE L'IMAGE ===============}

If P.Panel=1 Then M.Gx1:=LaF*28
             Else M.Gx1:=LaF*4;         {*Dbut Gauche de la Fentre Game*}

M.Gy1:=HaF*4+1-DelY;
M.Gx2:=M.Gx1+M.IX;
M.Gy2:=M.Gy1+M.IY;

{==================== CENTRAGE DE LA BOITE DE L'IMAGE =======================}

If P.Panel=0 Then Begin
   SizeT:=M.Gx2-M.Gx1;                  {*Keep True Size*}
   M.Gx1:=(M.WsX Div 2)-((M.Gx2-M.Gx1) Div 2);
   M.Gx2:=M.Gx1+SizeT;
   End;

{===================== CALCUL DE LA TAILLE D'UN BLOC ========================}

M.SBlock:=M.IX Div P.Qtt_Line;          {*Taille d'un Bloc*}
M.SLine:=1;                             {*Epaisseur de la Ligne = 1 de Base*}

If P.Line=4 Then Inc(M.SLine);          {*Taille -1 Car Relief*}
If P.Line=5 Then Dec(M.SLine);          {*Taille +1 Car pas de Traits*}

M.ScorV:=0;                             {*Score Ralis*}
End;

{****************************************************************************}
{****************************************************************************}
{****************************************************************************}
{****************************************************************************}
{****************************************************************************}
{****************************************************************************}

{ͻ
     TESTE SI LE NOUVEAU SCORE DOIT ETRE MIS DANS LA TABLE DES HIGHSCORES   
 ͼ}

Function TEST_NEW_SCORE(P:TPrefs; M:TMain; HS:THScore):Byte;   {*Test New Score...*}
Var A:Integer;
    V2,Code2:Integer;
    V3,Code3:Integer;
    POk:Byte;                           {*Position du Highscore si Ok...*}
    Rat1,Rat2:Real;                     {*Ratio 1 et 2...*}

Begin
POk:=0;
For A:=1 to MaxHS do                    {*As-t'on un Highscore ?*}
   Begin
   If P.Score=1 Then Begin              {*Read Time HighScores*}
      Val(HS.T2[A],V2,Code2);
      Val(HS.T3[A],V3,Code3);
      Rat2:=(M.CTime-M.ITime)/((P.Qtt_Line*P.Qtt_Line)*1.5);
      End;
   If P.Score=2 Then Begin              {*Read Block HighScores*}
      Val(HS.B2[A],V2,Code2);
      Val(HS.B3[A],V3,Code3);
      Rat2:=(M.ScorV)/((P.Qtt_Line*P.Qtt_Line)*1.5);
      End;
                                        {*Calcul des Ratios Comparatifs...*}
   If (V2<>0) And (V3<>0) Then Rat1:=V2/(V3*1.5);
   If (Code2=0) And (Code3=0) And (POk=0) Then
      Begin                             {*Ligne Contenant un Highscore*}
      If (V2=0) And (V3=0) Then POk:=A  {*Ligne Vierge...*}
         Else If Rat2<Rat1 Then POk:=A; {*Inserttion Entre Deux HighScores*}
      End;
   End;
If POk>0 Then TEST_NEW_SCORE:=POk       {*Trouv Position*}
         Else TEST_NEW_SCORE:=0;
End;

{ͻ
                         LECTURE DU NOUVEAU HIGHSCORE                       
 ͼ}

Procedure GET_HIGHSCORE(P:TPrefs; M:TMain; Var HS:THScore); {*Enregistre les Nouveaux Highscores*}
Var Str1:String;
    Num:Integer;
    POk:Integer;
Begin
Str1:='';
Num:=3;                                 {*Question Icon...*}
Req_String('HALL OF FAME','PLEASE ENTER YOUR NAME...','   _OK   ',100,180,Str1,Num);

POk:=TEST_NEW_SCORE(P,M,HS);            {*Get Pos New HighScore...*}

For Num:=MaxHs-1 Downto POk do          {*Decale Old HighScores*}
   Begin
   If P.Score=1 Then Begin              {*Time HighScores*}
      HS.T1[Num+1]:=HS.T1[Num];
      HS.T2[Num+1]:=HS.T2[Num];
      HS.T3[Num+1]:=HS.T3[Num];
      End;
   If P.Score=2 Then Begin              {*Block HighScores*}
      HS.B1[Num+1]:=HS.B1[Num];
      HS.B2[Num+1]:=HS.B2[Num];
      HS.B3[Num+1]:=HS.B3[Num];
      End;
   End;

If P.Score=1 Then Begin                 {*Insert New HighScore*}
   HS.T1[POk]:=Str1;
   Str(M.CTime-M.ITime,HS.T2[POk]);
   Str(P.Qtt_Line*P.Qtt_Line,HS.T3[POk]);
   End;
If P.Score=2 Then Begin
   HS.B1[POk]:=Str1;
   Str(M.ScorV,HS.B2[POk]);
   Str(P.Qtt_Line*P.Qtt_Line,HS.B3[POk]);
   End;
End;

{ͻ
                         PROCEDURE SHOW_HIGHSCORES                          
 ͼ}

Procedure SHOW_HIGHSCORES(P:TPrefs; HS:THScore);  {*Affiche Les Highscores*}

Var W1            :TWindow;             {*Window Structure*}
    Even          :Byte;                {*Get Windows Evens*}
    Exit_Flg      :Boolean;             {*Exit Flag*}
    But1          :TButton;                {*Buttons Structure*}
    Cyc1          :TCycler;                {*Cycler*}

{************************* DISPLAY WINDOW CONTENT ***************************}

Procedure REDRAW_FRAME;                 {*Define Window Content*}
Var A:Integer;
    Py,Step,Code:Integer;
    V2,V3:Integer;                      {*Pour Calcul Ratio*}
    S2,S3:String;
    Rat:String;                         {*Ratio Calcul...*}

Begin
Win_Clip(On,W1);                        {*Clipping Window*}
StringBox( LaF*4+1, HaF*2+2, LaF*86+4, HaF*19+5,1,1,False);

Button( LaF*21, HaF*21,  LaF*17,-1,0,7,$00,But1,'_OK');
Cycler( LaF*50, HaF*21,  LaF*15,  Cyc1.CyclVal,0,7,$00,Cyc1,'   TIME|  BLOCKS');

Py:=HaF*2+2;
For A:=1 to MaxHS do Begin              {*Build Gadgets Commands*}
   Step:=HaF+5;
   Step:=Step*A;
   BevelBox( LaF*6, Py+Step-5, LaF*40, Py+Step+HaF,1,4, Off,On);
   BevelBox( LaF*40,Py+Step-5, LaF*55, Py+Step+HaF,1,2, Off,On);
   BevelBox( LaF*55,Py+Step-5, LaF*70, Py+Step+HaF,1,10,Off,On);
   BevelBox( LaF*70,Py+Step-5, LaF*85, Py+Step+HaF,1,9, Off,On);
   VESA_SetColor(0);
   Mse_Hide;
   If Cyc1.CyclVal=1 Then Begin
      VESA_OutTextXY(LaF*6+3, Py+Step-9, HS.T1[A]);
      VESA_OutTextXY(LaF*40+3,Py+Step-9, HS.T2[A]+' Seconds');
      VESA_OutTextXY(LaF*55+3,Py+Step-9, HS.T3[A]+' Blocks');
      Val(HS.T2[A],V2,Code); Val(HS.T3[A],V3,Code);
      If (V2<>0) And (V3<>0) Then Str(V2/(V3+V3/2):4:2,Rat)
                             Else Rat:='0';
      VESA_OutTextXY(LaF*70+3,Py+Step-9, 'Ratio '+Copy(Rat,1,5));
      End
      Else Begin
      VESA_OutTextXY(LaF*6+3, Py+Step-9, HS.B1[A]);
      VESA_OutTextXY(LaF*40+3,Py+Step-9, HS.B2[A]+' Moves');
      VESA_OutTextXY(LaF*55+3,Py+Step-9, HS.B3[A]+' Blocks');
      Val(HS.B2[A],V2,Code); Val(HS.B3[A],V3,Code);
      If (V2<>0) And (V3<>0) Then Str(V2/(V3+V3/2):4:2,Rat)
                             Else Rat:='0';
      VESA_OutTextXY(LaF*70+3,Py+Step-9, 'Ratio '+Copy(Rat,1,5));
      End;
   Mse_Show;
   End;

Win_Clip(Off,W1);                       {*Restore Normal Clipping*}
End;

{***************************** MAIN PROCEDURE *******************************}

Begin
Win_Init(90,90,90+LaF*91,90+HaF1+HaF*23,$51D9,'HIGH SCORES - HALL OF FAME',W1);
Win_Sup(100,50,250,200,79,60,639,479,0,5,$0A10,W1);{*Supplement*}
If NError<>0 Then Exit;                 {*Initialisations Errors ?*}
Win_Draw(W1);                           {*Display Window*}

If P.Score=1 Then Cyc1.CyclVal:=1       {*Show Time or Block*}
             Else Cyc1.CyclVal:=2;
REDRAW_FRAME;                           {*Display Window Content*}
Exit_Flg:=False;                        {*Init Exit Flag*}

Repeat;
Main_Task;                              {*Manage System*}
If Win_Ready(W1) Then                   {*Test if Window Ready*}
   Begin                                {*Test Personnals Gadgets*}
   Win_Clip(On,W1);                     {*Clipping Window*}
   If Button_GetMsg(But1,1) Then Exit_Flg:=True;
   If Cycler_GetMsg(Cyc1,1) Then REDRAW_FRAME;
   Win_Clip(Off,W1);                    {*Clipping Window*}
   End;

Even:=Win_Test(W1);                     {*Get Windows Evens*}
If Even=1 Then Exit_Flg:=True;          {*Window Closed   => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Window Moved    => Display Content*}
Until Exit_Flg=True;                    {*Exit Flag*}

Win_Kill(W1);                           {*Close Window if Needs*}
End;

{****************************************************************************}
{****************************************************************************}
{****************************************************************************}
{ͻ
                          PROCEDURE TAQUIN_PREFS                            
 ͼ}
{****************************************************************************}
{****************************************************************************}
{****************************************************************************}

Procedure TAQUIN_PREFS(Var M:TMain; Var P:TPrefs; Var B:Blocks);
Var W1            :TWindow;             {*Window Structure*}
    Even          :Byte;                {*Get Windows Evens*}
    Exit_Flg      :Byte;                {*Exit Flag*}
    But1,But2,But3,
    But4,But5     :TButton;             {*Buttons Structure*}
    Rad1,Rad2,Rad3,
    Rad4,Rad5,Rad6,
    Rad7,Rad8,Rad9,
    Rad10,Rad11,Rad12,
    Rad13,Rad14,Rad15:TRadioBox;        {*Radios Structure*}
    Sld1,Sld2     :TSlider;             {*Sliders Structure*}
    Com1,Com2,Com3:TInputText;          {*Commands Structure*}
    Cin1,Cin2,Cin3:String;              {*Strings for Commands*}
    DirSel,FilSel :String;              {*Manage Directories*}
    Size          :Longint;
    Code          :Integer;             {*Code Erreur*}
    Tmp           :Integer;             {*Calculs Temporaires...*}

{************************* DISPLAY WINDOW CONTENT ***************************}

Procedure REDRAW_COM;                   {*Define Commands*}
Begin
Win_Clip(On,W1);                        {*Clipping Window*}
InputText( LaF*30, HaF*12+7,LaF*34,100,5,10,0,$26,Com1,Cin1);
InputText( LaF*38, HaF*5+2, LaF*6, 100,9,11,0,$26,Com2,Cin2);
InputText( LaF*38, HaF*7+2, LaF*6, 100,9,11,0,$26,Com3,Cin3);
Win_Clip(Off,W1);                       {*Restore Normal Clipping*}
End;

Procedure REDRAW_FRAME;                 {*Define Window Content*}
Begin
Win_Clip(On,W1);                        {*Clipping Window*}
StringBox( LaF*4, HaF*3+1,  LaF*34, HaF*10+6,1,6,False);
StringBox( LaF*36,HaF*3+1,  LaF*90, HaF*10+6,1,6,False);
StringBox( LaF*4, HaF*17+2, LaF*90, HaF*29,1,6,False);
StringBox( LaF*4, HaF*11+6, LaF*90, HaF*15+1,1,6,False);
StringBox( LaF*12,HaF*2+1,  LaF*26, HaF*3+6,1,3,False);
StringBox( LaF*50,HaF*2+1,  LaF*76, HaF*3+6,1,3,False);
StringBox( LaF*8, HaF*16+1, LaF*32, HaF*17+6,1,3,False);
StringBox( LaF*36,HaF*16+1, LaF*61, HaF*17+6,1,3,False);
StringBox( LaF*66,HaF*16+1, LaF*84, HaF*17+6,1,3,False);
VESA_SetColor(15);

Display( LaF*15+3, HaF*2+3,3,0,'SCORES');
Display( LaF*54+1, HaF*2+3,3,0,'LEVEL DIFFICULTY');
Display( LaF*12+2, HaF*16+3,3,0,'MISCELLANEOUS');
Display( LaF*40,   HaF*16+3,3,0,'GRID LINE STYLE');
Display( LaF*70,   HaF*16+3,3,0,'PLAYER IS');
VESA_SetColor(0);
Display( LaF*78, HaF*5+1,6,0,'QTT LINES');
Display( LaF*78, HaF*7+1,6,0,'MIX LEVEL');

Set_Font('MODN.CHR',4);
Button( LaF*13, HaF*30+6,LaF*16,-1,0,7,$10,But1,'_SAVE');
Set_Font('LITT.CHR',4);
Button( LaF*39, HaF*30+6,LaF*16,-1,0,7,$10,But2,'_USE');
Button( LaF*64, HaF*30+6,LaF*16,-1,0,7,$00,But3,'_CANCEL');
Button( LaF*6,  HaF*12+6,LaF*22,-1,0,7,$00,But4,'SELECT _IMAGE');
Button( LaF*66, HaF*12+6,LaF*22,-1,0,7,$00,But5,'_VIEW IMAGE');

RadioBox( LaF*6, HaF*4+6, 2,$10,0,0,Rad1.Status,Rad1,'NONE');
RadioBox( LaF*6, HaF*6+1, 2,$10,0,0,Rad2.Status,Rad2,'TIME');
RadioBox( LaF*6, HaF*7+6, 2,$10,0,0,Rad3.Status,Rad3,'BLOCKS');
RadioBox( LaF*42,HaF*18+6,2,$10,0,0,Rad4.Status,Rad4,'WHITE');
RadioBox( LaF*42,HaF*20+1,2,$10,0,0,Rad5.Status,Rad5,'BLACK');
RadioBox( LaF*42,HaF*21+6,2,$10,0,0,Rad6.Status,Rad6,'XOR');
RadioBox( LaF*42,HaF*23+1,2,$10,0,0,Rad12.Status,Rad12,'RELIEF');
RadioBox( LaF*42,HaF*24+6,2,$10,0,0,Rad15.Status,Rad15,'NONE');
RadioBox( LaF*6, HaF*18+6,1,$10,0,0,Rad7.Status,Rad7,'USE IMAGE AS BACKGROUND');
RadioBox( LaF*6, HaF*20+6,1,$10,0,0,Rad8.Status,Rad8,'MOVE ANIMATION');
RadioBox( LaF*6, HaF*22+6,1,$10,0,0,Rad9.Status,Rad9,'SOUND WHEN MOVE');
RadioBox( LaF*6, HaF*24+6,1,$10,0,0,Rad10.Status,Rad10,'PANEL CONTROL');
RadioBox( LaF*6, HaF*26+6,1,$10,0,0,Rad11.Status,Rad11,'PERCENTAGE DONE');
RadioBox( LaF*66,HaF*18+6,2,$10,0,0,Rad13.Status,Rad13,'HUMAN');
RadioBox( LaF*66,HaF*20+1,2,$10,0,0,Rad14.Status,Rad14,'COMPUTER');
RadioBox_Freeze(On,Rad14);
Slider( LaF*46,  HaF*5+1, LaF*68, HaF*6+5,MaxB*8,MaxB,0,True,Sld1,Sld1.Psl);
Slider( LaF*46,  HaF*7+1, LaF*68, HaF*8+5,100,10,0,True,Sld2,Sld2.Psl);

REDRAW_COM;                             {*Define Commands*}
Win_Clip(Off,W1);                       {*Restore Normal Clipping*}
End;

{***************************** MAIN PROCEDURE *******************************}

Begin
Win_Init(90,45,90+LaF*94,45+HaF1+HaF*32+6,$51D9,'TAQUIN PREFERENCES',W1);
Win_Sup(100,50,250,200,79,60,639,479,0,5,$0A10,W1);{*Supplement*}
If NError<>0 Then Exit;                 {*Initialisations Errors ?*}
Win_Draw(W1);                           {*Display Window*}

M.InGame:=Off;                          {*Flag Game Must Stop*}
M.ScorV:=0;                             {*Score Rinitialis*}

DirSel:=P.PPath; FilSel:=P.PName;

Rad1.Status:=Off;                       {*Score Type*}
Rad2.Status:=Off;
Rad3.Status:=Off;
Case P.Score of
   0: Rad1.Status:=On;
   1: Rad2.Status:=On;
   2: Rad3.Status:=On;
   End;

Rad4.Status:=Off;                       {*Line Style...*}
Rad5.Status:=Off;
Rad6.Status:=Off;
Rad12.Status:=Off;
Rad15.Status:=Off;
Case P.Line of
   1: Rad4.Status:=On;
   2: Rad5.Status:=On;
   3: Rad6.Status:=On;
   4: Rad12.Status:=On;
   5: Rad15.Status:=On;
   End;

If P.Gfx_Back=1 Then Rad7.Status:=On    {*Flags Miscellaneous*}
                 Else Rad7.Status:=Off;
If P.Move_Anim=1 Then Rad8.Status:=On
                 Else Rad8.Status:=Off;
If P.Sound=1 Then Rad9.Status:=On
             Else Rad9.Status:=Off;
If P.Panel=1 Then Rad10.Status:=On
             Else Rad10.Status:=Off;
If P.Done=1 Then Rad11.Status:=On
            Else Rad11.Status:=Off;

Rad13.Status:=Off;                      {*Player is... Human*}
Rad14.Status:=Off;
If P.Player=1 Then Rad13.Status:=On
              Else Rad14.Status:=On;

Sld1.Psl:=(P.Qtt_Line-2)*10;
Sld2.Psl:=P.Mix_Level;
Cin1:=DirSel+FilSel;
Str(P.Qtt_Line,Cin2);
Str(P.Mix_Level,Cin3);

REDRAW_FRAME;                           {*Display Window Content*}
Exit_Flg:=0;                            {*Init Exit Flag*}

Repeat;
Main_Task;                              {*Manage System*}
If Win_Ready(W1) Then                   {*Test if Window Ready*}
   Begin                                {*Test Personnals Gadgets*}
   Win_Clip(On,W1);                     {*Clipping Window*}
   If Button_GetMsg(But1,1) Then Exit_Flg:=3;   {*Save*}
   If Button_GetMsg(But2,1) Then Exit_Flg:=2;   {*Use*}
   If Button_GetMsg(But3,1) Then Exit_Flg:=1;   {*Cancel*}
   If Button_GetMsg(But4,1) Then Begin
      Req_FileManager(125,30,300,'SELECT MGF IMAGE','_OK','*.*',0,DirSel,FilSel,Size);
      If FilSel<>'' Then Begin
         Cin1:=DirSel+FilSel;
         REDRAW_COM;                            {*Define Commands*}
         End
         Else Begin
         DirSel:=P.PPath; FilSel:=P.PName;      {*Loading Canceled*}
         End;
      End;
   If Button_GetMsg(But5,1) Then Req_DisplayWinBMP(0,0,DirSel+FilSel); {*Display a BMP in a window*}

   If Mse_TestBox(W1.X1+LaF*4, W1.Y1+HaF1+HaF*3+1,  W1.X1+LaF*34, W1.Y1+HaF1+HaF*10+6,10) Then
      Begin
      RadioBox_GetMsg(Rad1,1);
      RadioBox_GetMsg(Rad2,1);
      RadioBox_GetMsg(Rad3,1);
      End;
   If Mse_TestBox(W1.X1+LaF*36, W1.Y1+HaF1+HaF*17+2,  W1.X1+LaF*50, W1.Y1+HaF1+HaF*29,10) Then
      Begin
      RadioBox_GetMsg(Rad4,1);
      RadioBox_GetMsg(Rad5,1);
      RadioBox_GetMsg(Rad6,1);
      RadioBox_GetMsg(Rad12,1);
      RadioBox_GetMsg(Rad15,1);
      End;
   If Mse_TestBox(W1.X1+LaF*60, W1.Y1+HaF1+HaF*17+2,  W1.X1+LaF*80, W1.Y1+HaF1+HaF*29,10) Then
      Begin
      RadioBox_GetMsg(Rad13,1);
      RadioBox_GetMsg(Rad14,1);
      End;
   RadioBox_GetMsg(Rad7,1);
   RadioBox_GetMsg(Rad8,1);
   RadioBox_GetMsg(Rad9,1);
   RadioBox_GetMsg(Rad10,1);
   RadioBox_GetMsg(Rad11,1);

   If Slider_GetMsg(Sld1,1)=Yes Then Begin
      Str((Sld1.Psl Div 10)+2,Cin2);
      REDRAW_COM;                       {*Define Commands*}
      End;
   If Slider_GetMsg(Sld2,1)=Yes Then Begin
      Str(Sld2.Psl,Cin3);
      REDRAW_COM;                       {*Define Commands*}
      End;
   Win_Clip(Off,W1);                    {*Restore Normal Clipping*}
   End;

Even:=Win_Test(W1);                     {*Get Windows Evens*}
If Even=1 Then Exit_Flg:=1;             {*Window Closed   => Exit*}
If Even=9 Then REDRAW_FRAME;            {*Window Moved    => Display Content*}
Until Exit_Flg>0;                       {*Exit Flag*}
Win_Kill(W1);                           {*Close Window if Needs*}

If (Exit_Flg=2) Or (Exit_Flg=3) Then    {*Use*}
   Begin
   P.PPath:=DirSel;
   P.PName:=FilSel;
   If Rad7.Status Then Gfx_Screen:=DirSel+FilSel;

   If Rad1.Status Then P.Score:=0;      {*Score Style*}
   If Rad2.Status Then P.Score:=1;
   If Rad3.Status Then P.Score:=2;

   If Rad4.Status Then P.Line:=1;       {*Line Style....*}
   If Rad5.Status Then P.Line:=2;
   If Rad6.Status Then P.Line:=3;
   If Rad12.Status Then P.Line:=4;
   If Rad15.Status Then P.Line:=5;

   If Rad13.Status Then P.Player:=1 Else P.Player:=2;

   If Rad7.Status Then P.Gfx_Back:=1    {*Flags Miscellaneous*}
                  Else P.Gfx_Back:=0;
   If Rad8.Status Then P.Move_Anim:=1
                  Else P.Move_Anim:=0;
   If Rad9.Status Then P.Sound:=1
                  Else P.Sound:=0;
   If Rad10.Status Then P.Panel:=1
                   Else P.Panel:=0;
   If Rad11.Status Then P.Done:=1
                   Else P.Done:=0;

   Val(Cin2,P.Qtt_Line,Code);
   Val(Cin3,P.Mix_Level,Code);
   End;

If Exit_Flg=3 Then
   Begin
   SAVE_CONFIG('TAQUIN.INI');           {*Save And Use MOS Prefs*}
   SAVE_PREFS('TAQUIN.CFG',P);          {*Save And Use Taquin Prefs*}
   End;
End;

{****************************************************************************}
{****************************************************************************}
{****************************************************************************}
{ͻ
                               GESTION DU JEU                               
 ͼ}
{****************************************************************************}
{****************************************************************************}
{****************************************************************************}

{ͻ
                          PROCEDURE GET_BLOCK_COORD                         
 ͼ}

Procedure GET_BLOCK_COORD(X,Y:Integer; Var Rx1,Ry1,Rx2,Ry2:Integer; P:TPrefs; M:TMain; W:TWindow);
Begin
Rx1:=0; Ry1:=0; Rx2:=0; Ry2:=0;         {*De Base au Cas o...*}

If (X<1) Or (X>P.Qtt_Line) Then Exit;   {*En Dehors du Tableau !*}
If (Y<1) Or (Y>P.Qtt_Line) Then Exit;

Rx1:=(M.Gx1+(X-1)*M.SBlock)+M.Sline;    {*Calcul Coord of Current Block*}
Rx2:=(M.Gx1+(X+0)*M.SBlock)-M.Sline;
Ry1:=(M.Gy1+(Y-1)*M.SBlock)+M.Sline;
Ry2:=(M.Gy1+(Y+0)*M.SBlock)-M.Sline;
End;

{ͻ
                           PROCEDURE GET_BLOCK_IND                          
 ͼ}

Procedure GET_BLOCK_IND(Rx,Ry:Integer; Var X,Y:Integer; P:TPrefs; M:TMain; W:TWindow);
Var Xa,Ya:Real;
Begin
Rx:=Rx-W.X1;                            {*Manual Clipping Window*}
Ry:=Ry-W.Y1-HaF1;

Xa:=(Rx-M.Gx1)/M.SBlock;                {*Calcul Indice of Current Block*}
Ya:=(Ry-M.Gy1)/M.SBlock;

If (Xa<0) Or (Ya<0) Or                  {*En Dehors du Tableau !*}
   (Xa>P.Qtt_Line) Or (Ya>P.Qtt_Line)
   Then Begin
   X:=0; Y:=0;                          {*Pas de Block Trouv*}
   Exit;
   End
   Else Begin                           {*On est dans le Tableau...*}
   X:=Trunc(Xa)+1;
   Y:=Trunc(Ya)+1;
   If (X>P.Qtt_Line) Or (Y>P.Qtt_Line)  {*Un Poil en Dehors !*}
      Then Begin
           X:=0; Y:=0;
           End;
   End;
End;

{ͻ
                          PROCEDURE GET_FREE_BLOCKS                         
 ͼ}

Function GET_FREE_BLOCK(X,Y:Integer; P:TPrefs; M:TMain):Boolean;
Begin                                   {*Si le Block peut Bouger => TRUE *}
If (X<1) Or (Y<1) Or (X>P.Qtt_Line) Or (Y>P.Qtt_Line) Then
   Begin
   GET_FREE_BLOCK:=False;               {*En Dehors du Carr...*}
   Exit;
   End;
If ((X+1=M.VideX) And (Y=M.VideY)) Or
   ((X-1=M.VideX) And (Y=M.VideY)) Or
   ((X=M.VideX) And (Y+1=M.VideY)) Or
   ((X=M.VideX) And (Y-1=M.VideY))
      Then GET_FREE_BLOCK:=True         {*Le Block Peut-tre Dplac...*}
      Else GET_FREE_BLOCK:=False;
End;

{ͻ
                            PROCEDURE MIX_BLOCKS                            
 ͼ}

Procedure MIX_BLOCKS(P:TPrefs; Var M:TMain; Var B:Blocks; W:TWindow);
Var N:Integer;
    Qm:Integer;                         {*Nombre de Dplacements...*}
    Xs,Ys,Xt,Yt:Integer;
    Sx1,Sy1,Sx2,Sy2:Integer;            {*Block Source Coordonnes*}
    Tx1,Ty1,Tx2,Ty2:Integer;            {*Block Target Coordonnes*}
    Ps,Pt         :TXMSBitmap;          {*Pointer sur Image Source et Target*}
    Xtmp,Ytmp     :Integer;             {*Coordonnes Temporaires*}
    Sens          :Byte;                {*Direction de Mlange...*}
    Ok            :Boolean;             {*Block Adjacent Trouv...*}

Begin
Qm:=((P.Mix_Level*P.Qtt_Line*P.Qtt_Line) Div 10)+1;
For N:=1 to Qm do
   Begin
   Ok:=No;                              {*De Base...*}
   Repeat
      Xs:=M.VideX; Ys:=M.VideY;         {*Source = Block vide*}
      Xt:=Xs; Yt:=Ys;
      Sens:=Random(4);                  {*4 Directions...*}
      Case Sens of
         0: Inc(Xt);                    {*Coord Block Adjacent*}
         1: Dec(Yt);
         2: Dec(Xt);
         3: Inc(Yt);
         End;
      If GET_FREE_BLOCK(Xt,Yt,P,M) Then {*Ce Bloc est t-il Libre ?...*}
         Ok:=Yes;
   Until Ok=Yes;

{gotoxy(1,1); writeln(Xs,' ',Ys,' ');
gotoxy(1,2); writeln(Xt,' ',Yt,' ');}

   Win_Clip(Off,W);
   Mse_Hide;                            {*Stocke Sources Images en XMS*}
   GET_BLOCK_COORD(Xs,Ys,Sx1,Sy1,Sx2,Sy2,P,M,W);
   XMS_GetImage(W.X1+Sx1, W.Y1+HaF1+Sy1, W.X1+Sx2, W.Y1+HaF1+Sy2, Ps);
   GET_BLOCK_COORD(Xt,Yt,Tx1,Ty1,Tx2,Ty2,P,M,W);
   XMS_GetImage(W.X1+Tx1, W.Y1+HaF1+Ty1, W.X1+Tx2, W.Y1+HaF1+Ty2, Pt);
                                        {*Display Targets Images*}
   XMS_PutImage(W.X1+Tx1, W.Y1+HaF1+Ty1, Ps, NormalPut);
   XMS_PutImage(W.X1+Sx1, W.Y1+HaF1+Sy1, Pt, NormalPut);
   Mse_Show;

   XMS_FreeBitmap(Ps);                  {*Libre la Mmoire XMS Alloue*}
   XMS_FreeBitmap(Pt);
   Win_Clip(On,W);

   If (Xs=M.VideX) And (Ys=M.VideY) Then{*Transfre le Block Vide...*}
      Begin
      M.VideX:=Xt; M.VideY:=Yt; End
      Else
      If (Xt=M.VideX) And (Yt=M.VideY) Then
         Begin
         M.VideX:=Xs; M.VideY:=Ys; End;

   Xtmp:=B[Xs,Ys].Xi;                    {*Swap Coordonnes...*}
   Ytmp:=B[Xs,Ys].Yi;
   B[Xs,Ys].Xi:=B[Xt,Yt].Xi;
   B[Xs,Ys].Yi:=B[Xt,Yt].Yi;
   B[Xt,Yt].Xi:=Xtmp;
   B[Xt,Yt].Yi:=Ytmp;
{gotoxy(1,3); writeln(M.VideX,' ',M.VideY,' ');}
   End;
End;

{ͻ
                          PROCEDURE SHOW_MOVE_BLOCKS                        
 ͼ}

Procedure SHOW_MOVE_BLOCK(Xs,Ys,Xt,Yt:Integer; P:TPrefs; M:TMain; B:Blocks; W:TWindow);
Var Cx1,Cy1,Cx2,Cy2:Integer;            {*Coord du Box d'un Block*}
    A:Integer;                          {*Loop*}
    Nx,Ny:Integer;                      {*Positions Temporaires*}
    Dir:Byte;                           {*Direction du Dplacement*}

Begin                                   {*Affiche le Dplacement*}
If P.Move_Anim=1 Then
   Begin        {====  ANIMATION ====}
   Nx:=0; Ny:=0;                        {*Stocke Source Image en XMS*}
   GET_BLOCK_COORD(Xs,Ys,Cx1,Cy1,Cx2,Cy2,P,M,W);
   Mse_Hide;
   XMS_GetImage(W.X1+Cx1, W.Y1+HaF1+Cy1, W.X1+Cx2, W.Y1+HaF1+Cy2, Pi);

   For A:=1 to M.Sblock do Begin
      If Xs=Xt Then                     {*Calcul de l'Incrment*}
         Begin
         If Yt>Ys Then Begin Inc(Ny); Dir:=3; End
                  Else Begin Dec(Ny); Dir:=1; End;
         End
         Else Begin
         If Xt>Xs Then Begin Inc(Nx); Dir:=4; End
                  Else Begin Dec(Nx); Dir:=2; End;
         End;
      XMS_PutImage(W.X1+Cx1+Nx, W.Y1+HaF1+Cy1+Ny, Pi,NormalPut);
      VESA_Setcolor(Col[7]);
      Case Dir of                       {*Efface la Dernire Ligne => MOVE*}
         1: VESA_Line(W.X1+Cx1, W.Y1+HaF1+Cy2+Ny+1, W.X1+Cx2, W.Y1+HaF1+Cy2+Ny+1);
         2: VESA_Line(W.X1+Cx2+Nx+1, W.Y1+HaF1+Cy1, W.X1+Cx2+Nx+1, W.Y1+HaF1+Cy2);
         3: VESA_Line(W.X1+Cx1, W.Y1+HaF1+Cy1+Ny-1, W.X1+Cx2, W.Y1+HaF1+Cy1+Ny-1);
         4: VESA_Line(W.X1+Cx1+Nx-1, W.Y1+HaF1+Cy1, W.X1+Cx1+Nx-1, W.Y1+HaF1+Cy2);
         End;
      End;

   If P.Line=1 Then VESA_SetColor(Col[15]);  {*Define Line Style...*}
   If P.Line=2 Then VESA_SetColor(Col[0]);
   If P.Line=3 Then Begin
      VESA_SetColor(Col[15]);
      VESA_SetWriteMode(XORPut);
      End;

   Case Dir of                          {*Draw Ligne Intersection*}
      1: VESA_Line(W.X1+Cx1, W.Y1+HaF1+Cy2+Ny+1, W.X1+Cx2, W.Y1+HaF1+Cy2+Ny+1);
      2: VESA_Line(W.X1+Cx2+Nx+1, W.Y1+HaF1+Cy1, W.X1+Cx2+Nx+1, W.Y1+HaF1+Cy2);
      3: VESA_Line(W.X1+Cx1, W.Y1+HaF1+Cy1+Ny-1, W.X1+Cx2, W.Y1+HaF1+Cy1+Ny-1);
      4: VESA_Line(W.X1+Cx1+Nx-1, W.Y1+HaF1+Cy1, W.X1+Cx1+Nx-1, W.Y1+HaF1+Cy2);
      End;
   Mse_Show;
   VESA_SetWriteMode(NormalPut);
   XMS_FreeBitmap(Pi);                  {*Libre la Mmoire XMS Alloue*}
   End

   Else Begin   {==== STATIQUE ====}
   Mse_Hide;                            {*Stocke Source Image en XMS*}
   GET_BLOCK_COORD(Xs,Ys,Cx1,Cy1,Cx2,Cy2,P,M,W);
   XMS_GetImage(W.X1+Cx1, W.Y1+HaF1+Cy1, W.X1+Cx2, W.Y1+HaF1+Cy2, Pi);
                                        {*Display on Target Image*}
   GET_BLOCK_COORD(Xt,Yt,Cx1,Cy1,Cx2,Cy2,P,M,W);
   XMS_PutImage(W.X1+Cx1, W.Y1+HaF1+Cy1, Pi,NormalPut);

   DISPLAY_BLANK_BLOCK(Xs,Ys,P,M,W);    {*Efface Block Source*}
   Mse_Show;
   XMS_FreeBitmap(Pi);                  {*Libre la Mmoire XMS Alloue*}
   End;
End;

{ͻ
                            PROCEDURE MOVE_BLOCKS                           
 ͼ}

Procedure MOVE_BLOCK(Xs,Ys,Xt,Yt:Integer; P:TPrefs; Var M:TMain; Var B:Blocks; W:TWindow);
Begin
If (Xs<1) Or (Xs>P.Qtt_Line) Then Exit; {*En Dehors du Tableau !*}
If (Ys<1) Or (Ys>P.Qtt_Line) Then Exit;
If (Yt<1) Or (Xt>P.Qtt_Line) Then Exit;
If (Yt<1) Or (Yt>P.Qtt_Line) Then Exit;

{gotoxy(1,10); writeln(B[Xs,Ys].Xi,',',B[Xs,Ys].Yi,' ');
gotoxy(1,11); writeln(B[Xs,Ys].X, ',',B[Xs,Ys].Y, ' ');}

SHOW_MOVE_BLOCK(Xs,Ys,Xt,Yt,P,M,B,W);   {*Affiche le Dplacement*}

B[Xs,Ys].X:=0;                          {*New Empty Block...*}
B[Xs,Ys].Y:=0;
B[Xt,Yt].X:=Xt;                         {*Set New Coord for Block*}
B[Xt,Yt].Y:=Yt;
B[Xt,Yt].Xi:=B[Xs,Ys].Xi;                         {*Set New Coord for Block*}
B[Xt,Yt].Yi:=B[Xs,Ys].Yi;

M.VideX:=Xs;                            {*New Coord du Block Vide*}
M.VideY:=Ys;
End;

{ͻ
                          PROCEDURE DEFINE_BLOCKS                           
 ͼ}

Procedure DEFINE_BLOCKS(P:TPrefs; Var B:Blocks);
Var I,J:Integer;
Begin
For I:=1 to P.Qtt_Line do               {*Parcours Blocks*}
   For J:=1 to P.Qtt_Line do
      Begin
      B[I,J].Xi:=I;                     {*Set Init Coordinates*}
      B[I,J].Yi:=J;
      B[I,J].X:=I;                      {*Set Current Coordinates*}
      B[I,J].Y:=J;
      End;
End;

{ͻ
                          PROCEDURE COUNT_BLOCKS_OK                         
 ͼ}

Procedure COUNT_BLOCKS_OK(P:TPrefs; Var M:Tmain; B:Blocks);
Var I,J:Integer;
    Cc:Integer;
Begin
Cc:=0;
For I:=1 to P.Qtt_Line do               {*Parcours Blocks*}
   For J:=1 to P.Qtt_Line do
      Begin
      If (B[I,J].X=B[I,J].Xi) And       {*Count Block Ok + 1*}
         (B[I,J].Y=B[I,J].Yi) Then Inc(Cc);
      End;
M.Count:=Cc;                            {*Transmet Rsultat*}
End;

{ͻ
                        PROCEDURE DISPLAY_BLANK_BLOCK                       
 ͼ}

Procedure DISPLAY_BLANK_BLOCK(X,Y:Integer; P:TPrefs; M:TMain; W:TWindow);
Var Rx1,Ry1,Rx2,Ry2:Integer;            {*Coordonnes de Block Vide*}

Begin
GET_BLOCK_COORD(X,Y,Rx1,Ry1,Rx2,Ry2,P,M,W);

If Rx1>0 Then Begin                     {*Draw Grey Box*}
   VESA_SetFillStyle(1,Col[7]);
   Win_Clip(Off,W);
   VESA_Bar(W.X1+Rx1, W.Y1+HaF1+Ry1, W.X1+Rx2, W.Y1+HaF1+Ry2);
   Win_Clip(On,W);
   End;
End;

{ͻ
                            PROCEDURE CREATE_VIDE                           
 ͼ}

Procedure CREATE_VIDE(P:TPrefs; Var M:TMain; Var B:Blocks; W:TWindow);
Var Rx1,Ry1,Rx2,Ry2:Integer;            {*Coordonnes de Block Vide*}

Begin
M.VideX:=P.Qtt_Line;                    {*Set Block Vide en Bas  Droite*}
M.VideY:=P.Qtt_Line;

B[M.VideX,M.VideY].X:=0;                {*Ce Block ne fait plus partie du Jeu*}
B[M.VideX,M.VideY].Y:=0;
                                        {*Get Coordonnes du Block  Effacer*}
GET_BLOCK_COORD(M.VideX,M.VideY,Rx1,Ry1,Rx2,Ry2,P,M,W);
                                        {*Efface Block en X,Y*}
DISPLAY_BLANK_BLOCK(M.VideX,M.VideY,P,M,W);
End;

{****************************************************************************}
{****************************************************************************}
{****************************************************************************}
{ͻ
                               PROCEDURE MAIN                               
 ͼ}
{****************************************************************************}
{****************************************************************************}
{****************************************************************************}

Procedure MAIN;
Var W1            :TWindow;             {*Window Structure*}
    Even          :Byte;                {*Get Windows Evens*}
    Exit_Flg      :Boolean;             {*Exit Flag*}
    Menu          :TMenu;               {*Variable Menu*}
    But1,But2,But3,
    But4,But5,
    But7,But8     :TButton;             {*Buttons Structure*}
    Com1,Com2     :TInputText;          {*Commands Structure*}
    Cin1,Cin2     :String;              {*Strings for Commands*}
    MS,PS,SS      :Byte;                {*Manage Menu*}
    P             :TPrefs;              {*Structure Prfrences*}
    M             :TMain;               {*Structure Principale*}
    B             :Blocks;              {*Structure Blocks*}
    HS            :THScore;             {*Structure HighScores*}
    Rx1,Ry1,Rx2,Ry2:Integer;            {*Mannage Coordinates*}
    Xb,Yb         :Integer;             {*Indice du Block Courrant*}
    Xm,Ym         :Word;                {*Coord et Mouse Buttons States*}
    Ga,Mi,Dr      :Boolean;
    Num           :Integer;             {*Pour Les EZ Requesters*}
    Iconified     :Boolean;             {*Fentre Iconifie*}

{**********************  QUADRILLE LA ZONE DE L'IMAGE ***********************}

Procedure DRAW_GRID;
Var A,B             :Integer;           {*For Loops...*}
    Px1,Py1,Px2,Py2 :Integer;
    Step            :Integer;
    Delta           :Byte;              {*Si Relief => Do -1 Sur Bevel Size*}

Begin
Win_Clip(On,W1);                        {*Clipping Window*}
Delta:=0;                               {*De Base pas de Dcalage...*}

If P.Line<>5 Then Begin                 {*No Grid...*}
   VESA_SetColor(Col[0]);
   Px1:=M.Gx1-1;

   If P.Line=1 Then VESA_SetColor(Col[15]);  {*Line Style...*}
   If P.Line=2 Then VESA_SetColor(Col[0]);
   If P.Line=3 Then Begin
      VESA_SetColor(Col[15]);
      VESA_SetWriteMode(XORPut);
      End;

   If P.Line=4 Then Begin               {====== Draw in Relief ======}
      Delta:=1;
      Step:=M.SBlock-1;                 {*Step -1 car Trait Double*}
      Py1:=M.Gy1;
      Py2:=M.Gy1+Step;
      For A:=1 to P.Qtt_Line do
         Begin
         Px1:=M.Gx1;
         Px2:=M.Gx1+Step;
         For B:=1 to P.Qtt_Line do Begin
            BevelBox(Px1, Py1, Px2, Py2, 1,7,True,False);
            Px1:=Px1+Step+1;            {*1 Colone de Plus*}
            Px2:=Px2+Step+1;
            End;
         Py1:=Py1+Step+1;               {*1 Ligne de Plus*}
         Py2:=Py2+Step+1;
         End;
      End;

   If (P.Line>=1) And (P.Line<=3) Then  {====== Draw Classic Lines ======}
      Begin
      Delta:=0;
      Mse_Hide;
      For A:=1 to P.Qtt_Line do
         Begin
         VESA_Line(Px1,M.Gy1-6,Px1,M.Gy2-6); {*Draw Vertical Lines*}
         Px1:=Px1+M.SBlock;
         End;
      Py1:=M.Gy1-6;
      For A:=1 to P.Qtt_Line do
         Begin
         VESA_Line(M.Gx1-1,Py1,M.Gx2-1,Py1); {*Draw Horizontal Lines*}
         Py1:=Py1+M.SBlock;
         End;
      Mse_Show;
      End;                              {*End Draw Classic Lines*}

   VESA_SetWriteMode(NormalPut);
   End;                                 {*End "No Grid"...*}

BevelBox(M.Gx1, M.Gy1, M.Gx2-Delta, M.Gy2-Delta, 1,7,True,False);
Win_Clip(Off,W1);                       {*Restore Normal Clipping*}
End;

{****************************** GENERATE MENU *******************************}

Procedure DECLARE_MENU;
Begin
Menu_Clear(Menu);                       {*Clear Menus Arrays*}

Menu_Add(Menu,1,1,'00 _TAQUIN');
Menu_Add(Menu,1,2,'00 ABOUT _TAQUIN');
Menu_Add(Menu,1,3,'00 ABOUT _MOS');
Menu_Add(Menu,1,4,'02');
Menu_Add(Menu,1,5,'00 _DOS SHELL');
Menu_Add(Menu,1,6,'00 E_XIT');

Menu_Add(Menu,2,1,'00 _GAME');
Menu_Add(Menu,2,2,'00 _NEW GAME');
Menu_Add(Menu,2,3,'00 _STOP GAME');
Menu_Add(Menu,2,4,'02');
Menu_Add(Menu,2,5,'00 _HIGH SCORES');
Menu_Add(Menu,2,6,'02');
Menu_Add(Menu,2,7,'01 _RESOLVE GAME');

Menu_Add(Menu,3,1,'00 _SYSTEM');
Menu_Add(Menu,3,2,'00 _SYSTEM PREFS');
Menu_Add(Menu,3,3,'00 _TAQUIN PREFS');
Menu_Add(Menu,3,4,'02');
Menu_Add(Menu,3,5,'00 _MEMORY INFORMATIONS');
Menu_Add(Menu,3,6,'00 _HARDWARE INFORMATIONS');
End;

{************************** DISPLAY GRID AND IMAGE **************************}

Procedure SHOW_IMAGE;
Begin
M.View_One:=No;                         {*On N'affichera plus l'Image de Base*}

If Test_BMP(P.PPath+P.PName) Then       {*Affiche l'image*}
   Show_BMP(W1.X1+M.Gx1,
            W1.Y1+HaF1+M.Gy1,
            W1.X1+M.Gx2,
            W1.Y1+HaF1+M.Gy2,0,0,P.PPath+P.PName,$A0);

DRAW_GRID;                              {*Affiche la Grille sur l'Image...*}
End;

{**************** DISPLAY IMAGE DE BASE OR RECALCULATED IMAGE ***************}

Procedure SHOW_BACKGROUND_GAME;
Begin
M.Catch:=No;                            {*On Peut Reprendre l'Image*}

If M.View_One Then
   Begin
   SHOW_IMAGE;                          {*Affiche l'Image et la Grille...*}
   Mse_Hide;
   XMS_GetImage(W1.X1+M.Gx1, W1.Y1+HaF1+M.Gy1, W1.X1+M.Gx2, W1.Y1+HaF1+M.Gy2, M.Image);
   Mse_Show;
   End
   Else Begin
   Mse_Hide;
   XMS_PutImage(W1.X1+M.Gx1, W1.Y1+HaF1+M.Gy1, M.Image,NormalPut);
   XMS_FreeBitmap(M.Image);             {*Libre la Mmoire XMS Alloue*}
   XMS_GetImage(W1.X1+M.Gx1, W1.Y1+HaF1+M.Gy1, W1.X1+M.Gx2, W1.Y1+HaF1+M.Gy2, M.Image);
   Mse_Show;
   End;
End;

{************************* DISPLAY COMMAND CONTENT **************************}

Procedure REDRAW_COMMANDS;              {*Define Window Commands*}
Var DelX:Integer;                       {*Delta X si Panel=1*}

Begin
COUNT_BLOCKS_OK(P,M,B);                 {*Compte le Nombre de Blocks Ok*}

{gotoxy(1,4); writeln(M.Count,'  ');
gotoxy(1,5); writeln(P.Qtt_Line*P.Qtt_Line,'  ');}

Str(M.ScorV,Cin1);                      {*Values for Commands*}
If P.Score=1 Then Cin1:=Cin1+' s';
Str(Round((M.Count/(P.Qtt_Line*P.Qtt_Line-1))*100),Cin2);
Cin2:=Cin2+' %';

If P.Panel=1 Then DelX:=LaF*26          {*Affichage du Panneau...*}
             Else DelX:=LaF*3;

VESA_SetColor(0);
Win_Clip(On,W1);                        {*Clipping Window*}
If P.Done=1 Then Begin                  {*Affichage du % Accomplis*}
   Display( LaF*4+DelX,  HaF*2+1,-1,0,'DONE');
   InputText( LaF*10+DelX, HaF*2,LaF*8,100,12,11,1,$26,Com2,Cin2);
   End;
If P.Score>0 Then Begin                 {*Affichage du Score*}
   Display( LaF*24+3+DelX, HaF*2+1,-1,0,'SCORE');
   InputText( LaF*32+DelX, HaF*2,LaF*8,100,12,11,1,$26,Com1,Cin1);
   End;

Win_Clip(Off,W1);                       {*Restore Normal Clipping*}
End;

{************************* DISPLAY WINDOW CONTENT ***************************}

Procedure REDRAW_FRAME;                 {*Define Window Content*}
Var DelX:Integer;                       {*Delta X si Panel=1*}

Begin
M.Wxi:=W1.X1; M.Wyi:=W1.Y1;             {*Memorise Coord Window...*}

If Iconified Then Exit;                 {*Fentre Iconifie => Pas d'affichage*}

REDRAW_COMMANDS;                        {*Affiche les Gadgets Commands*}

Win_Clip(On,W1);                        {*Clipping Window*}
VESA_SetColor(0);

If P.Panel=1 Then DelX:=LaF*26          {*Affichage du Panneau...*}
             Else DelX:=LaF*3;

If P.Panel=1 Then Begin                 {*Affichage du Panneau...*}
   StringBox( LaF*4+1, HaF*4+2, LaF*25+4, HaF*26,1,6,False);
   Button( LaF*6, HaF*5+1, LaF*18,-1,15,4, $00,But1,'_NEW GAME');
   Button( LaF*6, HaF*7+1, LaF*18,-1,0, 12,$00,But8,'S_TOP GAME');
   Button( LaF*6, HaF*9+1, LaF*18,-1,0, 7, $00,But2,'GAME _PREFS');
   Button( LaF*6, HaF*11+1,LaF*18,-1,0, 7, $00,But3,'_SYSTEM');
   Button( LaF*6, HaF*13+1,LaF*18,-1,0, 7, $00,But4,'_HIGH SCORES');
   Button( LaF*12-3,HaF*18,35,    35,0, 12,$18,But5,Get_SystemPath(SP_ICONS)+'I_BUTFLY.ICO');
   Button( LaF*6, HaF*23+2,LaF*18,-1,11,9, $00,But7,'E_XIT');
   End;

Win_Clip(Off,W1);                       {*Restore Normal Clipping*}

SHOW_BACKGROUND_GAME;                   {*Show Fond d'cran Game...*}
End;

{************************** DEFINE AND OPEN WINDOW **************************}

Function DEFINE_WINDOW:Boolean;
Begin
Iconified:=No;                          {*Fentre Taille Normale de Base*}
CALCULE_DATAS(P,M);                     {*Calcule Size Window & Autre*}
DEFINE_BLOCKS(P,B);                     {*Set Blocks Coordinates*}
B[P.Qtt_Line,P.Qtt_Line].X:=0;          {*Max Block - Vide Sont Placs*}
B[P.Qtt_Line,P.Qtt_Line].Y:=0;

M.View_One:=Yes;                        {*On Peut Rafficher l'Image 1 Fois*}

Win_Init(M.Wxi,M.Wyi,                   {*Define Main Window*}
            M.Wxi+M.WsX,
            M.Wyi+HaF1+M.WsY,
            $51DB,'MOS TAQUIN',W1);
Win_Sup(0,0,LaF*50,HaF1+4,0,0,0,0,0,5,$0A10,W1);{*Supplement*}

If NError=0 Then Begin
   Win_Draw(W1);                        {*Display Window*}
   DEFINE_WINDOW:=True;
   End
   Else DEFINE_WINDOW:=False;
End;

{********************** GERE LES SCORES: TIME ET BLOCKS *********************}

Procedure MANAGE_SCORE;                 {*Gre le Score...*}
Var Th,Tm,Ts,Td:Word;                   {*Get Time...*}
    Tmp:Longint;
Begin
Case P.Score Of
   1: Begin                             {*Time Score*}
      GetTime(Th,Tm,Ts,Td);             {*Rcupre le Temps Actuel*}
      Tmp:=Ts+Tm*60+Th*3600;
      If M.CTime<>Tmp Then M.Stime:=1;  {*On Affiche le Nouveau Temps*}
      M.CTime:=Tmp;                     {*Initialise les Scores*}
      M.ScorV:=M.CTime-M.ITime;         {*Calcul Diffrence*}
      End;
   2: Inc(M.ScorV);                     {*Block Score Simple...*}
   End;
End;

{*************************** MODIFIE MOS SYSTEM *****************************}

Procedure MODIF_MOS_SYSTEM;
Begin
Num:=1;
If M.InGame Then Begin
   Num:=3;                              {*Game is Running*}
   Req_Dialog('REQUEST','DO YOU WANT REALLY TO STOP THE CURRENT GAME|'
      +'AND MOFIFY MOS SYSTEM PREFERENCES ?',' _STOP AND MODIFY | _CONTINUE GAME ',Num);
   End;
If Num=1 Then Begin
   XMS_FreeBitmap(M.Image);             {*Libre Mmoire Main Image*}
   System_Request(120,30,'TAQUIN.INI');
   M.InGame:=Off;                       {*Flag Game Must Stop*}
   Win_Kill(W1);                        {*Ferme Fentre Actuelle*}
   Show_Screen;                         {*Rafiche le Fond d'Ecran...*}
   If Not DEFINE_WINDOW Then            {*Open Main Window*}
      Begin Exit_Flg:=On; Exit; End;    {*Erreur ?*}
   REDRAW_FRAME;                        {*Display Window Content*}
   End;
End;

{******************* DEMANDE DE MODIFICATION DES PREFERENCES ****************}

Procedure MODIFY_PREFS;
Begin
Num:=1;
If M.InGame Then Begin
   Num:=3;                              {*Game is Running*}
   Req_Dialog('REQUEST','DO YOU WANT REALLY TO STOP THE CURRENT GAME|'
      +'AND MOFIFY GAME PREFERENCES ?',' _STOP AND MODIFY | _CONTINUE GAME ',Num);
   End;
If Num=1 Then Begin
   XMS_FreeBitmap(M.Image);             {*Libre Mmoire Main Image*}
   TAQUIN_PREFS(M,P,B);
   Win_Kill(W1);                        {*Ferme Fentre Actuelle*}
   Show_Screen;                         {*Rafiche le Fond d'Ecran...*}
   If Not DEFINE_WINDOW Then            {*Open Main Window*}
      Begin Exit_Flg:=On; Exit; End;    {*Erreur ?*}
   REDRAW_FRAME;                        {*Display Window Content*}
   End;
End;

{*************** DEMANDE LE CAS ECHEANT DE RECOMMENCER LE JEU ***************}

Procedure STOP_GAME;
Begin
If Not M.InGame Then Exit;              {*On n'est pas en Train de Jouer...*}
M.InGame:=Off;                          {*Flag Game Begin*}
Num:=4;                                 {*Game is Running*}
Req_Dialog('REQUEST','YOU HAVE STOPED THE GAME|','   _OK   ',Num);
End;

{***************************** SORTIE DU JEU ? ******************************}

Procedure EXIT_GAME;
Begin
Num:=3;                                 {*Exit TAQUIN ?*}
Req_Dialog('REQUEST','DO YOU WANT REALLY TO QUIT TAQUIN ?|','   _YES   |   _NO   ',Num);
   If Num=1 Then Exit_Flg:=True;
End;

{*************** DEMANDE LE CAS ECHEANT DE RECOMMENCER LE JEU ***************}

Procedure ASKTO_START_GAME;
Var Th,Tm,Ts,Td:Word;                   {*Get Time...*}

Begin
Num:=1;                                 {*De Base Restart Game*}
If M.InGame Then Begin
   Num:=3;
   Req_Dialog('REQUEST','DO YOU WANT TO RESTART A NEW GAME ?|',' _START | _CANCEL ',Num);
   End;
If Num=1 Then Begin
   XMS_FreeBitmap(M.Image);             {*Libre la Mmoire XMS Alloue*}
   M.View_One:=On;                      {*Affiche L'image de Base*}
   REDRAW_FRAME;                        {*Raffiche Fentre*}
   DEFINE_BLOCKS(P,B);                  {*Set Blocks Coordinates*}
   CREATE_VIDE(P,M,B,W1);               {*Define Block Vide*}
   MIX_BLOCKS(P,M,B,W1);                {*Melange les Blocks*}
   COUNT_BLOCKS_OK(P,M,B);              {*Compte le Nombre de Blocks Ok*}
   REDRAW_COMMANDS;                     {*Raffiche Commands*}
   M.InGame:=On;                        {*Flag Game Begin*}
   GetTime(Th,Tm,Ts,Td);                {*Rcupre le Temps Actuel*}
   M.ITime:=Ts+Tm*60+Th*3600;           {*Initialise les Scores*}
   M.Stime:=1;                          {*Afficher De Base le Nouveau Temps*}
   M.ScorV:=0;
   End;
End;

{****************************** MAIN PROCEDURE ******************************}

Begin
Iconified:=No;                          {*Fentre pas Iconifie*}
INIT_ALL(M,P,HS);                       {*Initialise All*}
If Not DEFINE_WINDOW Then Exit;         {*Open Main Window*}
{gotoxy(1,1); Writeln(XMSGetFreeMem);}

DECLARE_MENU;                           {*Define Menu*}
REDRAW_FRAME;                           {*Display Window Content*}
Exit_Flg:=False;                        {*Init Exit Flag*}

Repeat;
Main_Task;                              {*Manage System*}

If (Win_Ready(W1)) And (Not Iconified) Then {*Test if Window Ready*}
   Begin                                {*Test Personnals Gadgets*}
{If M.Catch=TRUE Then Display(0,0,-1,0,'TRUE ') Else Display(0,0,-1,0,'FALSE');}
{   If M.Catch=FALSE Then Mse_SetPointerMode(P_UserMode);}
   If (P.Panel=1) And (M.Catch=TRUE) Then{*Gestion du Panneau...*}
      Begin 
      Win_Clip(On,W1);                  {*Clipping Window*}
      If Button_GetMsg(But1,1) Then ASKTO_START_GAME;  {*Start Game...*}
      If Button_GetMsg(But2,1) Then MODIFY_PREFS;      {*Edit Prefs*}
      If Button_GetMsg(But3,1) Then MODIF_MOS_SYSTEM;  {*Edit MOS System*}
      If Button_GetMsg(But4,1) Then SHOW_HIGHSCORES(P,HS);
      If Button_GetMsg(But5,1) Then Req_Register;
      If Button_GetMsg(But7,1) Then EXIT_GAME;         {*Exit TAQUIN ?*}
      If Button_GetMsg(But8,1) Then STOP_GAME;         {*Flag Finish Game*}
      Win_Clip(Off,W1);                 {*Restore Normal Clipping*}
   End;
                                        {====== SAVE IMAGE ======}
   If Not Mse_TestBox(W1.X1+M.Gx1, W1.Y1+HaF1+M.Gy1, W1.X1+M.Gx2, W1.Y1+HaF1+M.Gy2,10) Then
      Begin
      If Not M.Catch Then Begin         {*Pas dja Captur...*}
         Mse_Hide;
         M.Catch:=Yes;
         XMS_FreeBitmap(M.Image);       {*Libre la Mmoire XMS Alloue*}
         XMS_GetImage(W1.X1+M.Gx1, W1.Y1+HaF1+M.Gy1, W1.X1+M.Gx2, W1.Y1+HaF1+M.Gy2, M.Image);
         MSe_Show;
         End;
      End
      Else M.Catch:=No;                 {*On peut de Nouveau *}

{=================}

   If M.InGame Then Begin               {====== ROUTINE TEST DE JEU ======}
      Mse_Get(Xm,Ym,Ga,Mi,Dr);      {*Get Mouse Coordonnes...*}
      If P.Score=1 Then Begin           {*Score = Time...*}
         MANAGE_SCORE;                  {*Gre le Score...*}
         If M.STime=1                   {*On Affiche le Nouveau Temps*}
            Then Begin
            REDRAW_COMMANDS;            {*Raffiche le Score...*}
            M.Stime:=0;
            End;
         End;
      GET_BLOCK_IND(Xm,Ym,Xb,Yb,P,M,W1);{*Get Block Indices Under Mouse*}
{gotoxy(1,16); writeln(B[Xb,Yb].Xi,',',B[Xb,Yb].Yi,'    ');
gotoxy(1,17); writeln(B[Xb,Yb].X, ',',B[Xb,Yb].Y, '    ');}

      If GET_FREE_BLOCK(Xb,Yb,P,M) Then {*Le Bloc est t-il Libre ?...*}
         Begin
         Mse_SetPointerMode(P_UserMode);
         Mse_SetPointer(P_Hand);        {*Pointer to be Hand*}
                                        {*Dplace le Block*}
         If Ga Then Begin
            If P.Sound=1 Then Begin     {*Sound When Move...*}
               Sound(5000); Delay(20); NoSound;
               End;
            MOVE_BLOCK(Xb,Yb,M.VideX,M.VideY,P,M,B,W1);
            MANAGE_SCORE;               {*Gre le Score...*}
            REDRAW_COMMANDS;            {*Raffiche Score...*}
            If M.Count+1=P.Qtt_Line*P.Qtt_Line Then
               Begin
               M.InGame:=Off;           {*!!! Gagn !!!*}
               Mse_SetPointerMode(P_AutoMode);
               Mse_SetPointer(P_Current);
               Num:=1;
               Req_Dialog('CONGRATULATIONS','!!! YOU WON !!!','   _OK   ',Num);
               If TEST_NEW_SCORE(P,M,HS)>0 Then
                  Begin                 {*Dans la Table des Highscores ?*}
                  GET_HIGHSCORE(P,M,HS);{*Enregistre les Nouveaux Hiscores*}
                  SHOW_HIGHSCORES(P,HS);{*Affiche Les Highscores*}
                  End;
               End;
            End;
         End
         Else Begin
            Mse_SetPointerMode(P_AutoMode);
            End;
      End;                              {*End InGame*}
   End;

{=================}

Menu_Test(Menu,Col[1],Col[15],MS,PS,SS);{*Test Menu*}
Case MS of
   1: Case PS of                        {*Test Menu "TAQUIN"*}
      1: ;
      2: Req_Register;
      4: DOS_Shell;
      5: EXIT_GAME;                     {*Exit TAQUIN ?*}
      End;
   2: Case PS of                        {*Test Menu "GAMES"*}
      1: ASKTO_START_GAME;              {*Start Game...*}
      2: STOP_GAME;                     {*Stop Game*}
      4: SHOW_HIGHSCORES(P,HS);         {*Affiche Les High-Scores*}
      End;
   3: Case PS of                        {*Test Menu "PREFS"*}
      1: MODIF_MOS_SYSTEM;              {*Edit MOS System*}
      2: MODIFY_PREFS;                  {*Demande de Modification des Prfrences*}
      4: Req_Memory(100,100,'MEMORY INFORMATIONS');
      5: Req_Hardware(100,100,'HARDWARE INFORMATIONS');
      End;
   End;

Even:=Win_Test(W1);                     {*Get Windows Evens*}
If Even=1 Then Exit_Flg:=True;          {*Window Closed   => Exit*}
If Even=3 Then
   Begin                                {*Window Inconified / Uniconified*}
   If Iconified Then
      Begin
      Iconified:=No;
      BCLR(W1.IDRES,6);
      Win_IdRes(W1.IDRES,W1);
      REDRAW_FRAME;                     {*Redisplay Window Content*}
      End
      Else Begin
      BSET(W1.IDRES,6);
      Win_IdRes(W1.IDRES,W1);
      Iconified:=Yes;
      End;
   End;
If Even=9 Then REDRAW_FRAME;            {*Window Moved    => Display Content*}
Until Exit_Flg=True;                    {*Exit Flag*}

Win_Kill(W1);                           {*Close Window if Needs*}

DONE_ALL(P,M,B,HS);                     {*Done All*}
End;

{ͻ
                         MAIN PROGRAM (INITIALISATIONS)                     
 ͼ}

Begin
Directvideo:=False;
INIT_BASE;                               {*Initialise Hardware*}
INIT_SCREEN;                            {*Initialise Screen*}
INIT_MOUSE;                             {*Initialise Mouse*}

Oldexit:=ExitProc;                      {*Intercept Errors*}
SetJump(MyAddr);
ExitProc:=@ENTRY_INT24;

MAIN;                                   {*Call Main Procedure*}

DONE_MOUSE;                             {*Restore Mouse*}
DONE_SCREEN;                            {*Restore Screen*}
DONE_BASE;                               {*Restore Hardware*}
End.
