program TVEdit;

{$M 16384,11260,655360}
{$X+,S-,D-}

uses Dos,Graph, Objects, EventMan, Memory, Buffers, GrDriver, GraV, GraMenu,
Controls, GStdDlg, GMsgBox, GrApp, GEditors,Calc,Puzzle,GadGets,
Arty {, Overlay};
(*
{$O Grav}
{$O Controls}
{$O GraMenu}
{$O GStdDlg}
{$O GrApp}
{$O GMsgBox}
{$O Geditors}
{$O Calc}
{$O Puzzle}
{$O Gadgets}
{$O Arty}
*)

const
  HeapSize = 80 * (1024 div 16);

const
  cmOpen       = 100;
  cmNew        = 101;
  cmChangeDir  = 102;
  cmDosShell   = 103;
  cmCalculator = 104;
  cmShowClip   = 105;
  cmPuzzle     = 106;
  cmArty       = 107;
  cmAbout      = 108;
  cmCircles    = 109;

type
  PEditorApp = ^TEditorApp;
  TEditorApp = object(GraphApplication)
   Clock : PClockView;
    Heap : PHeapView;
    constructor Init;
    destructor Done; virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Idle; virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
    procedure OutOfMemory; virtual;
  end;

  PAboutPane = ^AboutPane;
  AboutPane = object(GraphView)
     constructor Init(Bounds : TRect);
     procedure Draw; virtual;
  end;

  PInfo = ^TInfo;
  Tinfo = object(TObject)
     C : TPoint;
     R : Integer;
     cl : word;
     constructor Init(Center : TPoint; Radius : integer; AColor : word);
  end;

  PCircleDemo = ^CircleDemo;
  CircleDemo = object(GraphView)
     Data : PCollection;
     constructor Init(var Bounds : TRect; ANum : integer);
     destructor Done; virtual;
     procedure Draw; virtual;
  end;

  PCircleDemoWindow = ^CircleDemoWindow;
  CircleDemoWindow = object(GraphWindow)
     constructor Init(var Bounds : TRect);
  end;

var
  EditorApp: TEditorApp;
  ClipWindow: PEditWindow;
  EXEName: PathStr;

function ExecDialog(P: PGraphDialog; Data: Pointer): Word;
var
  Result: Word;
begin
  Result := cmCancel;
  P := PGraphDialog(Application^.ValidView(P));
  if P <> nil then
  begin
    if Data <> nil then P^.SetData(Data^);
    Result := DeskTop^.ExecView(P);
    if (Result <> cmCancel) and (Data <> nil) then P^.GetData(Data^);
    Dispose(P, Done);
  end;
  ExecDialog := Result;
end;

function DoEditDialog(Dialog: Integer; Info: Pointer): Word; far;
var
  R: TRect;
  T: TPoint;
begin
  case Dialog of
    edOutOfMemory:
      DoEditDialog := MessageBox('Not enough memory for this operation.',
        nil, mfError + mfOkButton);
    edReadError:
      DoEditDialog := MessageBox('Error reading file %s.',
        @Info, mfError + mfOkButton);
    edWriteError:
      DoEditDialog := MessageBox('Error writing file %s.',
        @Info, mfError + mfOkButton);
    edCreateError:
      DoEditDialog := MessageBox('Error creating file %s.',
        @Info, mfError + mfOkButton);
    edSaveModify:
      begin
      DoEditDialog := MessageBox('%s has been modified. Save?',
        @Info, mfInformation + mfYesNoCancel);
      end;
    edSaveUntitled:
      begin
      DoEditDialog := MessageBox('Save untitled file?',
        nil, mfInformation + mfYesNoCancel);
      end;
    edSaveAs:
      DoEditDialog := ExecDialog(New(PFileDialog, Init('*.*',
        'Save file as', '~N~ame', fdOkButton, 101)), Info);
  end;
end;

function OpenEditor(FileName: FNameStr; Visible: Boolean): PEditWindow;
var
  P: PGraphView;
  R: TRect;
begin
  DeskTop^.GetExtent(R);
  P := Application^.ValidView(New(PEditWindow,
    Init(R, FileName, wfFramed + wfTitle + wfClose + wfZoom + wfMove + wfGrow)));
  if P <> nil then if not Visible then P^.Hide;
  DeskTop^.Insert(P);
  OpenEditor := PEditWindow(P);
end;

constructor AboutPane.Init(Bounds : TRect);
begin
   GraphView.Init(Bounds);
end;

procedure AboutPane.Draw;
var
   R : TRect;
   P : TPoint;
begin
   GetExtent(R);
   SetFillStyle(SolidFill,GetColor(1));
   Bar(R);
   SetFillStyle(SolidFill,Red);
   SetColor(Red);
   P.X := 17;
   P.Y := 47;
   FillEllipse(P,15,15);
   SetFillStyle(SolidFill,Green);
   SetColor(Green);
   P.X := 43;
   P.Y := 47;
   FillEllipse(P,15,15);
   SetFillStyle(SolidFill,Blue);
   SetColor(Blue);
   P.X := 30;
   P.Y := 70;
   FillEllipse(P,15,15);
   GFonts.SetTextStyle(3,HorizDir,1);
   Fillbackground := false;
   SetColor(DarkGray);
   P.X := 115;
   P.Y := 10;
   WriteTextXY(P,'Graph Vision');
   dec(P.X);
   dec(P.Y);
   SetColor(Blue);
   WritetextXY(P,'Graph Vision');
   FillBackground := true;
   GFonts.SetTextStyle(2,HorizDir,1);
   P.X := 121;
   P.Y := 40;
   SetFillStyle(SolidFill,GetColor(1));
   SetColor(Black);
   WriteTextXY(P,'Written by');
   inc(P.Y,15);
   P.X := 100;
   WriteTextXY(P,'Sergey E. Levov');
   inc(P.Y,32);
   P.X := 70;
   WriteTextXY(P,'Phone: (095) 954-55-78');
   inc(P.Y,15);
   P.X := 62;
   WriteTextXY(P,'E-mail: serg@isrir.msk.su');
end;

constructor TInfo.Init(Center : TPoint; Radius : integer; AColor : word);
begin
   TObject.Init;
   C := Center;
   R := Radius;
   Cl := AColor;
end;
constructor CircleDemo.Init(var Bounds : TRect; ANum : integer);
var
   i : integer;
   M : PInfo;
   A : TPoint;
begin
   GraphView.Init(Bounds);
   GrowMode := gfGrowHiX + GfGrowHiY;
   Data := New(PCollection,Init(ANum,1));
   Randomize;
   for i := 0 to ANum-1 do begin
      A.X := Random(ScreenWidth);
      A.Y := Random(ScreenHeight);
      M := New(Pinfo,Init(A,Random(200),Random(GetMaxColor)));
      Data^.Insert(M);
   end;
end;

procedure CircleDemo.Draw;
var
   R : TRect;
   T : TPoint;
   X,Y : integer;
procedure DrawCircle(P : PObject); far;
begin
  if P = nil then Exit;
  with PInfo(P)^ do begin
     SetFillStyle(SolidFill,Cl);
     SetColor(Cl);
     FillEllipse(C,R,2 * R div 3);
  end;
end;

begin
   GetExtent(R);
   SetFillStyle(SolidFill,Black);
   Bar(R);
   Data^.ForEach(@DrawCircle);
end;

destructor CircleDemo.Done;
begin
   Data^.Done;
   GraphView.Done;
end;

constructor CircleDemoWindow.Init(var Bounds : Trect);
var
   R : TRect;
begin
   GraphWindow.Init(Bounds,'Circles',wfFramed + wfTitle + wfClose + wfZoom + wfMove + wfGrow);
   WorkSpace^.GetExtent(R);
   Insert(New(PCircleDemo, Init(R,20)));
end;

constructor TEditorApp.Init;
var
  H: Word;
  R: TRect;
begin
  H := PtrRec(HeapEnd).Seg - PtrRec(HeapPtr).Seg;
  if H > HeapSize then BufHeapSize := H - HeapSize else BufHeapSize := 0;
  InitBuffers;
  GraphApplication.Init;
  DisableCommands([cmSave, cmSaveAs, cmCut, cmCopy, cmPaste, cmClear,
    cmUndo, cmFind, cmReplace, cmSearchAgain]);
  EditorDialog := DoEditDialog;
  GetExtent(R);
  R.A.X := R.B.X - 74;
  inc(R.A.Y);
  R.B.Y := R.A.Y + 14;
  Clock := New(PClockView,Init(R));
  Insert(Clock);
  GetExtent(R);
  dec(R.B.Y,2);
  R.A.Y := R.B.Y - 14;
  R.A.X := R.B.X - 74;
  dec(R.B.X,2);
  Heap := New(PHeapView,Init(R));
  Insert(Heap);
  ClipWindow := OpenEditor('', False);
  if ClipWindow <> nil then
  begin
    Clipboard := ClipWindow^.Editor;
    Clipboard^.CanUndo := False;
  end;
end;

destructor TEditorApp.Done;
begin
  GraphApplication.Done;
  DoneBuffers;
end;

procedure TEditorApp.HandleEvent(var Event: TEvent);

procedure FileOpen;
var
  FileName: FNameStr;
begin
  FileName := '*.*';
  if ExecDialog(New(PFileDialog, Init('*.*', 'Open file',
    '~N~ame', fdOpenButton, 100)), @FileName) <> cmCancel then begin
     OpenEditor(FileName, True);
  end;
 end;

procedure Calculator;
begin
  DeskTop^.Insert(ValidView(New(PCalculator, Init)));
end;

procedure Puzzle;
begin
  DeskTop^.Insert(ValidView(New(PPuzzleWindow,Init)));
end;

procedure Arty;
begin
   DeskTop^.Insert(ValidView(New(PArtyWindow,Init)));
end;

procedure Circles;
var
   R,R1 : Trect;
begin
   Randomize;
   repeat
      R.Assign(Random(GetMaxX),Random(GetMaxY),
      Random(GetMaxX),Random(GetMaxY));
      GetExtent(R1);
      R1.Intersect(R);
   until (not R1.Empty) and (R1.B.X-R1.A.X > MinWinSize.X)
   and (R1.B.Y-R1.A.Y > MinWinSize.Y);
   Desktop^.Insert(ValidView(New(PCircleDemoWindow,Init(R))));
end;

procedure About;
var
   D : PGraphDialog;
   R : TRect;
begin
  R.Assign(0, 0, 351, 258);
  R.Move((Desktop^.Size.X - R.B.X) div 2, (Desktop^.Size.Y - R.B.Y) div 2);
  D := New(PGraphDialog,Init(R,'About'));
  with D^ do begin
     R.Assign(14,13,325,157);
     Insert(New(PGraphGrayGroup,Init(R)));
     R.Assign(28,26,318,144);
     Insert(New(PAboutPane,Init(R)));
     R.Assign(132,174,195,213);
     Insert(New(PGraphBitmapButton,Init(R,'OK',cmOk,bfNormal)));
     SelectNext(false);
  end;
   DeskTop^.ExecView(D);
   Dispose(D,Done);
{   MessageBox(#3'Graph Vision',nil,mfInformation+mfOkButton);}
end;

procedure FileNew;
begin
  OpenEditor('', True);
end;

procedure DosShell;
begin
  DoneSysError;
  DoneEvents;
  DoneVideo;
  DoneMemory;
  SetMemTop(Ptr(BufHeapPtr, 0));
  PrintStr('Type EXIT to return to TVEDIT...');
  SwapVectors;
  Exec(GetEnv('COMSPEC'), '');
  SwapVectors;
  SetMemTop(Ptr(BufHeapEnd, 0));
  InitMemory;
  InitVideo;
  DetectMouse;
  InitEvents;
  InitSysError;
  Redraw;
end;

procedure ShowClip;
begin
  ClipWindow^.Select;
  ClipWindow^.Show;
end;

procedure Tile;
var
  R: TRect;
begin
  Desktop^.GetExtent(R);
  Desktop^.Tile(R);
end;

procedure Cascade;
var
  R: TRect;
begin
  Desktop^.GetExtent(R);
  Desktop^.Cascade(R);
end;

begin
  GraphApplication.HandleEvent(Event);
  case Event.What of
    evCommand:
      case Event.Command of
        cmOpen: FileOpen;
        cmNew: FileNew;
        cmDosShell: DosShell;
        cmShowClip: ShowClip;
        cmTile: Tile;
        cmCalculator: Calculator;
        cmCascade: Cascade;
        cmPuzzle: Puzzle;
        cmArty : Arty;
        cmAbout : About;
        cmCircles : Circles;
      else
        Exit;
      end;
  else
    Exit;
  end;
  ClearEvent(Event);
end;

procedure TEditorApp.Idle;

function IsTileable(P: PGraphView): Boolean; far;
begin
  IsTileable := P^.Options and ofTileable <> 0;
end;

begin
  GraphApplication.Idle;
  Clock^.Update;
  Heap^.Update;
  Message(DeskTop,evBroadcast,cmIdle,nil);
  if Desktop^.FirstThat(@IsTileable) <> nil then
    EnableCommands([cmTile, cmCascade])
  else
    DisableCommands([cmTile, cmCascade]);
end;

procedure TEditorApp.InitMenuBar;
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y + MenuItemHeight;
  MenuBar := New(PGraphMenuBar, Init(R, NewMenu(
    NewSubMenu('~F~ile', hcNoContext, NewMenu(
      NewItem('~O~pen...', 'F3', kbF3, cmOpen, hcNoContext,
      NewItem('~N~ew', '', kbNoKey, cmNew, hcNoContext,
      NewItem('~S~ave', 'F2', kbF2, cmSave, hcNoContext,
      NewItem('S~a~ve as...', '', kbNoKey, cmSaveAs, hcNoContext,
      NewLine(
      NewItem('~D~OS shell', '', kbNoKey, cmDosShell, hcNoContext,
      NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext,
      nil)))))))),
    NewSubMenu('~E~dit', hcNoContext, NewMenu(
      NewItem('~U~ndo', '', kbNoKey, cmUndo, hcNoContext,
      NewLine(
      NewItem('Cu~t~', 'Shift-Del', kbShiftDel, cmCut, hcNoContext,
      NewItem('~C~opy', 'Ctrl-Ins', kbCtrlIns, cmCopy, hcNoContext,
      NewItem('~P~aste', 'Shift-Ins', kbShiftIns, cmPaste, hcNoContext,
      NewItem('~S~how clipboard', '', kbNoKey, cmShowClip, hcNoContext,
      NewLine(
      NewItem('~C~lear', 'Ctrl-Del', kbCtrlDel, cmClear, hcNoContext,
      nil))))))))),
    NewSubMenu('~W~indows', hcNoContext, NewMenu(
      NewItem('~S~ize/move','Ctrl-F5', kbCtrlF5, cmResize, hcNoContext,
      NewItem('~Z~oom', 'F5', kbF5, cmZoom, hcNoContext,
      NewItem('~T~ile', '', kbNoKey, cmTile, hcNoContext,
      NewItem('C~a~scade', '', kbNoKey, cmCascade, hcNoContext,
      NewItem('~N~ext', 'F6', kbF6, cmNext, hcNoContext,
      NewItem('~P~revious', 'Shift-F6', kbShiftF6, cmPrev, hcNoContext,
      NewItem('~C~lose', 'Alt-F3', kbAltF3, cmClose, hcNoContext,
      NewLine(
      NewItem('Ca~l~culator', '', kbNoKey, cmCalculator, hcNoContext,
      NewItem('P~u~zzle','',kbNoKey,cmPuzzle,hcNoContext,
      NewItem('~A~rty','',kbNoKey,cmArty,hcNoContext,
      NewItem('A~b~out','',kbNoKey,cmAbout,hcNoContext,
      NewItem('C~i~rcles','',kbNoKey,cmCircles,hcNoContext,
      nil)))))))))))))),
    nil))))));
end;

procedure TEditorApp.InitStatusLine;
var
  R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - StatusItemHeight;
  New(StatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('~F2~ Save', kbF2, cmSave,
      NewStatusKey('~F3~ Open', kbF3, cmOpen,
      NewStatusKey('~Alt-F3~ Close', kbAltF3, cmClose,
      NewStatusKey('~F5~ Zoom', kbF5, cmZoom,
      NewStatusKey('~F6~ Next', kbF6, cmNext,
      NewStatusKey('~F10~ Menu', kbF10, cmMenu,
      NewStatusKey('', kbCtrlF5, cmResize,
      nil))))))),
    nil)));
end;

procedure TEditorApp.OutOfMemory;
begin
  MessageBox('Not enough memory for this operation.',
    nil, mfError + mfOkButton);
end;

begin
{  OvrInit('tvedit.ovr');
  OvrSetBuf(60 * 1024);
  if OvrResult <> ovrOk then
  begin
    PrintStr('Overlay error...'#13#10);
    Halt(1);
  end;}
  EditorApp.Init;
  EditorApp.Run;
  EditorApp.Done;
end.
