Program Demo_Mouse_2;

(****************************************************************************)
(*                                                                          *)
(*                             Demo Program For                             *)
(*                                 The Unit                                 *)
(*                                 G_Mouse2                                 *)
(*                                                                          *)
(*                          By Jean-Laurent PRADEL                          *)
(*                                                                          *)
(****************************************************************************)

Uses Crt,Dos,Graph,G_Mouse2;

Var x, y, button, b : Integer;
    SizeBox: Word;
    P : Pointer;
    i:integer;
    Boite, Boite2, Boite3, ContBox : ^Box;
    xcm, ycm, km : real;
    Intkm, Frackm, textkm : String;


Procedure Init;
  Var GrD, GrM : Integer;
  Begin
    DetectGraph (GrD,GrM);
    InitGraph (GrD,GrM,'c:\tp\bgi');
    If Not TestMouse Then Begin
      SetTextJustify (CenterText, CenterText);
      SetTextStyle (DefaultFont, HorizDir, 5);
      OutTextXY (Round (GetMaxX/2), Round (GetMaxY/2), 'You need a mouse driver !');
      Repeat Until KeyPressed;
      Halt;
    End;
    ChangeMouse(Arrow);
    New (ContBox,Init (Round (GetMaxX/2), Round (GetMaxY/20*15), 0,0,9,3,1));
    ContBox^.SetText (1,0,3,'Continue');
  End;

Procedure Title;
  Begin
    SetColor (Random (14)+1);
    SetTextStyle (1, HorizDir, 6);
    SetTextJustify (CenterText, TopText);
    OutTextXY (Round (GetMaxX/2), 5, 'UNIT MOUSE');
    SetTextJustify (CenterText, BottomText);
    OutTextXY (Round (GetMaxX/2), GetMaxY-5, 'DEMO');
    SetTextJustify (LeftText, CenterText);
    SetTextStyle(1, HorizDir, 3);
    SetColor (15);
    PutMouse (Round (GetMaxX/2), Round (GetMaxY/2));
  End;

Begin
  Init;
  Title;
  New (Boite,Init (Round (GetMaxX/2), Round (GetMaxY/2), 0,0,0,0,2));
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*4), 'This unit allows you to show or hide');
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*5), 'the mouse. This is usefull when you draw');
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*6), 'on the background...');
  Boite^.SetText (1,0,3,'Click to hide the mouse');
  Boite^.Bill;
  WaitButton (x,y,button);
  Boite^.ChangeText (1,0,3,'Click to show the mouse');
  Hide_Mouse;
  WaitButton (x,y,button);
  Show_Mouse;
  Dispose (Boite,Done);
  ContBox^.Bill;
  ContBox^.Wait (Left);
  Hide_Mouse;
  ClearViewPort;

  Title;
  New (Boite, Init (Round (GetMaxX/4), Round (GetMaxY/2), 120, 30,10,2,1));
  New (Boite2, Init (Round (GetMaxX/2), Round (GetMaxY/2), 120, 30,10,2,1));
  New (Boite3, Init (Round (GetMaxX/4*3), Round (GetMaxY/2), 120, 30,10,2,1));
  Boite^.SetText(1,0,3,'Left');
  Boite2^.SetText (1,0,3,'Center');
  Boite3^.SetText (1,0,3,'Right');
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*4), 'This unit allows you to create easily selection');
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*5), 'boxes, and wait the user click one of them...');
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*6), 'with the button you want...');
  Boite^.Bill;
  If KindOfMouse=3 Then Boite2^.Bill;
  Boite3^.Bill;
  ContBox^.Bill;
  SetColor (12);
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*12), 'Try at it on each of those boxes...');
  Show_Mouse;
  Repeat                                                         
    If Boite^.TestButton (Left) Or Boite3^.TestButton (Right) Or
      (Boite2^.TestButton (Middle) And (KindOfMouse=3)) Then Begin
          Sound (1000);
          Delay (100);
          NoSound;
    End;
  Until ContBox^.Testbutton (Left);
  Dispose (Boite,Done);
  Dispose (Boite2,Done);
  Dispose (Boite3,Done);
  Hide_Mouse;
  ClearViewPort;

  Title;
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*4), 'This unit allows you to change the mouse cursor');
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*5), 'There are 4 predefined cursors in constants and');
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*6), 'you can define new cursor...in an easy way...');
  SetColor(2);
  SetTextJustify (CenterText, CenterText);
  OutTextXY (Round (GetMaxX/2), Round (GetMaxY/2), 'Click right button to change the cursor');
  ContBox^.Bill;
  Show_Mouse;
  i:=0;
  Repeat
    Waitbutton(x,y,button);
    Case button Of
      Right : Begin
                Inc (i);
                i:= i Mod 4;
                Case i Of
                  0 : ChangeMouse (Arrow);
                  1 : ChangeMouse (Target);
                  2 : ChangeMouse (Bomb);
                  3 : ChangeMouse (QuestionMark);
                End;
              End;
    End;
  Until ContBox^.TestButton (Left);
  Hide_Mouse;
  ClearViewPort;

  Title;
  SetTextJustify (LeftText, CenterText);
  SetTextStyle(1, HorizDir, 3);
  SetColor (15);
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*4), 'This unit allows you to define a area out of');
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*5), 'which the mouse can''t go...');
  New (Boite, Init (Round(GetmaxX/2), Round(GetMaxY/2),300,100,14,8,2));
  Show_Mouse;
  PutMouse(0,0);
  MouseLimits (Round(GetMaxX/2)-150,Round(GetMaxY/2)-50,Round(GetMaxX/2)+150,Round(GetMaxY/2)+50);
  b:=0;
  Repeat
    Boite^.ChangeText (1,0,3,'Limited Area');
    For i:=0 To 10000 Do Begin
       MouseState (x,y,Button);
       If button<>0 Then b:=button;
    End;
    Boite^.ChangeText (1,0,3,'Click To Continue');
    For i:=0 To 10000 Do Begin
       MouseState (x,y,Button);
       If button<>0 Then b:=button;
    End;
  Until b<>0;
  Dispose (Boite, Done);
  UnLimitMouse;
  Hide_Mouse;
  ClearViewPort;

  Title;
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*4), 'And just for fun, you could compute');
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*5), 'how many (kilo)meters you make with...');
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*6), 'your mouse !');
  Show_Mouse;
  ContBox^.Bill;
  New (Boite, Init(Round(GetMaxX/2), Round(GetMaxY/2), 200, 30 ,15 ,0 ,14));
  km:=0;
  MouseRun (x,y);
  Repeat
    MouseRun (x,y);
    If (x<>0) Or (y<>0) Then Begin
      xcm := x/200*2.54;
      ycm := y/200*2.54;
      km := km + Sqrt (xcm*xcm+ycm*ycm);
      Str (Round(Int(km)), Intkm);
      Str (Round(Int(((km-Int(km))*100))), Frackm);
      Textkm := Intkm+'.'+Frackm+' cm';
      Boite^.ChangeText (1,0,3,Textkm);
    End;
  Until ContBox^.Testbutton (Left);
  Dispose (boite,Done);
  Hide_Mouse;
  ClearViewPort;

  Title;
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*4), 'New ! An object to define, move, modify');
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*5), 'and test the boxes...This object accepts');
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*6), 'news children with news procedures');
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*7), 'For example, click on the green box and');
  OutTextXY (Round (GetMaxX/15), Round (GetMaxY/20*8), 'move it with your mouse...');
  New (Boite, Init (Round (GetMaxX/2), Round (GetMaxY/2), 100,30,12,2,2));
  boite^.SetText (1,0,3,' ');
  ContBox^.Bill;
  Hide_Mouse;
  ChangeMouse (Target);
  With Boite^ Do Begin
    SizeBox := ImageSize(Round(MidX-Width/2),Round(MidY-Height/2),Round(MidX+Width/2),Round(MidY+Height/2));
    GetMem (P, SizeBox);
    GetImage (Round(MidX-Width/2),Round(MidY-Height/2),Round(MidX+Width/2),Round(MidY+Height/2),P^);
    Bill;
    Repeat
      If TestButton (Left) Then Begin
        MouseState (x,y,button);
        UnBill;
        Hide_Mouse;
        PutImage (Round(MidX-Width/2),Round(MidY-Height/2),P^,NormalPut);
        Move (x,y);
        GetImage (Round(MidX-Width/2),Round(MidY-Height/2),Round(MidX+Width/2),Round(MidY+Height/2),P^);
        Show_Mouse;
        Bill;
      End;
    Until ContBox^.TestButton (Left);
  End;
  Dispose (Boite,Done);
  Dispose (ContBox,Done);
  Dispose (P);
  Hide_Mouse;
  ChangeMouse (Bomb);
  ClearViewPort;

  Title;
  SetTextJustify (CenterText, CenterText);
  OutTextXY (Round (GetMaxX/2), Round (GetMaxY/20*6), 'All in all, you''ll find 21 procedures, 2 functions,');
  OutTextXY (Round (GetMaxX/2), Round (GetMaxY/20*7), 'few constants and types in the unit G_MOUSE2.TPU');
  OutTextXY (Round (GetMaxX/2), Round (GetMaxY/20*8), 'All details are in the file G_Mouse2.TXT.');
  OutTextXY (Round (GetMaxX/2), Round (GetMaxY/20*9), 'I wish you a lot of fun and nice new graphic');
  OutTextXY (Round (GetMaxX/2), Round (GetMaxY/20*10), 'programs with your MOUSE...!');
  Show_Mouse;
  Repeat
    x:=Random (GetMaxX);
    y:=Random (GetMaxY);
    PutMouse (x,y);
    Delay (100);
    MouseState (x,y,button);
  Until button<>0;
  Hide_Mouse;
  ClearViewPort;
  CloseGraph;
End.