{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Strings/Chained2.pas             [x] Protected mode

  Chanined tString instances. This is an example that demonstrates
  the built-in chain technique in tString. tStrings are more than
  simple text strings - they are prepared to handle an entire
  text structure!

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFSTREAM, EFSTRING, EFTEST;


var A, B, Delimeters : pToken;

begin
     MemPush; { EFTEST }

     { (i) Create a common string }

     New (A, Initialize ('SOMETIMES ONE MAY WANT TO IMPROVE A SOLUTION.'));

     { (ii) Set delimeter characters }

     Delimeters := New (pToken, Initialize ('O'));

     { (ii) Capture A before changing the pointer (we must be able
            to intercept A. Then, separate tokens in A and create
            a text structure with tokens and token separators in
            separate (linked) strings. }

     B := A; A^.Separate (Delimeters);

     { (iii) Write all the separated strings and show were
             they where separated. }

     WriteLn ('Separated:');

     while Assigned (A) do begin
           if A^.IsEqual (Endl) then Write ('<Endl>')
              else A^.StreamWrite (StdIO);

           A := pToken(A^.Successor);
           if Assigned (A) then Write ('|');
     end;
     WriteLn;
     WriteLn ('And merged into one entity again:');

     { (iv) Merge the separated substrings into a single
            string (the original string). If our string
            would have been >= 64K, it would have been
            merged into blocks of at the most 64K each. }

     B^.Merge;

     B^.StreamWrite (StdIO);

     WriteLn;

     { Release all memory }

     B^.Free;
     Delimeters^.Free;

     MemPop; { EFTEST }
end.