{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Streams/Storage2.pas             [x] Protected mode

  This program demonstrates how objects can be stored to a stream
  and then be retrieved later (in other applications and on other
  computers).

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFKERNEL, EFFILE, EFSTRING, EFDATA, EFBASIC, EFLIST;

var MyADT       : pList;
    MyObject    : pObject;
    MyStream    : tFile;
    MyText      : pText;

begin
     { Initialize data structure (can be of any type that supports
       stream storage) }
     New (MyADT, Initialize (0));

     with MyADT^ do begin

          New (MyText, InitializeEmpty);
          MyText^.Store ( 'Stream storage makes it very easy to transfer objects' );
          MyText^.Store ( 'to a file or to a memory allocation, and then reconstruct' );
          MyText^.Store (  'the object later.' );

          PutText (MyText);
          MyText^.Free;


          with MyStream do begin
               Initialize ('TEMP.$$$', 1024); Create;
               WriteLn ('* Stores object to stream *');
               Store (MyADT);
               { Read object from stream }
               Seek (0);
               WriteLn ('* Loads object from stream *');
               Load (MyObject);
               Intercept; { Stream }
          end;

          if MyObject^.IsInitialized and (MyADT^.IsEqual(MyObject)) then

             with pList (MyObject)^ do begin
                  { Write the objects type name }
                  WriteLn ('This object is of the type ', NameOfType, '.');
                  WriteLn ('* Content *');
                  { Construct an iterator for the data type }
                  with CreateIterator^ do begin
                       repeat
                             { Display element contents }
                             WriteLn (String(Content^));
                             WalkForward; { Go to next element }
                       until IsEnd;
                       Free; { Iterator }
                  end;
                  Free; { My object }
          end else WriteLn ('* Failed to reconstruct object! *');

          MyADT^.Free;

          WriteLn ('* Done *');

     end;

     DeleteFile ('TEMP.$$$'); { Delete temporary test file }
end.