{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Streams/Storage1.pas             [x] Protected mode

  This program demonstrates how objects can be stored to a stream
  and then be retrieved later (in other applications and on other
  computers).

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFKERNEL, EFSTREAM, EFTEST;

var Resource : pDataStream;
    Temporary : array [1 .. 4096] of byte;
    Stored : pObject; Retrieved : pObject;

begin
     MemPush; { EFTEST }

     New (Resource, Initialize (@Temporary, SizeOf(Temporary)));

       { Storing tObject }

       WriteLn ('Storing a tObject ...');
       New (Stored, Initialize);
       Resource^.Put (Stored);
       Stored^.Free;

       { Loading tObject }

       WriteLn ('Loading a tObject ...');
       Resource^.Reset;
       Retrieved := Resource^.Get;
       Retrieved^.Free;

       WriteLn ('Done.');

     Resource^.Free;

     MemPop; { EFTEST }
end.