{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Streams/Polymrph.pas             [x] Protected mode

  This program demonstrates the advantages with polymorphic I/O
  streams.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFKERNEL, EFSTREAM;

var FirstStream, SecondStream : pStream;
    Something : array [1 .. 20] of record Name : string end;


begin
     FirstStream  := New (pDataStream, { Data stream }
                          Initialize (@Something, SizeOf(Something)));
     SecondStream := New (pNullStream, Initialize); { Null stream }

     { The first stream and the second stream uses the same interface, ie.
       allows the same operations to be performed. They are polymorphic.
       Object polymorphism makes it possible to pass any stream to a
       component. The component can then access the stream without knowing
       anything about the stream implementation. How the expected
       operations are performed is not of interest, ie. what kind of
       stream you passed to it it'll never know. }

     FirstStream^.Free; SecondStream^.Free;
end.