{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Streams/Encrypt1.pas             [x] Protected mode

  This program demonstrates the encryption filter. tEncryptFilter
  provides random access. You can move around in the stream and
  still encrypt or decrypt the data.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFKERNEL, EFSTREAM, EFFILTER;


var Source : pStream; Target : pEncryptFilter;
    CodeMe, Coded, Keyword : string;

begin
     CodeMe := 'I am a coded text.';
     Coded  := CodeMe;
     Keyword := 'I coded something. This key is required to decrypt.';

     { Initialize streams }
     Source := New ( pDataStream,
                     Initialize (@CodeMe[1], Length(CodeMe)) );

     Target := New ( pEncryptFilter,
                     Initialize ( Keyword,
                                { Keyword }
                                  New ( pDataStream,
                                        Initialize (@Coded[1], Length(Coded)) )));
                                      { Base stream (will be destructed) }

     Source^.CopyOut (Target, Source^.Size);
     WriteLn ('The coded string is:');
     WriteLn ('  ', Coded);

     { Go to the first positions (the same as calling Source^.Reset
       and Target^.Reset). }
     Source^.Seek (0); Target^.Seek (0);

     Source^.CopyIn (Target, Source^.Size);
     WriteLn ('The decoded string is:');
     WriteLn ('  ', CodeMe);

     Source^.Free; Target^.Free;
end.