{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Math/Rational.pas                [x] Protected mode

  This is an example on the rational number data type.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFMATH;


var Q1, Q2 : tRational;
    N : tInteger;
    R : tReal;

begin
     Q1.Initialize (0, 0);
     Q2.Initialize (5, 15);


     { This example demonstrates the new rational
       data type that EFLIB introduces to Borland
       Pascal. The rational number has the property
       of being stored as a number P/Q, where
       the greatest common divisor, GCD (P,Q), is
       always equal to 1. }

     Q1.SetReal (0.5); { The rational number becomes 1/2 }

     Q1.Divide (@Q2);

     WriteLn ( 'Q1 / Q2 = ', Q1.P, '/', Q1.Q );

     Q1.Multiply (@Q2);

     WriteLn ( 'Q1 = ', Q1.P, '/', Q1.Q );
     WriteLn ( 'Q2 = ', Q2.P, '/', Q2.Q );

     { Integers are easy to type-cast: }

     with N do begin

          Initialize (5);
          Q1.Add (@N);
          WriteLn ( '5 + Q1 = ', Q1.P, '/', Q1.Q );

          Intercept;

     end;

     { Real numbers can also be type-casted to
       rational numbers. Notice that not all
       real numbers will give you exact results!
       If required, tRational will estimate the
       real number: }

     Q1.SetValue (0, 1); { Q <> 0 since P / 0 is not defined! }

     with R do begin

          Initialize (Pi);
          Q1.Add (@R);
          WriteLn ( 'Pi = ', Q1.P, '/', Q1.Q, ' [approximated]');

          Intercept;

     end;


     Q1.Intercept; Q2.Intercept;
end.