{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Location/Matrix6.pas             [x] Protected mode

  Matrix algebra demonstration: application of matrixes. This is
  a simple example on how matrixes are used to calculate
  partial fractions for a (specific) rational function.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFSTREAM, EFMATH;


var Matrix1, Matrix2 : tMatrix;

begin
     WriteLn ('*** Application of matrixes ***');

     with Matrix1 do begin

          { Build a square matrix }
          Initialize (5, 5);

          { Equation system after initial partial fraction calculations
            (easy calculations). }
          SetElement (1, 1, 1);  SetElement (1, 2, 0);  SetElement (1, 3, 0);  SetElement (1, 4, 1); SetElement (1, 5, 0);
          SetElement (2, 1, -2); SetElement (2, 2, 1);  SetElement (2, 3, 0);  SetElement (2, 4, 0); SetElement (2, 5, 1);
          SetElement (3, 1, 2);  SetElement (3, 2, -2); SetElement (3, 3, 1);  SetElement (3, 4, 0); SetElement (3, 5, 0);
          SetElement (4, 1, 0);  SetElement (4, 2, 2);  SetElement (4, 3, -2); SetElement (4, 4, 0); SetElement (4, 5, 0);
          SetElement (5, 1, 0);  SetElement (5, 2, 0);  SetElement (5, 3, 2);  SetElement (5, 4, 0); SetElement (5, 5, 0);

          with Matrix2 do begin

               { Build a row-matrix for an equation system }
               Initialize (5, 1);

               SetElement (1, 1, 0); { (Row, Column, Real number) }
               SetElement (2, 1, 0);
               SetElement (3, 1, 0);
               SetElement (4, 1, 0);
               SetElement (5, 1, 1);

               if Matrix1.Gauss (@Matrix2)
                  then Matrix2.StreamWrite (StdIO)
                  else WriteLn ('Error: Gauss elimiation failed.');

               Intercept;
          end;

          Intercept;
     end;

     WriteLn ('The above result corresponds to 1 / [ (x^3)(x^2-2x+2) ] =');
     WriteLn ('A/x + B/x^2 + C/x^3 + (Dx+E)/(x^2-2x+2), i.e. partial fractions');
     WriteLn ('for this rational function (A .. E listed).');
     WriteLn;
end.