{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Elements/Generic2.pas   [x] Protected mode

  Polymorphic elements. This is a demonstration of how tGenericElement
  allows you to place any data inside an element, and of tADT's support
  of tElement instances.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFADT, EFARRAY, EFELEM;


const SomeContent : string
        = 'Component selectors = great things that give you freedom.';

var MyADT : pLinearADT;
    Element, Retrieved : pElement;

begin
     { Let us create a bounded array with 10 generic elements
       of 100 bytes each. These elements can store any data.
       Note that the "generic elements" are not yet allocated,
       that is, the array is empty. }
     MyADT := New ( pBoundedArray, Initialize ( 100, 10 ) );

     { All ADT's - even ordered - have a method called CreateElement.
       This is a so called component selector, that is, a method
       intended to be overridden to allow you to modify how the ADT
       behave. Another component selector in ADT's is CreateIterator. }

     Element := MyADT^.CreateElement;

     { CreateElement guarantees that a valid element is created.
       If an element cannot be created, the method must trigger
       a fatal error. Right now, Element is a tElement instance.
       The default element class is tGenericElement, and
       we have not overridden CreateElement to force it to some
       other element type. Hence element must be a tGenericElement. }

     if TypeOf (Element^) = TypeOf (tGenericElement)
        then WriteLn ('ADT''s generally use tGenericElement. But we can put other elements in them. ');

     { Let us put some data in our new element! }

     Element^.Allocate (100);
     Element^.CopyIn (@SomeContent[0], 100, 0); { Content, Size }

     { All linear ADT's, e.g. arrays, stacks, queues and lists,
       have two methods: Put and Get. Put inserts a tElement instance
       into the ADT, and Get retrieves the instance at the given
       index. }

     MyADT^.Put (Element);

     { Now we have got an ADT with a generic element. To
       certify that it really is there, let us use the Low
       method to get the lowest used element. Surely, that
       element must also be our inserted element since there
       is only one element inside the array. }

     Retrieved := MyADT^.Get (MyADT^.Low);

     { Comment: Since the array is bounded, we can never be 100%
       sure of the ordering of elements. Boundaries are arbitrary
       set and elements may be defragmented. In this case, however,
       we could as well have replaced Low with "1". }

     { Let us write the content text on the screen: }
     WriteLn ('Conclusion:');
     WriteLn (String (Retrieved^.Data(0)^));

     MyADT^.Free; { Free ADT and elements. }
end.