{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Lists/Array4.pas        [x] Protected mode

  Demonstration of element moving in an array ADT.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFARRAY, EFSTRING;


const NumberOfElements = 20;


{ Display a fragmentation report. }
procedure Display (What : pArray);
var Index : word;
begin
     for Index := 1 to What^.Capacity do
         if What^.IsUsed (Index)
            then Write ('x') else Write ('o');
     WriteLn;
end;


var MyArray : tArray; Data : string;
    Index : word;

begin
     WriteLn ('This is an example of advanced');
     WriteLn ('array handling:');

     with MyArray do begin

          Initialize ( NumberOfElements, SizeOf (Data) );

          { Add some elements }
          for Index := 1 to Capacity do begin
              Data := StringNumber (Index, 0, 0);
              Store (Data);
          end;

          Display (@MyArray);

          Erase (2); Erase (5); { Make the array fragmented }
          Defragment; { Move elements to front }
          Display (@MyArray);

          Move (1, Elements, 1); { Move ( Start, Stop, Steps ) }
          Display (@MyArray);

          Intercept;
     end;
end.