{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Lists/Array2.pas        [x] Protected mode

  Demonstration of the array with regard to its memory efficiency.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFBASIC, EFARRAY, EFSTRING, EFTEST;


const CapacityOfElements = 25; { Will be doubled }
      NumberOfElements   = 10;

var MyArray : tArray; A : string; Index : word;
    Memory : longint; Timer : tTimer;


begin
     Randomize; Timer.Initialize; Memory := MemAvail;


     WriteLn ('* Array with dynamic element allocation *');

     { Build link database (CapacityOfElements number of links) }

     with MyArray do begin

          { Initialize an array with a specified maximum number
            of elements (element capacity), ie. the a specific number
            of elements slots. }

          Initialize ( CapacityOfElements,    SizeOf(Text) );
                       { Storage capacity }    { Element size }

          { Double the storage capacity of the array. }

          Resize ( Capacity * 2 );

          { Arrays are dynamically allocated, that is, elements that
            are not used does not require memory. }

          WriteLn (Memory - MemAvail,' bytes needed when the array is "empty".');

          { Update some elements }

          for Index := 1 to NumberOfElements do begin

              with CreateRandomString (35)^ do begin
                   A := Pascal;
                   Free;
              end;

              Store (A);
          end;

          { Move elements randomly }
          for Index := 1 to Capacity do
              Swap (Succ(Random(Capacity)), Succ(Random(Capacity)));

          WriteLn;
          Write ('Element sizes: ');
          { Display elements sizes }
          for Index := Capacity downto 1 do { Display used elements only }
              if IsUsed (Index) then Write (Get(Index)^.Size, ' ');

          WriteLn;
          WriteLn (Memory - MemAvail,' bytes needed when ', (Elements / Capacity)*100:0:0 ,
                   '% of the array is used (', Elements, ' elements of ', Capacity, ').');

          Intercept; { MyuArray }
     end;

end.