{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Advanced/Classes2.pas            [x] Protected mode

  This is an example of how identity instances can be handled. This
  is a low-level demonstration supplied for advanced users. Most user
  should not try to understand these techniques.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFDEF, EFKERNEL, EFTEST;


var First, Second : pClassIdentity;

begin
     MemPush; { EFTEST }

     { This is an advanced example on how
       the class hierarchy identities can be
       used to create small hierarchies indepdent
       of the tClassManager hierarchy. }

     New (Second);

     New (First, Initialize ( NIL,             NIL,               Second,
                            { ^ Level link } { ^ Parent link }  { ^ Descendant }
                              1001,            'tFirstClass',
                            { ^ Identity }   { ^ Name of class }
                              TypeOf(tObject), NIL,               NIL ));
                            { ^ Class VMT }  { ^ Loader }       { ^ Storer }

     Second^.Initialize     ( NIL,             First,             NIL,
                            { ^ Level link } { ^ Parent link }  { ^ Descendant }
                              1002,            'tSecondClass',
                            { ^ Identity }   { ^ Name of class }
                              TypeOf(tStream), NIL,               NIL );
                            { ^ Class VMT }  { ^ Loader }       { ^ Storer }


     { Compare the identity with some parameters, returning
       TRUE if any parameter match the identity. }

     if First^.IsMatch (0, 'tFirstClass', NIL, NIL)
        then WriteLn ('Matching class name, VMT and Parent ignored (NIL parameters).');

     { The following call would be invalid if tSecondClass didn't
       exist in the hiearchy, since Search then would return a
       NIL pointer and Address would result in a general protection
       fault (identity not assigned). }

     if First^.Search (0, 'tSecondClass', NIL, NIL)^.Address
        = TypeOf (tStream) then WriteLn ('Recognized tSecondClass.');

    First^.Free; { Release the entire hiearchy. }

    MemPop; { EFTEST }
end.