/******************************************************************************
*                                   rtobj.h                                   *
*      please notice -                                                        *
*      this unit includes both the object3d unit, and the superobj unit,      *
*      and it is used with no reference to the WWToolKit window GUI library,  *
*      uses project3, instead of prjWind  (It does, however, support OWL)     *
*                                                                             *
* In V2.x - The support collections are part of this unit as well ...         *
* V3.x adds os/2 support                                                      *
*                                                                             *
*                                                                             *
*                                 3D Objects                                   *
*                                 ----------                                   *
*                                                                              *
*   A 3D object is a collection of points and lines in the 3D universe,        *
*   that represent the body we want to draw on the screen.                     *
*   A 3D object is allways centered around point (0, 0, 0) in the 3D universe. *
*   (Its center of gravity assuming it is has a uniform weight distribution    *
*    is in point (0, 0, 0)                                                     *
*   At any moment during the object's life, we know it's distance from the     *
*   origin, And it's rotation using reveres rotation CTM.                      *
*                                                                              *
*   3D Object methods:                                                         *
*      constructor Open                                                        *
*      destructor  CloseMe                                                     *
*      procedures: Rotate, Scale, Move, Show, Hide, Load, Save                 *
*                  SetToOrigin, Paint                                          *
*                                                                              *
******************************************************************************/

#ifndef _rtobj_h
#define _rtobj_h

#include <stdio.h>
#include "ctm3d.h"
#include "project3.h"

class baseObject {

public:

   ctmPtr myCtm;

   unsigned int myColor;
   point3d location;
   int scrPntUpdt; // TRUE if screen points updated.
   char name[80];

   baseObject(char *myName, unsigned int color); // same as open in pascal
   virtual ~baseObject();  // same as closeMe in pascal

#ifndef _windows
   virtual void show();
   virtual void hide();
   virtual void paint();
#endif

   virtual void updateScreenPoints();
   virtual void move(axisType axis, double by);
   virtual void translate(int dx,
                          int dy,
                          int dz);
   virtual void scale(axisType axis, double factor);
   virtual void allScale(double sx, double sy, double sz);
   virtual void rotate(axisType axis, double deg);
   virtual void goto3dPos(double x, double y, double z);
   virtual void setToOrigin(); // translate to 0,0,0, update points and set ctm to unit.
   virtual void calcLocation(); // set location to central gravity
   virtual void deleteTransform(); // set myCtm to unit

   virtual unsigned int load(); // from disk 
   virtual unsigned int save(); // to disk
   virtual unsigned int writeMe(FILE *elementFile); // to disk, without opening file 
   virtual unsigned int readMe(FILE *elementFile);


}; // baseObject class definition

typedef baseObject *baseObjectPtr;

class obj3d : public baseObject {

public:

   point3d (*points)[];
   line3d  (*lines)[];
   screenPoints (*scrPoints)[];

   int numOfLines;
   int numOfPoints;
   ctmPtr reverseRot;
   ctmPtr unReverseRot;

   obj3d(char *myName, point3d ref, unsigned int color);
   virtual ~obj3d();

   virtual void paint();
   virtual void updateScreenPoints(); 
   virtual void calcLocation();
   virtual void setToOrigin();
   virtual unsigned int writeMe(FILE *elementFile);
   virtual unsigned int readMe(FILE *elementFile);

}; // obj3d class definition

typedef obj3d *obj3dPtr;

class complexObj : public baseObject {

public: 
   
   obj3dPtr (*childs)[];
   ctm   (*ctms)[];

   int numOfChilds;

   complexObj(char *myName, unsigned int color);
   virtual ~complexObj();

   virtual void updateScreenPoints();
   virtual unsigned int writeMe(FILE *elementFile);
   virtual unsigned int readMe(FILE *elementFile);
   virtual void calcLocation();
   virtual void paint();
   virtual void move(axisType axis, double by);
   virtual void scale(axisType axis, double factor);
   virtual void rotate(axisType axis, double deg);
   unsigned int addSubObject(char *myName, point3d ref);
   obj3dPtr getChildPtr(int index);
   void rotateChild(int child, axisType axis, double deg);
   void scaleChild(int child, axisType axis, double factor);
   void moveChild(int child, axisType axis, double by);

}; // complexObj class definition


#endif
