/******************************************************************************
*                                    hdr3d                                    *
******************************************************************************/

#ifndef _hdr3d_h
#define _hdr3d_h

#define version3dLib = "3.0";

extern const screenWidth;
extern const halfWidth;

extern const double radFactor;

struct line3d {
	int fromP;
	int toP;
  }; // line3d struct ddefinition

typedef line3d *line3dPtr;

struct screenPoints {
   int sx;
   int sy;
  }; // screenPoints struct definition

typedef screenPoints *screenPointsPtr;

enum axisType {x, y, z};

struct point3d {
   double x;
   double y;
   double z;
  }; // point 3d struct definition

typedef point3d *point3dPtr;

extern point3d zeroPoint;

extern int xAxis;
extern int yAxis;

#ifdef _WINDOWS_
extern unsigned int maxX;
extern unsigned int maxY;
extern unsigned int maxColor;
#endif

#ifdef _OS2_
unsigned int maxX;
unsigned int maxY;
unsigned int maxColor;
#endif

extern double cosine_x;
extern double cosine_y;
extern double sine_x;
extern double sine_y;

extern axisType currentAxis;

extern "C" void calcAxisDeg();

#endif
