/* imag.c - misc routines for dealing with imag structures
 */
#include "aldtypes.h"
#include "aldmem.h"
#include "aldutils.h"
#include "imtypes.h"
#include "imag.h"

void InitImag (p)
IMAG *p;
{

		/* zero out the structure, mainly for the existence fields and handles
		 */
		lmemset ((LPSTR)p, '\0', sizeof(IMAG));

		/* fill in simple defaults
		 */
#ifdef WINDOWS
		p->iFileType = INTELTIFF;
#endif
#ifdef MACINTOSH
		p->iFileType = MOTOROLATIFF;
#endif

		/* fill in some defaults
		 */
		p->iBitsPerSample = 1;
		p->iSamples = 1;
		p->iPredictor = PREDICTOR_NONE;
		p->iRowsPerStrip = MAXWORD;
		p->iPhotometricInterpretation = WHITEZERO;
		p->iCompression = PACKINTOBYTES;
}

void CloseImag (p)
IMAG *p;
{
		WORD	ii;

		/* free allocated field data:
		 */
		for (ii = 0; ii < NTFIELDS; ii++) {
			if (p->tf[ii].Talloc) {
				MMFree (p->tf[ii].Thandle);
				p->tf[ii].Talloc = FALSE;
				p->tf[ii].Thandle = HNULL;	/* probably unnecessary */
				p->tf[ii].Texists = FALSE;		/* probably unnecessary */
			}
		}

		return;
}
