/***************************************************************************

		Time the execution of a program

	All parameters are passed to the child program exactly as if the child
	had been invoked directly from the command line.

for executables -
	usage: rtime child program [child program options] [child program arguments]
for batch files -
	usage: rtime -b batchfile [args]
or
	usage: rtime command /c batchfile [args]

	Uses Microsoft C vers 3.0 or 4.0

	Created	26mar87	jlw

***************************************************************************/

#include	<stdio.h>
#include	<time.h>
#include	<process.h>

#define	SECS_MIN	60
#define	MINS_HOUR	60
#define	HOURS_DAY	24

int		batch = 0;		/* default to not a batch file */

	/* global versions of entry args */
int		ac;
char	**av;

main(argc, argv)
	int		argc;
	char	**argv;
{
long	stime, etime;

	ac = argc;
	av = argv;

	if( --ac ) {
		++av;
	}
	else {
		usage();
		exit(1);
	}

	parse();

	/* we must have at least the command name */
	if( !ac ) {
		usage();
		exit(1);
	}

	fprintf(stderr,"\nTiming program \"%s\" execution.", *av);
	time(&stime);
	fprintf(stderr,"\nStarting time is\n\t%s\n", ctime(&stime));
	if( batch ) {
		/* replace "rtime -b" with "command /c" */
		argv[0] = "command";
		argv[1] = "/c";
		execute(argv[0], argv);
	}
	else {
		execute(*av, av);
	}
	time(&etime);
	fprintf(stderr,"\nEnding time is\n\t%s", ctime(&etime));
	prt_elapsed_time(stime, etime);
}

parse()
{
	if( **av == '-' ) {
		switch( tolower(*++*av) ) {
			case 'b':
				batch = 1;
				--ac;
				++av;
				break;
			default:
				usage();
				--ac;
				++av;
				break;
		}
	}
}


execute(child, args)
	char	*child;
	char	**args;
{
int		retchild;

	retchild = spawnvp(P_WAIT, child, args);
	switch( retchild ) {
		case 0 :
			/* child succeeded */
			break ;

		case -1 :
			fprintf(stderr,"RTIME: - child proc \"%s\" not started\n", child);
			break ;

		default :
			fprintf(stderr,"\nRTIME: - child proc \"%s\" failed, returned 0x%02x\n" ,
				child, retchild) ;
			break ;
	}
}


prt_elapsed_time(stime, etime)
	long	stime, etime;
{
long	ttime;
long	td, th, tm, h, m, s;

	ttime = etime - stime;
	fprintf(stderr,"Elapsed time in seconds is\n\t%ld", ttime);

	s	= ttime % SECS_MIN;
	tm	= ttime / SECS_MIN;
	m	= tm % MINS_HOUR;
	th	= tm / MINS_HOUR;
	h	= th % HOURS_DAY;
	td	= th / HOURS_DAY;

	fprintf(stderr,"\nElapsed time is\n\t%ld day(s), %ld hour(s), %ld min(s), %ld sec(s)\n",
		td, h, m, s);			
}


usage()
{
		fprintf(stderr,"\nTo time executable programs the usage is:");
		fprintf(stderr,"\n\t\"rtime program [program_opts] [program_args]\"\n");

		fprintf(stderr,"\nTo time batch files the usage is:");
		fprintf(stderr,"\n\t\"rtime -b batchfile [batchfile_args]\"\nor");
		fprintf(stderr,"\n\t\"rtime command /c batchfile [batchfile args]\"\n");
		exit(1);
}



