{ GETONEREAL and GETONEINT: Two functions that do the same thing.
  They both print a prompt and the old value of the variable, and
  request a new value from the user.  If the user just hits ENTER,
  then the old value is returned.  If he types in a legitimate value
  (i.e., it is numeric and in the range Loval to Hival), then the
  new value is returned.  If an invalid entry is made, he is given
  an error message and prompted to retype.
}

function GETONEREAL (Oldval, Loval, Hival: real; Prompt: text80): real;
var Num:     integer;        { number of values read }
    Realvar: vartype;        { variables from input }
    Comment: text80;         { user's comment (unused) }
    Cmmd:    cmmdtype;
    Parm:    parmtype;
    Line_num:integer;

begin
  Num := -1;
  Line_num := -1;
  while (Num <> 0) and (Num <> 1) do begin
    write ('Enter ', Prompt, ' ( ', Oldval:7:3, ' ) = ');
    Num := inreal (Input, Realvar, Comment, Cmmd, Parm, Line_num, TRUE);
    if (Num = 1) then begin
      if (Realvar[1] < Loval) or (Realvar[1] > Hival) then begin
        writeln ('Error: Input must be in range ', Loval:7:3, ' to ',
                 Hival:7:3);
        Num := -1;
      end;
    end else if (Num <> 0) then
      writeln ('Error: Expecting one numeric input.');
  end; { while }
  if (Num = 1) then
    Getonereal := Realvar[1]
  else
    Getonereal := Oldval;
end; { function GETONEREAL }

function GETONEINT (Oldval, Loval, Hival: integer; Prompt: text80): integer;
var Num:     integer;        { number of values read }
    Realvar: vartype;        { variables from input }
    Comment: text80;         { user's comment (unused) }
    Cmmd:    cmmdtype;
    Parm:    parmtype;
    Line_num:integer;

begin
  Num := -1;
  Line_num := -1;
  while (Num <> 0) and (Num <> 1) do begin
    write ('Enter ', Prompt, ' ( ', Oldval, ' ) = ');
    Num := inreal (Input, Realvar, Comment, Cmmd, Parm, Line_num, TRUE);
    if (Num = 1) then begin
      if (Realvar[1] < Loval) or (Realvar[1] > Hival) then begin
        writeln ('Error: Input must be in range ', Loval, ' to ', Hival);
        Num := -1;
      end;
    end else if (Num <> 0) then
      writeln ('Error: Expecting one numeric input.');
  end; { while }
  if (Num = 1) then
    Getoneint := round (Realvar[1])
  else
    Getoneint := Oldval;
end; { function GETONEINT }

