unit anorpr_u;

interface

uses acrcy;
function anorpr(xx:double):double;

implementation

function anorpr(xx:double):double;
{
c        anorpr calculates the normal probability density to a specified
c        accuracy.  it uses both a continued fraction method (in the tai
c        and a series method (near 0).
}
const
  zer=0.0;
  tenth=0.1;
  half=0.5;
  one=1.0;
  two=2.0;
  ten=10.0;
  const1=0.39894228040143;
  xlim=9.0;

label
  label50,
  label60,
  label70;

var
  x,a,z,before,dif,
  alogx,anlog,fl2i1,
  an,bn,ai,bi,am1,am2,bm1,bm2
   : double;
  i
   : integer;
begin
      acu := 1.0e-7;
      x:=abs(xx);
      a:=one;
      if(x>=xlim) then
        goto label60;
      a:=half;
      if(abs(xx)<=acu) then
        goto label70;
      z:=const1*exp(-half*x*x);
      before:=two;
      if(x<two) then
      begin
{
c        integral by a series method...for xx near zero.
}
        alogx:=ln(x);
        anlog:=zer;
        a:=half+z*x;
        for i:=1 to 100 do
        begin
          fl2i1:=2*i+1;
          anlog:=anlog+ln(fl2i1);
          a:=a+z*exp(fl2i1*alogx-anlog);
          dif:=abs(a-before);
          if(dif<=acu) then
            goto label60;
     {10} before:=a;
        end
      end;
{
c       c  integral by continued fraction.  for xx in tails.
}
   {20} bi:=x;
      am1:=z;
      am2:=zer;
      bm1:=x;
      bm2:=one;
      for i:=1 to 100 do
      begin
        ai:=i;

        an:=am1*bi+am2*ai;
        bn:=bm1*bi+bm2*ai;

        if (abs(bn)>acu) then
        begin
          a:=an/bn;
          dif:=abs(a-before);
          if(dif<=acu) then
            goto label50;
          before:=a;
        end;
     {25} am2:=am1;
        bm2:=bm1;
        am1:=an;
        bm1:=bn;
     {30} while not ((am1<ten) and (bm1<ten)) do
        begin
{
  c        scaling matrix to avoid overflows.
}
          am2:=am2*tenth;
          bm2:=bm2*tenth;
          am1:=am1*tenth;
          bm1:=bm1*tenth;
        end;
     {40 continue}
      end;
   label50:
      a:=one-a;
   label60:
      if(xx<zer) then
        a:=one-a;
   label70:
      anorpr:=a;
end;

end.
