/************************************************
 * ds2.c - ANSI C English version
 * Descriptive statistics
 * Single-pass file version with array loading
 * Computes the median via array 2nd. pass
 * Joao Magalhaes 1997
 * jcm@mail.EUnet.pt
 */

#define OUTVALUES 12
#define VECTOR_SIZE 13000   /* for small model */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <float.h>
#include <ctype.h>

#include "dsfileu.c" /* file operations           */
#include "dsmed.c"  /* array (median) operations */
#include "dsmath.c" /* math operations           */
#include "dsoutu.c" /* output functions          */

int main (int argc, char ** argv)
   {
   float DataVector[VECTOR_SIZE];
		 /* compiles under the Small model */
   long double Counters[5],
	       OutValues[OUTVALUES];
   char * FileName = argv[1];

   if (argc <2)
     {
     puts("\nDS2: kindly indicate a"
	  " valid file name.\n");
     puts("\tUse: DS2 InFileName [>OutputFileName]\n");
     puts("Performs descriptive statistics of a file"
	  " of reals in "
	  "a single pass.");
     puts("Will not compute skewness and kurtosis.");
     printf("Freeware with ANSI C source. Joao Magalhaes 1997. ");
     printf("jcm@mail.EUnet.pt\n");
     printf("Test version compiled %s %s\n", __DATE__, __TIME__);
     exit(1);
     }

   while (*argv[1])
      {
      *argv[1] = toupper(*argv[1]);
      argv[1]++;
      }

   printf("FILE : %s ----------------------------",
	  FileName);
   S101Vect(Counters,
	    FileName,
	    DataVector,
	    VECTOR_SIZE
	    );
   S101Math(OutValues,
	    Counters);
   WOut(OutValues);
   SortFVect(DataVector, Counters[0]);
   PrintMedian( S101Med(DataVector, Counters[0]) );
   return 0;
   } /* main version 2 ends. */
