#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>

#include "allegro.h"
#include "lmuse.h"

/*extern lmuse.c*/
extern MAP maps[];
extern int cureditmap;
extern int unsavedmapchanges;

/* new scales need to be added here ...*/
int Twelvetone[13] = {0,1,2,3,4,5,6,7,8,9,10,11,12};
int Major[8] = {0,2,4,5,7,9,11,12};
int Penta1[6] = {0,4,7,9,10,12};
int minor[8]={0,2,3,5,7,8,11,12};
int blue1[9]={0,2,3,4,7,8,9,10,12};
int whole[7]={0,2,4,6,8,10,12};
int diminished[9]={0,1,3,4,6,7,9,10,12};

/*...here... */
SCALE scales[7]={
      {Twelvetone,12},{ Major ,7},{ Penta1 ,5},
      {minor,7},{blue1,8},{whole,6},{diminished,8}};
int numpredefinedscales=7;

/*... here ... */
char * scalenames[12]
={"twelve tone","Major","Penta 1","minor","blue 1","whole","diminshed","user's","user 2", "user 3","user 4"};
/* ... and here */
MENU scale_menu[] =
{
   { "&twelve tone",       NULL,          NULL },
   { "&Major",             NULL,          NULL },
   { "&Penta 1",           NULL,          NULL },
   { "m&inor",             NULL,          NULL },
   { "&blue 1",            NULL,          NULL },
   { "&whole",             NULL,          NULL },
   { "&diminished",        NULL,          NULL },
   { "&user's",            NULL,          NULL },
   { NULL,                 NULL,          NULL }
};

SCALE * cur_scale=&(scales[1]);
SCALE * user_defined_scale=NULL;


int do_userscaledialog();
char scalenamestring[40];
char scalefnnamestring[40];


int do_scalemenu()
{
   int menuret;


   menuret=do_menu (scale_menu,150,20);

   if(menuret>=0&&menuret<numpredefinedscales){
         cur_scale=&(scales[menuret]);
         maps[cureditmap].scale=(scales[menuret]);
         strcpy(scalenamestring,scalenames[menuret]);
   }
   else if( menuret==numpredefinedscales){
        do_userscaledialog();
        if(user_defined_scale!=NULL){
           cur_scale=user_defined_scale;
           maps[cureditmap].scale=*user_defined_scale;
           strcpy(scalenamestring,scalenames[menuret]);
        }
   }

   return D_O_K;
}
int scalemenu_proc(int msg, DIALOG*d, int c)
{
   int ret,menuret;
   ret=d_button_proc(msg,d,c);

   if(msg==MSG_CLICK){
       menuret=do_menu (scale_menu,d->x+30,d->y);

       if(menuret>=0&&menuret<numpredefinedscales){
           cur_scale=&(scales[menuret]);
           maps[cureditmap].scale=scales[menuret];
           strcpy(scalenamestring,scalenames[menuret]);
           strcpy(maps[cureditmap].scalename,scalenamestring);
       }

       else if( menuret==numpredefinedscales){
           do_userscaledialog();
           if(user_defined_scale!=NULL){
              cur_scale=user_defined_scale;
              maps[cureditmap].scale=*user_defined_scale;

              strcpy(scalenamestring,scalenames[menuret]);
              strcpy(maps[cureditmap].scalename,scalenames[menuret]);
           }
       }
       unsavedmapchanges=1;

       d->flags &= ~D_SELECTED;
   }

   return ret;
}


int ignscale(), scalesteps(), slidetoscale(),constantscale();
int (*scalefunctions[4])(int,SCALE *)={slidetoscale,scalesteps,constantscale,ignscale};
int (*scalefn)(int, SCALE*)=slidetoscale;
int (*defscalefn)(int, SCALE *)=slidetoscale;

char * scalefnnames[5]={"slide to","steps","constant","ignore"};


MENU scalefn_menu[] =
{
   { "&slide to",   NULL,  NULL },
   { "s&teps",      NULL,  NULL },
   { "&constant",   NULL,  NULL},
   { NULL,          NULL,  NULL }
};
int do_scalefnmenu()
{
   int menuret;
   menuret=do_menu (scalefn_menu,150,20);

   if(menuret>=0){
         scalefn=scalefunctions[menuret];
         maps[cureditmap].scalefn=scalefn;
         strcpy(scalefnnamestring,scalefnnames[menuret]);
   }
   return D_O_K;
}

int scalefnmenu_proc(int msg, DIALOG*d, int c)
{
   int ret,menuret;


   ret=d_button_proc(msg,d,c);
   if(msg==MSG_CLICK){
        menuret=do_menu (scalefn_menu,d->x+30,d->y);

        if(menuret>=0){
          scalefn=scalefunctions[menuret];
          maps[cureditmap].scalefn=scalefn;
          strcpy(scalefnnamestring,scalefnnames[menuret]);
          unsavedmapchanges=1;
        }
        d->flags&=~D_SELECTED;
   }
   return ret;
}

int ignscale(int pitch,SCALE *S __attribute__ ((unused)) )
{
	return (pitch&0x7f);
}

int constantscale(int pitch __attribute__ ((unused)),SCALE *S __attribute__ ((unused)) )
{
        return 0;
}

int scalesteps(int pitch,SCALE *S)
/*finds the pth member of the scale*/
{
	int oct,deg,n=S->num;
        int cnt=0;
	int *sc = S->s;
        int per=sc[n];
        while(pitch<0){
             cnt++;
             pitch+=n;
        }
	oct = (pitch)/(n);
	deg = (pitch)%(n);
	/*degm= deg/(n);
	deg = deg%(n);*/
        return ( (sc[deg]+(oct-cnt)*(per)) & 0x7f);
}

int slidetoscale(int pitch,SCALE *S)
/*returns first scale note higher or equal to given pitch*/
{
        int i=0,per,oct,origdeg;
        int cnt=0;
	int * sc = S->s;
	per     = sc[S->num];
        while (pitch<0){
              cnt++;
              pitch+=per;
        }
        oct     = pitch/per;
        origdeg = pitch%per;
	while(sc[i]<origdeg) i++;
	return((sc[i]+(oct-cnt)*per)&0x7f);

}
char scalestring[80]="";

void scale2scalestring(SCALE* scale){
        int i;
        char *c=scalestring;
        int *scalenotes;
        int numnotes;
        char buf[5];

        scalenotes=scale->s;
        numnotes=scale->num;
        *c='\0';
        for(i=0;i<numnotes;i++){
              itoa(scalenotes[i]+1,buf,10);
              strcat(scalestring,buf);
              strcat(scalestring, " ");
        }

}
SCALE * string2scale(char * str){

  int numsteps=0,i;
  int tempscale[80];
  int *scalenotes;
  int step=0;
  SCALE * newscale;
  char buf[60];
  char *tok;

  if(*str=='\0') return NULL;
  newscale= (SCALE *)malloc(sizeof(SCALE));
  if(newscale==NULL) return NULL;
  strcpy(buf,str);
  tok=strtok(buf," ,");
  if(tok!=NULL)
        step=atoi(tok);
  if (step>0){
     tempscale[numsteps]=step-1;
     numsteps++;
  }

  while (tok!=NULL){
            tok=strtok(NULL, " ,");
            if(tok!=NULL){
               step=atoi(tok);
               if (step>0){
                  tempscale[numsteps]=step-1;
                  numsteps++;
               }
            }
  }

  if (numsteps <=0) {
     if(newscale!=NULL)
          free(newscale);
     return NULL;
  }
  else{
     scalenotes=(int*)malloc(sizeof(int)*numsteps+1);
     if(scalenotes==NULL){
        if (newscale!=NULL)
            free(newscale);

        free(scalenotes);
        return NULL;
     }
     for(i=0;i<numsteps;i++)
           scalenotes[i]=tempscale[i];
     scalenotes[numsteps]=scalenotes[0]+12*(1+ (int)(tempscale[numsteps-1]/12));
     newscale->s=scalenotes;
     newscale->num=numsteps;
  }
  return newscale;
}


DIALOG userscale_dialog[]={

   {d_box_proc,      0,   0,    500,  55,   255,  0,       0,   0,      0,   0,   NULL},


   {d_text_proc,     10,  5,    0,    0,    255,  0,       0,   0,      0,   0,   "define a scale:"},
   {d_box_proc,      5,   15,   490,  18,   255,  0,       0,   0,      0,   0,   NULL},
   {d_edit_proc,     10,  20,   480,  10,   255,  2,       0 ,  0,      60,  0,   scalestring},

   { d_button_proc,  10,  36,   30,   16,   255,  0,       13,  D_EXIT, 0,   0,    "OK" },
   { NULL,           0,   0,    0,    0,    0,    0,       0,   0,      0,   0,    NULL }
};

int do_userscaledialog(){
     int ret;
     centre_dialog(userscale_dialog);
     ret=popup_dialog(userscale_dialog,2);
     user_defined_scale=string2scale(scalestring);
     maps[cureditmap].scale=*user_defined_scale;
     if(user_defined_scale !=NULL){
         scale2scalestring(user_defined_scale);
         strcpy(maps[cureditmap].scalename,scalestring);
     }
     return D_O_K;
}


