#define PROGRAMNAME "LMUSe"
#define PROGRAMVERSION "0.7b"
#define VERSIONDATE "11/23/98"

/* compile directions*/
#define SCREENDUMPS
//#define CONNECTSCREENDUMPS
#define EXITONARITHERROR
//#define STACKUNDERFLOWABORT

#define MAXRULES 100
#define MAXTRACKS 16
#define DEFSTRINGSIZE 2L*1024L*1024L

#define RND ((float)rand())/RAND_MAX
#define RANDOM(x) ((int)(RND*x))
#define DEG2RAD(deg) ((PI*deg/180.0))

#define DEF_SCREENWIDTH 640
#define DEF_SCREENHEIGHT 480
#define DRAWINGTOP 16
#define DRAWBORDERWIDE 5
#define PMBL 5
#define PMBD 21
#define BUTTONWIDTH 52
#define BUTTONHEIGHT 50

#define TWOPI 2*PI
#define DIVISION 96

#define STACKDEPTH  2*1024

/* views */
#define XY  0
#define ZY  1
#define ZX  2

/* control key for dialogs */
#define C(x)      (x - 'a' + 1)

/* scale functions*/
#define SLIDETOSCALE 0
#define SCALESTEPS 1
#define CONSTANTSCALE 2
#define IGNORESCALE 3


/* various background colors */
#define CONNECTBG 125
#define BG1 13
#define EMPTYBG 133
#define DRAWBG 15      /* drawing area */
#define PLAYBG EMPTYBG
#define TRACKBG 15    /* track box */
#define HELPBG 8   /* border for help screens */
#define PMBG 212   /* process buttons */

#define UNCHANGEDBG 0
#define MUTATEDBG 2
#define CHANGEDBG 3

#define INACTIVE 0
#define ACTIVE 1

#define INTERPRETFILEERROR 1
#define INTERPRETARITHERROR -1
#define INTERPRETARITHERRORINF -2
#define INTERPRETARITHERRORNAN -3
#define INTERPRETOK 0
#define INTERPRETABORT 2
#define INTERPRETSTACKOVERFLOW 3
#define INTERPRETSTACKUNDERFLOW 4

#define DMULTMAX 4.0
#define PSPREADMAX 4.0
#define DSPREADMAX 8.0
#define VSPREADMAX 8.0

#define NUMSTATEVARS 15
#define X_VAR 0
#define Y_VAR 1
#define Z_VAR 2
#define FX_VAR 3
#define FY_VAR 4
#define FZ_VAR 5
#define UX_VAR 6
#define UY_VAR 7
#define UZ_VAR 8
#define LX_VAR 9
#define LY_VAR 10
#define LZ_VAR 11
#define LENGTH_VAR 12
#define DRAWLENGTH_VAR 13
#define THICKNESS_VAR 14


typedef struct midi_chan_event{
     unsigned long t;
     unsigned char status;
     unsigned char data1;
     unsigned char data2;
}MIDICHANEVENT;

typedef struct midi_note_list{
     struct midi_chan_event m;
     struct midi_note_list  * next;
     struct midi_note_list  * prev;
}MIDINOTELIST;

typedef struct scale{
	int *s;
	int num;
}SCALE;


typedef struct vector{
        float x;
        float y;
        float z;
} VECTOR;

typedef struct state{
        float deltaangle;
        float x,y,z;
        VECTOR fdirection;
        VECTOR udirection;
        VECTOR ldirection;
        float length;
        float thickness;
        int clr;
        int transpose;
        float dfact;
        float vfact;

        unsigned long cumtime;
        unsigned long prevcumtime;
        int track;
        int inpoly;
        struct map * mymap;
}STATE;

/*variable types*/
#define COORDINATE 1
#define DIRECTION 2
#define LENGTH 3

typedef struct variable{
  float *v;
  int variabletype;
  float *mymin,*mymax;
}VARIABLE;

#define MAXMAPS 10
typedef struct map{
     VARIABLE *pitch;
     VARIABLE *duration;
     VARIABLE *volume;
     float pspread;
     float dspread;
     float vspread;

     float dmultiplier;

     long tempo;

     SCALE scale;

     int (*scalefn)(int, SCALE*);
     char scalename[80];
     int transpose;
     int tstack;
     int fstacks;
     unsigned int rstart;

}MAP;



int allegroexiterror(char * s);
