PAGE   60,132
TITLE  LOCK V1.3 - RECALLS PASSWORD DEVICE DRIVER CODE

;-----------------------------------------------------------------------
;  LOCK V1.3
;
;| LOCK is designed to work in conjunction with PASSWRD5.SYS.
;  Its purpose is to call a portion of code internal to the
;  device driver PASSWRD5.SYS. This will enable a user to "lock"
;  the PC until a user replies with the correct password.
;  ** CAUTION  Beware of upper case vs lower case when responding **
;
;  This code will check the interupt vector 66H for a non zero segment
;  reference before calling the password routine. PASSWRD5.SYS will
;  initialize this interrupt at boot time. since the PASSWRD5.SYS
;  device driver (like any device driver) remains resident, the user
;  is assured that he only need change PASSWRD5.SYS in order to
;  change the system password.
;
;					JOHN R. PETROCELLI
;					02/25/85
;v1.3, 19 Sep 88
; - Simplifying ANSI/non-ANSI switch.  Change ANSI to 0 for non-ANSI display.
; - Insuring compatible with PASSWRD5.ASM/.SYS
; - Code works now (no public complaints), so removing all the
;   v1.1 stuff I commented out.
; - Considered putting in a '?' help parameter processor (to give a REALLY
;   ignorant, unbriefed, or curious user an explanation about PASSWRD.SYS).
;   However, that might point a semi-ignorant threat at our PASSWRD.SYS driver
;   where he might snoop around and find out the password.
;   This whole mess is assuming a lot of ignorance on the part of users and
;   snoops .. but then I'm constantly amazed at the standard level of
;   expertise (or lack thereof) out there ..
; David Kirschbaum
;
;v1.2 Toad Hall Tweak, 7 Aug 88
; - minor tightening
; - minor editing to keep MASM 5.0 happy.
; - now using Service 4CH, Int 21H to terminate (returning errorlevels)
; - Remember -- remove the Escape sequences in the error message
;   if you don't have an ANSI driver installed.
;
;Note:  This system is fairly weak security-wise.
;If a "threat" ever gets a chance to look at the actual PASSWRD5.SYS file,
;he'll easily spot the "hardcoded" text password lying therein!
;Too much trouble to work out an inline encrypt/decrypt function tho.
;Also .. this assumes Int 66H is not being used by anything else in
;the system .. hope that's a safe assumption!

;David Kirschbaum
;Toad Hall
;kirsch@braggvax.ARPA
;
;----------------------------------------------------------------------
;

ANSI	EQU	1			;v1.3 make 0 for non-ANSI


INT_VECTORS  SEGMENT AT 0H		; POINT TO INTERUPT VECTOR TABLE
	ORG	66H*4			; INT 66H
ASK_OFF DW	?			; OFFSET OF PASSWORD RECALL
ASK_SEG DW	?			; SEGMENT OF PASSWORD RECALL
INT_VECTORS ENDS

CODE_SEG  SEGMENT PARA 'CODE'

	ASSUME  CS:CODE_SEG, DS:CODE_SEG, ES:INT_VECTORS, SS:NOTHING

	ORG	100H			; NEEDED FOR A .COM PROGRAM

BEGIN:
	xor	ax,ax	;TH		;  SET ES TO REFERENCE
	MOV	ES,AX			;  INT_VECTORS

	ASSUME  DS:CODE_SEG, ES:INT_VECTORS	;TH a reminder

	mov	bx,offset Ask_Off	;TH Set ES:BX to point to
					;  location in the int vector
					;  table containing seg & offset
					;  of password recall routine

	MOV	AX,ES:[BX+2]		; load AX with segment of call
	or	ax,ax	;TH		; and if the segment is 0 ..
	JZ	Error_Exit		; .. then exit - not initialized

	CALL	DWORD PTR ES:[BX]	; call Pword if installed
					; ES:BX will point to the address
					; of the routine to be called

	mov	ax,4C00H		;TH terminate process,ERRORLEVEL 0
	int	21H

Error_Exit:				; SEGMENT AND/OR OFFSET
					; WERE 0000 SO WE DON'T CALL
					; JUST PRINT ERROR MESSAGE

	MOV	DX,OFFSET no_Init	; DS:DX POINTS TO ERROR MSG
	MOV	AX,9			; display msg
	INT	21H

	mov	ax,4C01H		;TH terminate process, ERRORLEVEL 1
	int	21H

	IF	ANSI			;v1.3

no_Init DB 1BH,'[5m'			; MAKE "PASSWORD" BLINK
	DB ' PASSWORD '
	DB 1BH,'[0m'			; ATTRIBUTES TO NORMAL
	DB ' Device Driver Does Not'
	DB ' Appear To Be Installed'
	DB 07H,0DH,0AH,'$'		; BEEP+CR+LF

	ELSE				;v1.3

no_Init DB ' PASSWORD Device Driver Does Not Appear To Be Installed'
	DB 07H,0DH,0AH,'$'		; BEEP+CR+LF

	ENDIF				;v1.3

CODE_SEG	ENDS
	END	BEGIN
