title

code    segment
        assume          cs:code,ds:code

        org     100h

begin:
        mov     ax,500h         ;Set the active page to 0.
        int     10h

        mov     ax,1200h        ;Request ega information.
        mov     bl,10h
        xor     cx,cx           ;CX will contain info if ega.
        int     10h

        or      cx,cx           ;cx will not be 0 if ega is present.
        jz      done            ;ega not present.

        mov     bl,30h          ;Select scan lines for alphanumeric modes.
        mov     ax,1202h        ;Set 400 scan lines.
        int     10h

        mov     ax,7            ;Assume monochrome.
        or      bh,bh           ;Monochrome color bh == 0 if color.
        jnz     label_1
        mov     al,3            ;80 X 25 color text.

label_1:
        int     10h             ;Set the mode.

;Next find the attribute to use for clearing the screen.
        mov     dl,' '          ;Write out a byte
        mov     ah,2            ;using DOS
        int     21h

        mov     al,8            ;Now backspace
        mov     ah,14           ;Using BIOS call
        xor     bh,bh           ;Page number 0.
        int     10h

        mov     ah,8            ;Read character & attribute
        int     10h             ;using BIOS call (bh = pg)
        mov     bh,ah           ;And save attribute to clear screen.

        xor     cx,cx           ;Top row and column == 0, 0
        mov     ax,600h         ;Clear screen.
        mov     dx,(49 shl 8) + 79
        int     10h             ;Clear from top to bottom.

done:
        mov     ax,4c00h
        int     21h             ;Program terminate.

code    ends
        end        begin

