/* PALETTE - DISPLAYS THE COLOR SET AVAILABLE FOR TEXT MODE TEXTS */
//ver 1.1

// To be able to recompile it, read COMPILE.TXT

#include <crt.h>

#define CGA  1
#define MCGA 2
#define EGA  3
#define VGA  9

#define VIDEOADAPTER VGA
  //If your video adapter isn't VGA, redefine VIDEO_ADAPTER with one of
  //above adapter types.

void main ()
 {
	int c0,c1; //counters
	int a0,a1; //auxiliar variable
	char s[5]; //A string that stores the text that is written with each color
	char *s2;

  //Gets current video status (it is, number of rows, columns, etc)
	crt_init(VIDEOADAPTER); //and also updates crtwin_dta coordinates.

	fillscr (' ',0x07); //Clears the screen

  //verifies if text window is more than 64 character cells wide
	if (vmode_x>63)
	 {
		a0=4;
		s2=s;
		s[0]=' ';
		s[3]=' ';
		s[4]=0;
	 }
	 else
	 {
		a0=2;
		s2=s+1;
		s[3]=0;
	 }

  //Displays title
	printsj ("* * * CURRENT TEXT COLORS * * *",1,0x1f);
	printsj ("COLOR INDEX (hexadecimal):",3,0x0f);

  //Displays each color with it's value in hexadecimal notation
	a1=(vmode_x-a0*16)/2;


	for (c0=0;c0<16;c0++,a1+=a0) //c0==background color
	 {
		//Converts background color to s[1]
		if (c0<10)
			s[1]=c0+0x30;
		 else
			s[1]=c0+0x37;

		for (c1=0;c1<16;c1++) //c1==foreground color
		 {
			//Converts foreground color to s[2]
			if (c1<10)
				s[2]=c1+0x30;
			else
				s[2]=c1+0x37;
			prints (s2,a1,c1+5,c0*16u+(unsigned)c1); //outputs s
		 }
	 }

  //repositions the cursor at the begin of the immediate line that follows the
  //lowermost written line.
	if (vmode_y>21)
		a0=21;
	 else
		a0=vmode_y-1;
	crt_gotoxy (0,a0);
 }

// By Marcio Afonso Arimura Fialho
// http://pessoal.iconet.com.br/jlfialho
// e-mail: jlfialho@iconet.com.br or (alternate) jlfialho@yahoo.com