/* MICO - SIMPLE PROGRAM THAT FILLS THE SCREEN WITH A CHARACTER   */
/*        AND A COLOR                                             */

// To be able to recompile it, read COMPILE.TXT

//Usage: MICO <input character> <input color>
// Both character and color must be entered in hexadecimal notation.

#include <crt.h>
#include <ctype.h>
#include <stdio.h>

#define CGA  1
#define MCGA 2
#define EGA  3
#define VGA  9

#define VIDEO_ADAPTER VGA
	//replace VIDEO_ADAPTER value if your video adapter is not VGA/SVGA+

#include "asctoi.c"
  //asctoi defined in ASCTOI.CPP converts a string (in radix notation) to an integer

//pause pauses the screen

#define pause()\
asm mov ah,8;\
asm int 0x21

void main (int n_ent, char *ent[])
 {
	int color,chr;
	int dopause=0; //if !=0 pauses at the end.
	if (n_ent<3) //displays help if missing input parameters
	 {
		fputs ("\
MICO ver 1.1 - Utility that fills the screen with a given character and a\n\
color. - Freeware - May be distributed freely.\n\n\
\tUsage: MICO <char> <color> [/p] \n\n\
\t<char> is the character ASCII code (must be in hexadecimal notation)\n\
\t<color> is the fill color/attribute (must be in hexadecimal notation)\n\
\t[/p] Pauses until user hits any key\n\n\
 Example: \40 MICO B0 13 /P \n\n\
by Mrcio Afonso Arimura Fialho.",stdout);
		return;
	 }

  //converts input parameters to chr and color
	if(asctoi(&chr,ent[1],16) || asctoi(&color,ent[2],16))
	 {
		fputs ("Incorrect input.",stdout);
		goto jmp_error;
	 }

  //verifies if /p (pause) option was selected
	if (n_ent>3)
	 {
		if (*ent[3]=='/' && toupper(*(ent[3]+1))=='P')
			dopause++;
		 else
		 {
			fputs ("Unkown option ",stdout);
			fputs (ent[3],stdout);
			fputc ('.',stdout);
			goto jmp_error;
		 }
	 }

  //verifies if input arguments are inside acceptable range
  if (chr&0xFF00 || color&0xFF00)
	{
		fputs ("Input values are out of range.",stdout);
	  jmp_error:
		fputs ("\nType MICO with no parameters to get help.",stdout);
		return;
	}

  //detects number of rows and columns in current video mode
	crt_detect(VIDEO_ADAPTER);

  //fills the screen with character given by chr and color color
	fillscr(chr,color);

  //pauses
	if (dopause)
		pause();
 }

// By Marcio Afonso Arimura Fialho
// http://pessoal.iconet.com.br/jlfialho
// e-mail: jlfialho@iconet.com.br or (alternate) jlfialho@yahoo.com
