'                             ---FUNCTIONS---

DECLARE FUNCTION AColor$ (Fore%, Back%)
'       Makes an optimized ansi color string
'       Fore% = Foreground color to use
'       Back% = Background color to use
'
'       EXAMPLE:
'               Send AColor$(7,1)+"White on blue"

DECLARE FUNCTION CtrlCK% ()
'       Checks if Control C/K have been checked.  Also enables Control C/K
'       checking.  Returns -1 if true, 0 if not true.
'
'       EXAMPLE:
'               IF CtrlCK% THEN
'                       FlushOut
'                       SendCr "Aborted."
'               END IF

DECLARE FUNCTION Exist% (FileName$)
'       Returns a non-zero value if the file exists.
'
'       EXAMPLE:
'               IF Exist%("TEST.TTT") THEN Send "File FOUND"

DECLARE FUNCTION GetAnsi% ()
'       Gets the current ansi setting.  Returns -1 if true, 0 if not true.
'
'       EXAMPLE:
'               AnsiMode%=GetAnsi%
'               IF AnsiMode% THEN
'                       SendCr "Ansi is active"
'               ELSE
'                       SendCr "Ansi is not active"
'               END IF

DECLARE FUNCTION GetBaudRate& ()
'       Gets the current baud rate of the user (Door Info).  0 if local.
'
'       EXAMPLE:
'               Send "You are running at" + STR$(GetBaudRate&)

DECLARE FUNCTION GetBBSName$ ()
'       Gets the BBS name from the door file.
'
'       EXAMPLE:
'               SendCr "Your sysop is: " + GetSysopName$

DECLARE FUNCTION GetCarrier% ()
'       Gets the current carrier state.  Non-zero if there is a carrier.
'       The user's carrier is automatically managed.  This is not really
'       needed.
'
'       EXAMPLE:
'               IF GetCarrier% THEN Send "YOU ARE STILL CONNECTED"

DECLARE FUNCTION GetPort% ()
'       Gets the current serial port setting.  -1 if local
'
'       EXAMPLE:
'               Send "You are on com port" + STR$(GetPort%)

DECLARE FUNCTION GetSecLevel& ()
'       Gets the user's security level.
'
'       EXAMPLE:
'               Send "Your security Level is" + STR$(GetSecLevel&)

DECLARE FUNCTION GetSnoopState% ()
'       Gets the status of the snoop setting on the SysOp's side.
'       Returns -1 if true, 0 if not.
'
'       EXAMPLE:
'               IF GetSnoopState% THEN
'                       Send "Snoop is ON"
'               ELSE
'                       Send "Snoop is OFF"
'               ENDIF

DECLARE FUNCTION GetSysopName$ ()
'       Gets the sysop's name,  in all uppercase.
'
'       EXAMPLE:
'               Send "Your sysop is: " + GetSysopname$

DECLARE FUNCTION GetTimeLeft% ()
'       Gets the amount of time the user has left in minutes.
'
'       EXAMPLE:
'               Send "You have" + STR$(GetTimeLeft%)+" minutes left."

DECLARE FUNCTION GetUserLocation$ ()
'       Gets the user's location (DOOR INFO) in all uppercase
'
'       EXAMPLE:
'               Send "Your location is: " + GetUserLocation$

DECLARE FUNCTION GetUserName$ ()
'       Gets the user's name (DOOR INFO) in all uppercase
'
'       EXAMPLE:
'               Send "Your name is: " + GetUserName$

'                          ---END OF FUNCTIONS---
'                            ---SUBROUTINES---

DECLARE SUB Center (St$)
'       Centers the specified text and stays on the same line.
'
'       EXAMPLE:
'               Center "Testing the centering routine"

DECLARE SUB CenterCr (St$)
'       Centers the specified text and creates a new line.
'
'       EXAMPLE:
'               CenterCr "Testing the centering routine"

DECLARE SUB Chat ()
'       Starts a chatmode with the user.  Restores the colors to normal
'       afterwards.
'
'       EXAMPLE:
'               SendCr "Forced CHAT:"
'               Chat


DECLARE SUB ClearScreen ()
'       Clears the screen
'
'       EXAMPLE:
'               ClearScreen

DECLARE SUB ComParms (BaudRate&, Flag$)
'       Sets the communications parameters.  These are already set upon
'       initialization.  There should be no need to play with them.
'
'       BaudRate& can be:  300, 600, 1200, 2400, 4800, 9600, 19200, 38400
'       Flag$ takes the form of: "8N1" where the 8 can be replaced by:
'                                       5, 6, 7, 8   (Data bits)
'                                and the N can be replaced by:
'                                       N, O, E      (Parity)
'                                and the 1 can be replaced by:
'                                       1, 2         (Stop bits)
'
'       EXAMPLE:
'               ComParms 2400, "8N1"

DECLARE SUB CtrlCKOn ()
'       Turns on Control-C/K checking.
'
'       EXAMPLE:
'               CtrlCKOn

DECLARE SUB CtrlCKOff ()
'       Turns off Control-C/K checking.
'
'       EXAMPLE:
'               CtrlCKOff

DECLARE SUB DeInitialize ()
'       Turns off the status bar and removes it from the screen.  Disables
'       the door driver and turns off the door driver's internal error
'       checking.  Also causes Send, SendCr, and all other routines to
'       malfunction.  DO NOT DO ANY OTHER DOORDRIVER CALLS AFTER
'       DEINITIALIZING!  DOES NOT TERMINATE THE PROGRAM.
'
'       EXAMPLE:
'               DeInitialize
'               Print "Cleaning up after door"
'               END

DECLARE SUB DetectAnsi (Ansi%)
'       Detects Ansi (Remote user)
'       Returns -1 or 0 into Ansi% (or any other variable of your choice)
'
'       EXAMPLE:
'               DetectAnsi Ansi%                    
'               SetAnsi Ansi%

DECLARE SUB FlushIn ()
'       Flushes the inbound modem buffer.  Wipes all user keystrokes.
'
'       EXAMPLE:
'               FlushIn
'               Send "What now sire? "
'               GetChar ToDoThis$
'               SendCr ToDoThis$

DECLARE SUB FlushOut ()
'       Flushes the outbound modem buffer.  Usefull for stopping screens
'       when Control-C/K have been pressed.
'
'       EXAMPLE:
'               SendCr "Press Control-C/K to stop this mess"
'               CtrlCKOn
'               DO
'                       SendCr "Testing 1234567890..."
'                       I$ = Inkey$
'               LOOP UNTIL I$ = CHR$(3) OR I$ = CHR$(11) OR CtrlCK%
'               SendCr "Aborted."

DECLARE SUB GetChar (Ch$)
'       Gets a character from the modem into Ch$.  (Ch$ can be any
'       variable)
'
'       EXAMPLE:
'               SendCr "Yo there dude!  Press any key please!"
'               GetChar Test$
'               SendCr "Thanks!"

DECLARE SUB GetColor (Fore%, Back%)
'       Gets the current foreground and background colors.
'   
'       EXAMPLE:
'               GetColor ForeGround%, BackGround%
'               SendCr "The foreground color is: " + STR$(ForeGround%)
'               SendCr "The background color is: " + STR$(BackGround%)

DECLARE SUB GetCurPos (X%, Y%)
'       Gets the cursor position.
'       X% = The Current Row
'       Y% = The Current Column
'
'       EXAMPLE:
'               GetCurPos X%, Y%
'               SendCr "The row is: " + STR$(X%)
'               SendCr "The column is: " + STR$(Y%)
        
DECLARE SUB GetString (St$, Max%, Mode%)
'       Gets a string from the modem/console.
'       St$ = The returned string.
'       Max% = The max width/value.
'       Mode% = Input mode:
'               0  :-   Normal Input, exactly as entered.
'                       Max% = Maximum length in characters.
'               1  :-   UserName Input, Every first character of a word is
'                       converted to uppercase.  Uppercase characters after
'                       the first letter of each word are accepted.
'                       Max% = Maximum length in characters.
'               2  :-   Numeric input.  Allows from 0 to the number specified.
'                       Allows blank strings for 0.  Returned value is a
'                       string.
'                       Max% = Maximum value (Integer value; 0 - 32767)
'               3  :-   Password input.  Outputs dots (.) instead of entered
'                       characters.  Case insensitive.
'               4  :-   Telephone number.  Allows all numbers, brackets ()
'                       and the dash.
'
'       EXAMPLES:
'               GetString Test$, 20, 0  'Gets a string of 20 characters long
'                                       'into Test$ with no restrictions.
'               GetString Test$, 20, 1  'Gets a string of 20 characters long
'                                       'into Test$, with username style
'                                       'input.
'               GetString Test$, 128, 2 'Gets a number into Test$.  Max 128
'               GetString Test$, 20, 3  'Gets a password of 20 chars max.
'               GetString Test$, 14, 4  'Gets a telephone number of 14 chars
'                                       'maximum.

DECLARE SUB Hangup ()
'       Hangs up the user.
'
'       EXAMPLE:
'               Hangup

DECLARE SUB Initialize (DOORFile$, ProgName$)
'       Initializes the door driver routines.
'       DOORFile$ = The path and filename of the DORINFOx.DEF file
'       ProgName$ = The name of the door.  Only for registered versions.
'
'       EXAMPLES:
'               DoorFile$ = "\BBS\DORINFO1.DEF"
'               Intialize DoorFile$,"Test Door"
'

DECLARE SUB LineFeed (Lines%)
'       Sends (Lines%) CR/FL pairs.
'
'       EXAMPLE:
'               LineFeed 20

DECLARE SUB OfficePhone (Duration!)
'       Makes a sound similar to an office phone until any key is pressed
'       or the number of seconds specified in Duration! has elapsed!
'
'       EXAMPLE:
'               OfficePhone 30

DECLARE SUB ReInitPort ()
'       ReInitializes the com port.  Not needed, but here anyways.
'
'       EXAMPLE:
'               ReInitPort

DECLARE SUB ResetIdle ()
'       Resets the idle time counter to zero.
'       Is called upon every Send, SendCr, GetChar (after keypress),
'       GetString, SendFile, SetColor, Center, CenterCr.
'
'       EXAMPLE:
'               ResetIdle

DECLARE SUB Send (St$)
'       Sends the specified string to the modem/screen if snoop is on.
'       St$ = The string to send.
'
'       EXAMPLE:
'               Send "Testing 123"

DECLARE SUB SendCr (St$)
'       Sends the specified string to the modem/screen and appends a CR/LF
'       pair at the end of it.
'       St$ = The string to send.
'
'       EXAMPLE:
'               SendCr "This is on the line above the line below."
'               SendCr "This is on the line below the libe above."

DECLARE SUB SendFile (FileName$, More%, Ck%, Er%)
'       Sends a file to the modem/screen.
'       FileName$ is the full path/filename of a file to display.  Defaults
'        to the current directory.
'        If the extension is supplied, your program must determine itself if
'        the user supports ANSI or not.  If you do not supply an extension,
'        the door driver will attempt to locate a .ANS file if the user has
'        ANSI active, if not, it will resort to ASCII (.ASC) and if that
'        fails, it will then assume "File not found".
'       More% is the toggle for the More prompt.  A non-zero value will
'        activate it.  A user can use Ctrl-C/K as a "NO" at the More prompt.
'       Ck% is the toggle for Control-C/K aborting.  If this value is
'        non-zero, then Ctrl-K/C from either side will stop the file from
'        being displayed.  If you want the user to be forced to see the
'        whole file, then I reccomend making your own sendfile routine and
'        making it ask for any key to continue once per x lines.
'       Er% is set to a non-zero value if the file isn't found.
'       This routine cannot handle disk IO errors, so the SumDoor error
'       handler is called upon to do the dirty work.  This means the game
'       will terminate.
'
'       EXAMPLE:
'               SendFile "TEST",0,1,Er%
'               IF Er% THEN SendCr "Hey, where'd my file go?"

DECLARE SUB SetAnsi (AnsiState%)
'       Sets the user's ANSI state.  Not reccomended unless the user changes
'       it themselves.
'
'       EXAMPLE:
'               Send "You have ansi "
'               AnsiMode%=GetAnsi%
'               IF AnsiMode% THEN
'                       SendCr "enabled"
'               ELSE
'                       SendCr "disabled"
'               ENDIF

DECLARE SUB SetColor (Fore%, Back%)
'       Sets the color.
'       Fore% = Foreground color
'
'        Color systems------------------------- Monochrome systems-------
'
'        0  - Black        1  - Blue            0 -  Black
'        2  - Green        3  - Cyan            1 -  Underline
'        4  - Red          5  - Magenta         2 to 7 -  Normal
'        6  - Brown        7  - White           8 -  Black
'        8  - Gray         9  - Light Blue      9 -  Intense Underline
'        10 - Light Green  11 - Light Cyan      10 to 15 -  Intense
'        12 - Light Red    13 - Light Magenta
'        14 - Yellow       15 - Light White
'
'       Back% = Background color
'
'       Color systems-------------------------- Monochrome systems-------
'
'        0  - Black        1  - Blue            0 to 6 -  Black
'        2  - Green        3  - Cyan            7 -  White (Only with 0 as
'        4  - Red          5  - Magenta              foreground)
'        6  - Brown        7  - White
'
'       EXAMPLE:
'               SetColor 7,1            'White on blue

DECLARE SUB SetCurPos (X%, Y%)
'       Sets the cursor position (ONLY WHEN ANSI IS ACTIVE)
'       X% = Row%
'       Y% = Col%
'       WARNING: No internal checking for the Row% is done.  It must not
'       exceed 24 if you want to maintain compatibility with old ansi
'       terminals.
'
'       EXAMPLE:
'               SetCurPos 9, 1

DECLARE SUB SetIdle (IdleTim%)
'       Sets the idle timeout value (defaults to 240 seconds on startup)
'       IdleTim% = number of seconds before idle timeout.  Gives idle
'        warning at 30 seconds left.
'
'       EXAMPLE:
'               SetIdle 250

DECLARE SUB SetSnoopState (SnSt%)
'       Sets the Snoop state.
'       SnSt% - The snoop state flag.  Any non-zero value turns on snoop.
'       Zero turns it off.
'
'       EXAMPLE:
'               SetSnoopState -1

DECLARE SUB StatBarOff ()
'       Turns off status bar updates (and disables carrier/timelimit
'       checking)
'       GOOD FOR DISK I/O WHEN REWRITING DATAFILES!
'
'       EXAMPLE:
'               SendCr "Updating Datafile"
'               StatBatOff
'               .
'               .
'               .
'               StatBarOn

DECLARE SUB StatBarOn ()
'       Turns on the status bar.  (and enables carrier/timelimit checking)
'
'       EXAMPLE:
'               [See Previous Command]

DECLARE SUB StatusBar ()
'       Forces an update of the status bar.
'
'       EXAMPLE:
'               StatusBar

DECLARE SUB ToggleSnoop ()
'       Toggles the snoop setting.
'
'       EXAMPLE:
'               ToggleSnoop


