TITLE  'Fill Window Dither'
NAME   FILLWIND
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      25 Jan 91                                              |
; function:      fill the window with 4-byte dither pattern             |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call FILLWIND(0,density,FG,BG)                         |
;    stack:     +06 = background color (0-15)                           |
;                08 = foreground color (0-15)                           |
;                10 = density 0=FG 1=FGB 2=MID 3=BGF 4=BG               |
;                12 = mode (0,8,16,24)                                  |
;  returns:      none                                                   |
;------------------------------------------------------------------------

PARMS           = 4
ARGaddtype      EQU [bp+12]
ARGdensity      EQU [bp+10]     ;stored in PixelValue
ARGfg           EQU [bp+08]
ARGbg           EQU [bp+06]
ByteOffsetShift EQU 3

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

EXTRN PixelAddr:far

FillWinD_TEXT   SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:FillWinD_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  FillWinD
FillWinD        PROC    FAR

                push    bp
                mov     bp,sp
                push    ds
                push    si
                push    di

                cld
                mov     bx,ARGaddtype
                mov     ax,[bx]
                mov     RMWbits,ax
                mov     bx,ARGdensity
                mov     ax,[bx]
                mov     PixelValue,ax
                mov     bx,ARGfg
                mov     ax,[bx]
                mov     fg,ax
                mov     bx,ARGbg
                mov     ax,[bx]
                mov     bg,ax

                mov     ax,PixelValue
                cmp     ax,4
                ja      FWx2            ;valid range is 0 to 4
                mov     si,offset FillMask
                add     si,ax
                mov     al,cs:[si]
                sub     ah,ah
                mov     PMask,ax

                mov     cx,Y1clip2      ;bottom window Y
                sub     cx,Y0clip2      ;- top Y
                cmp     cx,1
                jg      FW00            ;must be a valid window
FWx2:           jmp     FWDxit2         ;else gone

FillMask        db 00h,88h,99h,0EEh,0FFh

FW00:           inc     cx              ;lines to do
                mov     bx,Y0clip2      ;first Y line

                ;set up Graphics Controller Initial

                mov     dx,03CEh        ;dx = Graphics Controller
                mov     ah,0            ;color (doesn't matter for now)
                xor     al,al           ;reg number
                out     dx,ax           ;update this register

                mov     ax,0F01h        ;ah = 0F (bit plane mask for enable\..
                out     dx,ax           ;al = reg number

                mov     ah,byte ptr RMWbits     ;bits 3 & 4 of ah = function
                mov     al,3            ;al = reg number
                out     dx,ax

FW0P:           mov     ax,X0clip2
                mov     x0,ax
                mov     ax,X1clip2
                mov     x1,ax
                mov     y0,bx
                mov     y1,bx
                push    bx
                push    cx

                push    ds
                mov     ax,y0
                mov     bx,x0
                mov     cx,bpl
                call    PixelAddr

                mov     di,bx           ;es:di -> buffer
                mov     dh,ah           ;dh = unshifted bit mask for left byte
                not     dh
                shl     dh,cl           ;dh = reverse bit mask for first byte
                not     dh              ;dh = bit mask for first byte
                mov     cx,x1
                and     cl,7
                xor     cl,7            ;cl = number of bits to shift left
                mov     dl,0FFh         ;dl = unshifted bit mask for right byte
                shl     dl,cl           ;dl = bit mask for last byte

                ;determine byte offset of first and last pixel in the line

                mov     ax,x1           ;ax = x1
                mov     bx,x0           ;bx = x0

                mov     cl,ByteOffsetShift      ;number of bits to shift left
                                                ;convert pixels to bytes
                shr     ax,cl           ;ax = byte offset of x1
                shr     bx,cl           ;bx = byte offset of x0
                mov     cx,ax
                sub     cx,bx           ;cx = # bytes per line - 1

                mov     bx,dx           ;bh = bit mask for first byte
                                        ;bl = bit mask for last byte
                mov     dx,03CEh        ;dx = graphics controller port

                ;make video buffer addressable through ds:di

                push    es
                pop     ds
                ASSUME ds:nothing
                mov     si,di           ;ds:si = video buffer

                ;set pixels in left byte of the line

                or      bh,bh
                js      L43             ;jump if byte-aligned

                or      cx,cx
                jnz     L42             ;jump if more than one byte in the line

                and     bl,bh           ;bl = bit mask for the line
                jmp     short L44

L42:            mov     ah,byte ptr fg  ;color FG
                xor     al,al           ;reg number
                out     dx,ax
                mov     al,8            ;al=bit mask reg index
                mov     ah,bh           ;bh=bit mask for first byte (or frac)
                and     ah,byte ptr PMask ;just those in PMask
                out     dx,ax           ;update the graphics controller
                movsb
                dec     si              ;again, BG
                dec     di
                mov     ah,byte ptr bg
                xor     al,al
                out     dx,ax           ;set color of BG
                mov     ah,bh           ;first byte's mask
                mov     al,byte ptr PMask
                not     al
                and     ah,al           ;do any needed BG bits
                mov     al,8
                out     dx,ax
                movsb
                dec     cx

                ;use a fast 8086 instruction to draw remainder of the line

L43:            mov     ah,byte ptr fg  ;color
                xor     al,al           ;reg number
                out     dx,ax           ;update this register

                push    cx
                push    si
                mov     ah,byte ptr PMask  ;FG density mask
                mov     al,8            ;al = bit mask reg number
                out     dx,ax           ;update bit mask register
                rep     movsb
                pop     si
                mov     di,si
                pop     cx              ;now do it again for the BG

                mov     ah,byte ptr bg  ;color
                xor     al,al           ;reg number
                out     dx,ax           ;update this register
                mov     ah,byte ptr PMask
                not     ah              ;do the other (off) bits
                mov     al,8            ;al = bit mask reg number
                out     dx,ax           ;update bit mask register
                rep     movsb

                ;set pixels in right byte of the line

L44:            mov     ah,byte ptr fg  ;color FG
                xor     al,al           ;reg number
                out     dx,ax
                mov     al,8            ;al=bit mask reg index
                mov     ah,bl           ;bl=bit mask for last byte (or frac)
                and     ah,byte ptr PMask ;just those in PMask
                out     dx,ax           ;update the graphics controller
                movsb
                dec     si              ;again, BG
                dec     di
                mov     ah,byte ptr bg
                xor     al,al
                out     dx,ax           ;set color of BG
                mov     ah,bl           ;last byte's mask
                mov     al,byte ptr PMask
                not     al              ;do the BG bits
                and     ah,al
                mov     al,8
                out     dx,ax
                movsb
                pop     ds
                ASSUME ds:dgroup

Lexit:          pop     cx
                pop     bx
                inc     bx              ;next Y line
                dec     cx              ;any lines left?
                jz      FWDxit          ;no
                mov     ax,PMask
                ror     al,1
                ror     al,1
                mov     PMask,ax
                jmp     FW0P

                ;restore default graphics controller state and return to caller

FWDxit:         mov     dx,03CEh        ;dx = Graphics Controller
                xor     ax,ax
                out     dx,ax           ;restore set\reset register
                inc     ax
                out     dx,ax           ;restore enable set\reset reg
                mov     al,3
                out     dx,ax           ;data rotate\function select reg
                mov     ax,0FF08h
                out     dx,ax           ;restore bit mask reg

FWDxit2:        pop     di
                pop     si
                pop     ds
                pop     bp
                RET     PARMS*2

FillWinD        ENDP
FillWinD_TEXT   ENDS
                END


