TITLE  'Blank EGA/VGA screen'
NAME   BLANKSCN
PAGE   55,132
;-----------------------------------------------------------------------|
;    ScanSoft          (C)1990 Cornel H Huth     ALL RIGHTS RESERVED    |
;-----------------------------------------------------------------------|
;     date:      04 Aug 90                                              |
; function:      blank EGA/VGA screen                                   |
;   caller:      FAR call (QuickBASIC convention)                       |
;                call BLANKSCN(onoff)                                   |
;    stack:     +06 = onoff (0=on else off)                             |
;  returns:      none                                                   |
;-----------------------------------------------------------------------|

PARMS           = 1
ARGonoff        EQU [bp+06]

include EXTRNDAT.INC

dgroup          group _BSS,_DATA

BlankScn_TEXT   SEGMENT WORD PUBLIC 'CODE'
                ASSUME cs:BlankScn_TEXT,ds:dgroup,ss:dgroup

                PUBLIC  BlankScn     ;blank screen on/off
BlankScn        PROC    FAR          ;POWER GRAPHICS PROGRAMMING p.190

                push    bp
                mov     bp,sp

                mov     ax,040h
                mov     es,ax
                mov     dx,es:[063h]
                add     dl,6
                in      al,dx
                mov     dx,03C0h        ;AC

                mov     bx,ARGonoff
                mov     ax,[bx]
                cmp     ax,0
                jne     L1

                mov     al,20h          ;on
                jmp     short L2

L1:             sub     al,al           ;off
L2:             out     dx,al

                pop     bp
                RET     PARMS*2

BlankScn        ENDP

BlankScn_TEXT   ENDS
                END

