'***********************************************************************
'                             STRIPIT.BAS                              *
'     STRIPIT deletes any extraneous <LF> characters inserted into the *
' page heading of a MASM listing (LST) file by the bug in MASM 5.10.   *
' (The erroneous LST files occur only on dates in which both the month *
' and the day are given by single digits.)  The original file will be  *
' replaced by the "stripped" file.                                     *
'                   Written by M. L. Lesser, 2/14/91                   *
'            Compiled with Microsoft BC v 7.1, switch "/O"             *
'   Linked to stub files NOFLTIN, NOCOM, and NOLPT, switches "E/NOE"   *
'***********************************************************************
    DEFSTR F, T: DEFINT I, L
    LET FILE.OUT = COMMAND$             '<filespec> from command line
    IF LEN(FILE.OUT) = 0 THEN
        PRINT: PRINT "No input <filespec> on command line."
        PRINT "     Usage:  Call with STRIPIT <filespec>"
        PRINT "             where <filespec> is a MASM .LST file."
        END
    END IF
' Force FILE.OUT to have .LST extension:
    LET I = INSTR(FILE.OUT,".")
    IF I <> 0 THEN LET FILE.OUT = LEFT$(FILE.OUT,I)
    LET FILE.OUT = FILE.OUT + ".LST"
    COLOR 2,0                                      'Dealer's choice
    PRINT "Stripping extraneous <LF>s from "; FILE.OUT
    PRINT TAB(5) "Renaming "; FILE.OUT; " to $$$.$$$"
    NAME FILE.OUT AS "$$$.$$$"
    PRINT TAB(5) "Filtering $$$.$$$ to produce new "; FILE.OUT
    OPEN "$$$.$$$" FOR INPUT AS #1 LEN=5120       'Use 5KB buffer
    OPEN FILE.OUT FOR OUTPUT AS #2 LEN=5120
    WHILE NOT EOF(1)
        LINE INPUT #1, TEXT
        IF LEN(TEXT) <> 0 AND ASC(TEXT) = 12 THEN    'Header-line check
' Note:  To prevent an "Illegal function call" runtime error if compiled
'      with BC version 4.5, comment out the statement above this note;
'      use the three commented-out (nested IF block) statements below
'        IF LEN(TEXT) <> 0 THEN
'          IF ASC(TEXT) = 12 THEN
            LET I = INSTR(TEXT,CHR$(10))        '  (marked by <FF>)
            IF I <> 0 THEN                      '  for extraneous <LF>
                LET TEXT = LEFT$(TEXT,I-1) + MID$(TEXT,I+1)
                LET LINE.NO = LINE.NO + 1
            END IF
 '         END IF    
        END IF
        LET LINE.NO = LINE.NO + 1
        LOCATE ,1                               'Display filter progress
        PRINT TAB(10) "Filtering line" LINE.NO; ' by overprinting
        PRINT #2, TEXT
     WEND
     PRINT
     CLOSE
     PRINT TAB(5) "Deleting $$$.$$$"
     KILL "$$$.$$$"
     PRINT "STRIPIT ran to completion."
     END
