// datetime.cxx
//
// example of using classes in C++ for the OS/2 date and time interface.
//
// (c) Copyright 1988 Aspen Scientific
// All Rights Reserved.

#include	<stdio.h>
#include	<os2.h>
#include	"datetime.hxx"

static char *months[] = {
	"Jan", "Feb", "Mar",
	"Apr", "May", "Jun",
	"Jul", "Aug", "Sep",
	"Oct", "Nov", "Dec"
};

static char *days[] = {
	"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
};

// the following are the class object routines

// the constructor of a DateAndTime object
DateAndTime::DateAndTime(int dt, int tm)
{
	// allocate memory for the date and time
	dtBuf = new DATETIME;

	// allocate memory for the show buffers
	showBuf      = new char[ showSize=26 ];

	showDateOnly = (dt ? new char[ dateSize=17 ] : (dateSize=0, (char *)0));

	showTimeOnly = (tm ? new char[ timeSize=10 ] : (timeSize=0, (char *)0));

	// it is a comfort to know that all objects of type
	// DateAndTime will reuse error, month and day data, since
	// the two class members are declared as static.

	// error message
	errorMsg = "Error\n";

	// set up month and day names
	monthName = months;
	dayName   = days;

	// initialize with the current date and time.
	// perform last, so that the result is accurate.
	Update();
}

// the destructor of a DateAndTime object
DateAndTime::~DateAndTime()
{
	// give memory back to free storage
	delete dtBuf;
	delete showBuf;
	if (dateSize)
		delete showDateOnly;
	if (timeSize)
		delete showTimeOnly;
}

// show the DateAndTime; format a string and return a pointer to it.
// format is the same as that found in the std-C library routine ctime().
char *DateAndTime::Show()
{
	sprintf( showBuf, "%s %s %02d %02d:%02d:%02d %4d\n",
		dayName[ dtBuf->weekday ],
		monthName[ dtBuf->month - 1 ],
		dtBuf->day,
		dtBuf->hours,
		dtBuf->minutes,
		dtBuf->seconds,
		dtBuf->year );

	return ( showBuf );
}

// show only the date portion of the DateAndTime object
char *DateAndTime::ShowDate()
{
	if (showDateOnly == (char *)0)
		return ( errorMsg );

	sprintf( showDateOnly, "%s %s %02d %4d\n",
		dayName[ dtBuf->weekday ],
		monthName[ dtBuf->month - 1 ],
		dtBuf->day,
		dtBuf->year );

	return ( showDateOnly );
}

// show only the time portion of the DateAndTime object
char *DateAndTime::ShowTime()
{
	if (showTimeOnly == (char *)0)
		return ( errorMsg );

	sprintf( showTimeOnly, "%02d:%02d:%02d\n",
		dtBuf->hours,
		dtBuf->minutes,
		dtBuf->seconds );


	return ( showTimeOnly );

}
