Copyright Michael Abrash, 1988.  All Rights Reserved.
;
; Program to demonstrate the 32 text pages of the VGA/EGA.
;
; To demonstrate the 32 text pages of the VGA, set
; ADAPTER_IS_VGA to 1.
;
; To demonstrate the 32 text pages of the EGA, set
; ADAPTER_IS_VGA to 0.
;
; By Michael Abrash  5/22/88
;

ADAPTER_IS_VGA		equ	0
PAGE_LENGTH		equ	1000h	;number of bytes per page
MISCELLANEOUS_OUTPUT_W	equ	3c2h	;Miscellaneous Output write port
MISCELLANEOUS_OUTPUT_R	equ	3cch	;Miscellaneous Output read port
GC_INDEX		equ	3ceh
GC_MISCELLANEOUS	equ	6
CRTC_INDEX		equ	3d4h
CRTC_START_ADDRESS_HIGH	equ	0ch
CRTC_START_ADDRESS_LOW	equ	0dh

stack	segment	para stack 'STACK'
	db	512 dup (?)
stack	ends

code	segment para public 'CODE'
	assume	cs:code, ds:nothing
start	proc	near
;
; Set to text mode.
;
	mov	ax,3
	int	10h
;
; Relocate display memory to A000 by reprogramming
; the Graphics Controller's Miscellaneous register.
;
	mov	dx,GC_INDEX
	mov	al,GC_MISCELLANEOUS
	out	dx,al
	inc	dx
	mov	al,06h
	out	dx,al
;
; Point to display memory.
;
	mov	ax,0a000h
	mov	es,ax
;
; Fill text pages 0-15 (the pages that are accessible when

; the Page bit is 1, the setting after a mode set is performed).
; (Page 0 is filled with "A", page 1 with "B", and so on.)
;
	sub	ax,ax	;start with page 0
	mov	bl,'A'	;base letter for pages 0-15
FillPages0_15Loop:
	push	ax
	call	FillPage
	pop	ax
	inc	ax
	cmp	ax,16
	jb	FillPages0_15Loop
;
; Set the Page bit to 0.
;
if ADAPTER_IS_VGA
	mov	dx,MISCELLANEOUS_OUTPUT_R
	in	al,dx
	and	al,not 20h	;Page bit (bit 5) -> 0
	mov	dx,MISCELLANEOUS_OUTPUT_W
	out	dx,al
else
	mov	dx,MISCELLANEOUS_OUTPUT_W
	mov	al,87h		;Page bit (bit 5) -> 0
	out	dx,al
endif
;
; Now fill text pages 16-31 (the pages that are accessible when
; the Page bit is 0).
; (Page 16 is filled with "Q", page 17 with "R", and so on.)
;
	sub	ax,ax	;start with page 0
	mov	bl,'Q'	;base letter for pages 16-31
FillPages16_31Loop:
	push	ax
	call	FillPage
	pop	ax
	inc	ax
	cmp	ax,16
	jb	FillPages16_31Loop
;
; Display each of the text pages in turn, waiting for a key
; before going to the next page. Note that all 32 pages can
; be displayed without changing the Page bit; the Page bit
; only affects CPU accesses, not video data fetching.
;
	sub	ax,ax
ShowPageLoop:
	push	ax
	call	ShowPage
	call	WaitKey
	pop	ax
	inc	ax
	cmp	ax,32
	jb	ShowPageLoop
;
; Done-perform a mode set to reset all paging and clear
; the screen, then return to DOS.
;
	mov	ax,3
	int	10h
	mov	ah,4ch
	int	21h
start	endp
;
; Fills a text page with a corresponding character.
;
; Input:
;	AX = text page
;	BL = character for text page 0 (each text page
;		is filled with character BL + text page #)
;
FillPage	proc	near
	push	ax	;save the page #
	mov	dx,PAGE_LENGTH
	mul	dx	;calculate the start offset of the page
			; in the display memory segment
	mov	di,ax
	pop	ax	;get back the page #
	add	al,bl	;convert it to a unique letter
	mov	ah,7	;attribute is white
	mov	cx,PAGE_LENGTH/2 ;page length as measured
				 ; in character/attribute pairs
	cld
	rep	stosw	;fill the page
	ret
FillPage	endp
;
; Programs the CRTC to display the desired text page.
;
; Input: AX = text page.
;
ShowPage	proc	near
	mov	dx,PAGE_LENGTH/2
	mul	dx		;start offset of the pages as
				; measured in character/attribute
				; pairs (which is how the CRTC
				; counts in text mode)
	mov	dx,CRTC_INDEX	;point to the CRTC Index register
	push	ax
	mov	al,CRTC_START_ADDRESS_HIGH
	out	dx,al
	inc	dx		;point to the CRTC Data register
	mov	al,ah
	out	dx,al		;set the high start address byte
	dec	dx		;point to the CRTC Index register
	mov	al,CRTC_START_ADDRESS_LOW
	out	dx,al
	inc	dx		;point to the CRTC Data register
	pop	ax
	out	dx,al		;set the low start address byte
	ret
ShowPage	endp
;
; Waits until a key is pressed.
;
WaitKey	proc	near
	mov	ah,1
	int	16h
	jz	WaitKey
	sub	ah,ah
	int	16h	;clear the key
	ret
WaitKey	endp

code	ends
	end	start

