/*    Source Code for "A Note on Printer Output from Turbo C Programs"
                           by Bernard H. Robinson, Jr.
      Page 48, Volume 5.5, Programmer's Journal
      Copyright 1987, Bernard H. Robinson, Jr., All Rights Reserved
*/
/******************************
*       name: outdemo.c
*    purpose: Demonstrate two ways of printer output for Turbo C
* written by: Bernard H. Robinson, Jr.
*       date: June 1, 1987
*    version: 005
*******************************/

#include "stdio.h"   /* For FILE structure; fdopen, fprintf, printf,
                        and  fcloseall functions */
#include "process.h" /* For exit function */
#include "io.h"      /* for write function */

FILE *stdprt;   /* declare stdprt pointer to FILE structure  */

void main()
{
    int i;
    char *s1,*s2;
    s1 = "This is a test line for the write function.\n";
    s2 = "This is a test line for the fprintf function.\n";

    write(4,s1,strlen(s1));                /* Level one printer output */

    /* Now lets go on to level two printer output */

    /* First point "stdprt" to the printer */

    if( (stdprt = fdopen( 4, "wt" ))  == NULL) {
        printf("Unable to open printer");
        i = -1;
        exit(i);
    }
    /* Now use "stdprt" to output to printer */

    fprintf(stdprt,"%s",s2);
}
/************* End of program ****************/

