#include <ctype.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef enum { TRACTOR, MANUAL } _papermode ;
typedef enum { SINGLE, DOUBLE } _printmode ;

FILE *printfile = stdout ;
FILE *target = NULL ;
_papermode papermode = MANUAL ;
_printmode printmode = SINGLE ;
int totallines = 0 ;
int totalpages ;
int tabsize = 8 ;

#define USLETTER        61
int formlength = USLETTER ;

#define ABORT   0x1b

#define CPL80   "\x1b\x50"
#define CPL96   "\x1b\x4d"
#define CPL120  "\x1b\x67"
#define CPL137  "\x1b\x50\xf"
#define CPL160  "\x1b\x4d\xf"

#define RELEASE "\x12"
#define INIT    "\x1b\x40"

#define FORMFEED	'\x0c'
#define TAB		'\t'
#define NEWLINE		'\n'
#define DELIMITATOR	'|'
#define SPACE		' '
#define BS		'\b'

typedef struct {
	int len ;
	char *pitch ;
	char *name ;
	int dbsz ;
} printerline ;
printerline prtl[5] = {
	{ 160, CPL160, "160 CPL (ELITE COMPRESS PITCH, 20 CPI)", 79 },
	{ 137, CPL137, "137 CPL (PICA COMPRESS PITCH, 17 CPI)", 67 },
	{ 120, CPL120, "120 CPL (MICRON PITCH, 15 CPI)", 59 },
	{ 96, CPL96, "96 CPL (ELITE PITCH, 12 CPI)", 47 },
	{ 80, CPL80, "80 CPL (PICA PITCH, 10 CPI)", 39 }
} ;

#define NORMAL  0
int pitch = -1 ;

#define MAXCHAR 160
#define BUFSZ 256

int formfeed (
	int *counter
) {
	static int page = 1 ;

	if ( *counter == formlength ) {
		fputc( FORMFEED, printfile ) ;
		*counter = 0 ;
		if ( papermode == MANUAL ) {
			fputs( "Insert new paper...\n", stderr ) ;
			if ( getch() == ABORT )
				return 0 ;
		}
		page++ ;
		fprintf( stderr,
			"Now printing page %d / total is %d pages.\n",
			page, totalpages ) ;
	}
	return 1 ;
}

int checkabort ( void )
{
	while ( kbhit() )
		if ( getch() == ABORT ) {
			fputs( "Aborting by user...\n", stderr ) ;
			return 1 ;
		}
	return 0 ;
}

int
singleprint ( void )
{
	char s[BUFSZ] ;
	int linecounter = 0, counter = 0 ;
	int i, l ;

	while ( !feof( target ) ) {
		if ( checkabort() )
			return 0 ;
		fgets( s, BUFSZ, target ) ;
		l = strlen( s ) ;
		for ( i = 0 ; i < l ; i++ )
			if ( s[i] == FORMFEED ) {
				counter = formlength ;
				goto formfee ;
			} else
				fputc( s[i], printfile ) ;
		linecounter++ ;
		counter++ ;
		if ( linecounter != totallines )
formfee:		if ( !formfeed( &counter ) )
				return 0 ;
	}
	return 1 ;
}

void removetab (
	char *orig,
	char *modi
) {
	const int l = strlen( orig ) ;
	int i, j, k, m ;

	if ( l )
		for ( j = i = 0 ; i < l ; i++ )
			if ( orig[i] == TAB )
				for ( m = j, k = 0 ;
					k < tabsize - m % tabsize ; k++, j++ )
					modi[j] = SPACE ;
			else {
				modi[j] = orig[i] ;
				j++ ;
			}
	else
		j = 0 ;
	modi[j] = 0 ;
}

void
printline (
	char *left,
	char *right
) {
	const l = strlen( left ), m = strlen( right ) ;
	const s = prtl[pitch].dbsz ;
	int i, k ;
	for ( i = k = 0 ; i < l && k < s ; i++, k++ ) {
		if ( left[i] == FORMFEED )
			continue ;
		if ( left[i] == BS )
			k -= 2 ;
		else if ( !isprint( left[i] ) )
			k-- ;
		fputc( left[i], printfile ) ;
	}
	for ( ; k < s ; k++ )
		fputc( SPACE, printfile ) ;
	fputc( DELIMITATOR, printfile ) ;
	for ( i = 0 ; i < m ; i++ )
		if ( right[i] != FORMFEED )
			fputc( right[i], printfile ) ;
	fputc( NEWLINE, printfile ) ;
}

int
doubleprint ( void )
{
	static char s1[BUFSZ], s2[BUFSZ], s3[BUFSZ] ;
	int counter = 0, linecounter = 0, i, j, k ;
	fpos_t *fpos ;

	fpos = ( fpos_t * )malloc( sizeof ( fpos_t ) * formlength * 2 ) ;

	if ( fpos == NULL ) {
		fputs( "Not enough memory for double column\n", stderr ) ;
		return 0 ;
	}
	while ( !feof( target ) ) {
		for ( i = 0 ; i < formlength * 2 ; i++ )
			if ( !feof( target ) ) {
				fgetpos( target, &fpos[i] ) ;
				do {
					j = fgetc( target ) ;
				} while ( !feof( target ) && j != NEWLINE ) ;
			} else
				fpos[i] = -1 ;
		for ( i = 0 ; i < formlength ; i++ ) {
			s1[0] = s2[0] = s3[0] = 0 ;
			k = 0 ;
			if ( fpos[i] != -1 ) {
				fsetpos( target, &fpos[i] ) ;
				fgets( s3, prtl[pitch].dbsz, target ) ;
				j = strlen( s3 ) ;
				if ( j > 0 && s3[j - 1] == NEWLINE )
					s3[j - 1] = 0 ;
				removetab( s3, s1 ) ;
				k++ ;
			}
			if ( fpos[i + formlength] != -1 ) {
				fsetpos( target, &fpos[i + formlength] ) ;
				fgets( s3, prtl[pitch].dbsz, target ) ;
				j = strlen( s3 ) ;
				if ( j > 0 && s3[j - 1] == NEWLINE )
					s3[j - 1] = 0 ;
				removetab( s3, s2 ) ;
				k++ ;
			}
			if ( k ) {
				if ( checkabort() )
					return 0 ;
				printline( s1, s2 ) ;
				linecounter++ ;
				counter++ ;
				if ( linecounter == totallines )
					goto bye ;
				if ( !formfeed( &counter ) ) {
					free( fpos ) ;
					return 0 ;
				}
			}
		}
	}
bye:    free( fpos ) ;
	return 1 ;
}

void
printout ( void )
{
	int ( *printfunc )( void ) =
		printmode == SINGLE ? singleprint : doubleprint ;

#ifndef DEBUG
	if ( printfile == stdprn ) {
#endif
		fputs( "Make sure printer is ON-LINE, and insert paper...\n",
			stderr ) ;
		if ( getch() == ABORT )
			return ;
#ifndef DEBUG
	}
#endif
	fprintf( printfile, INIT ) ;
	fprintf( printfile, prtl[pitch].pitch ) ;
	if ( printfunc() )
		fputc( FORMFEED, printfile ) ;
	fprintf( printfile, INIT ) ;
}

preprocess (
	int *wmax,
	int *lmax
) {
	int max = 0, i, k ;
	char s[BUFSZ] ;

	while ( !feof( target ) ) {
		fgets( s, BUFSZ, target ) ;
		for ( k = i = 0 ; i < strlen( s ) ; i++, k++ )
			if ( s[i] == TAB ) {
				k += tabsize - k % tabsize ;
				k-- ;
			} else if ( s[i] == BS )
				k -= 2 ;
			else if ( !isprint( s[i] ) )
				k-- ;
		totallines++ ;
		if ( max < k )
			max = k ;
	}
	rewind( target ) ;
	*lmax = max ;
	if ( printmode == DOUBLE ) {
		max *= 2 ;
		k = totallines / formlength +
			( totallines % formlength ? 1 : 0 ) ;
		totallines = formlength *
			( k / 2 + ( k % 2 ? 1 : 0 ) ) ;
	}
	if ( max <= MAXCHAR )
		for ( k = 0 ; k < 5 ; k++ )
			if ( max <= prtl[k].len )
				pitch = k ;
	*wmax = max ;
	return pitch != -1 ;
}

main (
	int argc,
	char **argv
) {
	int j, k ;
	char *c ;

	if ( argc <= 1 ) {
usage:          fprintf( stderr,
			"Quick Print ! Second Edition\n"
			"Copyright (c) 1993 by Anthony Shih Hao Lee\n\n"
			"Usage: %s -[t|d|p|#num|T<#tab>] file\n"
			"t\tpaper source is tractor (default: manual)\n"
			"p\tsend target to printer (default: console)\n"
			"d\tdouble column printing (defailt: single)\n"
			"#num\tnumber of form (default: 61 lines USLETTER)\n"
			"T<#tab>\tset TAB size (default: 8)\n\n"
			"NB1: This program is ready for Panasonic KXP1124 "
			"in EPSON LQ-2500 mode.\n"
			"NB2: If target is console, then paper source is "
			"tractor.\n"
			"NB3: if double column, line may be truncated to fit "
			"into the column.\n"
			"NB4: Please do not print raw U*IX file due to "
			"newline (0x0a) problem.\n"
			"NB5: if double column, formfeed (0x0c) in the source "
			"will be ignored.\n"
			, argv[0]
		) ;
		return -1 ;
	}
	for ( j = 1 ; j < argc - 1 ; j++ ) {
			c = argv[j] ;
			if ( *c != '-' && *c != '/' ) {
unknown:                        fprintf( stderr,
					"ignore unknown option -- `%s'\n",c );
				continue ;
			}
			c++ ;
			switch ( *c ) {
				case 'p' :
					printfile = stdprn ;
					break ;
				case 't' :
					papermode = TRACTOR ;
					break ;
				case 'd' :
					printmode = DOUBLE ;
					break ;
				case 'T' :
					tabsize = atoi( c + 1 ) ;
					break ;
				default :
					goto unknown ;
			}
			if ( isdigit( *c ) )
				formlength = atoi( c ) ;
	}
	if ( ( target = fopen( argv[argc - 1], "rt" ) ) == NULL ) {
		fprintf( stderr,
			"Cannot find `%s'. aborting...\n", argv[argc - 1] ) ;
		goto usage ;
	}
#ifndef DEBUG
	if ( printfile == stdout )
		papermode = TRACTOR ;
#endif
	if ( !preprocess( &j, &k ) ) {
		fputs( "Warning: some line(s) are too long, <ESC> abort...\n",
			stderr ) ;
		if ( getch() == ABORT )
			return -1 ;
		pitch = NORMAL ;
	}
	fprintf( stderr, "*** STATUS REPORT ***\n"
		"PRINT TARGET : %s\nPAPER SOURCE : %s\nPRINT MODE : %s\n"
		"PAPER LENGTH : %d\nTARGET FILE : %s\nTAB SIZE : %d\n"
		"MAX LINE WIDTH : %d (PRINT WIDTH %d) -- USE %s\n"
		"TOTAL LINES : %d -- USE %d PAGE(S)\n"
		"Whenever you can press <ESC> to abort...\n",
		printfile == stdout ? "CONSOLE" : "PRINTER",
		papermode == MANUAL ? "MANUAL" : "TRACTOR",
		printmode == SINGLE ? "SINGLE COLUMN" : "DOUBLE COLUMN",
		formlength,
		strupr( argv[argc - 1] ),
		tabsize,
		k, j,
		prtl[pitch].name,
		totallines,
		totalpages = totallines / formlength +
			( totallines % formlength ? 1 : 0 )
		) ;
	printout() ;
	fcloseall() ;
	return 0 ;
}
