#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <fonts.h>
#ifdef __TURBOC__
#include <alloc.h>
#endif

#if defined(__HUGE__) || defined(__LARGE__) || defined(__MEDIUM__)
#define LARGE_CODE
#endif

#define MAX_WIDTH 801			/* Maximum width of any PGRAPH viewport defined in the program */

extern int page_height, page_width;	/* Size of page in pixels */
extern int prn;							/* Output device */

void end_slice(void);
#if defined(LARGE_CODE)
void start_screen_output(void);
void stop_screen_output(void);

#ifdef __TURBOC__
#include <graphics.h>
#include <bgidrive.h>
#define CLS cleardevice()
#else
#include <graph.h>
#define CLS _clearscreen(0)
#endif
#endif

#include "pgraph.h"


/********************************************************************
 Draw lines, ellipses, polygons, move graphics cursor */

void shapes_demo(void)
{
int xasp, yasp;
int xres, yres;
int error_code;
int width, height;
long free_space;
struct arccoordstype arccoords;
static int polypoints[14] = {
	500, 160,
	500, 340,
	450, 250,
	400, 250,
	350, 330,
	360, 170,
	500, 160};

	printf("\n\nSHAPES DEMO\n\n");
	p_getresolution(&xres, &yres);
	p_setviewport(0, 0, 0, 0, 1);
#ifdef __TURBOC__
    free_space = farcoreleft() - 0x4000L;       /* Leave room for other graph memory uses */
#else
    free_space = 409600L;                   /* Take 400K */
#endif
	width = (int)((long)xres * page_width / 100);
	height = (int) (free_space * 8 / width);
	height = min(height, (int)((long)yres * page_height / 100));
	printf("Setting %d by %d pixel (%d*%d inches) viewport\n",
		width, height, width/xres, height/yres);
	p_setviewport(0, 0, width - 1, height - 1, 1);
	error_code = p_graphresult();
	if (error_code != grOk || height < 340) {
		printf("Failed... Insufficient memory\n");
		return;
	}
	p_setlinestyle(USERBIT_LINE, 0x8080, NORM_WIDTH);
	p_rectangle(0, 0, p_getmaxx(), p_getmaxy());
	p_setlinestyle(CENTER_LINE, 0, NORM_WIDTH);
	printf("p_drawpoly(7, polypoints);\n");
	p_drawpoly(7, polypoints);
	printf("p_rectangle(220, 140, 270, 10);\n");
	p_rectangle(220, 240, 270, 110);
	printf("p_circle(p_getmaxx() - 120, 100, 100);\n");
	p_circle(p_getmaxx() - 120, 100, 100);
	printf("p_arc(p_getmaxx() - 220, 100, 45, 135, 100);\n");
	p_arc(p_getmaxx() - 220, 100, 45, 135, 100);
	p_getarccoords(&arccoords);
	printf("Last arc centred at (%d, %d), from (%d, %d) to (%d, %d)\n",
		arccoords.x, arccoords.y, arccoords.xstart, arccoords.ystart,
		arccoords.xend, arccoords.yend);
	printf("p_ellipse(90, 10, 0, 360, 30, 10);\n");
	p_ellipse(90, 10, 0, 360, 30, 10);
	printf("p_ellipse(160, 10, 0, 360, 5, 10);\n");
	p_ellipse(160, 10, 0, 360, 5, 10);
	printf("p_ellipse(200, 10, 45, 135, 30, 10);\n");
	p_ellipse(200, 10, 45, 135, 30, 10);
	printf("p_ellipse(240, 10, 45, 135, 5, 10);\n");
	p_ellipse(240, 10, 45, 135, 5, 10);
	printf("p_ellipse(280, 10, 45, 225, 30, 10);\n");
	p_ellipse(280, 10, 45, 225, 30, 10);
	printf("p_getaspectratio(&xasp, &yasp);\np_setaspectratio(xasp, yasp/3);\n");
	p_getaspectratio(&xasp, &yasp);
	p_setaspectratio(xasp, yasp/3);
	printf("Same circle and arc as above, but Ycentre at 390\n");
	p_circle(p_getmaxx() - 120, 390, 100);
	p_arc(p_getmaxx() - 220, 390, 45, 135, 100);
	printf("Width = %d, Height = %d\n", p_getmaxx(), p_getmaxy());
	printf("Current position = (%d, %d)\n", p_getx(), p_gety());
	printf("p_moveto(40, 50);\n");
	p_moveto(40, 50);
	printf("Current position = (%d, %d)\n", p_getx(), p_gety());
	printf("p_moverel(+20, -10);\n");
	p_moverel(+20, -10);
	printf("Current position = (%d, %d)\n", p_getx(), p_gety());

	printf("Various ellipse fragments\n");
	p_ellipse(450, 60,   0,  20, 100, 50);
	p_ellipse(450, 60,  30,  60, 100, 50);
	p_ellipse(450, 60,  70,  90, 100, 50);
	p_ellipse(450, 60,  90, 110, 100, 50);
	p_ellipse(450, 60, 120, 150, 100, 50);
	p_ellipse(450, 60, 160, 180, 100, 50);
	p_ellipse(450, 60, 180, 200, 100, 50);
	p_ellipse(450, 60, 210, 240, 100, 50);
	p_ellipse(450, 60, 250, 270, 100, 50);
	p_ellipse(450, 60, 270, 290, 100, 50);
	p_ellipse(450, 60, 300, 330, 100, 50);
	p_ellipse(450, 60, 340, 360, 100, 50);
	p_ellipse(100, 140, 20, 340, 100, 50);

	printf("Lines\n");
	p_setlinestyle(DASHED_LINE, 0, NORM_WIDTH);
	p_line(100, 140, 200, 140);
	p_line(100, 140, 100, 90);
	p_line(0, 200, 10, 250);
	p_line(0, 200, 50, 210);
	p_line(50, 210, 0, 220);
	p_line(50, 210, 40, 250);
	p_moveto(450, 60);
	p_linerel(100, 0);
	p_lineto(450, 110);

	printf("Pixels\n");
	p_putpixel(319, 0, 1);
	p_putpixel(319, 1, 1);
	p_putpixel(319, 1, 0);
	end_slice();
}

/********************************************************************
 Register stroked fonts, and print them in different sizes and
 orientations */

void stroked_fonts_demo(void)
{
int goth_height, next_line;

	printf("\n\nSTROKED FONTS DEMO\n\n");
	p_setviewport(0, 0, 719, 170, 1);
	p_registerbgifont(gothic_font);
#if !defined(__TINY__)
	p_registerfarbgifont(script_font_far);
#endif
	printf("Printing text size 1, horizontally\n");
	p_settextstyle(GOTHIC_FONT, HORIZ_DIR, 1);
	p_outtextxy(0, 0, "Gothic 1");
	goth_height = p_textheight("Gothic 1");
	p_settextstyle(SCRIPT_FONT, HORIZ_DIR, 1);
	p_outtextxy(200, 0, "Script 1");
	next_line = max(p_textheight("Script 1"), goth_height);

	printf("Printing text size 1, vertically\n");
	p_settextstyle(GOTHIC_FONT, VERT_DIR, 1);
	p_outtextxy(360, 0, "Gothic 1");
	p_settextstyle(SCRIPT_FONT, VERT_DIR, 1);
	p_outtextxy(380, 0, "Script 1");

	printf("Printing text size 2, horizontally\n");
	p_settextstyle(GOTHIC_FONT, HORIZ_DIR, 2);
	p_outtextxy(0, next_line, "Gothic 2");
	goth_height = p_textheight("Gothic 2");
	p_settextstyle(SCRIPT_FONT, HORIZ_DIR, 2);
	p_outtextxy(200, next_line, "Script 2");
	next_line += max(p_textheight("Script 2"), goth_height);

	printf("Printing text size 2, vertically\n");
	p_settextstyle(GOTHIC_FONT, VERT_DIR, 2);
	p_outtextxy(410, 0, "Gothic 2");
	p_settextstyle(SCRIPT_FONT, VERT_DIR, 2);
	p_outtextxy(430, 0, "Script 2");

	printf("Printing text size 3, horizontally\n");
	p_settextstyle(GOTHIC_FONT, HORIZ_DIR, 3);
	p_outtextxy(0, next_line, "Gothic 3");
	goth_height = p_textheight("Gothic 3");
	p_settextstyle(SCRIPT_FONT, HORIZ_DIR, 3);
	p_outtextxy(200, next_line, "Script 3");
	next_line += max(p_textheight("Script 3"), goth_height);

	printf("Printing text size 3, vertically\n");
	p_settextstyle(GOTHIC_FONT, VERT_DIR, 3);
	p_outtextxy(465, 0, "Gothic 3");
	p_settextstyle(SCRIPT_FONT, VERT_DIR, 3);
	p_outtextxy(500, 0, "Script 3");

	printf("Printing text size 4, horizontally\n");
	p_settextstyle(GOTHIC_FONT, HORIZ_DIR, 4);
	p_outtextxy(0, next_line, "Gothic 4");
	goth_height = p_textheight("Gothic 4");
	p_settextstyle(SCRIPT_FONT, HORIZ_DIR, 4);
	p_outtextxy(200, next_line, "Script 4");
	next_line += max(p_textheight("Script 4"), goth_height);

	printf("Printing text size 4, vertically\n");
	p_settextstyle(GOTHIC_FONT, VERT_DIR, 4);
	p_outtextxy(540, 0, "Gothic 4");
	p_settextstyle(SCRIPT_FONT, VERT_DIR, 4);
	p_outtextxy(580, 0, "Script 4");

	printf("Printing text size 5, horizontally\n");
	p_settextstyle(GOTHIC_FONT, HORIZ_DIR, 5);
	p_outtextxy(0, next_line, "Gothic 5");
	p_settextstyle(SCRIPT_FONT, HORIZ_DIR, 5);
	p_outtextxy(200, next_line, "Script 5");

	printf("Printing text size 5, vertically\n");
	p_settextstyle(GOTHIC_FONT, VERT_DIR, 5);
	p_outtextxy(620, 0, "Gothic 5");
	p_settextstyle(SCRIPT_FONT, VERT_DIR, 5);
	p_outtextxy(660, 0, "Script 5");

	end_slice();

	p_setviewport(0, 0, 550, 240, 1);
	printf("Printing text size 9, horizontally\n");
	p_settextstyle(GOTHIC_FONT, HORIZ_DIR, 9);
	p_outtextxy(0, 0, "Gothic 9");
	next_line = p_textheight("Gothic 9");

	printf("Printing text size 10, horizontally\n");
	p_settextstyle(GOTHIC_FONT, HORIZ_DIR, 10);
	p_outtextxy(0, next_line, "Gothic 10");

	end_slice();
}

/********************************************************************
 Print default font in various sizes and orientations */
void default_font_demo(void)
{
	printf("\n\nDEFAULT FONT DEMO\n\n");
	p_setviewport(0, 0, 680, 199, 1);
	printf("Printing text size 1, horizontally\n");
	p_settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
	p_outtextxy(0, 0, "Default 1");
	printf("Printing text size 1, vertically\n");
	p_settextstyle(DEFAULT_FONT, VERT_DIR, 1);
	p_outtextxy(360, 0, "Default 1");

	printf("Printing text size 2, horizontally\n");
	p_settextstyle(DEFAULT_FONT, HORIZ_DIR, 2);
	p_outtextxy(0, 18, "Default 2");
	printf("Printing text size 2, vertically\n");
	p_settextstyle(DEFAULT_FONT, VERT_DIR, 2);
	p_outtextxy(378, 0, "Default 2");

	printf("Printing text size 3, horizontally\n");
	p_settextstyle(DEFAULT_FONT, HORIZ_DIR, 3);
	p_outtextxy(0, 40, "Default 3");
	printf("Printing text size 3, vertically\n");
	p_settextstyle(DEFAULT_FONT, VERT_DIR, 3);
	p_outtextxy(416, 0, "Default 3");

	printf("Printing text size 4, horizontally\n");
	p_settextstyle(DEFAULT_FONT, HORIZ_DIR, 4);
	p_outtextxy(0, 65, "Default 4");
	printf("Printing text size 4, vertically\n");
	p_settextstyle(DEFAULT_FONT, VERT_DIR, 4);
	p_outtextxy(468, 0, "Default 4");

	printf("Printing text size 5, horizontally\n");
	p_settextstyle(DEFAULT_FONT, HORIZ_DIR, 5);
	p_outtextxy(0, 100, "Default 5");
	printf("Printing text size 5, vertically\n");
	p_settextstyle(DEFAULT_FONT, VERT_DIR, 5);
	p_outtextxy(520, 0, "Default 5");

	printf("Printing text size 6, horizontally\n");
	p_settextstyle(DEFAULT_FONT, HORIZ_DIR, 6);
	p_outtextxy(0, 150, "Default 6");
	printf("Printing text size 6, vertically\n");
	p_settextstyle(DEFAULT_FONT, VERT_DIR, 6);
	p_outtextxy(620, 0, "Default 6");

	end_slice();

	p_setviewport(0, 0, 800, 89, 1);
	printf("Printing text size 10, horizontally\n");
	p_settextstyle(DEFAULT_FONT, HORIZ_DIR, 10);
	p_outtextxy(0, 0, "Default 10");

	end_slice();
}

/********************************************************************
 Print stroked and default font horizontally, using various
 justification settings */

void horiz_text_demo(void)
{
int i;

	printf("\n\nHORIZONTAL JUSTIFICATION DEMO\n\n");
	p_setviewport(0, 0, 760, 175, 1);
	p_setlinestyle(DOTTED_LINE, 0, NORM_WIDTH);
	for (i = 25; i <= 150; i += 25)
		p_line(0,  i, p_getmaxx(),  i);
	for (i = 100; i < p_getmaxx(); i += 100)
		p_line( i, 0,  i, p_getmaxy());

	printf("Printing Triplex\n");
	p_settextstyle(TRIPLEX_FONT, HORIZ_DIR, 1);
	p_settextjustify(LEFT_TEXT, TOP_TEXT);
	p_outtextxy(100, 50, "Triplex left top");

	p_settextjustify(LEFT_TEXT, CENTER_TEXT);
	p_outtextxy(300, 50, "Triplex left centre");

	p_settextjustify(LEFT_TEXT, BOTTOM_TEXT);
	p_outtextxy(500, 50, "Triplex left bottom");

	p_settextjustify(CENTER_TEXT, TOP_TEXT);
	p_outtextxy(100, 100, "Triplex centre top");

	p_settextjustify(CENTER_TEXT, CENTER_TEXT);
	p_outtextxy(300, 100, "Triplex centre centre");

	p_settextjustify(CENTER_TEXT, BOTTOM_TEXT);
	p_outtextxy(500, 100, "Triplex centre bottom");

	p_settextjustify(RIGHT_TEXT, TOP_TEXT);
	p_outtextxy(100, 150, "Triplex right top");

	p_settextjustify(RIGHT_TEXT, CENTER_TEXT);
	p_outtextxy(300, 150, "Triplex right centre");

	p_settextjustify(RIGHT_TEXT, BOTTOM_TEXT);
	p_outtextxy(500, 150, "Triplex right bottom");

	printf("Printing Default\n");
	p_settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
	p_settextjustify(LEFT_TEXT, TOP_TEXT);
	p_outtextxy(200, 25, "Default left top");

	p_settextjustify(LEFT_TEXT, CENTER_TEXT);
	p_outtextxy(400, 25, "Default left centre");

	p_settextjustify(LEFT_TEXT, BOTTOM_TEXT);
	p_outtextxy(600, 25, "Default left bottom");

	p_settextjustify(CENTER_TEXT, TOP_TEXT);
	p_outtextxy(200, 75, "Default centre top");

	p_settextjustify(CENTER_TEXT, CENTER_TEXT);
	p_outtextxy(400, 75, "Default centre centre");

	p_settextjustify(CENTER_TEXT, BOTTOM_TEXT);
	p_outtextxy(600, 75, "Default centre bottom");

	p_settextjustify(RIGHT_TEXT, TOP_TEXT);
	p_outtextxy(200, 125, "Default right top");

	p_settextjustify(RIGHT_TEXT, CENTER_TEXT);
	p_outtextxy(400, 125, "Default right centre");

	p_settextjustify(RIGHT_TEXT, BOTTOM_TEXT);
	p_outtextxy(600, 125, "Default right bottom");

	end_slice();
}

/********************************************************************
 Print stroked and default font vertically, using various
 justification settings */

void vert_text_demo(void)
{
int i;

	printf("\n\nVERTICAL JUSTIFICATION DEMO\n\n");
	p_setviewport(0, 0, 642, 180, 1);
	p_setlinestyle(DOTTED_LINE, 0, NORM_WIDTH);
	for (i = 25; i <= 150; i += 25)
		p_line(0,  i, p_getmaxx(),  i);
	for (i = 20; i < p_getmaxx(); i += 20)
		p_line( i, 0,  i, p_getmaxy());

	printf("Printing Triplex\n");
	p_settextstyle(TRIPLEX_FONT, VERT_DIR, 1);
	p_settextjustify(LEFT_TEXT, TOP_TEXT);
	p_outtextxy(100, 50, "Triplex left top");

	p_settextjustify(LEFT_TEXT, CENTER_TEXT);
	p_outtextxy(300, 50, "Triplex left centre");

	p_settextjustify(LEFT_TEXT, BOTTOM_TEXT);
	p_outtextxy(500, 50, "Triplex left bottom");

	p_settextjustify(CENTER_TEXT, TOP_TEXT);
	p_outtextxy(120, 100, "Triplex centre top");

	p_settextjustify(CENTER_TEXT, CENTER_TEXT);
	p_outtextxy(320, 100, "Triplex centre centre");

	p_settextjustify(CENTER_TEXT, BOTTOM_TEXT);
	p_outtextxy(520, 100, "Triplex centre bottom");

	p_settextjustify(RIGHT_TEXT, TOP_TEXT);
	p_outtextxy(140, 150, "Triplex right top");

	p_settextjustify(RIGHT_TEXT, CENTER_TEXT);
	p_outtextxy(340, 150, "Triplex right centre");

	p_settextjustify(RIGHT_TEXT, BOTTOM_TEXT);
	p_outtextxy(540, 150, "Triplex right bottom");

	printf("Printing Default\n");
	p_settextstyle(DEFAULT_FONT, VERT_DIR, 1);
	p_settextjustify(LEFT_TEXT, TOP_TEXT);
	p_outtextxy(200, 25, "Default left top");

	p_settextjustify(LEFT_TEXT, CENTER_TEXT);
	p_outtextxy(400, 25, "Default left centre");

	p_settextjustify(LEFT_TEXT, BOTTOM_TEXT);
	p_outtextxy(600, 25, "Default left bottom");

	p_settextjustify(CENTER_TEXT, TOP_TEXT);
	p_outtextxy(220, 75, "Default centre top");

	p_settextjustify(CENTER_TEXT, CENTER_TEXT);
	p_outtextxy(420, 75, "Default centre centre");

	p_settextjustify(CENTER_TEXT, BOTTOM_TEXT);
	p_outtextxy(620, 75, "Default centre bottom");

	p_settextjustify(RIGHT_TEXT, TOP_TEXT);
	p_outtextxy(240, 125, "Default right top");

	p_settextjustify(RIGHT_TEXT, CENTER_TEXT);
	p_outtextxy(440, 125, "Default right centre");

	p_settextjustify(RIGHT_TEXT, BOTTOM_TEXT);
	p_outtextxy(640, 125, "Default right bottom");

	end_slice();
}

/********************************************************************
 Print stroked font, using various scaling factors */

void text_scaling_demo(void)
{
struct textsettingstype texttypeinfo;
int lomode, himode;

	printf("\n\nTEXT SCALING DEMO\n\n");
	p_setviewport(0, 0, 660, 190, 1);
	p_settextstyle(TRIPLEX_FONT, VERT_DIR, 1);
	p_settextjustify(LEFT_TEXT, TOP_TEXT);

	p_gettextsettings(&texttypeinfo);
	printf("Text set to font no. %d, direction = %s, size = %d\n",
		texttypeinfo.font,
		texttypeinfo.direction == HORIZ_DIR ? "Horizontal" : "Vertical",
		texttypeinfo.charsize);
	printf("Text justification is %s, %s\n",
		texttypeinfo.horiz == LEFT_TEXT ? "Left" : texttypeinfo.horiz == CENTER_TEXT ? "Centre" : "Right",
		texttypeinfo.vert  == TOP_TEXT  ? "Top"  : texttypeinfo.vert  == CENTER_TEXT ? "Centre" : "Bottom");

	p_settextstyle(DEFAULT_FONT, HORIZ_DIR, 2);
	p_settextjustify(CENTER_TEXT, BOTTOM_TEXT);

	p_gettextsettings(&texttypeinfo);
	printf("Text set to font no. %d, direction = %s, size = %d\n",
		texttypeinfo.font,
		texttypeinfo.direction == HORIZ_DIR ? "Horizontal" : "Vertical",
		texttypeinfo.charsize);
	printf("Text justification is %s, %s\n",
		texttypeinfo.horiz == LEFT_TEXT ? "Left" : texttypeinfo.horiz == CENTER_TEXT ? "Centre" : "Right",
		texttypeinfo.vert  == TOP_TEXT  ? "Top"  : texttypeinfo.vert  == CENTER_TEXT ? "Centre" : "Bottom");

	p_setusercharsize(3, 2, 1, 2);
	p_settextstyle(TRIPLEX_FONT, HORIZ_DIR, 0);
	p_settextjustify(LEFT_TEXT, TOP_TEXT);
	p_outtextxy(0, 0, "Treble width, Normal height");
	p_setusercharsize(1, 2, 1, 2);
	p_outtextxy(0, 15, "Normal width, Normal height");
	p_setusercharsize(1, 2, 3, 2);
	p_outtextxy(0, 25, "Normal width, Treble height");
	p_setusercharsize(3, 2, 3, 2);
	p_outtextxy(0, 60, "Treble width, Treble height");
	p_setusercharsize(1, 6, 1, 2);
	p_outtextxy(0, 110, "1/3 width, Normal height");
	p_setusercharsize(1, 2, 1, 6);
	p_outtextxy(0, 140, "Normal width, 1/3 height");
	p_setusercharsize(1, 6, 1, 6);
	p_outtextxy(0, 170, "1/3 width, 1/3 height");

	p_settextstyle(TRIPLEX_FONT, HORIZ_DIR, 1);
	printf("Width, height of 'ABC' in Triplex size  1 = %d, %d\n", p_textwidth("ABC"), p_textheight("ABC"));
	p_settextstyle(TRIPLEX_FONT, HORIZ_DIR, 10);
	printf("Width, height of 'ABC' in Triplex size 10 = %d, %d\n", p_textwidth("ABC"), p_textheight("ABC"));

	p_settextstyle(DEFAULT_FONT, HORIZ_DIR, 1);
	printf("Width, height of 'ABC' in Default size  1 = %d, %d\n", p_textwidth("ABC"), p_textheight("ABC"));
	p_settextstyle(DEFAULT_FONT, HORIZ_DIR, 10);
	printf("Width, height of 'ABC' in Default size 10 = %d, %d\n", p_textwidth("ABC"), p_textheight("ABC"));

	printf("Current graph mode    = %d\n", p_getgraphmode());
	printf("Maximum graph mode    = %d\n", p_getmaxmode());
	printf("Graph mode name       = %Fs\n", p_getmodename(p_getgraphmode()));
	p_getmoderange(STAR, &lomode, &himode);
	printf("Star NX-10 mode range = %d -- %d\n", lomode, himode);

	end_slice();
}

/********************************************************************
 Fill various shapes with various patterns */

void shape_fill_demo(void)
{
int i, xasp, yasp;
static int polypoints[] = {
	500, 10,
	500, 190,
	450, 100,
	400, 100,
	350, 180,
	360, 20,
	400, 20,
	420, 70,
	370, 100,
	450, 20,
	500, 10
	};
struct fillsettingstype fillinfo;
static char user_pattern[8] =  "\xf0\x0f\xf0\x0f\xf0\x0f\xf0\x0f";
char user_pattern2[8];

	printf("\n\nSHAPE FILLING DEMO\n\n");
	printf("Printing in default viewport\n");
	p_graphdefaults();
	p_getaspectratio(&xasp, &yasp);
	for (i = 0; i < 7; i++) {
		p_setfillstyle(i, 1);
		p_getfillsettings(&fillinfo);
		printf("Fill style set to %d, colour %d\n", fillinfo.pattern, fillinfo.color);
		p_fillellipse( i * 40 + 20, 20, 20, (int)(20L * xasp / yasp));
	}

	p_setfillpattern(user_pattern, 1);
	p_getfillpattern(user_pattern2);
	p_getfillsettings(&fillinfo);
	printf("Fill style set to %d, colour %d\n", fillinfo.pattern, fillinfo.color);
	p_fillellipse( i * 40 + 20, 20, 20, (int)(20L * xasp / yasp));

	p_setfillstyle(LTSLASH_FILL, 1);
	printf("p_fillpoly(11, polypoints);\n");
	p_fillpoly(11, polypoints);

	printf("p_bar(370, 100, 500, 170)\n");
	p_bar(570, 100, 600, 170);
	printf("p_bar3d(0, 100, 50, 150, 25, 1)\n");
	p_bar3d(0, 100, 50, 150, 25, 1);
	printf("p_bar3d(70, 100, 120, 150, 25, 0)\n");
	p_bar3d(70, 100, 120, 150, 25, 0);
	end_slice();
}

/********************************************************************
 Fill an arbitrary shape */

void flood_fill_demo(void)
{
static int polypoints[] = {
	200, 10,
	200, 190,
	150, 100,
	100, 100,
	 50, 180,
	 60, 20,
	100, 20,
	120, 70,
	 70, 100,
	150, 20,
	200, 10
	};

	printf("\n\nFLOOD FILLING DEMO\n\n");
	p_setviewport(0, 0, 719, 199, 1);
	p_setcolor(1);
	printf("Drawing polygon\n");
	p_drawpoly(11, polypoints);
	printf("Including a circle\n");
	p_circle(150, 80, 10);
	printf("Filling polygon\n");
	p_floodfill(165, 80, 1);

	end_slice();
}

/********************************************************************
 Draw various lines in different directions, with a user-defined
 pattern */

void lines_demo(void)
{
int i;
struct linesettingstype linetypeinfo;

	printf("\n\nLINE DRAWING DEMO\n\n");
	p_setviewport(0, 0, 719, 199, 1);
	p_setlinestyle(USERBIT_LINE, 0xfc02, THICK_WIDTH);
	for (i = 0; i <= 100; i += 20) {
		p_line(0, 0, 100, i);
		p_line(319, 0, 200, i);
		p_line(i, 199, 100, 100);
		p_line(200, 199, 319-i, 100);
	}
	p_getlinesettings(&linetypeinfo);
	printf("Current line settings: \n\tLine stype = %d\n\tUser pattern = %04x\n\
\tThickness = %d\n\n", linetypeinfo.linestyle, linetypeinfo.upattern, linetypeinfo.thickness);

	end_slice();
}

/********************************************************************
 Draw an elliptical pie chart on the printer. */

static void draw_elliptical_pie(void)
{
	p_setviewport(0, 0, 500, 120, 1);
	p_outtextxy(300, 50, "Elliptical Pie chart");
	p_setlinestyle(SOLID_LINE, 0, NORM_WIDTH);
	p_setfillstyle(CLOSE_DOT_FILL, 1);
	p_sector(150, 50, 0, 50, 75, 30);
	p_setfillstyle(HATCH_FILL, 1);
	p_sector(150, 50, 50, 120, 75, 30);
	p_setfillstyle(XHATCH_FILL, 1);
	p_sector(150, 50, 120, 190, 75, 30);
	p_setfillstyle(WIDE_DOT_FILL, 1);
	p_sector(150, 50, 190, 290, 75, 30);
	p_setlinestyle(SOLID_LINE, 0, THICK_WIDTH);
	p_setfillstyle(INTERLEAVE_FILL, 1);
	p_sector(160, 60, 290, 360, 75, 30);
}

/********************************************************************
 Draw a circular pie chart on the printer. */

void pie_demo(void)
{
	printf("\n\nPIE CHART DRAWING DEMO\n\n");
	p_setviewport(0, 0, 500, 200, 1);
	printf("Circular pie chart, various fill patterns\n");
	p_outtextxy(300, 100, "Circular Pie chart");
	printf("Slice 1, CLOSE DOT FILL.\n");
	p_setlinestyle(SOLID_LINE, 0, NORM_WIDTH);
	p_setfillstyle(CLOSE_DOT_FILL, 1);
	p_pieslice(150, 100, 0, 50, 75);
	printf("Slice 2, HATCH FILL.\n");
	p_setfillstyle(HATCH_FILL, 1);
	p_pieslice(150, 100, 50, 120, 75);
	printf("Slice 3, XHATCH FILL.\n");
	p_setfillstyle(XHATCH_FILL, 1);
	p_pieslice(150, 100, 120, 190, 75);
	printf("Slice 4, WIDE DOT FILL.\n");
	p_setfillstyle(WIDE_DOT_FILL, 1);
	p_pieslice(150, 100, 190, 290, 75);
	printf("Slice 5, INTERLEAVE FILL.\n");
	p_setlinestyle(SOLID_LINE, 0, THICK_WIDTH);
	p_setfillstyle(INTERLEAVE_FILL, 1);
	p_pieslice(160, 110, 290, 360, 75);

	end_slice();

	printf("Elliptical pie chart, various fill patterns\n");
	draw_elliptical_pie();
	end_slice();
}

#if defined(LARGE_CODE)
/********************************************************************
 Scale an image to best fit the aspect ratio of the printer. This only
 works if the resulting xaspect >= yaspect */

static int scale_image(void far *bitmap, int xscale)
{
int x, y, right, bottom, old_width;
int new_width, new_x;
int source, dest, pixel;
int far *header = bitmap;
char far *data = (char far *) bitmap + 4;

	if (xscale == 0) return 0;
	right = header[0];
	bottom = header[1];
	old_width = (right+8) / 8;
	new_width = (old_width + xscale - 1)/xscale;
	header[0] = new_width * 8 - 1;
	for (y = 0; y <= bottom; y++) {
		for (x = new_x = 0; x <= right; x += xscale, new_x++) {
			source = y * old_width + x/8;
			dest = y * new_width + new_x/8;
			pixel = (data[source] >> (7 - (x & 7))) & 1;
			data[dest] &= 0xFF7F >> (new_x & 7);
			data[dest] |= (pixel << (7 - (new_x & 7)));
		}
	}
	return 1;
}


extern int far face[];		/* Image of Anne's face, originally digitised on a Mac */


/********************************************************************
 Display Anne's face on the printer and screen, firstly unscaled (it
 was saved as an image from a CGA screen via getimage), then scaled
 to fit the printer's aspect ratio as near as possible. In between,
 use putimage & getimage, and p_putimage & p_getimage, to swap characters
 from the printer buffer to screen and vice versa. */

void image_demo(void)
{
char imagep[130], imageg[130];
unsigned sizep;
int xaspp, yaspp;
int depth, width, left;

	printf("\n\nPICTURE DRAWING DEMO\n\n");
	width = face[0];
	depth = face[1];
	left = (MAX_WIDTH - width)/2;
	p_setviewport(left, 0, left + width, depth, 1);

	sizep = p_imagesize(50, 20, 60, 30);
	printf("Image size = %u bytes\n", sizep);

	start_screen_output();
	p_putimage(0, 0, face, NOT_PUT);
	end_slice();

#ifdef __TURBOC__
	CLS;
	outtextxy(0,100, "Getimage/putimage swapping screen/printer");
	p_outtextxy(50, 20, "F");
	outtextxy(50, 20, "G");
	p_getimage(50, 20, 60, 30, imagep);
	getimage(50, 20, 60, 30, imageg);
	p_putimage(60, 20, imageg, COPY_PUT);
	putimage(60, 20, imagep, COPY_PUT);
	end_slice();
	CLS;

	p_getaspectratio(&xaspp, &yaspp);
	if (scale_image(face, (int)((12L * xaspp)/(yaspp * 5L)))) {
		outtextxy(0,180, "Printing Scaled image");
		p_outtextxy(0,150, "Scaled");
		p_putimage(0, 0, (char far *)face, NOT_PUT);
		end_slice();
	} else {
		outtextxy(0, 180, "Can't scale image -- Press a key to continue");
		getch();
    }
#else   /* If not Turbo C */
	CLS;
	p_outtextxy(50, 20, "F");
	p_getimage(50, 20, 60, 30, imagep);
    _getimage(50, 20, 60, 30, imageg);
	p_putimage(60, 20, imageg, COPY_PUT);
    _putimage(60, 20, imagep, COPY_PUT);
	end_slice();
	CLS;

	p_getaspectratio(&xaspp, &yaspp);
	if (scale_image(face, (int)((12L * xaspp)/(yaspp * 5L)))) {
		p_outtextxy(0,150, "Scaled");
		p_putimage(0, 0, face, NOT_PUT);
		end_slice();
	} else {
        printf("Can't scale image -- Press a key to continue");
		getch();
	}
#endif
	stop_screen_output();
}

/********************************************************************
 Draw a circular pie chart on the printer, then display it on the
 screen. */

void view_demo(void)
{
	printf("\n\nIMAGE VIEWING DEMO\n\n");
	printf("Viewing Elliptical pie chart, various fill patterns\n");
	draw_elliptical_pie();
	start_screen_output();
	p_view();
#ifdef __TURBOC__
	outtextxy(0, 180, "Press a key to continue");
#else
    printf("Press a key to continue");
#endif
	getch();
	stop_screen_output();
}

/********************************************************************
 Switch screen to graphics mode, and start echoing printer output to
 the screen. */

void start_screen_output(void)
{
#ifdef __TURBOC__
int driver = DETECT, mode;
	detectgraph(&driver,&mode);
	switch(driver) {
	case VGA:
	case EGA:
		driver = CGA;
	case CGA:
		registerbgidriver(CGA_driver);
		mode = CGAHI;
		break;
	case HERCMONO:
		registerbgidriver(Herc_driver);
		mode = HERCMONOHI;
		break;
	case ATT400:
		mode = ATT400HI;
		break;
	case PC3270:
		mode = PC3270HI;
		break;
	case MCGA:
		mode = MCGAHI;
		break;
	}
	initgraph(&driver, &mode, NULL);
	if (driver < 0) {
		printf("BGI Error: %s\n", grapherrormsg(graphresult()));
		exit(1);
	}
#else
	_setvideomode(_HRESBW);
#endif
	_p_putpixel_screen = (void far *) putpixel;
}

/********************************************************************
 Switch screen back to text mode, and stop echoing printer output to
 the screen. */

void stop_screen_output(void)
{
#ifdef __TURBOC__
	closegraph();
#else
	_setvideomode(_DEFAULTMODE);
#endif
	_p_putpixel_screen = NULL;
}

#ifndef __TURBOC__

/********************************************************************
 Output a pixel to the screen */

void far putpixel(int x, int y, int colour)
{
	_setcolor(colour);
	_setpixel(x, y);
}
#endif
#endif
