'  This library is subject to GNU General Library Public License ver. 2 of 
'  June 1991 and any later version. See COPYING.LIB for details.

'$INCLUDE: 'USER.BI'

END

SWErr:
    SWError = TRUE
    RESUME NEXT

TxtCol:
'Begins from 60
DATA 50,  43,  30,  28,  25

Grph:
'X - Begins from 720 (Hercules SCREEN 3)
DATA 640, 320
'Y - Begins from 480
DATA 400, 348, 350, 200

ColorAnsiData:
DATA 0;30,0;34,0;32,0;36,0;31,0;35,0;33,0;37
DATA 1;30,1;34,1;32,1;36,1;31,1;35,1;33,1;37
DATA 5;30,5;34,5;32,5;36,5;31,5;35,5;33,5;37
DATA 1;5;30,1;5;34,1;5;32,1;5;36,1;5;31,1;5;35,1;5;33,1;5;37
DATA 40,44,42,46,41,45,43,47

LibTrap:
    RESUME NEXT

DEFSNG A-Z
FUNCTION Bin$ (Dec%)
    IF Dec% < 0 THEN Dec% = Dec% * -1: Neg% = 1
    b$ = ""

    FOR a% = 15 TO 0 STEP -1
        IF Dec% AND 2 ^ a% THEN BinVal% = 1 ELSE BinVal% = 0
        IF Neg% = 1 THEN
            IF BinVal% = 0 THEN
                b$ = b$ + "1"
            ELSE
                b$ = b$ + "0"
            END IF
        ELSE
            b$ = b$ + LTRIM$(STR$(BinVal%))
        END IF
    NEXT a%
   
    Neg% = 0
    Bin$ = b$

END FUNCTION

SUB Box (BTop%, BLeft%, BHeight%, BWidth%, BorderStyle%, BFColor%, BBColor%, SFColor%, SBColor%, Zoom%, Shadow%, TransShadow%, Title$)
    REDIM FC$(0 TO 31)
    REDIM BC$(0 TO 15)
   
    FFile = FREEFILE
    OPEN "Cons:" FOR OUTPUT SHARED AS FFile
    ON ERROR GOTO LibTrap
   
    IF Shadow% THEN
        RESTORE ColorAnsiData
        FOR a% = 0 TO 31
            READ FC$(a%)
        NEXT a%
                 
        FOR a% = 0 TO 7
            READ BC$(a%)
            BC$(a% + 8) = BC$(a%)
        NEXT a%
                 
        LOCATE BTop% + BHeight% / 2, (BLeft% + BWidth% / 2) - 6
        PRINT #FFile, "[" + FC$(SFColor%) + ";" + BC$(SBColor%) + "m";
        LOCATE BTop% + BHeight% / 2, (BLeft% + BWidth% / 2) - 6
        PRINT SPACE$(12);
    END IF
   

    IF BorderStyle% = 0 THEN
        HT$ = " "
        HB$ = " "
        V$ = " "
        DR$ = " "
        DL$ = " "
        UR$ = " "
        UL$ = " "
    ELSEIF BorderStyle% = 1 THEN
        HT$ = ""
        HB$ = ""
        V$ = ""
        DR$ = ""
        DL$ = ""
        UR$ = ""
        UL$ = ""
    ELSEIF BorderStyle% = 2 THEN
        HT$ = ""
        HB$ = ""
        V$ = ""
        DR$ = ""
        DL$ = ""
        UR$ = ""
        UL$ = ""
    ELSE
        HT$ = ""
        HB$ = ""
        V$ = ""
        DR$ = ""
        DL$ = ""
        UR$ = ""
        UL$ = ""
    END IF
   
    COLOR BFColor%
    COLOR , BBColor%
   
    IF Zoom% <> 0 THEN
        IF Zoom% = 1 THEN
            Z% = BHeight% / 2 - 1
        ELSE
            Z% = BHeight%
        END IF
       
        FOR b% = Z% TO 2 STEP -1
            TTop% = BTop% + b%
            TLeft% = BLeft% + b%
            TWidth% = BWidth% - b% * 2
            THeight% = BHeight% - b% * 2
           
            LOCATE TTop%, TLeft%, 0
            PRINT UR$ + STRING$(TWidth%, HT$) + UL$;
          
            FOR a% = TTop% + 1 TO TTop% + THeight% - 1
                LOCATE a%, TLeft%
                PRINT V$ + SPACE$(TWidth%) + V$;
            NEXT a%
          
            LOCATE TTop% + THeight%, TLeft%
            PRINT DR$ + STRING$(TWidth%, HB$) + DL$;
           
            a# = TIMER
            DO: LOOP UNTIL a# < TIMER
        NEXT b%
    END IF
   
    FOR a% = BTop% + 1 TO BTop% + BHeight% - 1
        LOCATE a%, BLeft%
        PRINT V$ + SPACE$(BWidth% - 2) + V$;
    NEXT a%
   
    LOCATE BTop% + BHeight%, BLeft%
    PRINT DR$ + STRING$(BWidth% - 2, HB$) + DL$;
   
    LOCATE BTop%, BLeft%, 0
    PRINT UR$ + STRING$(BWidth% - 2, HT$) + UL$;
   
    IF Title$ <> "" AND LEN(Title$) < BWidth% - 3 THEN
        LOCATE BTop%, BLeft% + ((BWidth% - LEN(Title$)) / 2) - 1
        PRINT " " + Title$ + " ";
    END IF
   
    IF Shadow% THEN
        COLOR SFColor%
        COLOR , SBColor%
        IF BLeft% + BWidth% < 80 THEN
            FOR a% = BTop% + 1 TO BTop% + BHeight% + 1
                LOCATE a%, BLeft% + BWidth%
                IF TransShadow% THEN
                    a1% = SCREEN(a%, BLeft% + BWidth%)
                    a2% = SCREEN(a%, BLeft% + BWidth% + 1)
                    PRINT "  ";
                    LOCATE a%, BLeft% + BWidth%
                    PRINT #FFile, CHR$(a1%) + CHR$(a2%);
                ELSE
                    PRINT "";
                END IF
            NEXT a%
        END IF
                   
        IF BLeft% + BWidth% <= 81 THEN
            IF TransShadow% THEN
                FOR a% = BLeft% + 2 TO BLeft% + BWidth% - 1
                    a1% = SCREEN(BTop% + BHeight% + 1, a%)
                    LOCATE BTop% + BHeight% + 1, a%
                    PRINT " ";
                    LOCATE BTop% + BHeight% + 1, a%
                    PRINT #FFile, CHR$(a1%);
                NEXT a%
            ELSE
                LOCATE BTop% + BHeight% + 1, BLeft% + 2
                PRINT STRING$(BWidth% - 2, "");
            END IF
        END IF
    END IF
   
    CLOSE #FFile
    COLOR BFColor%
    COLOR , BBColor%

END SUB

SUB Centre (Row%, Text$)
    IF LEN(Text$) > 80 THEN EXIT SUB
    LOCATE Row%, INT((82 - LEN(Text$)) / 2), 0
    PRINT Text$;
END SUB

SUB Centre40 (Row%, Text$)
    IF LEN(Text$) > 40 THEN EXIT SUB
    LOCATE Row%, INT((42 - LEN(Text$)) / 2), 0
    PRINT Text$;
END SUB

SUB Clr (Fore%, Back%)
    COLOR 0, 0
    FOR i% = 13 TO 1 STEP -1
        LOCATE i%, 1: PRINT SPACE$(80);
        LOCATE 26 - i%, 1, 0: PRINT SPACE$(80);
        a# = TIMER
        DO: LOOP WHILE a# + .001 > TIMER
    NEXT i%
  
    COLOR Fore%, Back%
   
    FOR i% = 1 TO 13
        LOCATE i%, 1: PRINT SPACE$(80);
        LOCATE 26 - i%, 1, 0: PRINT SPACE$(80);
        a# = TIMER
        DO: LOOP WHILE a# + .001 > TIMER
    NEXT i%
    CLS
END SUB

FUNCTION Day$
    Z$ = DATE$
    Z$ = MID$(Z$, 4, 2) + "." + LEFT$(Z$, 2) + "." + MID$(Z$, INSTR(4, Z$, "-") + 1)
    Day$ = Z$
END FUNCTION

FUNCTION GetK$ (SChar%, Mode$, EChar%, TimeOut#, Text$)
   
    IF SChar% < 1 OR SChar% > 255 THEN SChar% = 1
    IF EChar% < 1 OR EChar% > 255 THEN EChar% = 255
    IF EChar% < SChar% THEN SWAP EChar%, SChar%
    IF Text$ <> "" THEN PRINT Text$;
    WHILE INKEY$ <> "": WEND
    a# = TIMER

    IF Mode$ = "," THEN
        DO: GOSUB GetKey: LOOP UNTIL e$ = CHR$(SChar%) OR e$ = CHR$(EChar%)
    ELSEIF Mode$ = "-" THEN
        DO: GOSUB GetKey: LOOP UNTIL e$ >= CHR$(SChar%) AND e$ <= CHR$(EChar%)
    ELSE
        DO: GOSUB GetKey: LOOP WHILE e$ = ""
    END IF

    GetK = e$
    EXIT FUNCTION

GetKey:
    e$ = INKEY$
    IF INT(TimeOut#) <> 0 AND a# + TimeOut# <= TIMER THEN EXIT FUNCTION
RETURN

END FUNCTION

SUB Pause (Sec#)
    WHILE INKEY$ <> "": WEND
    IF Sec# <> -1 THEN
        a# = TIMER
        DO: LOOP UNTIL a# + Sec# <= TIMER OR INKEY$ <> ""
    ELSE
        WHILE INKEY$ = "": WEND
    END IF
END SUB

DEFINT A-Z
'Rows is the same as Y
'Cols is the same as X
SUB SM (Rows, Cols, Graphics)
  
    IF NOT Graphics THEN
        SHARED SWError
      
        ON ERROR GOTO SWErr
      
        Col = POS(0)
        Row = CSRLIN

        Cols = 80
        LOCATE , Cols
        IF SWError THEN
            SWError = FALSE
            Cols = 40
        END IF

        RESTORE TxtCol

        Rows = 60
        FOR a = 1 TO 5
            LOCATE Rows
            IF SWError THEN
                SWError = FALSE
                READ Rows
            ELSE
                EXIT FOR
            END IF
        NEXT a
      
        LOCATE Row, Col

        ON ERROR GOTO 0
    ELSE
        RESTORE Grph

        Cols = 720
        FOR a = 1 TO 2
            IF POINT(Cols - 1, 0) THEN
                READ Cols
            ELSE
                EXIT FOR
            END IF
        NEXT a
      
        Rows = 480
        FOR a = 1 TO 4
            IF POINT(0, Rows - 1) THEN
                READ Rows
            ELSE
                EXIT FOR
            END IF
        NEXT a
    END IF
END SUB

DEFSNG A-Z
SUB TextSpeed (Speed%, Text$)
    IF Speed% < 0 THEN Speed% = 0
    IF Speed% > 10000 THEN Speed% = 10000
    FOR a% = 1 TO LEN(Text$)
        PRINT MID$(Text$, a%, 1);
        T# = TIMER
        e$ = INKEY$
        DO: LOOP UNTIL TIMER >= T# + (Speed% / 10000)
    NEXT a%
END SUB

