/*
 EPSHeader

   File: flags.h
   Author: J. Kercheval
   Created: Thu, 09/05/1991  20:15:37
*/
/*
 EPSRevision History

   J. Kercheval  Thu, 09/05/1991  20:17:03  creation
   J. Kercheval  Wed, 09/11/1991  01:41:28  add extern flag for C
   J. Kercheval  Tue, 09/17/1991  19:32:57  add case_sensitive flag
   J. Kercheval  Fri, 10/04/1991  10:43:20  add ck and ci flags
*/

#ifndef FLAGS_HEADER
#define FLAGS_HEADER

#ifndef BOOLEAN
#define BOOLEAN int
#define TRUE 1
#define FALSE 0
#endif


/* tag_type is the tagging method currently in use */
typedef enum {
    C, ASM, MERGE, SORT
} TagType;


/* flag structure for command line flags */
typedef struct FlagStruct {

    /* verbose or no? */
    BOOLEAN quiet;              /* suppress stderr logging messages */

    /* file overwrite on log entry */
    BOOLEAN log_overwrite;

    /* use relative pathnames in output */
    BOOLEAN use_relative_pathnames;

    /* sort the tags output */
    BOOLEAN sort_tags;

    /* use case sensitive sort */
    BOOLEAN case_sensitive;

    /* use an output file */
    BOOLEAN output_file;

    /* the type of parsing which occurs for the current file */
    TagType tag_type;           /* type of tag file */

    /* Assembly element parsing */
    BOOLEAN af;                 /* assembly, procedure labels */
    BOOLEAN al;                 /* assembly, local labels */
    BOOLEAN am;                 /* assembly, macro labels */
    BOOLEAN as;                 /* assembly, struc labels */
    BOOLEAN au;                 /* assembly, union labels */
    BOOLEAN ad;                 /* assembly, data definition labels */

    /* C language element parsing */
    BOOLEAN cf;                 /* C, function calls */
    BOOLEAN cp;                 /* C, prototypes */
    BOOLEAN cm;                 /* C, macros */
    BOOLEAN cs;                 /* C, struct, global */
    BOOLEAN ct;                 /* C, typedef, global */
    BOOLEAN ce;                 /* C, enum, global */
    BOOLEAN ck;                 /* C, enum Konstants, global */
    BOOLEAN cu;                 /* C, union, global */
    BOOLEAN cv;                 /* C, global variables */
    BOOLEAN cc;                 /* C, class, global */
    BOOLEAN cd;                 /* C, macros, defines and constants */
    BOOLEAN cx;                 /* C, extern, global declarations */
    BOOLEAN ci;                 /* C, static, global declarations */

    /* output format options only the last in parameter allowed or used */
    BOOLEAN oe;                 /* epsilon tags format */
    BOOLEAN og;                 /* GNU tags format */
    BOOLEAN os;                 /* space delimited format */
    BOOLEAN om;                 /* MicroSoft Error format */
} Flags;


/*----------------------------------------------------------------------------
 *
 * init_flags() set the initial values of the all option flags in FLAGS struct
 *
 ---------------------------------------------------------------------------*/

void init_flags(Flags * flags);


/*----------------------------------------------------------------------------
 *
 * parse_ASM_flags() set the option flags for ASM command line switch
 *
 ---------------------------------------------------------------------------*/

void parse_ASM_flags(char *argv, Flags * flags);


/*----------------------------------------------------------------------------
 *
 * parse_C_flags() set the option flags for C command line switch
 *
 ---------------------------------------------------------------------------*/

void parse_C_flags(char *argv, Flags * flags);


/*----------------------------------------------------------------------------
 *
 * parse_output_flag() set the option flag for output format, These formats
 * are mutually exclusive from the point of view of this routine.
 *
 ---------------------------------------------------------------------------*/

void parse_output_flags(char *argv, Flags * flags);

#endif                          /* FLAGS_HEADER */
