
{****************************************************** Switch! Demo
******************************************************* Version 2.0
******************************************************* Tab Size:  8
******************************************************* December 19, 1988
******************************************************* Curtis Little
******************************************************* 1087 Murrietta Blvd
*******************************************************                #244
******************************************************* Livermore, CA 94550
*
* NOTES:  This demo was designed for Turbo Pascal.
*
* WARNING:  For this demo the input length is not restricted, and can
* therefore be exceeded, but since you have to compile this and will be
* running it yourself this shouldn't pose a big problem - just don't type
* more characters than allowed in the input fields!
*
}


program Swdemo;

uses CRT;

type cline = string[84];


var
	mmem : integer;
        mprog  : string[84];
        ch     : char;

{$F+}
function Switch(drive : integer; mem : integer; command : cline) : integer;
external;
{$L switchtp}
{$F-}
begin


	writeln( #13#10#10'     This demo demonstrates the usefullness of Switch!.  Switch! is an' );
	writeln( '     assembly function that frees up as much memory as needed to run' );
	writeln( '     another program.  Switch! saves the memory used by your Pascal' );
	writeln( '     application to a temporary disk file (registered versions' );
	writeln( '     of Switch! use EMS if present) then frees it up for use by DOS. It' );
	writeln( '     can free up all but about 11K of available memory!!  To see how' );
	writeln( '     helpful Switch! is this program allows you to specify a program' );
	writeln( '     to run and the amount of memory required by the program.  Use a' );
	writeln( '     map program or CHKDSK to see how much memory you have free before' );
	writeln( '     running this demo.  Then specify CHKDSK as the program to run from' );
	writeln( '     within this demo and specify 0 for the amount of memory required' );
	writeln( '     (a value of 0 causes Switch! to free all memory possible).  You''ll' );
	writeln( '     be amazed how much memory becomes available!' );

	writeln( #10'     Switch! was designed to work with QuickBASIC, MS BASIC, IBM BASIC,' );
	writeln( '     Turbo C, Turbo Pascal 4.0 and above, and Summer ''87 Clipper.' );
	writeln( '     It doesn''t matter how big the program is!  You can free most of' );
	writeln( '     the used memory to run another program!  Using Switch! you can' );
	writeln( '     run a 630K program from within a 640K program by using a simple' );
	writeln( '     function call.  With Switch! there''s no worries about memory!' );
	writeln( #10'     The calling syntax for the Turbo Pascal version of Switch! is:' );
	writeln( #10'     SWITCH(Drive to use, K mem needed, Program to run and parameters)' );

	ch := readkey;

	mmem := 0;

	while mmem >= 0 do begin
		(* get the program name and the amount of memory required *)
		writeln( #13#10'Enter the program to run (leave blank for DOS shell):' );
		write( '>' );
		readln( mprog );
		writeln( #13#10'Enter amount of K RAM required by program (0 for all)' );
		write( '                            (Negative number to quit): ' );
		readln( mmem );

		(* exit the loop if the user wants to quit *)
		if (mmem >= 0) then
			mmem := Switch(0, mmem, mprog);

		(* check for error *)
		if (mmem > 0) then begin
               		writeln( #13#10'Switch!  Error# ', mmem, '  SWDEMO aborted.' );
			halt;
		end;

                if (mmem >= 0) then begin
                   write( #13#10#10'>> Press Any Key to Continue <<' );
		   ch := readkey;
                end;
	end;


	writeln(#13#10#10#10#10'     Switch! only frees up the memory it needs to.  For instance, if you' );
	writeln('     specify the program to run needs 64K Switch! will only save memory' );
	writeln('     if there isn''t already 64K free memory.  Setting the value to the' );
	writeln('     minimum required by the application reduces the time it takes to' );
	writeln('     Switch! applications.  To really get a feel for what Switch! can do' );
	writeln('     for you use the SWITCH.OBJ file to link Switch! into your own' );
	writeln('     applications and use it to call other programs.' );
	writeln(#10'     To register Switch! (and get the source!) please send $20.00 check' );
	writeln('     or money order to:' );
	writeln(#10'                      Curtis Little' );
	writeln('                      1087 Murrietta Blvd #244' );
	writeln('                      Livermore, CA  94550'#13#10#10#10#10#10#10 );

end.

