#ifdef __DJGPP__

#if !defined __vesa_h__
#define __vesa_h__

#include <dpmi.h>

/* You'll notice every structure here has __attribure__ ((packed)) tacked
 * on to the end of it.  The reason for this has to do with the slow down
 * you get when you use unaligned variables on a 386+ processor.   DJGPP,
 * being the great compiler that it is, automatically aligns words on word
 * boundaries, and dwords on dword boundaries.  However, for our purposes
 * here, the structure must be aligned _exactly_ as we tell it to be, so the
 * extra attribute tells DJGPP not to align this data.
 */

#pragma pack(1)

// This is the Vesa information block.  It's 256K for Vesa 1.0 and 512K for
// Vesa 2.0.  We just use a 512K block for everything though, since it's
// simpler.  Also, some 1.0 cards have been known to write over 256K
// anyway, so this is the safer way to do it.
typedef struct {
  char  VESASignature[4]               __attribute__ ((packed));
  short VESAVersion                    __attribute__ ((packed));
  long  OEMStringPtr                   __attribute__ ((packed));
  char  Capabilities[4]                __attribute__ ((packed));
  long  VideoModePtr                   __attribute__ ((packed));
  short TotalMemory                    __attribute__ ((packed));
  short OemSoftwareRev                 __attribute__ ((packed));
  long  OemVendorNamePtr               __attribute__ ((packed));
  long  OemProductNamePtr              __attribute__ ((packed));
  long  OemProductRevPtr               __attribute__ ((packed));
  char  Reserved[222]                  __attribute__ ((packed));
  char  OemData[256]                   __attribute__ ((packed));
} VesaInfo;

/* This is the old Vesa 1.0 structure
typedef struct {
  char    VESASignature[4] PACKED;      // 'VESA' 4 byte signature
  short   VESAVersion PACKED;           // VBE version number
  char    *OEMStringPtr PACKED;         // Pointer to OEM string
  long    Capabilities PACKED;          // Capabilities of video card
  short   *VideoModePtr PACKED;         // Pointer to supported modes
  short   TotalMemory PACKED;           // Number of 64kb memory blocks
  char    reserved[236] PACKED;         // Pad to 256 byte block size
} VesaInfo;
*/

// Vesa mode information block
typedef struct {
  short   ModeAttributes               __attribute__ ((packed)); // Mode attributes
  char    WinAAttributes               __attribute__ ((packed)); // Window A attributes
  char    WinBAttributes               __attribute__ ((packed)); // Window B attributes
  short   WinGranularity               __attribute__ ((packed)); // Window granularity in k
  short   WinSize                      __attribute__ ((packed)); // Window size in k
  short   WinASegment                  __attribute__ ((packed)); // Window A segment
  short   WinBSegment                  __attribute__ ((packed)); // Window B segment
  void    *WinFuncPtr                  __attribute__ ((packed)); // Pointer to window function
  short   BytesPerScanLine             __attribute__ ((packed)); // Bytes per scanline
  short   XResolution                  __attribute__ ((packed)); // Horizontal resolution
  short   YResolution                  __attribute__ ((packed)); // Vertical resolution
  char    XCharSize                    __attribute__ ((packed)); // Character cell width
  char    YCharSize                    __attribute__ ((packed)); // Character cell height
  char    NumberOfPlanes               __attribute__ ((packed)); // Number of memory planes
  char    BitsPerPixel                 __attribute__ ((packed)); // Bits per pixel
  char    NumberOfBanks                __attribute__ ((packed)); // Number of CGA style banks
  char    MemoryModel                  __attribute__ ((packed)); // Memory model type
  char    BankSize                     __attribute__ ((packed)); // Size of CGA style banks
  char    NumberOfImagePages           __attribute__ ((packed)); // Number of images pages
  char    res1                         __attribute__ ((packed)); // Reserved
  char    RedMaskSize                  __attribute__ ((packed)); // Size of direct color red mask
  char    RedFieldPosition             __attribute__ ((packed)); // Bit posn of lsb of red mask
  char    GreenMaskSize                __attribute__ ((packed)); // Size of direct color green mask
  char    GreenFieldPosition           __attribute__ ((packed)); // Bit posn of lsb of green mask
  char    BlueMaskSize                 __attribute__ ((packed)); // Size of direct color blue mask
  char    BlueFieldPosition            __attribute__ ((packed)); // Bit posn of lsb of blue mask
  char    RsvdMaskSize                 __attribute__ ((packed)); // Size of direct color res mask
  char    RsvdFieldPosition            __attribute__ ((packed)); // Bit posn of lsb of res mask
  char    DirectColorModeInfo          __attribute__ ((packed)); // Direct color mode attributes
  // VESA 2.0 specific variables
  long    PhysBasePtr                  __attribute__ ((packed)); // physical address for flat frame buffer
  long    OffScreenMemOffset           __attribute__ ((packed)); // pointer to start of off screen memory
  short   OffScreenMemSize             __attribute__ ((packed)); // amount of off screen memory in 1k units
  char    res2[206]                    __attribute__ ((packed)); // Pad to 256 byte block size
} VesaModeInfo;

// The Vesa 2.0 protected mode interface block
typedef struct {
   unsigned short setWindow            __attribute__ ((packed));
   unsigned short setDisplayStart      __attribute__ ((packed)); 
   unsigned short setPalette           __attribute__ ((packed)); 
   unsigned short IOPrivInfo           __attribute__ ((packed)); 
   // actual code is located here
} VesaProtected;

#pragma pack()

typedef enum {
  memPL       = 3,                // Planar memory model
  memPK       = 4,                // Packed pixel memory model
  memRGB      = 6,                // Direct color RGB memory model
  memYUV      = 7,                // Direct color YUV memory model
} VesaMemModels;

void get_mode_info(int mode, VesaModeInfo *mode_info);

extern VesaInfo card;
extern VesaModeInfo mode;
extern int bytes_per_line;
extern int bytes_per_pixel;
extern int curbank;
extern __dpmi_regs regs;

#endif

#endif
