PROGRAM Simple;

USES PCRobots;

CONST ARENA_WALL=1;

 { Define possible angles of motion
 * x,y are x,y positions on the local map
 * angle is the angle of motion to specify
 }

CONST
     Angle: ARRAY[1..8] OF
     RECORD
           X    : Integer;
           Y    : Integer;
           Angle: Integer;
     END
          = ((X:5; Y:4; Angle:0),
             (X:5; Y:5; Angle:45),
             (X:4; Y:5; Angle:90),
             (X:3; Y:5; Angle:135),
             (X:3; Y:4; Angle:180),
             (X:3; Y:3; Angle:225),
             (X:4; Y:3; Angle:270),
             (X:5; Y:3; Angle:315));



VAR
	Local_Map   : Map_Buffer;                { Buffer to hold the local map }
    X_Pos, Y_Pos: Integer;  	             { Current X and Y coordinates  }
    Go_Dir      : Integer;			 { Current direction (index to angle[]) }
    Scan_Angle  : Integer;
    Range       : Integer;
    Try         : Integer;

    DummyI      : Integer;

BEGIN

	{ Configure robot - all normal settings in this case            }
    { This *MUST* be the first special function called by the robot }

    DummyI := Configure(2,2,2,2,2,0);

    Randomize;
	Go_Dir := Random(8) + 1;		{ Select initial direction }

    WHILE True DO
	BEGIN
		{ Get the current position }
		GetXY(X_Pos, Y_Pos);

		{ Get a map of the local area }
		Get_Local_Map(@Local_Map);

        { Quick and easy way of dealing with the }
        { robot being near an outside wall       }

        IF X_Pos < 20 THEN
			Go_Dir :=((Random(3)-1) MOD 8) + 1;

        IF X_Pos >= 980 THEN
            Go_Dir := random(3)+3;

        IF y_pos < 20 THEN
           go_dir := random(3)+1;

        IF y_pos >= 980 THEN
           go_dir := random(3)+5;

        Try:=0;

		{ Look for a square which hasn't got a wall in it }
		{ (ignore traps in this simple program)           }
		WHILE (local_map[angle[go_dir].y][angle[go_dir].x] = ARENA_WALL)
		  AND (Try <= 10) DO
		BEGIN
			go_dir := random(8) + 1;
            Inc(Try);
            SwapTask;
        END;


		{ Move in the new direction }
		Movement(50,angle[go_dir].angle);


		{ Check if target found, shoot at it if so, }
        { otherwise go to next angle                }

		IF (scan(scan_angle,5, Range)>=0) THEN
			DummyI := shoot(scan_angle,range)
		else
			scan_angle := (scan_angle+5) MOD 360;

    END;

END.
  
