
#include <stdio.h>

#include "luthor.h"
#include "basicdef.h"
#include "basictab.h"

int SubmitChar();

int main(int argc,char **argv)
{
	int lextable,lexstream,t;

    LexInit(0);		/* initialize the lex processor */
    lextable=LexSetObject(&BASICObject);
	if(lextable==LXE_ERROR){
    	fprintf(stderr,"Lex error %d\n",lexerror);
        exit(1);
	}
	
    lexstream=LexInputFunction(lextable,SubmitChar);
    if(lexstream==LXE_ERROR){
    	fprintf(stderr,"Lex error %d\n",lexerror);
        exit(1);
	}
    
    while((t=ThisToken(lexstream)) != EOF){
    	if(!t){
        	printf("token error!\n");
            exit(1);
		}
    	printf("%d\t ",t);
    	if(t==TK_EOL){
        	printf("\\n\n");
		} else {
        	printf("%s\n",ThisTokenText(lexstream));
		}
        if(!AdvanceToken(lexstream)){
        	printf("token error!\n");
            exit(1);
		}
	}
    printf("EOF\n");
    exit(0);
}

char *buffer = "FOR X=1 TO 1000\n\tPRINT X\nNEXT X";

int SubmitChar()
{
	static int x;
    int c;
    
    c=buffer[x];
    if(c){
    	x++;
        return(c);
	} else {
    	return(EOF);
	}
}
