REM Program: Hex Editor v7.0a, Module 4 of 5, PD 2005.
REM Author: Erik Jon Oredson AS. Csci
REM Release: 04/10/2005.
REM Status: Public Domain.
REM Email: eoredson@yahoo.com
REM Urls: www.filegate.net www.simtel.net

REM Marker and Hilighting subroutines.
REM Hex/Dec calculator subroutine.
REM Formatting subroutine.
REM File menu box move subroutine.
REM File menu box file/dir override subroutine.
REM File exclusion subourtine.
REM Path override subroutines.
REM Specialized DIR$ function.

REM Remaining small subroutines:
REM  LseekFile()
REM  ReadFile()
REM  Writefile()
REM  LockedFile()
REM  LocateCursor()
REM  LocateCursor2()
REM  LocateHilightCursor()
REM  BytePrint()
REM  DisplayPosition()
REM  ClearStatus()
REM  DisplayFilename()
REM  DisplayFileTitle()
REM  DisplayPageByte()
REM  ResetHilightBytes()
REM  ResetBytes()
REM  RestoreHilightBytes()
REM  ResetByte()
REM  ClearPageByte()
REM  ClearHilightByte()
REM  DisplayHilightByte()
REM  DisplayStatus1()
REM  DisplayStatus2()
REM  DisplayStatusLine()
REM  PromptKey()
REM  DisplayHexPage()
REM  RedrawRightWindow()
REM  RedrawWindow1()
REM  RedrawWindow2()
REM  PressKey()
REM  CheckASCIIValue(S$)
REM  CheckString(S$)
REM  CheckHexValue(S$)
REM  FormatPosition2(V%)
REM  AsciiToHex1(S$)
REM  AsciiToHex2(S$)
REM  CheckAsciiBytes(S$)
REM  CheckHexBytes(S$)

' get include file.
REM $INCLUDE: 'hexedit.inc'

REM Marker routines:

SUB Marker(Var)
' declare error trap.
ON LOCAL ERROR GOTO Error.Routine1

IF Var = 1 THEN GOTO ListMarkerRange
IF Var = 2 THEN GOTO AddMarker
IF Var = 3 THEN GOTO AddSpecificMarker
IF Var = 4 THEN GOTO DeleteMarker
IF Var = 5 THEN GOTO DeleteSpecificMarker
IF Var = 6 THEN GOTO JumpPreviousMarker
IF Var = 7 THEN GOTO JumpCurrentMarker
IF Var = 8 THEN GOTO JumpNextMarker
IF Var = 9 THEN GOTO JumpSpecificMarker
IF Var = 10 THEN GOTO ListAllMarkers
IF Var = 11 THEN GOTO ListSpecificMarker
IF Var = 12 THEN GOTO ListMarkersOfValue
IF Var = 13 THEN GOTO DeleteMarkerRange
IF Var = 14 THEN GOTO DeleteAllMarkers
IF Var = 15 THEN GOTO DeleteMarkersOfValue
EXIT SUB

TopProgram:
EXIT SUB

AddMarker:
 TempPosition3 = FilePosition
 GOSUB AddMarkerValue
 EXIT SUB

AddMarkerValue:
 IF CurrentUndo >= 32767 THEN
    StatusMessage = "Maximum markers are at 32,767."
    CALL DisplayStatus2
    RETURN
 END IF
 IF MarkerCount < 32767 THEN
    MarkerCount = MarkerCount + 1
    MarkerFile.Markers1(CurrentFile) = TempPosition3
    PUT #7, MarkerCount, MarkerFile
    CurrentMarker = MarkerCount
 END IF
 RETURN

AddSpecificMarker:
 Call ClearStatus
 PRINTf "Enter file position"
 INPUT ByteString$
 IF UCASE$(LEFT$(ByteString$, 1)) = "H" THEN
    CALL CheckHexValue(ByteString$)
    IF ValidHexValue = False THEN
       EXIT SUB
    END IF
    TempPosition3 = HexValue
 ELSE
    CALL CheckASCIIValue(ByteString$)
    IF ValidASCIIValue = False THEN
       EXIT SUB
    END IF
    TempPosition3 = ASCIIValue3
 END IF
 IF TempPosition3 >= 1 AND TempPosition3 <= FileLength THEN
    GOSUB AddMarkerValue
    CALL LocateCursor2
    CALL DisplayFilename
    EXIT SUB
 END IF
 StatusMessage = "Invalid file position."
 CALL DisplayStatus2
 EXIT SUB

DeleteMarker:
 IF CurrentMarker >= 1 AND CurrentMarker <= MarkerCount THEN
    MarkerFile.Markers1(CurrentFile) = False
    PUT #7, CurrentMarker, MarkerFile
 END IF
 EXIT SUB

DeleteSpecificMarker:
 Call ClearStatus
 PRINTf "Enter marker number"
 INPUT ByteString$
 IF LEN(ByteString$) THEN
    IF UCASE$(LEFT$(ByteString$, 1)) = "H" THEN
       ByteString$ = "&" + ByteString$
    END IF
    MarkerPosition = INT(VAL(ByteString$))
    IF MarkerPosition >= 1 AND MarkerPosition <= MarkerCount THEN
       MarkerFile.Markers1(CurrentFile) = False
       PUT #7, MarkerPosition, MarkerFile
       CALL LocateCursor2
       CALL DisplayFilename
       EXIT SUB
    END IF
 END IF
 StatusMessage = "Invalid marker number."
 CALL DisplayStatus2
 EXIT SUB

JumpPreviousMarker:
 NewMarker = CurrentMarker
 DO
    IF NewMarker <= 1 THEN
       EXIT SUB
    END IF
    NewMarker = NewMarker - 1
    IF Markers#(NewMarker) > 0# THEN
       CurrentMarker = NewMarker
       EXIT DO
    END IF
 LOOP
 GOTO JumpCurrentMarker

JumpNextMarker:
 NewMarker = CurrentMarker
 DO
    IF NewMarker >= MarkerCount THEN
       EXIT SUB
    END IF
    NewMarker = NewMarker + 1
    IF Markers#(NewMarker) > 0# THEN
       CurrentMarker = NewMarker
       EXIT DO
    END IF
 LOOP
 GOTO JumpCurrentMarker

JumpSpecificMarker:
 Call ClearStatus
 PRINTf "Enter marker number"
 INPUT ByteString$
 IF LEN(ByteString$) THEN
    IF UCASE$(LEFT$(ByteString$, 1)) = "H" THEN
       ByteString$ = "&" + ByteString$
    END IF
    MarkerPosition = INT(VAL(ByteString$))
    IF MarkerPosition >= 1 AND MarkerPosition <= MarkerCount THEN
       IF Markers#(MarkerPosition) > 0# THEN
          CurrentMarker = MarkerPosition
          GOTO JumpCurrentMarker
       END IF
    END IF
 END IF
 StatusMessage = "Invalid marker number."
 CALL DisplayStatus2
 EXIT SUB

JumpCurrentMarker:
 IF CurrentMarker >= 1 AND CurrentMarker <= MarkerCount THEN
    TempPosition = Markers#(CurrentMarker)
    IF TempPosition >= 1 AND TempPosition <= FileLength THEN
       IF TempPosition <> FilePosition THEN
          CALL ClearPageByte
          LastPage = FilePage
          FilePosition = TempPosition
          CALL CalculatePosition1
          IF LastPage <> FilePage THEN
             CALL DisplayHexPage
          END IF
          CALL DisplayPageByte
       END IF
    END IF
 END IF
 CALL DisplayFilename
 EXIT SUB

ListAllMarkers:
 CALL DisplayScreen2
 COLORf White
 LOCATEf 2, 2, 0
 PRINTf "Marker list:"
 PageCount = False
 CountFlag = False
 Var2 = 2
 FOR MarkerPosition = 1 TO MarkerCount
    IF Markers#(MarkerPosition) > 0# THEN
       PageCount = PageCount + 1
       CountFlag = True
       COLORf Yellow
       Var2 = Var2 + 1
       LOCATEf Var2, 2, 0
       CALL FormatPosition2(2)
       IF PageCount >= 20 THEN
          PageCount = False
          LOCATEf 23, 2, 0
          CALL PressKey
          CALL DisplayScreen2
          COLORf White
          LOCATEf 2, 2, 0
          PRINTf "Marker list:"
          Var2 = 2
       END IF
    END IF
 NEXT
 IF CountFlag = False THEN
    COLORf Yellow
    LOCATEf 3, 2, 0
    PRINTf "No markers stored."
    LOCATEf 23, 2, 0
    CALL PressKey
 END IF
 IF PageCount > False THEN
    LOCATEf 23, 2, 0
    CALL PressKey
 END IF
 EXIT SUB

ListSpecificMarker:
 Call ClearStatus
 PRINTf "Enter marker number"
 INPUT ByteString$
 IF LEN(ByteString$) THEN
    IF UCASE$(LEFT$(ByteString$, 1)) = "H" THEN
       ByteString$ = "&" + ByteString$
    END IF
    MarkerPosition = INT(VAL(ByteString$))
    IF MarkerPosition >= 1 AND MarkerPosition <= MarkerCount THEN
       Call ClearStatus
       CALL FormatPosition2(1)
       CALL LocateCursor2
       CALL PromptKey
       CALL DisplayFilename
       EXIT SUB
    END IF
 END IF
 StatusMessage = "Invalid marker number."
 CALL DisplayStatus2
 EXIT SUB

ListMarkersOfValue:
 Call ClearStatus
 PRINTf "Enter marker value"
 INPUT ByteString$
 IF UCASE$(LEFT$(ByteString$, 1)) = "H" THEN
    CALL CheckHexValue(ByteString$)
    IF ValidHexValue = False THEN
       EXIT SUB
    END IF
    TempPosition1 = HexValue
 ELSE
    CALL CheckASCIIValue(ByteString$)
    IF ValidASCIIValue = False THEN
       EXIT SUB
    END IF
    TempPosition1 = ASCIIValue3
 END IF
 CALL DisplayScreen2
 COLORf White
 LOCATEf 2, 2, 0
 PRINTf "Marker list:"
 PageCount = False
 CountFlag = False
 Var2 = 2
 FOR MarkerPosition = 1 TO MarkerCount
    IF Markers#(MarkerPosition) = TempPosition1 THEN
       PageCount = PageCount + 1
       CountFlag = True
       COLORf Yellow
       Var2 = Var2 + 1
       LOCATEf Var2, 2, 0
       CALL FormatPosition2(2)
       IF PageCount >= 20 THEN
          PageCount = False
          LOCATEf 23, 2, 0
          CALL PressKey
          CALL DisplayScreen2
          COLORf White
          LOCATEf 2, 2, 0
          PRINTf "Marker list:"
          Var2 = 2
       END IF
    END IF
 NEXT
 IF CountFlag = False THEN
    COLORf Yellow
    LOCATEf 3, 2, 0
    PRINTf "No markers of value stored."
    LOCATEf 23, 2, 0
    CALL PressKey
 END IF
 IF PageCount > False THEN
    LOCATEf 23, 2, 0
    CALL PressKey
 END IF
 EXIT SUB

ListMarkerRange:
 Call ClearStatus
 PRINTf "Enter beginning marker number"
 INPUT ByteString$
 IF LEN(ByteString$) THEN
    IF UCASE$(LEFT$(ByteString$, 1)) = "H" THEN
       ByteString$ = "&" + ByteString$
    END IF
    MarkerPosition1 = INT(VAL(ByteString$))
    IF MarkerPosition1 >= 1 AND MarkerPosition1 <= MarkerCount THEN
       Call ClearStatus
       PRINTf "Enter ending marker number"
       INPUT ByteString$
       IF LEN(ByteString$) THEN
          IF UCASE$(LEFT$(ByteString$, 1)) = "H" THEN
             ByteString$ = "&" + ByteString$
          END IF
          MarkerPosition2 = INT(VAL(ByteString$))
          IF MarkerPosition2 >= 1 AND MarkerPosition2 <= MarkerCount THEN
             CALL DisplayScreen2
             COLORf White
             LOCATEf 2, 2, 0
             PRINTf "Marker list:"
             PageCount = False
             CountFlag = False
             Var2 = 2
             FOR MarkerPosition = MarkerPosition1 TO MarkerPosition2
                IF Markers#(MarkerPosition) > 0# THEN
                   PageCount = PageCount + 1
                   CountFlag = True
                   COLORf Yellow
                   Var2 = Var2 + 1
                   LOCATEf Var2, 2, 0
                   CALL FormatPosition2(2)
                   IF PageCount >= 20 THEN
                      PageCount = False
                      LOCATEf 23, 2, 0
                      CALL PressKey
                      CALL DisplayScreen2
                      COLORf White
                      LOCATEf 2, 2, 0
                      PRINTf "Marker list:"
                      Var2 = 2
                   END IF
                END IF
             NEXT
             IF CountFlag = False THEN
                COLORf Yellow
                LOCATEf 3, 2, 0
                PRINTf "No markers stored."
                LOCATEf 23, 2, 0
                CALL PressKey
             END IF
             IF PageCount > False THEN
                LOCATEf 23, 2, 0
                CALL PressKey
             END IF
             ValidFunction = True
             EXIT SUB
          END IF
       END IF
    END IF
 END IF
 ValidFunction = False
 StatusMessage = "Invalid marker range."
 CALL DisplayStatus2
 EXIT SUB

DeleteMarkerRange:
 Call ClearStatus
 PRINTf "Enter beginning marker number"
 INPUT ByteString$
 IF LEN(ByteString$) THEN
    IF UCASE$(LEFT$(ByteString$, 1)) = "H" THEN
       ByteString$ = "&" + ByteString$
    END IF
    MarkerPosition1 = INT(VAL(ByteString$))
    IF MarkerPosition1 >= 1 AND MarkerPosition1 <= MarkerCount THEN
       Call ClearStatus
       PRINTf "Enter ending marker number"
       INPUT ByteString$
       IF LEN(ByteString$) THEN
          IF UCASE$(LEFT$(ByteString$, 1)) = "H" THEN
             ByteString$ = "&" + ByteString$
          END IF
          MarkerPosition2 = INT(VAL(ByteString$))
          IF MarkerPosition2 >= 1 AND MarkerPosition2 <= MarkerCount THEN
             FOR MarkerPosition = MarkerPosition1 TO MarkerPosition2
                MarkerFile.Markers1(CurrentFile) = False
                PUT #7, MarkerPosition, MarkerFile
             NEXT
             StatusMessage = "Range of markers deleted."
             CALL DisplayStatus2
             EXIT SUB
          END IF
       END IF
    END IF
 END IF
 StatusMessage = "Invalid marker range."
 CALL DisplayStatus2
 EXIT SUB

DeleteAllMarkers:
 CurrentMarker = False
 MarkerCount = False
 StatusMessage = "All markers deleted."
 CALL DisplayStatus2
 EXIT SUB

DeleteMarkersOfValue:
 Call ClearStatus
 PRINTf "Enter marker value"
 INPUT ByteString$
 IF LEN(ByteString$) THEN
    IF UCASE$(LEFT$(ByteString$, 1)) = "H" THEN
       CALL CheckHexValue(ByteString$)
       IF ValidHexValue = False THEN
          EXIT SUB
       END IF
       TempPosition1 = HexValue
    ELSE
       CALL CheckASCIIValue(ByteString$)
       IF ValidASCIIValue = False THEN
          EXIT SUB
       END IF
       TempPosition1 = ASCIIValue3
    END IF
    FOR MarkerPosition = 1 TO MarkerCount
       IF Markers#(MarkerPosition) = TempPosition1 THEN
          MarkerFile.Markers1(CurrentFile) = False
          PUT #7, MarkerPosition, MarkerFile
       END IF
    NEXT
 END IF
 StatusMessage = "All markers of value deleted."
 CALL DisplayStatus2
 EXIT SUB

' critical error trap.
Error.Routine1:
 ErrorTrap = ERR
 IF ScreenDrawn THEN
    CLS
 END IF
 ScreenDrawn = False
 COLORf White
 LOCATEf Csrlin, 1, 0
 PRINTf "Hex Editor Marker " + Version + " " + Release + " critical error trap:"
 COLORf Yellow
 LOCATEf Csrlin+1, 1, 0
 CALL DisplayCriticalError(ErrorTrap)
 ' display error prompt.
 COLORf Green
 LOCATEf Csrlin+1, 1, 0
 PRINTf "Press R(etry), C(ontinue), Q(uit):"
 LOCATEf Csrlin, 35, 1
 ' get keypress.
 DO
    ErrorRespond$ = Nul
    DO
       ErrorRespond$ = INKEY$
       IF LEN(ErrorRespond$) THEN
          EXIT DO
       END IF
    LOOP
    ' parse key.
    SELECT CASE LCASE$(ErrorRespond$)
    CASE "r"
       PRINTf "r"
       LOCATEf Csrlin+1, 1, 0
       RESUME TopProgram
    CASE "c"
       PRINTf "c"
       LOCATEf Csrlin+1, 1, 0
       RESUME TopProgram
    CASE "q"
       PRINTf "q"
       LOCATEf Csrlin+1, 1, 0
       RESUME TopProgram
    END SELECT
 LOOP
END SUB

' process left mouse button drag. also includes shift-<key> hilighting.
SUB MouseButton1Drag(Var)
 ON LOCAL ERROR GOTO Error.Routine2
 IF Var = 0 THEN GOTO DragMouse
 IF Var = 1 THEN GOTO ShiftLeftKey
 IF Var = 2 THEN GOTO ShiftRightKey
 IF Var = 3 THEN GOTO ShiftUpKey
 IF Var = 4 THEN GOTO ShiftDownKey
 IF Var = 5 THEN GOTO ShiftPageUpKey
 IF Var = 6 THEN GOTO ShiftPageDownKey
 IF Var = 7 THEN GOTO ShiftEndKey
 IF Var = 8 THEN GOTO ShiftHomeKey
 IF Var = 9 THEN GOTO DragMousePageUp
 IF Var = 10 THEN GOTO DragMousePageDown
 EXIT SUB

REM Hilighting key routines:

' move hilight area left.
ShiftLeftKey:
 IF FilePosition = 1 THEN
    GOSUB StoreHilight
 ELSE
    IF PageColumn - 1 >= 1 THEN
       GOSUB StoreHilight
       IF CopyPositionEnd - 1 >= CopyPositionPivot THEN
          CALL ClearHilightByte
          PageColumn = PageColumn - 1
          FilePosition = FilePosition - 1
          CopyPositionEnd = CopyPositionEnd - 1
       ELSE
          IF CopyPositionStart - 1 <= CopyPositionPivot THEN
             PageColumn = PageColumn - 1
             FilePosition = FilePosition - 1
             CopyPositionStart = CopyPositionStart - 1
          ELSE
             EXIT SUB
          END IF
       END IF
    END IF
 END IF
 CALL DisplayHilightByte
 CALL LocateHilightCursor
 EXIT SUB

' move hilight area right.
ShiftRightKey:
 IF FilePosition = FileLength THEN
    GOSUB StoreHilight
 ELSE
    IF PageColumn = 20 THEN
       GOSUB StoreHilight
    ELSE
       IF PageColumn + 1 <= 20 THEN
          IF FilePosition + 1 <= FileLength THEN
             IF CopyPositionStart = DFalse THEN
                GOSUB StoreHilight
             ELSE
                IF CopyPositionStart + 1 <= CopyPositionPivot THEN
                   CALL ClearHilightByte
                   PageColumn = PageColumn + 1
                   FilePosition = FilePosition + 1
                   CopyPositionStart = CopyPositionStart + 1
                ELSE
                   IF CopyPositionEnd + 1 >= CopyPositionPivot THEN
                      PageColumn = PageColumn + 1
                      FilePosition = FilePosition + 1
                      CopyPositionEnd = CopyPositionEnd + 1
                   ELSE
                      EXIT SUB
                   END IF
                END IF
             END IF
          END IF
       END IF
    END IF
 END IF
 CALL DisplayHilightByte
 CALL LocateHilightCursor
 EXIT SUB

' move hilight area up.
ShiftUpKey:
 IF PageRow - 1 >= 1 THEN
    GOSUB StoreHilight
    IF CopyPositionEnd > CopyPositionPivot THEN
       IF CopyPositionEnd - 20 >= CopyPositionPivot THEN
          Temp# = FilePosition
          Temp2# = PageRow
          FOR FilePosition = CopyPositionEnd TO CopyPositionEnd - 20 STEP -1
             CALL CalculatePosition1
             CALL ClearHilightByte
          NEXT
          PageRow = Temp2# - 1
          FilePosition = Temp# - 20
          CopyPositionEnd = CopyPositionEnd - 20
          CALL CalculatePosition1
          CALL DisplayHilightByte
          CALL LocateHilightCursor
       ELSE
          IF CopyPositionEnd - 20 < CopyPositionPivot THEN
             Temp# = FilePosition
             Temp2# = PageRow
             FOR FilePosition = CopyPositionPivot TO CopyPositionEnd
                CALL CalculatePosition1
                CALL ClearHilightByte
             NEXT
             CopyPositionStart = CopyPositionEnd - 20
             CopyPositionEnd = CopyPositionPivot
             FOR FilePosition = CopyPositionStart TO CopyPositionPivot 
                CALL CalculatePosition1
                CALL DisplayHilightByte
             NEXT
             PageRow = Temp2# - 1
             FilePosition = Temp# - 20
             CALL CalculatePosition1
             CALL DisplayHilightByte
             CALL LocateHilightCursor
          END IF
       END IF
    ELSE
       Temp# = FilePosition
       Temp2# = PageRow
       FOR FilePosition = CopyPositionStart - 20 TO CopyPositionStart
          CALL CalculatePosition1
          CALL DisplayHilightByte
       NEXT
       CopyPositionStart = CopyPositionStart - 20
       PageRow = Temp2# - 1
       FilePosition = Temp# - 20
       CALL CalculatePosition1
       CALL DisplayHilightByte
       CALL LocateHilightCursor
    END IF
 END IF
 EXIT SUB

' move hilight area down.
ShiftDownKey:
 IF PageRow + 1 <= 16 THEN
    IF FilePosition + 20 <= FileLength THEN
       GOSUB StoreHilight
       IF CopyPositionStart < CopyPositionPivot THEN
          Temp# = FilePosition
          Temp2# = PageRow
          IF CopyPositionStart + 20 < CopyPositionPivot THEN
             FOR FilePosition = CopyPositionStart TO CopyPositionStart + 20
                CALL CalculatePosition1
                CALL ClearHilightByte
             NEXT
             PageRow = Temp2# + 1
             FilePosition = Temp# + 20
             CopyPositionStart = CopyPositionStart + 20
             CALL DisplayHilightByte
             CALL LocateHilightCursor
          ELSE
             FOR FilePosition = CopyPositionStart TO CopyPositionPivot
                CALL CalculatePosition1
                CALL ClearHilightByte
             NEXT
             CopyPositionStart = CopyPositionPivot
             CopyPositionEnd = Temp# + 20
             FOR FilePosition = CopyPositionPivot TO CopyPositionEnd
                CALL CalculatePosition1
                CALL DisplayHilightByte
             NEXT
             PageRow = Temp2# + 1
             FilePosition = CopyPositionEnd
             CALL DisplayHilightByte
             CALL LocateHilightCursor
          END IF
       ELSE
          IF CopyPositionEnd >= CopyPositionPivot THEN
             Temp# = FilePosition
             Temp2# = PageRow
             FOR FilePosition = CopyPositionEnd TO CopyPositionEnd + 20
                CALL CalculatePosition1
                CALL DisplayHilightByte
             NEXT
             PageRow = Temp2# + 1
             FilePosition = Temp# + 20
             CopyPositionEnd = CopyPositionEnd + 20
             CALL DisplayHilightByte
             CALL LocateHilightCursor
          END IF
       END IF
    END IF
 END IF
 EXIT SUB

' move hilight area up one page.
ShiftPageUpKey:
 ' check there is a page to move up.
 IF FilePosition - 320 >= 1 THEN
    GOSUB StoreHilight
    ' move copypositionstart up one page.
    IF CopyPositionEnd = CopyPositionPivot THEN
       FilePage = FilePage - 1
       FilePosition = FilePosition - 320
       CopyPositionStart = CopyPositionStart - 320
    ELSE
       IF CopyPositionEnd > CopyPositionPivot THEN
          ' move copypositionend up one page before pivot.
          IF CopyPositionEnd - 320 < CopyPositionPivot THEN
             FilePage = FilePage - 1
             FilePosition = FilePosition - 320
             CopyPositionStart = FilePosition
             CopyPositionEnd = CopyPositionPivot
          ELSE
             ' move copypositionend up one page.
             IF CopyPositionEnd - 320 >= CopyPositionPivot THEN
                FilePage = FilePage - 1
                FilePosition = FilePosition - 320
                CopyPositionEnd = CopyPositionEnd - 320
             END IF
          END IF
       END IF
    END IF
 ELSE
    ' check there is a first position on the first page to move up to.
    IF FilePosition > 1 THEN
       GOSUB StoreHilight
       PageRow = 1
       PageColumn = 1
       FilePosition = 1
       CopyPositionStart = 1
       CopyPositionEnd = CopyPositionPivot
    ELSE
       EXIT SUB
    END IF
 END IF
 CALL CalculatePosition1
 CALL DisplayHexPage
 Reset1 = False
 CALL ResetByte
 CALL DisplayHilightByte
 CALL LocateHilightCursor
 EXIT SUB

' move hilight area down one page.
ShiftPageDownKey:
 ' check there is a page to move down.
 IF FilePosition + 320 <= FileLength THEN
    GOSUB StoreHilight
    ' move copypositionend down one page.
    IF CopyPositionStart = CopyPositionPivot THEN
       FilePage = FilePage + 1
       FilePosition = FilePosition + 320
       CopyPositionEnd = CopyPositionEnd + 320
    ELSE
       IF CopyPositionStart < CopyPositionPivot THEN
          ' move copypositionstart down one page after pivot.
          IF CopyPositionStart + 320 <= CopyPositionPivot THEN
             FilePage = FilePage + 1
             FilePosition = FilePosition + 320
             CopyPositionStart = FilePosition
             CopyPositionEnd = CopyPositionPivot
          ELSE
             ' move copypositionstart down one page.
             IF CopyPositionStart + 320 > CopyPositionPivot THEN
                FilePage = FilePage + 1
                FilePosition = FilePosition + 320
                CopyPositionStart = CopyPositionPivot
                CopyPositionEnd = FilePosition
             END IF
          END IF
       END IF
    END IF
 ELSE
    ' check there is a last position on the last page to move down to.
    IF FilePosition < FileLength THEN
       GOSUB StoreHilight
       FilePosition = FileLength
       CopyPositionStart = CopyPositionPivot
       CopyPositionEnd = FileLength
    ELSE
       EXIT SUB
    END IF
 END IF
 CALL CalculatePosition1
 CALL DisplayHexPage
 Reset1 = False
 CALL ResetByte
 CALL DisplayHilightByte
 CALL LocateHilightCursor
 EXIT SUB

' move hilight area to end of line.
ShiftEndKey:
 ' set to column 20
 IF PageColumn < 20 THEN
    ' check column 20 is positioned before end of file
    GOSUB StoreHilight
    IF FilePosition - PageColumn + 20 <= FileLength THEN
       Temp# = FilePosition
       Temp2# = PageColumn
       TempPosition3 = CopyPositionPivot
       CALL CalculatePosition2
       IF PageRow = PageRow2 THEN
          IF Temp# - Temp2# + 20 >= CopyPositionPivot THEN
             FOR FilePosition = Temp# - Temp2# + 1 TO CopyPositionPivot
                CALL CalculatePosition1
                CALL ClearHilightByte
             NEXT
             FOR FilePosition = CopyPositionPivot TO Temp# - Temp2# + 20
                CALL CalculatePosition1
                CALL DisplayHilightByte
             NEXT
          END IF
          CopyPositionEnd = Temp# - Temp2# + 20
          CopyPositionStart = CopyPositionPivot
       ELSE
          IF Temp# - Temp2# + 20 >= CopyPositionPivot THEN
             FOR FilePosition = Temp# TO Temp# - Temp2# + 20
                CALL CalculatePosition1
                CALL DisplayHilightByte
             NEXT
             CopyPositionEnd = Temp# - Temp2# + 20
             CopyPositionStart = CopyPositionPivot
          ELSE
             FOR FilePosition = Temp# TO Temp# - Temp2# + 20
                CALL CalculatePosition1
                CALL ClearHilightByte
             NEXT
             CopyPositionStart = Temp# - Temp2# + 1
             CopyPositionEnd = CopyPositionPivot
          END IF
       END IF
       FilePosition = Temp# - Temp2# + 20
       PageColumn = 20
       CALL DisplayHilightByte
       CALL LocateHilightCursor
    ELSE
       ' last position is end of file.
       Temp# = FilePosition
       Temp2# = PageColumn
       TempPosition3 = CopyPositionPivot
       CALL CalculatePosition2
       IF PageRow = PageRow2 THEN
          IF FileLength >= CopyPositionPivot THEN
             FOR FilePosition = Temp# - Temp2# + 1 TO CopyPositionPivot
                CALL CalculatePosition1
                CALL ClearHilightByte
             NEXT
             FOR FilePosition = CopyPositionPivot TO FileLength
                CALL CalculatePosition1
                CALL DisplayHilightByte
             NEXT
          END IF
       END IF
       FilePosition = FileLength
       CopyPositionEnd = FileLength
       CopyPositionStart = CopyPositionPivot
       CALL CalculatePosition1
       CALL DisplayHilightByte
       CALL LocateHilightCursor
    END IF
 END IF
 EXIT SUB

' move hilight area to start of line.
ShiftHomeKey:
 ' set to column 1
 IF PageColumn > 1 THEN
    GOSUB StoreHilight
    Temp# = FilePosition
    Temp2# = PageColumn
    TempPosition3 = CopyPositionPivot
    CALL CalculatePosition2
    IF PageRow = PageRow2 THEN
       IF Temp# - Temp2# + 1 <= CopyPositionPivot THEN
          FOR FilePosition = CopyPositionPivot TO Temp#
             CALL CalculatePosition1
             CALL ClearHilightByte
          NEXT
          FOR FilePosition = Temp# - Temp2# + 1 TO CopyPositionPivot
             CALL CalculatePosition1
             CALL DisplayHilightByte
          NEXT
       END IF
       CopyPositionStart = Temp# - Temp2# + 1
       CopyPositionEnd = CopyPositionPivot
    ELSE
       IF Temp# - Temp2# + 1 <= CopyPositionPivot THEN
          FOR FilePosition = Temp# - Temp2# + 1 TO Temp#
             CALL CalculatePosition1
             CALL DisplayHilightByte
          NEXT
          CopyPositionStart = Temp# - Temp2# + 1
          CopyPositionEnd = CopyPositionPivot
       ELSE
          FOR FilePosition = Temp# - Temp2# + 1 TO Temp#
             CALL CalculatePosition1
             CALL ClearHilightByte
          NEXT
          CopyPositionEnd = Temp# - Temp2# + 1
          CopyPositionStart = CopyPositionPivot
       END IF
    END IF
    FilePosition = Temp# - Temp2# + 1
    PageColumn = 1
    CALL DisplayHilightByte
    CALL LocateHilightCursor
 END IF
 EXIT SUB

' store inital hilight start
StoreHilight:
 IF CopyPositionStart = DFalse THEN
    CopyPositionStart = FilePosition
    CopyPositionPivot = FilePosition
    CopyPositionEnd = FilePosition
 END IF
 RETURN

REM Mouse hilighting routines:

DragMouse:
 ' check mouse position in screen editing area.
 IF Mouse.Row > 3 AND Mouse.Row < 20 THEN
    IF Mouse.Column >= 6 AND Mouse.Column <= 49 THEN
       ' check initial click is inside editing area.
       IF CopyStart = DFalse THEN
          EXIT SUB
       END IF
       ' check screen character.
       VarX = SCREEN(Mouse.Row, Mouse.Column)
       ' check space.
       IF VarX = 32 THEN
          EXIT SUB
       END IF
       ' check new position.
       IF VarX <> 32 THEN
          ' calculate new position.
          NewPosition = CalculatePosition3
          ' initialize copy area.
          IF CopyPositionStart = DFalse THEN
             CopyPositionStart = CopyStart
             CopyPositionPivot = CopyStart
             CopyPositionEnd = CopyStart
          END IF
          CALL HMouse
          ' check initial click area.
          IF NewPosition = CopyPositionPivot THEN
             FOR TempPosition3 = CopyPositionStart TO CopyPositionEnd
                CALL CalculatePosition2
                IF FilePage2 = FilePage THEN
                   FilePosition = TempPosition3
                   CALL CalculatePosition1
                   COLORf White
                   CALL BytePrint
                END IF
             NEXT
             CopyPositionStart = NewPosition
             CopyPositionEnd = NewPosition
             FilePosition = CopyPositionPivot
             CALL CalculatePosition1
             COLORf2 0, 7
             CALL BytePrint
             COLORf2 7, 0
          END IF
          ' check backwards wrap.
          IF NewPosition < CopyPositionPivot THEN
             IF CopyPositionEnd > CopyPositionPivot THEN
                FOR TempPosition3 = CopyPositionPivot TO CopyPositionEnd
                   CALL CalculatePosition2
                   IF FilePage2 = FilePage THEN
                      FilePosition = TempPosition3
                      CALL CalculatePosition1
                      COLORf White
                      CALL BytePrint
                   END IF
                NEXT
             END IF
             IF NewPosition > CopyPositionStart THEN
                FOR TempPosition3 = CopyPositionStart TO NewPosition
                   CALL CalculatePosition2
                   IF FilePage2 = FilePage THEN
                      FilePosition = TempPosition3
                      CALL CalculatePosition1
                      COLORf White
                      CALL BytePrint
                   END IF
                NEXT
             END IF
             CopyPositionStart = NewPosition
             CopyPositionEnd = CopyPositionPivot
             FOR TempPosition3 = CopyPositionStart TO CopyPositionPivot
                CALL CalculatePosition2
                IF FilePage2 = FilePage THEN
                   FilePosition = TempPosition3
                   CALL CalculatePosition1
                   COLORf2 0, 7
                   CALL BytePrint
                END IF
             NEXT
             COLORf2 7, 0
          END IF
          ' check forwards wrap.
          IF NewPosition > CopyPositionPivot THEN
             IF CopyPositionStart < CopyPositionPivot THEN
                FOR TempPosition3 = CopyPositionStart TO CopyPositionPivot
                   CALL CalculatePosition2
                   IF FilePage2 = FilePage THEN
                      FilePosition = TempPosition3
                      CALL CalculatePosition1
                      COLORf White
                      CALL BytePrint
                   END IF
                NEXT
             END IF
             IF NewPosition < CopyPositionEnd THEN
                FOR TempPosition3 = NewPosition TO CopyPositionEnd
                   CALL CalculatePosition2
                   IF FilePage2 = FilePage THEN
                      FilePosition = TempPosition3
                      CALL CalculatePosition1
                      COLORf White
                      CALL BytePrint
                   END IF
                NEXT
             END IF
             CopyPositionStart = CopyPositionPivot
             CopyPositionEnd = NewPosition
             FOR TempPosition3 = CopyPositionPivot TO CopyPositionEnd
                CALL CalculatePosition2
                IF FilePage2 = FilePage THEN
                   FilePosition = TempPosition3
                   CALL CalculatePosition1
                   COLORf2 0, 7
                   CALL BytePrint
                END IF
             NEXT
             COLORf2 7, 0
          END IF
          ' get new position and locate there.
          FilePosition = NewPosition
          CALL CalculatePosition1
          COLORf2 0, 7
          CALL BytePrint
          COLORf2 7, 0
          CALL DisplayPosition
          CALL LocateCursor
          CALL SMouse
       END IF
    END IF
 END IF
TopProgram1:
 EXIT SUB

REM this variable must be set before a call to dragmouse functions:
'   store mouse timing.
' MouseTime = 1!

' move hilight area up one page.
DragMousePageUp:
 ' check initial click is inside editing area.
 IF CopyStart = DFalse THEN
    EXIT SUB
 END IF
 ' check scrolling interval.
 IF Time1 = SFalse THEN
    Time1 = TimeNow!
 END IF
 IF TimeElapsed(Time1, MouseTime) = SFalse THEN
    EXIT SUB
 END IF
 Time1 = TimeNow!
 ' check drag variables.
 IF CopyPositionEnd = DFalse THEN
    CopyPositionEnd = CopyStart
 END IF
 IF CopyPositionPivot = DFalse THEN
    CopyPositionPivot = CopyPositionEnd
 END IF
 IF CopyPositionStart = DFalse THEN
    CopyPositionStart = (Filepage - 1) * 320 + 1
 END IF
 ' check there is a page to move up.
 IF FilePage - 1 >= 1 THEN
    ' move copypositionstart up one page.
    FilePage = FilePage - 1
    FilePosition = (FilePage - 1) * 320 + 1
    CopyPositionStart = FilePosition
    CALL CalculatePosition1
    CALL DisplayHexPage
    Reset1 = False
    CALL ResetByte
    CALL DisplayHilightByte
    CALL LocateHilightCursor
 END IF
 EXIT SUB

' move hilight area down one page.
DragMousePageDown:
 ' check initial click is inside editing area.
 IF CopyStart = DFalse THEN
    EXIT SUB
 END IF
 ' check scrolling interval.
 IF Time1 = SFalse THEN
    Time1 = TimeNow!
 END IF
 IF TimeElapsed(Time1, MouseTime) = SFalse THEN
    EXIT SUB
 END IF
 Time1 = TimeNow!
 ' check drag variables.
 IF CopyPositionStart = DFalse THEN
    CopyPositionStart = CopyStart
 END IF
 IF CopyPositionPivot = DFalse THEN
    CopyPositionPivot = CopyPositionStart
 END IF
 IF CopyPositionEnd = DFalse THEN
    CopyPositionEnd = (Filepage - 1) * 320 + 320
 END IF
 ' check there is a page to move down.
 FilePage2 = INT((FileLength - 1) / 320) + 1
 IF FilePage + 1 <= FilePage2 THEN
    ' move copypositionend down one page.
    FilePage = FilePage + 1
    FilePosition = (FilePage - 1) * 320 + 320
    IF FilePosition > FileLength THEN
       FilePosition = FileLength
    END IF
    CopyPositionEnd = FilePosition
    CALL CalculatePosition1
    CALL DisplayHexPage
    Reset1 = False
    CALL ResetByte
    CALL DisplayHilightByte
    CALL LocateHilightCursor
 END IF
 EXIT SUB

' critical error trap.
Error.Routine2:
 ErrorTrap = ERR
 IF ScreenDrawn THEN
    CLS
 END IF
 ScreenDrawn = False
 COLORf White
 LOCATEf Csrlin, 1, 0
 PRINTf "Hex Editor MouseButton1Drag " + Version + " " + Release + " critical error trap:"
 COLORf Yellow
 LOCATEf Csrlin+1, 1, 0
 CALL DisplayCriticalError(ErrorTrap)
 ' display error prompt.
 COLORf Green
 LOCATEf Csrlin+1, 1, 0
 PRINTf "Press R(etry), C(ontinue), Q(uit):"
 LOCATEf Csrlin, 35, 1
 ' get keypress.
 DO
    ErrorRespond$ = Nul
    DO
       ErrorRespond$ = INKEY$
       IF LEN(ErrorRespond$) THEN
          EXIT DO
       END IF
    LOOP
    ' parse key.
    SELECT CASE LCASE$(ErrorRespond$)
    CASE "r"
       PRINTf "r"
       LOCATEf Csrlin+1, 1, 0
       RESUME TopProgram1
    CASE "c"
       PRINTf "c"
       LOCATEf Csrlin+1, 1, 0
       RESUME TopProgram1
    CASE "q"
       PRINTf "q"
       LOCATEf Csrlin+1, 1, 0
       RESUME TopProgram1
    END SELECT
 LOOP
END SUB

' realtime hex/dec calculator.
SUB HexCalc
 ON LOCAL ERROR GOTO Error.Routine3
 GOSUB MakeBox ' create edit box.
 CalcBox = 1 ' reset to left box.
 Box$ = "0" ' current box
 Box1$ = "0" ' left box string
 Box2$ = "0" ' right box string
 GOSUB SelectBox2 ' display box 2.
 GOSUB SelectBox1 ' display box 1.
 DO ' calculator loop
    DO ' keystroke loop
       Var$ = INKEY$ ' get keystroke
       IF LEN(Var$) THEN ' check keystroke
          EXIT DO
       END IF
       Var = ReleaseTime ' release mouse timing
    LOOP
    SELECT CASE LEN(Var$)
    CASE 1 ' single ascii key
       SELECT CASE ASC(Var$)
       CASE 8 ' backspace
          IF Ycoor1 - Column3 > False THEN
             Box$ = LEFT$(Box$, Ycoor1 - Column3 - 1) + MID$(Box$, Ycoor1 - Column3 + 1)
             Ycoor1 = Ycoor1 - 1
             LOCATEf Xcoor1, Ycoor1, 1
             Var$ = MID$(Box$, Ycoor1 - Column3 + 1) + " "
             PRINTf Var$
             LOCATEf Xcoor1, Ycoor1, 1
             GOSUB PrintBoxes
          END IF
       CASE 9 ' tab
          IF CalcBox = 1 THEN
             CalcBox = 2
             GOSUB SelectBox2
             GOSUB PrintBoxes
          END IF
       CASE 27 ' escape
          COLORf2 7, 0
          EXIT SUB
       CASE ELSE ' keystroke
          VarX = False
          TempX$ = UCASE$(Var$)
          SELECT CASE TempX$
          CASE "0" TO "9"
             VarX = True
          CASE "A" TO "F"
             IF CalcBox = 1 THEN
                VarX = True
             END IF
          END SELECT
          IF VarX THEN
             IF Ycoor1 - Column3 + 1 <= LineLength THEN
                Box$ = LEFT$(Box$, Ycoor1 - Column3) + TempX$ + MID$(Box$, Ycoor1 - Column3 + 1)
                Box$ = LEFT$(Box$, LineLength)
                LOCATEf Xcoor1, Ycoor1, 1
                Var$ = MID$(Box$, Ycoor1 - Column3 + 1)
                PRINTf TempX$
                Ycoor1 = Ycoor1 + 1
                LOCATEf Xcoor1, Ycoor1, 1
                GOSUB PrintBoxes
             END IF
          END IF
       END SELECT
    CASE 2 ' extended key
       SELECT CASE ASC(RIGHT$(Var$,1))
       CASE 15 ' shift-tab
          IF CalcBox = 2 THEN
             CalcBox = 1
             GOSUB SelectBox1
             GOSUB PrintBoxes
          END IF
       CASE 71 ' home
          Ycoor1 = Column3
       CASE 79 ' end
          Ycoor1 = LEN(Box$) + Column3
       CASE 77 ' right
          IF Ycoor1 - Column3 + 1 <= LEN(Box$) THEN
             Ycoor1 = Ycoor1 + 1
          END IF
       CASE 75 ' left
          IF Ycoor1 - Column3 > False THEN
             Ycoor1 = Ycoor1 - 1
          END IF
       CASE 83 ' delete
          IF Ycoor1 - Column3 + 1 <= LEN(Box$) THEN
             Box$ = LEFT$(Box$, Ycoor1 - Column3) + MID$(Box$, Ycoor1 - Column3 + 2)
             LOCATEf Xcoor1, Ycoor1, 1
             Var$ = MID$(Box$, Ycoor1 - Column3 + 1) + " "
             PRINTf Var$
             LOCATEf Xcoor1, Ycoor1, 1
             GOSUB PrintBoxes
          END IF
       CASE 119 ' control-home
          Ycoor1 = Column3
       CASE 117 ' control-end
          Ycoor1 = LEN(Box$) + Column3
       END SELECT
       LOCATEf Xcoor1, Ycoor1, 1
    END SELECT
 LOOP
 EXIT SUB

' create edit box.
MakeBox:
 COLORf2 14, 1
 LOCATEf 4, 6, 1
 Var$ = " " + CHR$(201) + STRING$(1, 205) + "<esc>=Quit" + STRING$(16, 205) + CHR$(187) + " "
 PRINTf Var$
 LOCATEf 5, 6, 1
 Var$ = " " + CHR$(186) + SPACE$(9) + "Hex" + SPACE$(11) + "Dec " + CHR$(186) + " "
 PRINTf Var$
 LOCATEf 6, 6, 1
 Var$ = " " + CHR$(200) + STRING$(1, 205) + "<tab>/<shift-tab>=switch" + STRING$(2, 205) + CHR$(188) + " "
 PRINTf Var$
 RETURN

' move to box 1 (left box).
SelectBox1:
 Box2$ = Box$ ' store right box.
 Box$ = Box1$ ' reset to left box.

 ' reset editing parameters.
 Xcoor1 = 5
 Ycoor1 = 9
 Column3 = 9
 LineLength = 8

 ' display left box.
 COLORf2 15, 0
 LOCATEf Xcoor1, Ycoor1, 1
 PRINTf SPACE$(8)
 LOCATEf Xcoor1, Ycoor1, 1
 PRINTf Box$
 Ycoor1 = Ycoor1 + LEN(Box$)
 LOCATEf Xcoor1, Ycoor1, 1
 RETURN

' move to box 2 (right box).
SelectBox2:
 Box1$ = Box$ ' store left box.
 Box$ = Box2$ ' reset to right box.

 ' reset editing parameters.
 Xcoor1 = 5
 Ycoor1 = 21
 Column3 = 21
 LineLength = 10

 ' display right box.
 COLORf2 15, 0
 LOCATEf Xcoor1, Ycoor1, 1
 PRINTf SPACE$(10)
 LOCATEf Xcoor1, Ycoor1, 1
 PRINTf Box$
 Ycoor1 = Ycoor1 + LEN(Box$)
 LOCATEf Xcoor1, Ycoor1, 1
 RETURN

' calculates value of current box,
' displays result in calculated form
' in opposite box.
PrintBoxes:
 IF CalcBox = 1 THEN ' is in hex box.
    ' strip leading zeroes for signed bit conversion.
    TempBox$ = Box$
    DO
       IF LEFT$(TempBox$, 1) = "0" THEN
          TempBox$ = MID$(TempBox$, 2)
       ELSE
          EXIT DO
       END IF
    LOOP
    Value# = VAL("&H" + TempBox$) ' retreive decimal value.
    IF Value# < 0# THEN ' check twos-complement from signed value.
       IF LEN(TempBox$) = 8 THEN ' 8000 0000 to FFFF FFFF
          Value# = Value# + 4294967296#
       ELSE
          IF LEN(TempBox$) = 4 THEN ' 8000 to FFFF
             Value# = Value# + 65536
          END IF
       END IF
    END IF
    ' display decimal value.
    Box2$ = MID$(STR$(Value#), 2)
    COLORf2 15, 0
    LOCATEf 5, 21, 1
    PRINTf SPACE$(10)
    LOCATEf 5, 21, 1
    PRINTf Box2$
 END IF
 IF CalcBox = 2 THEN ' is in decimal box.
    Value# = VAL(Box$) ' retreive hex value.
    IF Value# >= 4294967296# THEN ' check overflow.
       COLORf2 15, 0
       LOCATEf 5, 9, 1
       Var$ = "overflow"
       PRINTf Var$
       Box1$ = "0"
    ELSE
       IF Value# > 2147483647# THEN ' force to twos-complement.
          Value# = Value# - 4294967296# ' 8000 0000 to FFFF FFFF
       END IF
       ' display hex value.
       Box1$ = HEX$(Value#)
       COLORf2 15, 0
       LOCATEf 5, 9, 1
       PRINTf SPACE$(8)
       LOCATEf 5, 9, 1
       PRINTf Box1$
    END IF
 END IF
 LOCATEf Xcoor1, Ycoor1, 1
 RETURN
Error.Resume3:
 EXIT SUB
Error.Routine3:
 RESUME Error.Resume3
END SUB

' formatting function.
'   Value$  output string.
'   Var#  input value.
'   Var3  true for filesize.
SUB FormatX(Value$, Var#, Var3)
 ON LOCAL ERROR GOTO Error.Routine4
 Var2# = Var#
 IF Var3 THEN
    SELECT CASE FileSizeType
    CASE 1 ' KB.
       Var# = INT(Var# / 1024#)
    CASE 2 ' MB.
       Var# = INT(Var# / 1048576#)
    END SELECT
 END IF
 Value$ = Nul
 Var4$ = MID$(STR$(Var#), 2)
 FOR Var4 = LEN(Var4$) TO 3 STEP -3
    Value$ = MID$(Var4$, Var4 - 2, 3) + "," + Value$
 NEXT
 IF Var4 > False THEN
    Value$ = MID$(Var4$, 1, Var4) + "," + Value$
 END IF
 IF LEN(Var4$) < 3 THEN
    Value$ = Var4$
 END IF
 IF RIGHT$(Value$, 1) = "," THEN
    Value$ = LEFT$(Value$, LEN(Value$) - 1)
 END IF
 IF Var3 THEN
    SELECT CASE FileSizeType
    CASE 1 ' KB.
       Var2# = Var2# / 1024#
       GOSUB AddPoint
    CASE 2 ' MB.
       Var2# = Var2# / 1048576#
       GOSUB AddPoint
    END SELECT
 END IF
 EXIT SUB
AddPoint:
 V$ = STR$(Var2#)
 V = INSTR(V$, ".")
 IF V THEN
    Value$ = Value$ + MID$(V$, V, 2)
 ELSE
    Value$ = Value$ + ".0"
 END IF
 RETURN
Error.Resume4:
 EXIT SUB
Error.Routine4:
 RESUME Error.Resume4
END SUB

' file menu box move subroutine.
SUB MoveMenu
 ON LOCAL ERROR GOTO Error.Routine5
 GOSUB StoreArea
 COLORf2 White, 1
 CLS
 GOSUB RestoreArea
 I$ = Nul
 DO
    I$ = INKEY$
    IF LEN(I$) THEN
       IF I$ = CHR$(27) THEN
          I$ = Nul
          EXIT DO
       END IF
       IF LEN(I$) = 2 THEN
          SELECT CASE ASC(RIGHT$(I$, 1))
          CASE 72 ' up
             IF Xcoor - 1 >= 2 THEN
                Xcoor = Xcoor - 1
                COLORf2 White, 1
                CLS
                GOSUB RestoreArea
             END IF
          CASE 80 ' down
             IF Xcoor + 1 <= 8 THEN
                Xcoor = Xcoor + 1
                COLORf2 White, 1
                CLS
                GOSUB RestoreArea
             END IF
          CASE 75 ' left
             IF Ycoor - 1 >= 1 THEN
                Ycoor = Ycoor - 1
                COLORf2 White, 1
                CLS
                GOSUB RestoreArea
             END IF
          CASE 77 ' right
             IF Ycoor + 1 <= 39 THEN
                Ycoor = Ycoor + 1
                COLORf2 White, 1
                CLS
                GOSUB RestoreArea
             END IF
          END SELECT
       END IF
    END IF
 LOOP
 EXIT SUB

' store area.
StoreArea:
 RowX1 = False
 ColumnY1 = False
 FOR RowX2 = Xcoor - 1 TO Xcoor + 16
    RowX1 = RowX1 + 1
    ColumnY1 = False
    FOR ColumnY2 = Ycoor TO Ycoor + 41
       ColumnY1 = ColumnY1 + 1
       ' store ascii character.
       Area1(RowX1, ColumnY1) = SCREEN(RowX2, ColumnY2)
       ' store color. (undocumented: also stores background color).
       Area2(RowX1, ColumnY1) = SCREEN(RowX2, ColumnY2, 1)
    NEXT
 NEXT
 RETURN

' restore area.
RestoreArea:
 RowX1 = False
 ColumnY1 = False
 FOR RowX2 = Xcoor - 1 TO Xcoor + 16
    RowX1 = RowX1 + 1
    ColumnY1 = False
    FOR ColumnY2 = Ycoor TO Ycoor + 41
       ColumnY1 = ColumnY1 + 1
       LOCATEf RowX2, ColumnY2, 1
       ' restore color.
       TempZ = Area2(RowX1, ColumnY1)
       ' undocumented: also stores background color.
       VarB = INT(TempZ / 16)
       VarF = TempZ MOD 16
       COLORf2 VarF, VarB
       ' restore ascii character.
       PRINTf CHR$(Area1(RowX1, ColumnY1))
    NEXT
 NEXT
 RETURN
Error.Resume5:
 EXIT SUB
Error.Routine5:
 RESUME Error.Resume5
END SUB

SUB OverridePrompt
 ON LOCAL ERROR GOTO Error.Routine6
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 PRINTf SPACE$(38)
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 COLORf2 White, 0
 PRINTf "Require readonly bit. Press <y/n>:"
 DO
    M$ = Nul
    WHILE M$ = Nul
       M$ = INKEY$
    WEND
    M$ = UCASE$(M$)
    IF M$ = "Y" THEN
       RequireReadOnly = True
       EXIT DO
    END IF
    IF M$ = "N" THEN
       RequireReadOnly = False
       EXIT DO
    END IF
 LOOP
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 PRINTf SPACE$(38)
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 COLORf2 White, 0
 PRINTf "Require hidden bit. Press <y/n>:"
 DO
    M$ = Nul
    WHILE M$ = Nul
       M$ = INKEY$
    WEND
    M$ = UCASE$(M$)
    IF M$ = "Y" THEN
       RequireHidden = True
       EXIT DO
    END IF
    IF M$ = "N" THEN
       RequireHidden = False
       EXIT DO
    END IF
 LOOP
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 PRINTf SPACE$(38)
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 COLORf2 White, 0
 PRINTf "Require system bit. Press <y/n>:"
 DO
    M$ = Nul
    WHILE M$ = Nul
       M$ = INKEY$
    WEND
    M$ = UCASE$(M$)
    IF M$ = "Y" THEN
       RequireSystem = True
       EXIT DO
    END IF
    IF M$ = "N" THEN
       RequireSystem = False
       EXIT DO
    END IF
 LOOP
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 PRINTf SPACE$(38)
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 COLORf2 White, 0
 PRINTf "Require archive bit. Press <y/n>:"
 DO
    M$ = Nul
    WHILE M$ = Nul
       M$ = INKEY$
    WEND
    M$ = UCASE$(M$)
    IF M$ = "Y" THEN
       RequireArchive = True
       EXIT DO
    END IF
    IF M$ = "N" THEN
       RequireArchive = False
       EXIT DO
    END IF
 LOOP
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 PRINTf SPACE$(38)
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 COLORf2 White, 0
 PRINTf "Require dir readonly bit. Press <y/n>:"
 DO
    M$ = Nul
    WHILE M$ = Nul
       M$ = INKEY$
    WEND
    M$ = UCASE$(M$)
    IF M$ = "Y" THEN
       RequireDirReadOnly = True
       EXIT DO
    END IF
    IF M$ = "N" THEN
       RequireDirReadOnly = False
       EXIT DO
    END IF
 LOOP
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 PRINTf SPACE$(38)
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 COLORf2 White, 0
 PRINTf "Require dir hidden bit. Press <y/n>:"
 DO
    M$ = Nul
    WHILE M$ = Nul
       M$ = INKEY$
    WEND
    M$ = UCASE$(M$)
    IF M$ = "Y" THEN
       RequireDirHidden = True
       EXIT DO
    END IF
    IF M$ = "N" THEN
       RequireDirHidden = False
       EXIT DO
    END IF
 LOOP
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 PRINTf SPACE$(38)
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 COLORf2 White, 0
 PRINTf "Require dir system bit. Press <y/n>:"
 DO
    M$ = Nul
    WHILE M$ = Nul
       M$ = INKEY$
    WEND
    M$ = UCASE$(M$)
    IF M$ = "Y" THEN
       RequireDirSystem = True
       EXIT DO
    END IF
    IF M$ = "N" THEN
       RequireDirSystem = False
       EXIT DO
    END IF
 LOOP
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 PRINTf SPACE$(38)
 LOCATEf Xcoor + 1, Ycoor + 2, 1
 COLORf2 White, 0
 PRINTf "Require dir archive bit. Press <y/n>:"
 DO
    M$ = Nul
    WHILE M$ = Nul
       M$ = INKEY$
    WEND
    M$ = UCASE$(M$)
    IF M$ = "Y" THEN
       RequireDirArchive = True
       EXIT DO
    END IF
    IF M$ = "N" THEN
       RequireDirArchive = False
       EXIT DO
    END IF
 LOOP
Error.Resume6:
 EXIT SUB
Error.Routine6:
 RESUME Error.Resume6
END SUB

' routine compares occurrence of filename1$ in filename2$.
'  allows imbedded ? and * characters,
'  also compares ^ character exclusion.
SUB CheckExcluded(Filename1$, Filename2$, Match)
 On Local Error Goto Error.Routine7
 Match = True ' assume mask matches filename2
 Length1 = 1
 Length2 = 1
 DO
    ' global replacement
    IF MID$(Filename1$, Length1, 1) = "*" THEN
       DO
          Length1 = Length1 + 1
          IF Length1 > LEN(Filename1$) THEN
             EXIT SUB
          END IF
          ' global replacement followed by exclusion character
          ' searches remaining string until exclusion character found or not.
          IF MID$(Filename1$, Length1, 1) = "^" THEN
             Length1 = Length1 + 1
             Not.Include$ = MID$(Filename1$, Length1, 1)
             DO
                IF Not.Include$ <> MID$(Filename2$, Length2, 1) THEN
                   Length2 = Length2 + 1
                ELSE
                   Match = False
                   EXIT SUB
                END IF
                IF Length2 > LEN(Filename2$) THEN
                   EXIT SUB
                END IF
             LOOP
          END IF
          ' global replacement followed by ? or another *
          ' skips to next character.
          IF MID$(Filename1$, Length1, 1) <> "*" THEN
             IF MID$(Filename1$, Length1, 1) <> "?" THEN
                EXIT DO
             END IF
          END IF
       LOOP
       ' global replacement
       ' searches for next matching character
       DO
          IF MID$(Filename1$, Length1, 1) = MID$(Filename2$, Length2, 1) THEN
             EXIT DO
          ELSE
             Length2 = Length2 + 1
          END IF
          IF Length2 > LEN(Filename2$) THEN
             EXIT DO
          END IF
       LOOP
    ELSE
       ' character replacement
       ' matches any next character
       IF MID$(Filename1$, Length1, 1) = "?" THEN
          Length1 = Length1 + 1
          Length2 = Length2 + 1
       ELSE
          ' exclusion character
          ' checks next character unmatched
          IF MID$(Filename1$, Length1, 1) = "^" THEN
             Length1 = Length1 + 1
             Not.Include$ = MID$(Filename1$, Length1, 1)
             IF Not.Include$ <> MID$(Filename2$, Length2, 1) THEN
                Length1 = Length1 + 1
                Length2 = Length2 + 1
             ELSE
                Match = False
                EXIT DO
             END IF
          ELSE
             ' matches next character
             IF MID$(Filename1$, Length1, 1) = MID$(Filename2$, Length2, 1) THEN
                Length1 = Length1 + 1
                Length2 = Length2 + 1
             ELSE
                Match = False
                EXIT DO
             END IF
             ' check string lengths
             IF Length1 > LEN(Filename1$) THEN
                IF Length2 <= LEN(Filename2$) THEN
                   Match = False
                END IF
                EXIT DO
             END IF
          END IF
       END IF
    END IF
 LOOP
 EXIT SUB
Error.Resume7:
 Exit Sub
Error.Routine7:
 Resume Error.Resume7
END SUB

SUB Parse.Path(D$, X$)
 On Local Error Goto Error.Routine8
 ' parse out imbedded \.\ path.
 GOSUB PathOverride1
 ' parse out trailing \.. path with multiple dots.
 GOSUB PathOverride2
 ' parse out leading ..\ path with multiple dots.
 GOSUB PathOverride3
 ' parse out leading \..\ path with multiple dots.
 GOSUB PathOverride4
 ' parse out imbedded \..\ path with multiple dots.
 GOSUB PathOverride5
 ' parse out imbedded \\ from path.
 GOSUB PathOverride6
 EXIT SUB

' parse out imbedded \.\ path.
PathOverride1:
 IF LEN(X$) THEN
    DO
       V = INSTR(X$, "\.\")
       IF V THEN
          X$ = LEFT$(X$, V) + MID$(X$, V + 3)
       ELSE
          EXIT DO
       END IF
    LOOP
 END IF
 RETURN

' parse out trailing \.. path with multiple dots.
PathOverride2:
 Z$ = Nul
 IF LEN(X$) THEN
    ' search for trailing path.
    DO
       Z = False
       L = False
       IF RIGHT$(X$, 1) = "." THEN
          FOR V = LEN(X$) TO 1 STEP -1
             IF MID$(X$, V, 1) = "." THEN
                L = L + 1
             ELSE
                IF MID$(X$, V, 1) = "\" THEN
                   Z = True
                   EXIT FOR
                ELSE
                   EXIT FOR
                END IF
             END IF
          NEXT
       END IF
       IF Z = False THEN
          EXIT DO
       END IF
       Z$ = MID$(X$, V) + Z$
       X$ = LEFT$(X$, V - 1)
    LOOP
    IF Z$ = Nul THEN
       ' strip trailing dots.
       IF INSTR(X$, "\") THEN
          DO
             IF RIGHT$(X$, 1) = "." THEN
                X$ = LEFT$(X$, LEN(X$) - 1)
             ELSE
                EXIT DO
             END IF
          LOOP
       END IF
       RETURN
    END IF
    DO
       ' search leading dots.
       L = False
       FOR V = 2 TO LEN(Z$)
          IF MID$(Z$, V, 1) = "." THEN
             L = L + 1
             IF V = LEN(Z$) THEN
                Z$ = Nul
                EXIT FOR
             END IF
          ELSE
             IF MID$(Z$, V, 1) = "\" THEN
                Z$ = MID$(Z$, V)
                EXIT FOR
             END IF
          END IF
       NEXT
       ' strip trailing path.
       DO
          L2 = 1
          Z = False
          FOR V = LEN(X$) TO 1 STEP -1
             IF MID$(X$, V, 1) = "\" THEN
                L2 = L2 + 1
                IF L = L2 THEN
                   Z = True
                   EXIT DO
                END IF
             END IF
          NEXT
          IF Z = False THEN
             EXIT DO
          END IF
       LOOP
       IF Z = False THEN
          X$ = Nul
          EXIT DO
       END IF
       IF V = 1 THEN
          IF LEFT$(X$, 1) = "\" THEN
             X$ = "\"
             EXIT DO
          END IF
       END IF
       X$ = LEFT$(X$, V - 1)
       IF Z$ = Nul THEN
          EXIT DO
       END IF
    LOOP
 END IF
 ' strip trailing dots.
 IF INSTR(X$, "\") THEN
    DO
       IF RIGHT$(X$, 1) = "." THEN
          X$ = LEFT$(X$, LEN(X$) - 1)
       ELSE
          EXIT DO
       END IF
    LOOP
 END IF
 RETURN

' parse out leading ..\ path with multiple dots.
PathOverride3:
 Z$ = D$
 DO
    ' search for leading dots.
    Z = False
    L = False
    IF LEFT$(X$, 1) = "." THEN
       FOR V = 1 TO LEN(X$)
          IF MID$(X$, V, 1) = "." THEN
             L = L + 1
          ELSE
             IF MID$(X$, V, 1) = "\" THEN
                Z = True
                EXIT FOR
             ELSE
                EXIT FOR
             END IF
          END IF
       NEXT
    END IF
    IF Z = False THEN
       EXIT DO
    END IF
    X$ = MID$(X$, V + 1)
    ' parse off trailing path.
    IF L > 1 THEN
    L2 = 1
       DO
          Z = False
          FOR V = LEN(Z$) TO 1 STEP -1
             IF MID$(Z$, V, 1) = "\" THEN
                Z$ = LEFT$(Z$, V - 1)
                L2 = L2 + 1
                Z = True
                EXIT FOR
             END IF
          NEXT
          IF Z = False THEN
             Z$ = Nul
             EXIT DO
          END IF
          IF L2 = L THEN
             EXIT DO
          END IF
       LOOP
    END IF
 LOOP
 D$ = Z$
 RETURN

' parse out leading \..\ path with multiple dots.
PathOverride4:
 DO
    IF LEFT$(X$, 1) = "\" THEN
       IF LEN(X$) = 1 THEN
          EXIT DO
       END IF
       L = False
       FOR V = 2 TO LEN(X$)
          IF MID$(X$, V, 1) = "." THEN
             L = L + 1
          ELSE
             IF MID$(X$, V, 1) = "\" THEN
                IF L > 0 THEN
                   X$ = MID$(X$, V)
                   EXIT FOR
                END IF
             END IF
             EXIT DO
          END IF
       NEXT
    ELSE
       EXIT DO
    END IF
 LOOP
 RETURN

' parse out imbedded \..\ path with multiple dots.
PathOverride5:
 IF LEN(X$) THEN
    DO
       ' search for \.\
       Z = False
       FOR V = 1 TO LEN(X$)
          IF MID$(X$, V, 1) = "\" THEN
             L = False
             FOR V2 = V + 1 TO LEN(X$)
                IF MID$(X$, V2, 1) = "." THEN
                   L = L + 1
                ELSE
                   IF MID$(X$, V2, 1) = "\" THEN
                      IF L > 0 THEN
                         Z = True
                      END IF
                      EXIT FOR
                   ELSE
                      EXIT FOR
                   END IF
                END IF
             NEXT
          END IF
          IF Z = True THEN
             EXIT FOR
          END IF
       NEXT
       IF Z = False THEN
          EXIT DO
       END IF
       Z$ = "\" + STRING$(L, ".") + "\"
       V4 = INSTR(X$, Z$)
       A$ = MID$(X$, V4 + L + 2)
       L2 = 1
       DO
          V4 = V4 - 1
          IF V4 = False THEN
             EXIT DO
          END IF
          IF MID$(X$, V4, 1) = "\" THEN
             L2 = L2 + 1
             IF L2 = L THEN
                EXIT DO
             END IF
          END IF
       LOOP
       IF V4 = False THEN
          X$ = A$
       ELSE
          X$ = LEFT$(X$, V4) + A$
       END IF
    LOOP
 END IF
 ' search for imbedded ..\
 DO
    V = INSTR(X$, ".\")
    IF V THEN
       L = False
       FOR V2 = V TO 1 STEP -1
          IF MID$(X$, V2, 1) = "." THEN
             L = L + 1
          ELSE
             X$ = LEFT$(X$, V2) + MID$(X$, V + 1)
             EXIT FOR
          END IF
       NEXT
    ELSE
       EXIT DO
    END IF
 LOOP
 RETURN

' strip imbedded \\ from path.
PathOverride6:
 DO
    V = INSTR(X$, "\\")
    IF V THEN
       X$ = LEFT$(X$, V - 1) + MID$(X$, V + 1)
    ELSE
       EXIT DO
    END IF
 LOOP
 RETURN
Error.Resume8:
 Exit Sub
Error.Routine8:
 Resume Error.Resume8
END SUB

' strip multiple dots from path.
SUB Parse.Path2(D$, X$)
 On Local Error Goto Error.Routine9
 DO
    IF LEFT$(X$, 2) = ".." THEN
       Z = False
       FOR Var = LEN(D$) TO 1 STEP -1
          IF MID$(D$, Var, 1) = "\" THEN
             D$ = LEFT$(D$, Var - 1)
             X$ = MID$(X$, 2)
             Z = True
             EXIT FOR
          END IF
       NEXT
       IF Z = False THEN
          D$ = Nul
          X$ = Nul
          EXIT DO
       END IF
    ELSE
       X$ = Nul
       EXIT DO
    END IF
 LOOP
Error.Resume9:
 Exit Sub
Error.Routine9:
 Resume Error.Resume9
END SUB

' specialized DIR$ function.
FUNCTION DIRx$ (Filespec$) STATIC ' keep data between calls.
 ON LOCAL ERROR GOTO Error.Routine10
 DIM InregsX4 AS RegTypeX
 DIM OutregsX4 AS RegTypeX
 DIM DTAfilex AS DTAtype
 DIM ASCIIZx AS STRING * 261
 DIM ASCIIZx2 AS STRING * 261
 DIM Current.DTA.SEG AS INTEGER
 DIM Current.DTA.OFF AS INTEGER

 ' check call type.
 IF Filespec$ = "" THEN
    GOSUB FindNext
 ELSE
    GOSUB CheckDrive
    ASCIIZx = UCASE$(Filespec$) + CHR$(0)
    GOSUB FindFirst
 END IF
 DIRx$ = Filenamex$
 EXIT FUNCTION

' initate findfile.
FindFirst:
 ' store current dta
 InregsX4.AX = &H2F00
 CALL InterruptX(&H21, InregsX4, OutregsX4)
 Current.DTA.SEG = OutregsX4.ES
 Current.DTA.OFF = OutregsX4.BX

 ' store function dta
 InregsX4.AX = &H1A00
 InregsX4.DS = VARSEG(DTAfilex)
 InregsX4.DX = VARPTR(DTAfilex)
 CALL InterruptX(&H21, InregsX4, OutregsX4)

 ' findfirst
 InregsX4.AX = &H4E00
 InregsX4.CX = &H37
 InregsX4.DS = VARSEG(ASCIIZx)
 InregsX4.DX = VARPTR(ASCIIZx)
 CALL InterruptX(&H21, InregsX4, OutregsX4)

 ' check carry flag error
 IF (OutregsX4.flags AND &H1) = &H1 THEN
    Filenamex$ = ""
 END IF
 IF (OutregsX4.flags AND &H1) = &H0 THEN
    GOSUB Store.Fileinfo
 END IF

 ' restore current dta
 InregsX4.AX = &H1A00
 InregsX4.DS = Current.DTA.SEG
 InregsX4.DX = Current.DTA.OFF
 CALL InterruptX(&H21, InregsX4, OutregsX4)
 RETURN

' continue filespec match.
FindNext:
 ' store current dta
 InregsX4.AX = &H2F00
 CALL InterruptX(&H21, InregsX4, OutregsX4)
 Current.DTA.SEG = OutregsX4.ES
 Current.DTA.OFF = OutregsX4.BX

 ' store function dta
 InregsX4.AX = &H1A00
 InregsX4.DS = VARSEG(DTAfilex)
 InregsX4.DX = VARPTR(DTAfilex)
 CALL InterruptX(&H21, InregsX4, OutregsX4)

 ' find next filename
 InregsX4.AX = &H4F00
 CALL InterruptX(&H21, InregsX4, OutregsX4)

 ' check carry flag error
 IF (OutregsX4.flags AND &H1) = &H1 THEN
    Filenamex$ = ""
 END IF
 IF (OutregsX4.flags AND &H1) = &H0 THEN
    GOSUB Store.Fileinfo
 END IF

 ' restore current dta
 InregsX4.AX = &H1A00
 InregsX4.DS = Current.DTA.SEG
 InregsX4.DX = Current.DTA.OFF
 CALL InterruptX(&H21, InregsX4, OutregsX4)
 RETURN

' check drive.
CheckDrive:
 Disk.Ready = 0
 IF MID$(Filespec$, 2, 1) = ":" THEN
    GOSUB StoreDrive
    Z$ = LEFT$(Filespec$, 1) + ":\"
    CHDIR Z$
    IF Disk.Ready THEN
       DIRx$ = ""
       EXIT FUNCTION
    END IF
    CHDIR DefaultDir$
 END IF
 RETURN

' store current drive/directory.
StoreDrive:
 InregsX4.AX = &H1900
 CALL InterruptX(&H21, InregsX4, OutregsX4)
 Drive.Number = OutregsX4.AX AND &HFF
 InregsX4.AX = &H4700
 InregsX4.DX = Drive.Number + 1
 InregsX4.DS = VARSEG(ASCIIZx2)
 InregsX4.SI = VARPTR(ASCIIZx2)
 CALL InterruptX(&H21, InregsX4, OutregsX4)
 DefaultDir$ = LEFT$(ASCIIZx2, INSTR(ASCIIZx2, CHR$(0)) - 1)
 IF LEFT$(DefaultDir$, 1) <> "\" THEN
    DefaultDir$ = "\" + DefaultDir$
 END IF
 RETURN

' store file information
Store.Fileinfo:
 ' strip filename from ASCIIZ
 Filenamex$ = DTAfilex.ASCIIZfilename
 VX = INSTR(Filenamex$, CHR$(0))
 IF VX THEN
    Filenamex$ = LEFT$(Filenamex$, VX - 1)
 END IF
 RETURN

' error routine
Error.Routine10:
 ' device I/O error
 IF ERR = 57 THEN
    Disk.Ready = 57
    RESUME NEXT
 END IF
 ' disk not ready
 IF ERR = 71 THEN
    Disk.Ready = 71
    RESUME NEXT
 END IF
 ' path not found
 IF ERR = 76 THEN
    Disk.Ready = 76
    RESUME NEXT
 END IF
 RESUME NEXT
END FUNCTION

' position pointer in file.
SUB LseekFile
 ON LOCAL ERROR RESUME NEXT
 ' calculate high/low seek position.
 SeekPosition2 = SeekPosition - 1 ' offset is from zero.
 ' seek values are signed bit sensitive.
 High = INT(SeekPosition2 / 65536)
 Low = SeekPosition2 AND 65535
 ' seek position in file.
 InregsX.AX = &H4200
 InregsX.BX = Handle
 InregsX.CX = INT(VAL("&H" + HEX$(High))) ' hex conversion is signed.
 InregsX.DX = INT(VAL("&H" + HEX$(Low)))
 CALL InterruptX(&H21, InregsX, OutregsX)
END SUB

' read 1 byte from file.
SUB ReadFile
 ON LOCAL ERROR RESUME NEXT
 InregsX.AX = &H3F00
 InregsX.BX = Handle
 InregsX.CX = 1
 InregsX.DS = VARSEG(Buffer)
 InregsX.DX = VARPTR(Buffer)
 CALL InterruptX(&H21, InregsX, OutregsX)
END SUB

' write 1 byte to file.
SUB WriteFile
 ON LOCAL ERROR RESUME NEXT
 Buffer = FileByte
 InregsX.AX = &H4000
 InregsX.BX = Handle
 InregsX.CX = 1
 InregsX.DS = VARSEG(Buffer)
 InregsX.DX = VARPTR(Buffer)
 CALL InterruptX(&H21, InregsX, OutregsX)
END SUB

' display message for locked file.
SUB LockedFile
 ON LOCAL ERROR RESUME NEXT
 COLORf White
 PRINTf "<locked file>"
 LOCATEf 1, 1, 0
END SUB

' locate cursor on window.
SUB LocateCursor
 ON LOCAL ERROR RESUME NEXT
 IF FileLength = False THEN
    LOCATEf 1, 1, 0
    EXIT SUB
 END IF
 IF CurrentWindow = False THEN
    LOCATEf PageRow + 3, Column + 5, 1
 ELSE
    LOCATEf PageRow + 3, PageColumn + 54, 1
 END IF
END SUB

' select cursor on window.
SUB LocateCursor2
 ON LOCAL ERROR RESUME NEXT
 IF CopyPositionStart = False THEN
    Call locatecursor
 ELSE
    Call locatehilightcursor
 END IF
END SUB

' locate cursor on window for hilighted area.
SUB LocateHilightCursor
 ON LOCAL ERROR RESUME NEXT
 IF FileLength = False THEN
    LOCATEf 1, 1, 0
    EXIT SUB
 END IF
 IF CurrentWindow = False THEN
    LOCATEf PageRow + 3, Column + 7, 1
 ELSE
    LOCATEf PageRow + 3, PageColumn + 55, 1
 END IF
END SUB

' print byte at fileposition in edit area.
SUB BytePrint
 ON LOCAL ERROR RESUME NEXT
 SeekPosition = FilePosition
 Call lseekfile
 Call readfile
 FileByte = Buffer
 ByteValue = ASC(FileByte)
 Column = CalculateColumn
 ' display hex byte.
 CALL HMouse
 LOCATEf PageRow + 3, Column + 5, 0
 PRINTf RIGHT$("00" + HEX$(ByteValue), 2)
 ' check right window toggled.
 IF CurrentWindow2 = False THEN
    ' display ascii byte.
    LOCATEf PageRow + 3, PageColumn + 54, 0
    ' skip unprintable characters.
    SELECT CASE ByteValue
    CASE 0, 7, 9 TO 13, 28 TO 32
       PRINTf "."
    CASE ELSE
       PRINTf FileByte
    END SELECT
 END IF
 CALL SMouse
END SUB

' display info on file being edited.
SUB DisplayPosition
 ON LOCAL ERROR RESUME NEXT
 COLORf2 Yellow, 0
 StringLength = LEN("Editing file: " + RTRIM$(Filename) + " ") + 4
 LOCATEf 2, StringLength, 0
 PRINTf SPACE$(77 - StringLength)
 LOCATEf 2, StringLength, 0
 IF FileLength = False THEN
    Call lockedfile
    EXIT SUB
 END IF
 IF CurrentWindow2 = False THEN
    PRINTf "(Position:" + STR$(FilePosition - 1) + ") "
 ELSE
    PRINTf "(Position: " + RIGHT$("00000000" + HEX$(FilePosition - 1), 8) + "H) "
 END IF
 PRINTf "(Ascii:" + STR$(AsciiValue) + ") "
 PRINTf "(Hex: " + RIGHT$("00" + HEX$(AsciiValue), 2) + "H)"
 Call locatecursor2
END SUB

' clear top status area
SUB ClearStatus
 ON LOCAL ERROR RESUME NEXT
 COLORf2 Yellow, 0
 LOCATEf 2, 4, 0
 PRINTf SPACE$(74)
 LOCATEf 2, 4, 0
END SUB

' display name of file being edited.
SUB DisplayFilename
 ON LOCAL ERROR RESUME NEXT
 Call clearstatus
 PRINTf "Editing file: " + RTRIM$(Filename) + " "
 IF FileLength = False THEN
    Call lockedfile
    EXIT SUB
 END IF
 Call displayposition
END SUB

' display 64-byte name of file being editied.
SUB DisplayFileTitle
 ON LOCAL ERROR RESUME NEXT
 ' redisplay line 3.
 LOCATEf 3, 4, 0
 COLORf Green
 PRINTf CHR$(ULcorner) + STRING$(46, Hline) + CHR$(URcorner) + " "
 PRINTf CHR$(ULcorner) + STRING$(22, Hline) + CHR$(URcorner)
 ' display filename.
 Z$ = RTRIM$(ShortFilename)
 N$ = RTRIM$(CurrentNetPath)
 IF N$ <> Nul THEN
    IF MID$(Z$, 2, 1) = ":" THEN
       Z$ = MID$(Z$, 3)
    END IF
 END IF
 CALL Deconcatenate(N$, Z$, 64)
 Z$ = MID$(STR$(CurrentFile), 2) + ": " + Z$
 Var = INT((80 - (LEN(RTRIM$(Z$))) + 2) / 2) - 1
 LOCATEf 3, Var, 0
 COLORf2 0, 7
 PRINTf " " + Z$ + " "
 COLORf2 7, 0
 Call locatecursor2
END SUB

' display current byte being edited.
SUB DisplayPageByte
 ON LOCAL ERROR RESUME NEXT
 ' check filename display.
 IF FileDisplay2 THEN
    FileDisplay2 = False
    Call clearstatus
    PRINTf "Editing file: " + RTRIM$(Filename) + " "
 END IF
 ' check filelength.
 IF FileLength = False THEN
    LOCATEf 1, 1, 0
    EXIT SUB
 END IF
 ' check hilighted bytes.
 IF CopyPositionStart > 0# THEN
    CALL ResetHilightBytes
 END IF
 ' display byte.
 COLORf Yellow
 Call byteprint
 ' store the current byte value being edited.
 AsciiValue = ASC(FileByte)
 Call displayposition
END SUB

' reset hilight bytes.
SUB ResetHilightBytes
 ON LOCAL ERROR RESUME NEXT
 Call ResetBytes
 ' adjust file position.
 IF PageColumn + 1 <= 20 THEN
    IF FilePosition + 1 <= FileLength THEN
       CALL ClearPageByte
       PageColumn = PageColumn + 1
       FilePosition = FilePosition + 1
       Call displaypagebyte
    END IF
 END IF
 COLORf Yellow
 Call byteprint
END SUB

' reset hilighted byte.
SUB ResetBytes
 ON LOCAL ERROR RESUME NEXT
 Reset1 = True
 Call ResetByte
 CopyPositionStart = False
 CopyPositionPivot = False
 CopyPositionEnd = False
 CopyStart = False
END SUB

' restore hilighted bytes.
SUB RestoreHilightBytes
 ON LOCAL ERROR RESUME NEXT
 CopyPositionStart=File(CurrentFile).CopyPositionStart
 CopyPositionPivot=File(CurrentFile).CopyPositionPivot
 CopyPositionEnd=File(CurrentFile).CopyPositionEnd
 FilePosition=File(CurrentFile).FilePosition
 Reset1 = False
 Call ResetByte
END SUB

' draw byte area.
SUB ResetByte
 ON LOCAL ERROR RESUME NEXT
 Temp# = FilePosition
 Temp2# = FilePage
 Var1# = CopyPositionStart
 Var2# = CopyPositionEnd
 ' reset hilighted positions.
 IF Var1# < (Temp2# - 1) * 320 + 1 THEN
    Var1# = (Temp2# - 1) * 320 + 1
 END IF
 IF Var2# > (Temp2# - 1) * 320 + 320 THEN
    Var2# = (Temp2# - 1) * 320 + 320
 END IF
 IF Var2# > FileLength THEN
    Var2# = FileLength
 END IF
 ' draw the bytes.
 FOR FilePosition = Var1# TO Var2#
    CALL CalculatePosition1
    IF Reset1 THEN
       COLORf White
    ELSE
       COLORf2 0, 7
    END IF
    Call byteprint
 NEXT
 COLORf2 7, 0
 FilePosition = Temp#
 CALL CalculatePosition1
END SUB

' clear current byte on screen.
SUB ClearPageByte
 ON LOCAL ERROR RESUME NEXT
 IF FileLength = False THEN
    LOCATEf 1, 1, 0
    EXIT SUB
 END IF
 IF CopyPositionStart > 0# THEN
    Call resethilightbytes
 END IF
 COLORf White
 Call byteprint
END SUB

' clear current hilighted byte on screen.
SUB ClearHilightByte
 ON LOCAL ERROR RESUME NEXT
 IF FileLength = False THEN
    LOCATEf 1, 1, 0
    EXIT SUB
 END IF
 COLORf White
 CALL BytePrint
END SUB

' display current hilight byte being edited.
SUB DisplayHilightByte
 ON LOCAL ERROR RESUME NEXT
 IF FileDisplay2 THEN
    FileDisplay2 = False
    Call ClearStatus
    PRINTf "Editing file: " + RTRIM$(Filename) + " "
 END IF
 ' display byte.
 IF FileLength = False THEN
    LOCATEf 1, 1, 0
    EXIT SUB
 END IF
 COLORf2 0, 7
 CALL BytePrint
 COLORf2 7, 0
 ' store the current byte value being edited.
 AsciiValue = ASC(FileByte)
 CALL DisplayPosition
END SUB

' display status line message and prompt type 1.
SUB DisplayStatus1
 ON LOCAL ERROR RESUME NEXT
 StatusMessage = StatusMessage + " Press <esc>:"
 CALL DisplayStatusLine
END SUB

' display status line message and prompt type 2.
SUB DisplayStatus2
 ON LOCAL ERROR RESUME NEXT
 StatusMessage = StatusMessage + " Press <esc> to continue:"
 CALL DisplayStatusLine
END SUB

' display the status line message and prompt for key or mouse click.
SUB DisplayStatusLine
 ON LOCAL ERROR RESUME NEXT
 Call clearstatus
 PRINTf StatusMessage
 Call locatecursor2
 Call PromptEscKey
 Call displayfilename
END SUB

' prompts for escape key or left mouse click.
SUB PromptEscKey
 ON LOCAL ERROR RESUME NEXT
 DO
    ' check escape key pressed.
    IF INKEY$ = CHR$(27) THEN
       EXIT DO
    END IF
    ' call mouse subroutine.
    CALL MouseDriver
    ' check left mouse button release.
    IF Mouse.ButtonX THEN
       EXIT DO
    END IF
    ' release windows time slice.
    Var = ReleaseTime
 LOOP
END SUB

' prompts for any key or left mouse click.
SUB PromptKey
 ON LOCAL ERROR RESUME NEXT
 DO
    ' check any key pressed.
    IF INKEY$ <> "" THEN
       EXIT DO
    END IF
    ' call mouse subroutine.
    CALL MouseDriver
    ' check left mouse button release.
    IF Mouse.ButtonX THEN
       EXIT DO
    END IF
    ' release windows time slice.
    Var = ReleaseTime
 LOOP
END SUB

' display screen of current page of hex/ascii values of file being edited.
SUB DisplayHexPage
 ON LOCAL ERROR RESUME NEXT
 IF FileLength = False THEN
    Row = False
    Column = False
    CALL HMouse
    FOR NextByte = 1 TO 320
       LOCATEf Row + 4, Column + 6, 0
       PRINTf "  "
       ColumnSpace = ColumnSpace + 1
       IF ColumnSpace = 4 THEN
          PRINTf " "
          Column = Column + 1
          ColumnSpace = False
       END IF
       Column = Column + 2
       IF Column > 44 THEN
          Row = Row + 1
          Column = False
       END IF
    NEXT
    CALL SMouse
    CALL RedrawRightWindow
    LOCATEf 1, 1, 0
    EXIT SUB
 END IF
 COLORf White
 Row = False
 Column = False
 ColumnSpace = False
 CALL HMouse
 FOR NextByte = (FilePage - 1) * 320 + 1 TO (FilePage - 1) * 320 + 320
    LOCATEf Row + 4, Column + 6, 0
    IF NextByte <= FileLength THEN
       SeekPosition = NextByte
       Call lseekfile
       Call readfile
       FileByte = Buffer
       PRINTf RIGHT$("00" + HEX$(ASC(FileByte)), 2)
    ELSE
       PRINTf "  "
    END IF
    ColumnSpace = ColumnSpace + 1
    IF ColumnSpace = 4 THEN
       PRINTf " "
       Column = Column + 1
       ColumnSpace = False
    END IF
    Column = Column + 2
    IF Column > 44 THEN
       Row = Row + 1
       Column = False
    END IF
 NEXT
 CALL SMouse
 CALL RedrawRightWindow
END SUB

' redraw right window.
SUB RedrawRightWindow:
 ON LOCAL ERROR RESUME NEXT
 IF CurrentWindow2 = False THEN
    CALL RedrawWindow1
 ELSE
    CALL RedrawWindow2
 END IF
END SUB

' redraw right window of ascii values.
SUB RedrawWindow1
 ON LOCAL ERROR RESUME NEXT
 IF FileLength = False THEN
    CALL HMouse
    COLORf White
    Row = False
    Column = False
    FOR NextByte = 1 TO 320
       LOCATEf Row + 4, Column + 55, 0
       PRINTf " "
       Column = Column + 1
       IF Column > 19 THEN
          Row = Row + 1
          Column = False
       END IF
    NEXT
    LOCATEf 1, 1, 0
    CALL SMouse
    EXIT SUB
 END IF
 Row = False
 Column = False
 COLORf White
 CALL HMouse
 FOR NextLine = 0 TO 15
    LOCATEf NextLine + 4, 54, 0
    PRINTf " "
 NEXT
 FOR NextByte = (FilePage - 1) * 320 + 1 TO (FilePage - 1) * 320 + 320
    LOCATEf Row + 4, Column + 55, 0
    IF NextByte <= FileLength THEN
       SeekPosition = NextByte
       Call lseekfile
       Call readfile
       FileByte = Buffer
       ByteValue = ASC(FileByte)
       ' skip unprintable characters
       SELECT CASE ByteValue
       CASE 0, 7, 9 TO 13, 28 TO 32
          PRINTf "."
       CASE ELSE
          PRINTf FileByte
       END SELECT
    ELSE
       PRINTf " "
    END IF
    Column = Column + 1
    IF Column > 19 THEN
       Row = Row + 1
       Column = False
    END IF
 NEXT
 CALL SMouse
END SUB

' redraw right window of hex ranges.
SUB RedrawWindow2:
 ON LOCAL ERROR RESUME NEXT
 CALL HMouse
 CALL Window2DrawSub
 CALL SMouse
END SUB

' key prompt.
SUB PressKey
 ON LOCAL ERROR RESUME NEXT
 COLORf White
 PRINTf "Press a key:"
 WHILE INKEY$ = Nul
 WEND
END SUB

' check valid ascii value
SUB CheckASCIIValue(ByteString$)
 ON LOCAL ERROR RESUME NEXT
 ValidASCIIValue = False
 ASCIIValue3 = VAL(ByteString$)
 IF ASCIIValue3 <= 0# OR ASCIIValue3 > 2147483647# THEN
    StatusMessage = "Invalid ascii value."
    Call displaystatus2
    EXIT SUB
 END IF
 ValidASCIIValue = True
END SUB

' check hex byte string.
SUB CheckString(ByteString$)
 ON LOCAL ERROR RESUME NEXT
 ValidString=True
 FOR HexPosition=2 TO LEN(ByteString$)
    SELECT CASE UCASE$(MID$(ByteString$,HexPosition,1))
    CASE "0" To "9", "A" TO "F"
       ' nul activity
    CASE ELSE
       ValidString=False
       EXIT SUB
    END SELECT
 NEXT
END SUB

' check hex byte value.
' input:
'   ByteString$ is packed hex string.
' output:
'   returns ValidHexValue True for valid hex value.
'   returns HexValue contains value of hex string.
' parameters:
'   Hex string must be 8 characters or less.
'   Hex value from 8000 to ffff return signed bit
'     and must be incremented by 65536.
'   Since 7fff ffff is max filesize,
'     hex values from 8000 0000 to ffff ffff
'     which are length 8 return negative value.
'   Since hex values start from an offset of 0
'     then the maximum value allowed is 7fff fffe.
SUB CheckHexValue(ByteString$)
 ON LOCAL ERROR RESUME NEXT
 ValidHexValue = False
 StringLength2 = LEN(MID$(ByteString$,2))
 IF StringLength2 > 8 THEN
    StatusMessage = "Invalid hex value."
    Call displaystatus2
    EXIT SUB
 END IF
 CALL CheckString(ByteString$)
 IF ValidString=False THEN
    StatusMessage = "Invalid hex string."
    Call displaystatus2
    EXIT SUB
 END IF
 ByteString$ = MID$(ByteString$, 2)
 DO
    IF LEFT$(ByteString$, 1) = "0" THEN
       ByteString$ = MID$(ByteString$, 2)
    ELSE
       EXIT DO
    END IF
 LOOP
 StringLength2 = LEN(ByteString$)
 ByteString$ = "&H" + ByteString$
 HexValue = VAL(ByteString$)
 ' check signed bit error.
 IF StringLength2 = 4 THEN
    IF HexValue < 0 THEN
       HexValue = HexValue + 65536#
    END IF
 END IF
 IF StringLength2 = 8 THEN
    IF HexValue < 0 THEN
       StatusMessage = "Hex underflow."
       Call displaystatus2
       EXIT SUB
    END IF
 END IF
 IF HexValue >= 2147483647# THEN
    StatusMessage = "Hex overflow."
    Call displaystatus2
    EXIT SUB
 END IF
 ValidHexValue = True
 ' adjust hex offset.
 HexValue = HexValue + 1#
END SUB

' check ascii byte string.
'   input: ByteString$ is space-separated 3-byte ascii pair string.
'   returns: ValidByteString equals true if string is valid,
'     NumBytes is number of ascii byte pairs,
'     ByteString$ is concatenated hex byte string.
SUB CheckAsciiBytes(ByteString$)
 ON LOCAL ERROR RESUME NEXT
 AsciiByte$ = Nul
 ByteString$ = LTRIM$(ByteString$)
 ByteString$ = RTRIM$(ByteString$)
 IF LEN(ByteString$) = False THEN
    ValidByteString = False
    EXIT SUB
 END IF
 NumBytes = 1
 ValidByteString = True
 FOR StringPosition = 1 TO LEN(ByteString$)
    Byte$ = MID$(ByteString$, StringPosition, 1)
    IF (StringPosition MOD 4) = False THEN
       IF Byte$ <> " " THEN
          ValidByteString = False
          EXIT SUB
       END IF
       NumBytes = NumBytes + 1
    ELSE
       SELECT CASE Byte$
       CASE "0" TO "9"
          AsciiByte$ = AsciiByte$ + Byte$
          IF LEN(AsciiByte$) = 3 THEN
             ByteValue = VAL(AsciiByte$)
             IF ByteValue >= False AND ByteValue <= 255 THEN
                AsciiByte$ = Nul
             ELSE
                ValidByteString = False
                EXIT SUB
             END IF
          END IF
       CASE ELSE
          ValidByteString = False
          EXIT SUB
       END SELECT
    END IF
 NEXT
 ByteString$ = TrimSpaces$(ByteString$)
 CALL AsciiToHex1(ByteString$)
END SUB

' check hex byte string.
'   input: AllowWildcard true to allow ? character.
'     ByteString$ is space-separated hex byte pair string.
'   returns: ValidByteString equals true if string is valid,
'     NumBytes is number of hex byte pairs,
'     ByteString$ is concatenated hex byte string.
SUB CheckHexBytes(ByteString$)
 ON LOCAL ERROR RESUME NEXT
 ByteString$ = LTRIM$(ByteString$)
 ByteString$ = RTRIM$(ByteString$)
 IF LEN(ByteString$) = False THEN
    ValidByteString = False
    EXIT SUB
 END IF
 NumBytes = 1
 ValidByteString = True
 FOR StringPosition = 1 TO LEN(ByteString$)
    Byte$ = MID$(ByteString$, StringPosition, 1)
    IF (StringPosition MOD 3) = False THEN
       IF Byte$ <> " " THEN
          ValidByteString = False
          EXIT SUB
       END IF
       NumBytes = NumBytes + 1
    ELSE
       SELECT CASE Byte$
       CASE "0" TO "9", "A" TO "F", "a" TO "f", "?"
          IF Byte$ = "?" THEN
             IF AllowWildcard = False THEN
                ValidByteString = False
                EXIT SUB
             END IF
          END IF
          MID$(ByteString$, StringPosition, 1) = UCASE$(Byte$)
       CASE ELSE
          ValidByteString = False
          EXIT SUB
       END SELECT
    END IF
 NEXT
 ByteString$ = TrimSpaces$(ByteString$)
END SUB

' convert a 3-digit packed ascii string to a hex string.
SUB AsciiToHex1(ByteString$)
 ON LOCAL ERROR RESUME NEXT
 Byte$ = Nul
 NewString$ = Nul
 FOR StringPosition = 1 TO LEN(ByteString$)
    Byte$ = Byte$ + MID$(ByteString$, StringPosition, 1)
    IF LEN(Byte$) = 3 THEN
       NewString$ = NewString$ + RIGHT$("00" + HEX$(VAL(Byte$)), 2)
       Byte$ = Nul
    END IF
 NEXT
 ByteString$ = NewString$
END SUB

' convert a 1-digit packed ascii string to a hex string.
SUB AsciiToHex2(ByteString$)
 ON LOCAL ERROR RESUME NEXT
 Byte$ = Nul
 NewString$ = Nul
 FOR StringPosition = 1 TO LEN(ByteString$)
    Byte$ = MID$(ByteString$, StringPosition, 1)
    NewString$ = NewString$ + RIGHT$("00" + HEX$(ASC(Byte$)), 2)
 NEXT
 ByteString$ = NewString$
END SUB

' display cell position in string format.
SUB FormatPosition2(Var)
 ON LOCAL ERROR RESUME NEXT
 IF Var = 1 THEN
    PRINTf "Marker#" + MID$(STR$(MarkerPosition), 2) + ":"
 ELSE
    PRINTf "Marker#" + MID$(STR$(MarkerPosition), 2) + " Position:"
 END IF
 TempPosition3 = Markers#(MarkerPosition)
 IF CurrentWindow2 = False THEN
    PRINTf MID$(STR$(TempPosition3 - 1), 2) + " "
 ELSE
    PRINTf RIGHT$("00000000" + HEX$(TempPosition3 - 1), 8) + "H "
 END IF
 CALL CalculatePosition2
 IF CurrentWindow2 = False THEN
    PRINTf "(page:" + MID$(STR$(FilePage2 - 1), 2) + ","
 ELSE
    PRINTf "(page:" + RIGHT$("00000000" + HEX$(FilePage2 - 1), 8) + "H,"
 END IF
 PRINTf "row:" + MID$(STR$(PageRow2), 2) + ","
 PRINTf "column:" + MID$(STR$(PageColumn2), 2) + ")"
 IF Var = 1 THEN
    PRINTf " Press <esc>:"
 END IF
END SUB

REM End-of-subprogram. All I did was sit down and type it in.
